/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnchor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.ClsElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.DirElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.FileElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.HardElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl");
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    private final Class<? extends PsiElement> myElementClass;
    private byte myReferenceCount;

    SmartPsiElementPointerImpl(@NotNull Project project, @NotNull E element, @Nullable PsiFile containingFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        this(element, SmartPsiElementPointerImpl.createElementInfo(project, element, containingFile), element.getClass());
    }

    SmartPsiElementPointerImpl(@NotNull E element, @NotNull SmartPointerElementInfo elementInfo, @NotNull Class<? extends PsiElement> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (elementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInfo", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "<init>"));
        }
        this.myReferenceCount = 1;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementClass = elementClass;
        this.myElementInfo = elementInfo;
        this.cacheElement(element);
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myElementInfo.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "getProject"));
        }
        return project;
    }

    @Override
    @Nullable
    public E getElement() {
        E element = this.getCachedElement();
        if (element == null || !element.isValid()) {
            element = this.doRestoreElement();
            this.cacheElement(element);
        }
        return element;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element = this.myElementInfo.restoreElement();
        if (!(element == null || element.getClass().equals(this.myElementClass) && element.isValid())) {
            return null;
        }
        return (E)element;
    }

    void cacheElement(@Nullable E element) {
        this.myElement = element == null ? null : (PsiManagerEx.getInstanceEx(this.getProject()).isBatchFilesProcessingMode() ? new WeakReference<E>(element) : new SoftReference<E>(element));
    }

    public E getCachedElement() {
        return (E)((PsiElement)org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myElement));
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file2 = this.getElementInfo().restoreFile();
        if (file2 != null) {
            return file2;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(doc);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.myElementInfo.getRange();
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange();
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(project, element, containingFile);
        if (ApplicationManager.getApplication().isUnitTestMode() && !element.equals(elementInfo.restoreElement())) {
            LOG.error("Cannot restore " + element + " of " + element.getClass() + " from " + elementInfo);
        }
        SmartPointerElementInfo smartPointerElementInfo = elementInfo;
        if (smartPointerElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "createElementInfo"));
        }
        return smartPointerElementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile) {
        SmartPointerElementInfo info;
        TextRange elementRange;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
        }
        if (element instanceof PsiDirectory) {
            DirElementInfo dirElementInfo = new DirElementInfo((PsiDirectory)element);
            if (dirElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return dirElementInfo;
        }
        if (element instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element.isPhysical()) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
                    if (fileElementInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
                    }
                    return fileElementInfo;
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    ClsElementInfo clsElementInfo = new ClsElementInfo(stubReference);
                    if (clsElementInfo == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
                    }
                    return clsElementInfo;
                }
            }
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            if (hardElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return hardElementInfo;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
            elementRange = element.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(hostContext);
                InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, element, elementRange, containingFile, hostPointer);
                if (injectedSelfElementInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
                }
                return injectedSelfElementInfo;
            }
        }
        if ((info = AnchorElementInfoFactory.createElementInfo(element, containingFile)) != null) {
            SmartPointerElementInfo smartPointerElementInfo = info;
            if (smartPointerElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return smartPointerElementInfo;
        }
        if (element instanceof PsiFile) {
            FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
            if (fileElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return fileElementInfo;
        }
        elementRange = element.getTextRange();
        if (elementRange == null) {
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            if (hardElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return hardElementInfo;
        }
        if (elementRange.isEmpty() && PsiTreeUtil.findChildOfType(element, ForeignLeafPsiElement.class) != null) {
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            if (hardElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
            }
            return hardElementInfo;
        }
        ProperTextRange proper = ProperTextRange.create(elementRange);
        SelfElementInfo selfElementInfo = new SelfElementInfo(project, proper, AnchorTypeInfo.obtainInfo(element, LanguageUtil.getRootLanguage(element)), containingFile, false);
        if (selfElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "doCreateElementInfo"));
        }
        return selfElementInfo;
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "getElementInfo"));
        }
        return smartPointerElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer1", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "pointsToTheSameElementAs"));
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer2", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl", "pointsToTheSameElementAs"));
        }
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo())) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal(pointer1.getElement(), pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return 0;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }
}

