/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public final class Message {
    private final Topic myTopic;
    private final Method myListenerMethod;
    private final Object[] myArgs;

    public Message(@NotNull Topic topic, @NotNull Method listenerMethod, Object[] args) {
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "org/jetbrains/kotlin/com/intellij/util/messages/impl/Message", "<init>"));
        }
        if (listenerMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerMethod", "org/jetbrains/kotlin/com/intellij/util/messages/impl/Message", "<init>"));
        }
        this.myTopic = topic;
        listenerMethod.setAccessible(true);
        this.myListenerMethod = listenerMethod;
        this.myArgs = args;
    }

    @NotNull
    public Topic getTopic() {
        Topic topic = this.myTopic;
        if (topic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/Message", "getTopic"));
        }
        return topic;
    }

    @NotNull
    public Method getListenerMethod() {
        Method method = this.myListenerMethod;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/impl/Message", "getListenerMethod"));
        }
        return method;
    }

    public Object[] getArgs() {
        return this.myArgs;
    }

    public String toString() {
        return this.myTopic.toString() + ":" + this.myListenerMethod.getName();
    }
}

