/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsCase;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsCatch;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsDefault;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsDoWhile;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsForIn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsSwitch;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsSwitchMember;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsThrow;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsTry;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsWhile;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\fJ\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;", "", "function", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "(Lcom/google/dart/compiler/backend/js/ast/JsFunction;)V", "definedValues", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsExpression;", "definitions", "", "hasChanges", "", "localVariables", "", "Lorg/jetbrains/annotations/NotNull;", "namesToSubstitute", "", "namesWithSideEffects", "root", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsBlock;", "statementsToRemove", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNode;", "temporary", "usages", "variablesToRemove", "analyze", "", "apply", "assignVariable", "name", "value", "cleanUp", "isTrivial", "expr", "perform", "shouldConsiderTemporary", "shouldConsiderUnused", "useVariable", "SubstitutionCandidateFinder", "kotlin-compiler"})
public final class TemporaryVariableElimination {
    private final JsBlock root;
    private final Map<JsName, Integer> definitions;
    private final Map<JsName, Integer> usages;
    private final Map<JsName, JsExpression> definedValues;
    private final Set<JsName> temporary;
    private boolean hasChanges;
    private final Set<JsName> localVariables;
    private final Set<JsName> namesToSubstitute;
    private final Set<JsNode> statementsToRemove;
    private final Set<JsName> namesWithSideEffects;
    private final Set<JsName> variablesToRemove;
    private final JsFunction function;

    public final boolean apply() {
        this.analyze();
        this.perform();
        this.cleanUp();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final Set<JsName> currentScope;
            @NotNull
            private Set<JsName> localVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final Set<JsName> getCurrentScope() {
                return this.currentScope;
            }

            @NotNull
            public final Set<JsName> getLocalVars() {
                return this.localVars;
            }

            public final void setLocalVars(@NotNull Set<JsName> set) {
                Intrinsics.checkParameterIsNotNull(set, "<set-?>");
                this.localVars = set;
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    void name2;
                    Object object = assignment;
                    JsName jsName = ((Pair)object).component1();
                    JsExpression jsExpression = ((Pair)object).component2();
                    object = null;
                    if (TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) {
                        void value;
                        void v0 = name2;
                        Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                        void v1 = value;
                        Intrinsics.checkExpressionValueIsNotNull(v1, "value");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, (JsName)v0, (JsExpression)v1);
                        void v2 = name2;
                        Intrinsics.checkExpressionValueIsNotNull(v2, "name");
                        this.addVar((JsName)v2);
                        this.accept((JsNode)value);
                        if (MetadataProperties.getSynthetic(x)) {
                            object = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                            object.add(name2);
                        }
                    }
                    return;
                }
                super.visitExpressionStatement(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsName name2 = v.getName();
                    JsExpression value = v.getInitExpression();
                    if (value == null || !TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) continue;
                    JsName jsName = name2;
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "name");
                    TemporaryVariableElimination.access$assignVariable(this.this$0, jsName, value);
                    JsName jsName2 = name2;
                    Intrinsics.checkExpressionValueIsNotNull(jsName2, "name");
                    this.addVar(jsName2);
                    this.accept((JsNode)value);
                    if (!MetadataProperties.getSynthetic(x)) continue;
                    Collection collection = TemporaryVariableElimination.access$getTemporary$p(this.this$0);
                    collection.add(name2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
                JsName name2 = nameRef.getName();
                if (name2 != null && TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name2)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, name2);
                    if (this.currentScope.contains(name2) ^ true) {
                        JsExpression jsExpression = JsLiteral.UNDEFINED;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "JsLiteral.UNDEFINED");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name2, jsExpression);
                    }
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitFor(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitForIn(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitWhile(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitDoWhile(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitIf(@NotNull JsIf x) {
                Object object;
                Object $i$a$1$withNewScope;
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.accept((JsNode)x.getIfExpression());
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    this.accept((JsNode)x.getThenStatement());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $i$a$1$withNewScope = this_$iv.getCurrentScope();
                    object = this_$iv.getLocalVars();
                    CollectionsKt.removeAll($i$a$1$withNewScope, object);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
                JsStatement jsStatement = x.getElseStatement();
                if (jsStatement != null) {
                    void this_$iv2;
                    JsStatement jsStatement2 = jsStatement;
                    JsStatement it = jsStatement2;
                    $i$a$1$withNewScope = this;
                    Set<JsName> localVarsBackup$iv2 = this_$iv2.getLocalVars();
                    try {
                        this_$iv2.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                        this.accept((JsNode)it);
                        object = Unit.INSTANCE;
                    }
                    finally {
                        Collection collection = this_$iv2.getCurrentScope();
                        Iterable iterable = this_$iv2.getLocalVars();
                        CollectionsKt.removeAll(collection, iterable);
                        this_$iv2.setLocalVars(localVarsBackup$iv2);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCase(@NotNull JsCase x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitCase(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDefault(@NotNull JsDefault x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitDefault(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                analyze.1 this_$iv = this;
                Set<JsName> localVarsBackup$iv = this_$iv.getLocalVars();
                try {
                    this_$iv.setLocalVars(SetsKt.mutableSetOf(new JsName[0]));
                    super.visitCatch(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Collection collection = this_$iv.getCurrentScope();
                    Iterable iterable = this_$iv.getLocalVars();
                    CollectionsKt.removeAll(collection, iterable);
                    this_$iv.setLocalVars(localVarsBackup$iv);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Iterator<JsName> iterator2 = CollectUtilsKt.collectFreeVariables(x).iterator();
                while (iterator2.hasNext()) {
                    JsName freeVar;
                    JsName jsName = freeVar = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "freeVar");
                    TemporaryVariableElimination.access$useVariable(this.this$0, jsName);
                    JsName jsName2 = freeVar;
                    Intrinsics.checkExpressionValueIsNotNull(jsName2, "freeVar");
                    TemporaryVariableElimination.access$useVariable(this.this$0, jsName2);
                }
            }

            private final void addVar(JsName name2) {
                Collection collection = this.currentScope;
                collection.add(name2);
                this.localVars.add(name2);
            }
            {
                this.this$0 = $outer;
                this.currentScope = SequencesKt.toMutableSet(SequencesKt.map(CollectionsKt.asSequence((Iterable)TemporaryVariableElimination.access$getFunction$p($outer).getParameters()), analyze.currentScope.1.INSTANCE));
                this.localVars = SetsKt.mutableSetOf(new JsName[0]);
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new RecursiveJsVisitor(this){
            @NotNull
            private final List<Pair<JsName, JsNode>> lastAssignedVars;
            final /* synthetic */ TemporaryVariableElimination this$0;

            @NotNull
            public final List<Pair<JsName, JsNode>> getLastAssignedVars() {
                return this.lastAssignedVars;
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression expression = x.getExpression();
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression);
                if (assignment != null) {
                    void value;
                    void name2;
                    Pair<JsName, JsExpression> pair = assignment;
                    JsName jsName = pair.component1();
                    JsExpression jsExpression = pair.component2();
                    pair = null;
                    void v0 = name2;
                    Intrinsics.checkExpressionValueIsNotNull(v0, "name");
                    void v1 = value;
                    Intrinsics.checkExpressionValueIsNotNull(v1, "value");
                    this.handleDefinition((JsName)v0, (JsExpression)v1, x);
                } else {
                    JsExpression jsExpression = expression;
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression, "expression");
                    if (this.handleExpression(jsExpression)) {
                        this.invalidateTemporaries();
                    }
                }
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsExpression initializer2 = v.getInitExpression();
                    if (initializer2 == null) continue;
                    JsName jsName = v.getName();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "v.name");
                    JsNode jsNode = v;
                    Intrinsics.checkExpressionValueIsNotNull(jsNode, "v");
                    this.handleDefinition(jsName, initializer2, jsNode);
                }
            }

            private final void handleDefinition(JsName name2, JsExpression value, JsNode node) {
                boolean sideEffects = this.handleExpression(value);
                if (TemporaryVariableElimination.access$shouldConsiderTemporary(this.this$0, name2)) {
                    if (TemporaryVariableElimination.access$isTrivial(this.this$0, value)) {
                        Collection collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                        collection.add(node);
                        collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                        collection.add(name2);
                    } else {
                        Collection collection = this.lastAssignedVars;
                        Pair<JsName, JsNode> pair = new Pair<JsName, JsNode>(name2, node);
                        collection.add(pair);
                        if (sideEffects) {
                            collection = TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0);
                            collection.add(name2);
                        }
                    }
                } else {
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, name2)) {
                        Collection collection = TemporaryVariableElimination.access$getVariablesToRemove$p(this.this$0);
                        collection.add(name2);
                    }
                    if (sideEffects) {
                        this.invalidateTemporaries();
                    }
                }
            }

            public void visitIf(@NotNull JsIf x) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    JsExpression jsExpression = x.getIfExpression();
                    Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.ifExpression");
                    this.handleExpression(jsExpression);
                    this.invalidateTemporaries();
                    this.accept((JsNode)x.getThenStatement());
                    this.invalidateTemporaries();
                    JsStatement jsStatement = x.getElseStatement();
                    if (jsStatement == null) break block0;
                    JsStatement jsStatement2 = jsStatement;
                    JsStatement it = jsStatement2;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitReturn(@NotNull JsReturn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression jsExpression2 = jsExpression;
                    JsExpression it = jsExpression2;
                    this.handleExpression(it);
                }
                this.invalidateTemporaries();
            }

            public void visitThrow(@NotNull JsThrow x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.expression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                Iterable $receiver$iv = x.getCases();
                for (T element$iv : $receiver$iv) {
                    JsSwitchMember it = (JsSwitchMember)element$iv;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitWhile(x);
                this.invalidateTemporaries();
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitDoWhile(x);
                this.invalidateTemporaries();
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "x.objectExpression");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitFor(@NotNull JsFor x) {
                JsNode it;
                JsNode jsNode;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsVars jsVars = x.getInitVars();
                if (jsVars != null) {
                    jsNode = jsVars;
                    it = jsNode;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression = x.getInitExpression();
                if (jsExpression != null) {
                    jsNode = jsExpression;
                    it = (JsExpression)jsNode;
                    this.handleExpression((JsExpression)it);
                }
                this.invalidateTemporaries();
                JsExpression jsExpression2 = x.getCondition();
                if (jsExpression2 != null) {
                    jsNode = jsExpression2;
                    it = (JsExpression)jsNode;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression3 = x.getIncrementExpression();
                if (jsExpression3 != null) {
                    jsNode = jsExpression3;
                    it = (JsExpression)jsNode;
                    this.accept((JsNode)it);
                }
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitTry(@NotNull JsTry x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitTry(x);
                this.invalidateTemporaries();
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitCatch(x);
                this.invalidateTemporaries();
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
                super.visitLabel(x);
                this.invalidateTemporaries();
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.invalidateTemporaries();
            }

            private final void invalidateTemporaries() {
                this.lastAssignedVars.clear();
            }

            /*
             * WARNING - void declaration
             */
            private final boolean handleExpression(JsExpression expression) {
                SubstitutionCandidateFinder candidateFinder = this.this$0.new SubstitutionCandidateFinder();
                candidateFinder.accept((JsNode)expression);
                List<JsName> candidates = candidateFinder.getSubstitutableVariableReferences();
                while (true) {
                    void assignedStatement;
                    void assignedVar;
                    Object object = this.lastAssignedVars;
                    if (!(!object.isEmpty())) break;
                    Pair<JsName, JsNode> pair = CollectionsKt.last(this.lastAssignedVars);
                    object = pair.component1();
                    JsNode jsNode = pair.component2();
                    pair = null;
                    int candidateIndex = candidates.lastIndexOf(assignedVar);
                    if (candidateIndex < 0) break;
                    Collection collection = TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0);
                    collection.add(assignedVar);
                    collection = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                    collection.add(assignedStatement);
                    if (TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0).contains(assignedVar)) {
                        candidateFinder.setSideEffectOccurred(true);
                    }
                    candidates = candidates.subList(0, candidateIndex);
                    this.lastAssignedVars.remove(CollectionsKt.getLastIndex(this.lastAssignedVars));
                }
                return candidateFinder.getSideEffectOccurred();
            }
            {
                this.this$0 = $outer;
                this.lastAssignedVars = CollectionsKt.mutableListOf(new Pair[0]);
            }
        }.accept((JsNode)this.root);
    }

    private final void cleanUp() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryVariableElimination this$0;

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsVars x, @NotNull JsContext<JsNode> ctx) {
                List<Pair<List<JsVars.JsVar>, S>> ranges2;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                Collection collection = x.getVars();
                Collection object2 = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                }
                if (TypeIntrinsics.asMutableCollection(collection2).removeAll(object2)) {
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                }
                if ((ranges2 = UtilsKt.splitToRanges(x.getVars(), (Function1)new Function1<JsVars.JsVar, Boolean>(this){
                    final /* synthetic */ cleanUp.1 this$0;

                    public final boolean invoke(JsVars.JsVar it) {
                        return TemporaryVariableElimination.access$getVariablesToRemove$p(this.this$0.this$0).contains(it.getName());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })).size() == 1 && !((Boolean)ranges2.get(0).getSecond()).booleanValue()) {
                    return super.visit(x, ctx);
                }
                TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                for (Pair<List<JsVars.JsVar>, S> pair : ranges2) {
                    void $receiver;
                    JsVars jsVars;
                    Object object;
                    JsContext<JsNode> jsContext;
                    Object initializer2;
                    JsNode it;
                    Object element$iv;
                    void destination$iv$iv;
                    void $receiver$iv$iv$iv;
                    Iterator<Object> $receiver$iv$iv;
                    Iterable $receiver$iv;
                    List<JsVars.JsVar> subList = pair.component1();
                    boolean isRemoved = (Boolean)pair.component2();
                    Iterable iterable = subList;
                    void var9_11 = $receiver$iv;
                    Collection collection3 = new ArrayList<E>();
                    void var11_13 = $receiver$iv$iv;
                    for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                        JsExpression jsExpression;
                        T element$iv$iv = element$iv$iv$iv;
                        JsVars.JsVar it2 = (JsVars.JsVar)element$iv$iv;
                        if (it2.getInitExpression() == null) continue;
                        JsExpression it$iv$iv = jsExpression;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List initializers = (List)destination$iv$iv;
                    $receiver$iv = initializers;
                    $receiver$iv$iv = $receiver$iv.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        element$iv = $receiver$iv$iv.next();
                        it = (JsExpression)element$iv;
                        this.accept((JsNode)it);
                    }
                    if (isRemoved) {
                        $receiver$iv$iv = initializers.iterator();
                        while ($receiver$iv$iv.hasNext()) {
                            void $receiver2;
                            initializer2 = (JsExpression)$receiver$iv$iv.next();
                            element$iv = new JsExpressionStatement((JsExpression)initializer2);
                            jsContext = ctx;
                            it = (JsExpressionStatement)element$iv;
                            MetadataProperties.setSynthetic((HasMetadata)$receiver2, MetadataProperties.getSynthetic(x));
                            object = element$iv;
                            jsContext.addPrevious((JsNode)object);
                        }
                        continue;
                    }
                    initializer2 = subList;
                    JsVars jsVars2 = jsVars;
                    object = jsVars;
                    jsContext = ctx;
                    Iterable iterable2 = $receiver$iv;
                    if (iterable2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    Iterable<E> thisCollection$iv = (Collection)iterable2;
                    JsVars.JsVar[] jsVarArray = thisCollection$iv.toArray(new JsVars.JsVar[thisCollection$iv.size()]);
                    if (jsVarArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Object[] objectArray = jsVarArray;
                    JsVars.JsVar[] jsVarArray2 = (JsVars.JsVar[])objectArray;
                    jsVars2(Arrays.copyOf(jsVarArray2, jsVarArray2.length));
                    iterable = object;
                    thisCollection$iv = (JsVars)iterable;
                    MetadataProperties.setSynthetic((HasMetadata)$receiver, MetadataProperties.getSynthetic(x));
                    object = iterable;
                    jsContext.addPrevious((JsNode)object);
                }
                ctx.removeMe();
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    ctx.removeMe();
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                    return false;
                }
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    void name2;
                    Object object = assignment;
                    JsName jsName = ((Pair)object).component1();
                    JsExpression jsExpression = ((Pair)object).component2();
                    object = null;
                    if (TemporaryVariableElimination.access$getVariablesToRemove$p(this.this$0).contains(name2)) {
                        void $receiver;
                        void value;
                        TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                        object = new JsExpressionStatement((JsExpression)value);
                        JsContext<JsNode> jsContext = ctx;
                        JsExpressionStatement jsExpressionStatement = (JsExpressionStatement)object;
                        MetadataProperties.setSynthetic((HasMetadata)$receiver, true);
                        JsExpressionStatement jsExpressionStatement2 = (JsExpressionStatement)this.accept((JsNode)$receiver);
                        jsContext.replaceMe((JsNode)jsExpressionStatement2);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer2.getValueExpr());
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsName name2 = x.getName();
                if (name2 != null && x.getQualifier() == null && TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0).contains(name2)) {
                    V v = TemporaryVariableElimination.access$getDefinedValues$p(this.this$0).get(name2);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    JsExpression replacement = (JsExpression)this.accept((JsNode)v);
                    ctx.replaceMe((JsNode)replacement);
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public boolean visit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void assignVariable(JsName name2, JsExpression value) {
        Map<JsName, Object> map2 = this.definitions;
        Integer n = this.definitions.get(name2);
        Object object = (n != null ? n : 0) + 1;
        map2.put(name2, (Integer)object);
        map2 = this.definedValues;
        object = value;
        map2.put(name2, (Integer)object);
    }

    private final void useVariable(JsName name2) {
        Map<JsName, Integer> map2 = this.usages;
        Integer n = this.usages.get(name2);
        Integer n2 = (n != null ? n : 0) + 1;
        map2.put(name2, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderUnused(JsName name2) {
        if (!Intrinsics.areEqual(this.definitions.get(name2), 1)) return false;
        Integer n = this.usages.get(name2);
        if ((n != null ? n : 0) != 0) return false;
        if (!this.temporary.contains(name2)) return false;
        return true;
    }

    private final boolean shouldConsiderTemporary(JsName name2) {
        if (Intrinsics.areEqual(this.definitions.get(name2), 1) ^ true || this.temporary.contains(name2) ^ true) {
            return false;
        }
        JsExpression expr = this.definedValues.get(name2);
        return expr != null && this.isTrivial(expr) || Intrinsics.areEqual(this.usages.get(name2), 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsExpression expr) {
        JsExpression jsExpression = expr;
        if (jsExpression instanceof JsNameRef) {
            JsName name2;
            JsExpression qualifier = ((JsNameRef)expr).getQualifier();
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects((HasMetadata)((Object)expr)), (Object)SideEffectKind.PURE)) {
                if (qualifier == null) return true;
                if (this.isTrivial(qualifier)) {
                    return true;
                }
            }
            if (!CollectionsKt.contains((Iterable)this.localVariables, name2 = ((JsNameRef)expr).getName())) return false;
            Object object = this.definitions;
            Map<JsName, Integer> map2 = object;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            Integer n = map2.get(name2);
            if (Intrinsics.areEqual(n, null) || Intrinsics.areEqual(n, 0)) {
                return true;
            }
            if (!Intrinsics.areEqual(n, 1)) return false;
            if (CollectionsKt.contains((Iterable)this.namesToSubstitute, name2) ^ true) return true;
            object = this.definedValues;
            Map<JsName, Object> map3 = object;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            JsExpression jsExpression2 = (JsExpression)map3.get(name2);
            if (jsExpression2 == null) return false;
            object = jsExpression2;
            JsExpression it = (JsExpression)object;
            boolean bl = this.isTrivial(it);
            if (!bl) return false;
            return true;
        }
        if (jsExpression instanceof JsLiteral.JsValueLiteral) {
            if (expr.toString().length() >= 10) return false;
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression3;
            if (!Intrinsics.areEqual((Object)MetadataProperties.getSideEffects((HasMetadata)((Object)expr)), (Object)SideEffectKind.PURE)) return false;
            JsExpression jsExpression4 = ((JsInvocation)expr).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "expr.qualifier");
            if (!this.isTrivial(jsExpression4)) return false;
            Iterable $receiver$iv = ((JsInvocation)expr).getArguments();
            Iterator iterator2 = $receiver$iv.iterator();
            do {
                JsExpression it;
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                jsExpression3 = it = (JsExpression)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "it");
            } while (this.isTrivial(jsExpression3));
            return false;
        }
        if (!(jsExpression instanceof JsArrayAccess)) return false;
        JsExpression jsExpression5 = ((JsArrayAccess)expr).getArrayExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression5, "expr.arrayExpression");
        if (!this.isTrivial(jsExpression5)) return false;
        JsExpression jsExpression6 = ((JsArrayAccess)expr).getIndexExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression6, "expr.indexExpression");
        if (!this.isTrivial(jsExpression6)) return false;
        return true;
    }

    public TemporaryVariableElimination(@NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        this.function = function2;
        this.root = this.function.getBody();
        this.definitions = MapsKt.mutableMapOf(new Pair[0]);
        this.usages = MapsKt.mutableMapOf(new Pair[0]);
        this.definedValues = MapsKt.mutableMapOf(new Pair[0]);
        this.temporary = SetsKt.mutableSetOf(new JsName[0]);
        this.localVariables = CollectUtilsKt.collectLocalVariables(this.function);
        this.namesToSubstitute = SetsKt.mutableSetOf(new JsName[0]);
        this.statementsToRemove = SetsKt.mutableSetOf(new JsNode[0]);
        this.namesWithSideEffects = SetsKt.mutableSetOf(new JsName[0]);
        this.variablesToRemove = SetsKt.mutableSetOf(new JsName[0]);
    }

    public static final /* synthetic */ void access$assignVariable(TemporaryVariableElimination $this, @NotNull JsName name2, @NotNull JsExpression value) {
        $this.assignVariable(name2, value);
    }

    @NotNull
    public static final /* synthetic */ Set access$getTemporary$p(TemporaryVariableElimination $this) {
        return $this.temporary;
    }

    public static final /* synthetic */ void access$useVariable(TemporaryVariableElimination $this, @NotNull JsName name2) {
        $this.useVariable(name2);
    }

    @NotNull
    public static final /* synthetic */ JsFunction access$getFunction$p(TemporaryVariableElimination $this) {
        return $this.function;
    }

    public static final /* synthetic */ boolean access$isTrivial(TemporaryVariableElimination $this, @NotNull JsExpression expr) {
        return $this.isTrivial(expr);
    }

    @NotNull
    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryVariableElimination $this) {
        return $this.statementsToRemove;
    }

    @NotNull
    public static final /* synthetic */ Set access$getNamesWithSideEffects$p(TemporaryVariableElimination $this) {
        return $this.namesWithSideEffects;
    }

    public static final /* synthetic */ boolean access$shouldConsiderUnused(TemporaryVariableElimination $this, @NotNull JsName name2) {
        return $this.shouldConsiderUnused(name2);
    }

    @NotNull
    public static final /* synthetic */ Set access$getVariablesToRemove$p(TemporaryVariableElimination $this) {
        return $this.variablesToRemove;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(TemporaryVariableElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryVariableElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @NotNull
    public static final /* synthetic */ Map access$getDefinedValues$p(TemporaryVariableElimination $this) {
        return $this.definedValues;
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020'H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination$SubstitutionCandidateFinder;", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/RecursiveJsVisitor;", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;)V", "sideEffectOccurred", "", "getSideEffectOccurred", "()Z", "setSideEffectOccurred", "(Z)V", "substitutableVariableReferences", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "getSubstitutableVariableReferences", "()Ljava/util/List;", "visitArray", "", "x", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsArrayLiteral;", "visitArrayAccess", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsArrayAccess;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsConditional;", "visitFunction", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsInvocation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNameRef;", "visitNew", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsNew;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsObjectLiteral;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsPostfixOperation;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsPrefixOperation;", "kotlin-compiler"})
    private final class SubstitutionCandidateFinder
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsName> substitutableVariableReferences = CollectionsKt.mutableListOf(new JsName[0]);
        private boolean sideEffectOccurred;

        @NotNull
        public final List<JsName> getSubstitutableVariableReferences() {
            return this.substitutableVariableReferences;
        }

        public final boolean getSideEffectOccurred() {
            return this.sideEffectOccurred;
        }

        public final void setSideEffectOccurred(boolean bl) {
            this.sideEffectOccurred = bl;
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            for (JsPropertyInitializer initializer2 : x.getPropertyInitializers()) {
                this.accept((JsNode)initializer2.getValueExpr());
            }
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitNew(@NotNull JsNew x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitNew(x);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(x), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkParameterIsNotNull(invocation, "invocation");
            super.visitInvocation(invocation);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(invocation), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            this.accept((JsNode)x.getTestExpression());
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitArrayAccess(x);
            if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(x), (Object)SideEffectKind.AFFECTS_STATE)) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitArray(x);
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitPrefixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                    }
                }
            }
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            super.visitPostfixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            if (jsUnaryOperator != null) {
                switch (TemporaryVariableElimination$SubstitutionCandidateFinder$WhenMappings.$EnumSwitchMapping$1[jsUnaryOperator.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.sideEffectOccurred = true;
                    }
                }
            }
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkParameterIsNotNull(nameRef, "nameRef");
            JsName name2 = nameRef.getName();
            if (name2 != null && TemporaryVariableElimination.this.localVariables.contains(name2)) {
                if (TemporaryVariableElimination.this.namesToSubstitute.contains(name2) ^ true && TemporaryVariableElimination.this.shouldConsiderTemporary(name2) && !this.sideEffectOccurred) {
                    Collection collection = this.substitutableVariableReferences;
                    collection.add(name2);
                }
            } else {
                super.visitNameRef(nameRef);
                if (Intrinsics.areEqual((Object)MetadataProperties.getSideEffects(nameRef), (Object)SideEffectKind.AFFECTS_STATE)) {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkParameterIsNotNull(x, "x");
            if (Intrinsics.areEqual(x.getOperator(), JsBinaryOperator.ASG)) {
                JsExpression left = x.getArg1();
                JsExpression right = x.getArg2();
                if (left instanceof JsNameRef) {
                    JsExpression qualifier = ((JsNameRef)left).getQualifier();
                    if (qualifier != null) {
                        this.accept((JsNode)qualifier);
                    }
                } else if (left instanceof JsArrayAccess) {
                    this.accept((JsNode)((JsArrayAccess)left).getArrayExpression());
                    this.accept((JsNode)((JsArrayAccess)left).getIndexExpression());
                }
                this.accept((JsNode)right);
                this.sideEffectOccurred = true;
            } else {
                super.visitBinaryExpression(x);
            }
        }
    }
}

