/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.InputStream;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        BufferedBlockCipher bufferedBlockCipher = bl2 ? new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8)) : new BufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            bufferedBlockCipher.init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            bufferedBlockCipher.init(bl, (CipherParameters)keyParameter);
        }
        return bufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
        bufferedBlockCipher.init(bl, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(byArray), byArray2));
        return bufferedBlockCipher;
    }
}

