/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import java.util.Iterator;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;

public class ProjectDependencyPublicationResolver {
    public ModuleVersionIdentifier resolve(ProjectDependency dependency) {
        Project dependencyProject = dependency.getDependencyProject();
        ((ProjectInternal)dependencyProject).evaluate();
        PublishingExtension publishing = (PublishingExtension)dependencyProject.getExtensions().findByType(PublishingExtension.class);
        if (publishing == null || publishing.getPublications().withType(PublicationInternal.class).isEmpty()) {
            return new DefaultModuleVersionIdentifier(dependency.getGroup(), dependencyProject.getName(), dependency.getVersion());
        }
        NamedDomainObjectSet publications = publishing.getPublications().withType(PublicationInternal.class);
        Iterator iterator = publications.iterator();
        ModuleVersionIdentifier candidate = ((PublicationInternal)iterator.next()).getCoordinates();
        while (iterator.hasNext()) {
            ModuleVersionIdentifier alternative = ((PublicationInternal)iterator.next()).getCoordinates();
            if (candidate.equals(alternative)) continue;
            throw new UnsupportedOperationException("Publishing is not yet able to resolve a dependency on a project with multiple different publications.");
        }
        return candidate;
    }
}

