/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Nullable;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryIdentifier;

public class ChainedLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final List<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();

    public ChainedLibraryBinaryLocator(List<? extends LibraryBinaryLocator> locators) {
        this.locators.addAll(locators);
    }

    @Override
    @Nullable
    public DomainObjectSet<NativeLibraryBinary> getBinaries(LibraryIdentifier library) {
        for (LibraryBinaryLocator locator : this.locators) {
            DomainObjectSet<NativeLibraryBinary> binaries = locator.getBinaries(library);
            if (binaries == null) continue;
            return binaries;
        }
        return null;
    }
}

