/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.internal.component.model.IvyArtifactName;

class IntersectionExclusion
extends AbstractCompositeExclusion {
    private final Set<AbstractModuleExclusion> excludeSpecs = new HashSet<AbstractModuleExclusion>();

    public IntersectionExclusion(Collection<AbstractModuleExclusion> specs) {
        this.excludeSpecs.addAll(specs);
    }

    @Override
    Collection<AbstractModuleExclusion> getFilters() {
        return this.excludeSpecs;
    }

    @Override
    protected boolean excludesNoModules() {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (excludeSpec.excludesNoModules()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludeModule(ModuleIdentifier element) {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (!excludeSpec.excludeModule(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (!excludeSpec.excludeArtifact(module, artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        for (AbstractModuleExclusion spec : this.excludeSpecs) {
            if (!spec.mayExcludeArtifacts()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void unpackIntersection(Collection<AbstractModuleExclusion> specs) {
        specs.addAll(this.excludeSpecs);
    }
}

