/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import groovy.util.Node;
import groovy.util.XmlParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.internal.generator.AbstractPersistableConfigurationObject;

public abstract class XmlPersistableConfigurationObject
extends AbstractPersistableConfigurationObject {
    private final XmlTransformer xmlTransformer;
    private Node xml;

    protected XmlPersistableConfigurationObject(XmlTransformer xmlTransformer) {
        this.xmlTransformer = xmlTransformer;
    }

    @Override
    public void load(InputStream inputStream) throws Exception {
        this.xml = new XmlParser().parse(inputStream);
        this.load(this.xml);
    }

    @Override
    public void store(OutputStream outputStream) {
        this.store(this.xml);
        this.xmlTransformer.transform(this.xml, outputStream);
    }

    public Node getXml() {
        return this.xml;
    }

    protected void load(Node xml) {
    }

    protected void store(Node xml) {
    }

    public void transformAction(Closure action) {
        this.xmlTransformer.addAction(action);
    }

    protected static List<Node> getChildren(@Nullable Node root, String name) {
        return root == null ? Collections.emptyList() : (List)Cast.uncheckedCast((Object)root.get(name));
    }

    @Nullable
    public static Node findFirstChildNamed(@Nullable Node root, String name) {
        return root == null ? null : (Node)Iterables.getFirst(XmlPersistableConfigurationObject.getChildren(root, name), null);
    }

    @Nullable
    public static Node findFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        return root == null ? null : XmlPersistableConfigurationObject.findFirstWithAttributeValue(XmlPersistableConfigurationObject.getChildren(root, childName), attribute, value);
    }

    @Nullable
    protected static Node findFirstWithAttributeValue(@Nullable List<Node> nodes, final String attribute, final String value) {
        return nodes == null ? null : (Node)Iterables.getFirst((Iterable)Iterables.filter(nodes, (Predicate)new Predicate<Node>(){

            public boolean apply(Node node) {
                return value.equals(node.attribute((Object)attribute));
            }
        }), null);
    }

    public static Node findOrCreateFirstChildNamed(Node root, String name) {
        Node child = XmlPersistableConfigurationObject.findFirstChildNamed(root, name);
        if (child == null) {
            child = root.appendNode((Object)name);
        }
        return child;
    }

    public static Node findOrCreateFirstChildWithAttributeValue(@Nullable Node root, String childName, String attribute, String value) {
        Node child = XmlPersistableConfigurationObject.findFirstChildWithAttributeValue(root, childName, attribute, value);
        if (child == null) {
            HashMap attributes = Maps.newHashMap();
            attributes.put(attribute, value);
            child = root.appendNode((Object)childName, (Map)attributes);
        }
        return child;
    }
}

