/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.BuildActionResult;
import org.gradle.tooling.internal.provider.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionBuildConfigurationAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionResultEvaluator;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class TestExecutionRequestActionRunner
implements BuildActionRunner {
    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof TestExecutionRequestAction)) {
            return;
        }
        GradleInternal gradle = buildController.getGradle();
        try {
            TestExecutionRequestAction testExecutionRequestAction = (TestExecutionRequestAction)action;
            TestExecutionResultEvaluator testExecutionResultEvaluator = new TestExecutionResultEvaluator(testExecutionRequestAction);
            buildController.addNestedListener((Object)testExecutionResultEvaluator);
            this.doRun(testExecutionRequestAction, buildController);
            testExecutionResultEvaluator.evaluate();
        }
        catch (RuntimeException rex) {
            Throwable throwable = this.findRootCause(rex);
            if (throwable instanceof TestExecutionException) {
                throw new InternalTestExecutionException("Error while running test(s)", throwable);
            }
            throw rex;
        }
        PayloadSerializer payloadSerializer = (PayloadSerializer)gradle.getServices().get(PayloadSerializer.class);
        buildController.setResult((Object)new BuildActionResult(payloadSerializer.serialize(null), null));
    }

    private void doRun(TestExecutionRequestAction action, BuildController buildController) {
        TestExecutionBuildConfigurationAction testTasksConfigurationAction = new TestExecutionBuildConfigurationAction(action, buildController.getGradle());
        ((BuildConfigurationActionExecuter)buildController.getGradle().getServices().get(BuildConfigurationActionExecuter.class)).setTaskSelectors(Collections.singletonList(testTasksConfigurationAction));
        buildController.run();
    }

    private Throwable findRootCause(Exception tex) {
        Throwable t = tex;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

