/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.script.lang.kotlin.provider;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u001a\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u001a\u001b\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"extractBuildscriptBlockFrom", "Lkotlin/ranges/IntRange;", "script", "", "extractTopLevelSectionFrom", "identifier", "findBlockEnd", "", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "(Lorg/jetbrains/kotlin/lexer/KotlinLexer;)Ljava/lang/Integer;", "findTopLevelIdentifier", "(Lorg/jetbrains/kotlin/lexer/KotlinLexer;Ljava/lang/String;)Ljava/lang/Integer;", "skipWhiteSpaceAndComments", "", "gradle-script-kotlin_main"})
public final class BuildscriptBlockExtractionKt {
    @Nullable
    public static final IntRange extractBuildscriptBlockFrom(@NotNull String script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return BuildscriptBlockExtractionKt.extractTopLevelSectionFrom(script, "buildscript");
    }

    @Nullable
    public static final IntRange extractTopLevelSectionFrom(@NotNull String script, @NotNull String identifier) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        KotlinLexer kotlinLexer = new KotlinLexer();
        KotlinLexer $receiver = kotlinLexer;
        $receiver.start((CharSequence)script);
        while ($receiver.getTokenType() != null) {
            Integer n;
            if (BuildscriptBlockExtractionKt.findTopLevelIdentifier($receiver, identifier) == null) continue;
            int sectionStart = ((Number)n).intValue();
            $receiver.advance();
            BuildscriptBlockExtractionKt.skipWhiteSpaceAndComments($receiver);
            if (!Intrinsics.areEqual((Object)$receiver.getTokenType(), (Object)KtTokens.LBRACE)) continue;
            Integer n2 = BuildscriptBlockExtractionKt.findBlockEnd($receiver);
            if (n2 == null) continue;
            Integer n3 = n2;
            int sectionEnd = ((Number)n3).intValue();
            return new IntRange(sectionStart, sectionEnd);
        }
        return null;
    }

    private static final void skipWhiteSpaceAndComments(@NotNull KotlinLexer $receiver) {
        while (KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains($receiver.getTokenType())) {
            $receiver.advance();
        }
    }

    private static final Integer findTopLevelIdentifier(@NotNull KotlinLexer $receiver, String identifier) {
        int depth = 0;
        while ($receiver.getTokenType() != null) {
            IElementType iElementType = $receiver.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.IDENTIFIER)) {
                if (depth == 0 && Intrinsics.areEqual((Object)$receiver.getTokenText(), (Object)identifier)) {
                    return $receiver.getTokenStart();
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LBRACE)) {
                ++depth;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
                --depth;
            }
            $receiver.advance();
        }
        return null;
    }

    private static final Integer findBlockEnd(@NotNull KotlinLexer $receiver) {
        int depth = 0;
        while ($receiver.getTokenType() != null) {
            IElementType iElementType = $receiver.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LBRACE)) {
                ++depth;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.RBRACE)) {
                if (depth == 1) {
                    return $receiver.getTokenStart();
                }
                --depth;
            }
            $receiver.advance();
        }
        return null;
    }
}

