/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;

abstract class AbstractCompositeExclusion
extends AbstractModuleExclusion {
    AbstractCompositeExclusion() {
    }

    abstract Collection<AbstractModuleExclusion> getFilters();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(this.getClass().getSimpleName());
        for (AbstractModuleExclusion spec : this.getFilters()) {
            builder.append(' ');
            builder.append(spec);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    protected boolean doExcludesSameModulesAs(AbstractModuleExclusion other) {
        AbstractCompositeExclusion spec = (AbstractCompositeExclusion)other;
        return this.implies(spec) && spec.implies(this);
    }

    @Override
    protected boolean doEquals(Object obj) {
        AbstractCompositeExclusion other = (AbstractCompositeExclusion)obj;
        return this.getFilters().equals(other.getFilters());
    }

    @Override
    protected int doHashCode() {
        return this.getFilters().hashCode();
    }

    protected boolean implies(AbstractCompositeExclusion spec) {
        for (AbstractModuleExclusion thisSpec : this.getFilters()) {
            boolean found = false;
            for (AbstractModuleExclusion otherSpec : spec.getFilters()) {
                if (!thisSpec.excludesSameModulesAs(otherSpec)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

