/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalFileDependencyBackedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class FileDependencyCollectingGraphVisitor
implements DependencyGraphVisitor,
VisitedFileDependencyResults,
SelectedFileDependencyResults {
    private final SetMultimap<Long, ResolvedArtifactSet> filesByConfiguration = LinkedHashMultimap.create();
    private Map<FileCollectionDependency, ResolvedArtifactSet> rootFiles;

    @Override
    public void start(DependencyGraphNode root) {
        Set<LocalFileDependencyMetadata> fileDependencies = ((LocalConfigurationMetadata)root.getMetadata()).getFiles();
        this.rootFiles = Maps.newLinkedHashMap();
        for (LocalFileDependencyMetadata fileDependency : fileDependencies) {
            LocalFileDependencyBackedArtifactSet artifacts = new LocalFileDependencyBackedArtifactSet(fileDependency);
            this.rootFiles.put(fileDependency.getSource(), artifacts);
            this.filesByConfiguration.put((Object)root.getNodeId(), (Object)artifacts);
        }
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode resolvedConfiguration) {
        ConfigurationMetadata configurationMetadata = resolvedConfiguration.getMetadata();
        if (configurationMetadata instanceof LocalConfigurationMetadata) {
            LocalConfigurationMetadata localConfigurationMetadata = (LocalConfigurationMetadata)configurationMetadata;
            for (DependencyGraphEdge dependencyGraphEdge : resolvedConfiguration.getIncomingEdges()) {
                if (!dependencyGraphEdge.isTransitive()) continue;
                Set<LocalFileDependencyMetadata> fileDependencies = localConfigurationMetadata.getFiles();
                for (LocalFileDependencyMetadata fileDependency : fileDependencies) {
                    this.filesByConfiguration.put((Object)resolvedConfiguration.getNodeId(), (Object)new LocalFileDependencyBackedArtifactSet(fileDependency));
                }
            }
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
    }

    @Override
    public SelectedFileDependencyResults select(Transformer<HasAttributes, Collection<? extends HasAttributes>> selector) {
        return this;
    }

    @Override
    public Map<FileCollectionDependency, ResolvedArtifactSet> getFirstLevelFiles() {
        return this.rootFiles;
    }

    @Override
    public ResolvedArtifactSet getFiles(Long node) {
        return CompositeArtifactSet.of(this.filesByConfiguration.get((Object)node));
    }

    @Override
    public ResolvedArtifactSet getFiles() {
        return CompositeArtifactSet.of(this.filesByConfiguration.values());
    }
}

