/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.favorites;

import java.util.ArrayList;
import java.util.List;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.foundation.settings.SettingsSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FavoritesSerializable
implements SettingsSerializable {
    private List<FavoriteTask> favorites;
    private static final String FAVORITE_ELEMENT_TAG = "favorite";
    private static final String FULL_COMMAND_LINE = "full-command-line";
    private static final String DISPLAY_NAME = "display-name";
    private static final String SHOW_OUTPUT = "show-output";
    private static final String ROOT_TAG = "favorites";
    private static final String FAVORITES_SIZE = "favorites-size";
    private static final String FAVORITE_PREFIX = "favorite_";

    public FavoritesSerializable(List<FavoriteTask> favorites) {
        this.favorites = favorites;
    }

    public FavoritesSerializable() {
        this.favorites = new ArrayList<FavoriteTask>();
    }

    public List<FavoriteTask> getFavorites() {
        return this.favorites;
    }

    @Override
    public void serializeOut(SettingsNode settings) {
        FavoritesSerializable.serializeOut(settings, this.favorites);
    }

    public static void serializeOut(SettingsNode settings, List<FavoriteTask> favorites) {
        SettingsNode rootNode = settings.addChildIfNotPresent(ROOT_TAG);
        rootNode.removeAllChildren();
        for (FavoriteTask favoriteTask : favorites) {
            SettingsNode taskNode = rootNode.addChild(FAVORITE_ELEMENT_TAG);
            taskNode.setValueOfChild(FULL_COMMAND_LINE, favoriteTask.getFullCommandLine());
            taskNode.setValueOfChild(DISPLAY_NAME, favoriteTask.getDisplayName());
            taskNode.setValueOfChildAsBoolean(SHOW_OUTPUT, favoriteTask.alwaysShowOutput());
        }
    }

    @Override
    public void serializeIn(SettingsNode settings) {
        FavoritesSerializable.serializeIn(settings, this.favorites);
    }

    public static void serializeIn(SettingsNode settings, List<FavoriteTask> favorites) {
        favorites.clear();
        SettingsNode rootElement = settings.getChildNode(ROOT_TAG);
        if (rootElement == null) {
            return;
        }
        for (SettingsNode taskNode : rootElement.getChildNodes(FAVORITE_ELEMENT_TAG)) {
            String fullCommandLine = taskNode.getValueOfChild(FULL_COMMAND_LINE, null);
            if (fullCommandLine == null) continue;
            String displayName = taskNode.getValueOfChild(DISPLAY_NAME, fullCommandLine);
            boolean showOutput = taskNode.getValueOfChildAsBoolean(SHOW_OUTPUT, false);
            FavoritesSerializable.addFavoriteTask(favorites, fullCommandLine, displayName, showOutput);
        }
    }

    private static void addFavoriteTask(List<FavoriteTask> favorites, String fullCommandLine, String displayName, boolean alwaysShowOutput) {
        if (displayName == null) {
            displayName = fullCommandLine;
        }
        favorites.add(new FavoriteTask(fullCommandLine, displayName, alwaysShowOutput));
    }
}

