/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.gradle.api.internal.TaskOutputCachingState;

class DefaultTaskOutputCachingState
implements TaskOutputCachingState {
    static final TaskOutputCachingState ENABLED = new DefaultTaskOutputCachingState(null);
    static final TaskOutputCachingState DISABLED = DefaultTaskOutputCachingState.disabled("Task output caching is disabled");
    private final String disabledReason;

    static TaskOutputCachingState disabled(String disabledReason) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)disabledReason) ? 1 : 0) != 0, (Object)"disabledReason must be set if task output caching is disabled");
        return new DefaultTaskOutputCachingState(disabledReason);
    }

    private DefaultTaskOutputCachingState(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    public boolean isEnabled() {
        return this.disabledReason == null;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public String toString() {
        return "DefaultTaskOutputCachingState{disabledReason='" + this.disabledReason + '\'' + '}';
    }
}

