/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.internal.daemon.WorkerDaemonClient;
import org.gradle.process.internal.daemon.WorkerDaemonClientsManager;
import org.gradle.process.internal.health.memory.MaximumHeapHelper;
import org.gradle.process.internal.health.memory.MemoryAmount;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.process.internal.health.memory.MemoryInfo;

public class WorkerDaemonExpiration
implements MemoryHolder {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonExpiration.class);
    private final WorkerDaemonClientsManager clientsManager;
    private final MemoryInfo memoryInfo;
    private final long osTotalMemory;

    public WorkerDaemonExpiration(WorkerDaemonClientsManager clientsManager, MemoryInfo memoryInfo) {
        this.clientsManager = clientsManager;
        this.memoryInfo = memoryInfo;
        this.osTotalMemory = this.eventuallyGetOsTotalMemory(memoryInfo);
    }

    private long eventuallyGetOsTotalMemory(MemoryInfo memoryInfo) {
        try {
            return memoryInfo.getTotalPhysicalMemory();
        }
        catch (UnsupportedOperationException ex) {
            return -1L;
        }
    }

    public long attemptToRelease(long memoryAmountBytes) throws IllegalArgumentException {
        if (memoryAmountBytes < 0L) {
            throw new IllegalArgumentException("Negative memory amount");
        }
        LOGGER.debug("Will attempt to release {} of memory", (Object)(memoryAmountBytes / 1024L / 1024L));
        SimpleMemoryExpirationSelector selector = new SimpleMemoryExpirationSelector(memoryAmountBytes);
        this.clientsManager.selectIdleClientsToStop(selector);
        return selector.getReleasedBytes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleMemoryExpirationSelector
    implements Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> {
        private final long memoryBytesToRelease;
        private long releasedBytes;

        public SimpleMemoryExpirationSelector(long memoryBytesToRelease) {
            this.memoryBytesToRelease = memoryBytesToRelease;
        }

        public long getReleasedBytes() {
            return this.releasedBytes;
        }

        public List<WorkerDaemonClient> transform(List<WorkerDaemonClient> idleClients) {
            ArrayList<WorkerDaemonClient> toExpire = new ArrayList<WorkerDaemonClient>();
            for (WorkerDaemonClient idleClient : idleClients) {
                toExpire.add(idleClient);
                long freed = this.getMemoryUsage(idleClient);
                this.releasedBytes += freed;
                if (this.releasedBytes < this.memoryBytesToRelease) continue;
                break;
            }
            if (LOGGER.isDebugEnabled() && !toExpire.isEmpty()) {
                LOGGER.debug("Worker Daemon(s) expired to free some system memory {}", (Object)toExpire.size());
            }
            return toExpire;
        }

        private long getMemoryUsage(WorkerDaemonClient idleClient) {
            String forkOptionsMaxHeapSize = idleClient.getForkOptions().getMaxHeapSize();
            long parsed = MemoryAmount.parseNotation((String)forkOptionsMaxHeapSize);
            if (parsed != -1L) {
                return parsed;
            }
            if (WorkerDaemonExpiration.this.osTotalMemory != -1L) {
                return new MaximumHeapHelper().getDefaultMaximumHeapSize(WorkerDaemonExpiration.this.osTotalMemory);
            }
            return WorkerDaemonExpiration.this.memoryInfo.getMaxMemory();
        }
    }
}

