/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.sink.AnsiConsoleUtil;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;

public class ConsoleConfigureAction {
    public void execute(OutputEventRenderer renderer, ConsoleOutput consoleOutput) {
        if (consoleOutput == ConsoleOutput.Plain) {
            return;
        }
        ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
        boolean force = false;
        if (consoleMetaData == null) {
            if (consoleOutput == ConsoleOutput.Auto) {
                return;
            }
            assert (consoleOutput == ConsoleOutput.Rich);
            consoleMetaData = new FallbackConsoleMetaData();
            force = true;
        }
        boolean stdOutIsTerminal = consoleMetaData.isStdOut();
        boolean stdErrIsTerminal = consoleMetaData.isStdErr();
        if (stdOutIsTerminal) {
            OutputStream originalStdOut = renderer.getOriginalStdOut();
            OutputStreamWriter outStr = new OutputStreamWriter(force ? originalStdOut : AnsiConsoleUtil.wrapOutputStream(originalStdOut));
            AnsiConsole console = new AnsiConsole(outStr, outStr, renderer.getColourMap(), force);
            renderer.addConsole(console, true, stdErrIsTerminal, consoleMetaData);
        } else if (stdErrIsTerminal) {
            OutputStream originalStdErr = renderer.getOriginalStdErr();
            OutputStreamWriter errStr = new OutputStreamWriter(force ? originalStdErr : AnsiConsoleUtil.wrapOutputStream(originalStdErr));
            AnsiConsole console = new AnsiConsole(errStr, errStr, renderer.getColourMap(), force);
            renderer.addConsole(console, false, true, consoleMetaData);
        }
    }
}

