/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplChecker;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.cli.jvm.repl.messages.ReplTerminalDiagnosticMessageHolder;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileFactoryImpl;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0017J\u0006\u0010#\u001a\u00020$R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker;", "Lorg/jetbrains/kotlin/cli/common/repl/ReplChecker;", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "scriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "getCompilerConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "lineState", "Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "getLineState", "()Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "setLineState", "(Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;)V", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/PsiFileFactoryImpl;", "getPsiFileFactory", "()Lcom/intellij/psi/impl/PsiFileFactoryImpl;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "check", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "history", "", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/ReplTerminalDiagnosticMessageHolder;", "LineState", "kotlin-compiler"})
public class GenericReplChecker
implements ReplChecker {
    @NotNull
    private final KotlinCoreEnvironment environment;
    @NotNull
    private final PsiFileFactoryImpl psiFileFactory;
    @Nullable
    private LineState lineState;
    @NotNull
    private final KotlinScriptDefinition scriptDefinition;
    @NotNull
    private final CompilerConfiguration compilerConfiguration;

    @NotNull
    protected final KotlinCoreEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    protected final PsiFileFactoryImpl getPsiFileFactory() {
        return this.psiFileFactory;
    }

    @Nullable
    protected final LineState getLineState() {
        return this.lineState;
    }

    protected final void setLineState(@Nullable LineState lineState) {
        this.lineState = lineState;
    }

    @NotNull
    public final ReplTerminalDiagnosticMessageHolder createDiagnosticHolder() {
        return new ReplTerminalDiagnosticMessageHolder();
    }

    @Override
    @NotNull
    public synchronized ReplCheckResult check(@NotNull ReplCodeLine codeLine, @NotNull Iterable<ReplCodeLine> history) {
        String $receiver;
        Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
        Intrinsics.checkParameterIsNotNull(history, "history");
        LightVirtualFile lightVirtualFile = new LightVirtualFile("line" + codeLine.getNo() + KotlinParserDefinition.STD_SCRIPT_EXT, KotlinLanguage.INSTANCE, (CharSequence)codeLine.getCode());
        LightVirtualFile lightVirtualFile2 = lightVirtualFile;
        ((VirtualFile)((Object)$receiver)).setCharset(CharsetToolkit.UTF8_CHARSET);
        LightVirtualFile virtualFile = lightVirtualFile;
        KtFile ktFile = (KtFile)this.psiFileFactory.trySetupPsiForFile(virtualFile, KotlinLanguage.INSTANCE, true, false);
        if (ktFile == null) {
            $receiver = "Script file not analyzed at line " + codeLine.getNo() + ": " + codeLine.getCode();
            throw (Throwable)new IllegalStateException($receiver.toString());
        }
        KtFile psiFile = ktFile;
        ReplTerminalDiagnosticMessageHolder errorHolder = this.createDiagnosticHolder();
        AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.Companion.reportSyntaxErrors((PsiElement)psiFile, errorHolder);
        if (!syntaxErrorReport.isHasErrors()) {
            this.lineState = new LineState(codeLine, psiFile, errorHolder);
        }
        return syntaxErrorReport.isHasErrors() && syntaxErrorReport.isAllErrorsAtEof() ? (ReplCheckResult)ReplCheckResult.Incomplete.INSTANCE : (syntaxErrorReport.isHasErrors() ? (ReplCheckResult)new ReplCheckResult.Error(errorHolder.getRenderedDiagnostics(), null, 2, null) : (ReplCheckResult)ReplCheckResult.Ok.INSTANCE);
    }

    @NotNull
    public final KotlinScriptDefinition getScriptDefinition() {
        return this.scriptDefinition;
    }

    @NotNull
    public final CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public GenericReplChecker(@NotNull Disposable disposable, @NotNull KotlinScriptDefinition scriptDefinition2, @NotNull CompilerConfiguration compilerConfiguration, @NotNull MessageCollector messageCollector) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(disposable, "disposable");
        Intrinsics.checkParameterIsNotNull(scriptDefinition2, "scriptDefinition");
        Intrinsics.checkParameterIsNotNull(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        this.scriptDefinition = scriptDefinition2;
        this.compilerConfiguration = compilerConfiguration;
        GenericReplChecker genericReplChecker = this;
        GenericReplChecker genericReplChecker2 = this;
        GenericReplChecker genericReplChecker3 = genericReplChecker;
        CompilerConfiguration compilerConfiguration2 = $receiver2.compilerConfiguration;
        CompilerConfiguration compilerConfiguration3 = compilerConfiguration2;
        $receiver.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, $receiver2.scriptDefinition);
        $receiver.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
        $receiver.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
        CompilerConfiguration compilerConfiguration4 = $receiver2.compilerConfiguration;
        List<String> list2 = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Intrinsics.checkExpressionValueIsNotNull(list2, "EnvironmentConfigFiles.JVM_CONFIG_FILES");
        genericReplChecker2.environment = kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForProduction(disposable, compilerConfiguration4, list2);
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance(this.environment.getProject());
        if (psiFileFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.PsiFileFactoryImpl");
        }
        this.psiFileFactory = (PsiFileFactoryImpl)psiFileFactory;
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/repl/GenericReplChecker$LineState;", "", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "errorHolder", "Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;)V", "getCodeLine", "()Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "getErrorHolder", "()Lorg/jetbrains/kotlin/cli/jvm/repl/messages/DiagnosticMessageHolder;", "getPsiFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin-compiler"})
    protected static final class LineState {
        @NotNull
        private final ReplCodeLine codeLine;
        @NotNull
        private final KtFile psiFile;
        @NotNull
        private final DiagnosticMessageHolder errorHolder;

        @NotNull
        public final ReplCodeLine getCodeLine() {
            return this.codeLine;
        }

        @NotNull
        public final KtFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final DiagnosticMessageHolder getErrorHolder() {
            return this.errorHolder;
        }

        public LineState(@NotNull ReplCodeLine codeLine, @NotNull KtFile psiFile, @NotNull DiagnosticMessageHolder errorHolder) {
            Intrinsics.checkParameterIsNotNull(codeLine, "codeLine");
            Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
            Intrinsics.checkParameterIsNotNull(errorHolder, "errorHolder");
            this.codeLine = codeLine;
            this.psiFile = psiFile;
            this.errorHolder = errorHolder;
        }
    }
}

