/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.HasName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.SourceInfoAwareJsNode;

public final class JsParameter
extends SourceInfoAwareJsNode
implements HasName {
    @NotNull
    private final JsName name;

    public JsParameter(@NotNull JsName name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsParameter", "<init>"));
        }
        this.name = name2;
    }

    @Override
    @NotNull
    public JsName getName() {
        JsName jsName = this.name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsParameter", "getName"));
        }
        return jsName;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitParameter(this);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsParameter deepCopy() {
        JsParameter jsParameter = new JsParameter(this.name).withMetadataFrom(this);
        if (jsParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsParameter", "deepCopy"));
        }
        return jsParameter;
    }
}

