/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;

public class PsiBuilderFactoryImpl
extends PsiBuilderFactory {
    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull ASTNode chameleon) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        PsiBuilder psiBuilder = this.createBuilder(project, chameleon, null, chameleon.getElementType().getLanguage(), chameleon.getChars());
        if (psiBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilder;
    }

    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }

    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl", "createBuilder"));
        }
        return psiBuilderImpl;
    }

    private static Lexer createLexer(Project project, Language lang) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        assert (parserDefinition != null) : "ParserDefinition absent for language: " + lang.getID();
        return parserDefinition.createLexer(project);
    }
}

