/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;

public class MessageBusFactory {
    private static final AtomicReference<Impl> ourImpl = new AtomicReference<Impl>(Impl.DEFAULT);

    @NotNull
    public static MessageBus newMessageBus(@NotNull Object owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        MessageBus messageBus = ourImpl.get().newMessageBus(owner);
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        return messageBus;
    }

    public static interface Impl {
        public static final Impl DEFAULT = new Impl(){

            @Override
            @NotNull
            public MessageBus newMessageBus(@NotNull Object owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                MessageBusImpl.RootBus rootBus = new MessageBusImpl.RootBus(owner);
                if (rootBus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                return rootBus;
            }
        };

        @NotNull
        public MessageBus newMessageBus(@NotNull Object var1);
    }
}

