/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsDynamicScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsObjectScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.LinkedHashMap;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.DeferredCallSite;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StandardClasses;
import org.jetbrains.kotlin.js.translate.context.generator.Generator;
import org.jetbrains.kotlin.js.translate.context.generator.Rule;
import org.jetbrains.kotlin.js.translate.intrinsic.Intrinsics;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final StandardClasses standardClasses;
    @NotNull
    private final JsScope rootScope;
    @NotNull
    private final Map<FqName, JsName> packageNames;
    @NotNull
    private final Generator<JsScope> scopes;
    @NotNull
    private final Map<JsScope, JsFunction> scopeToFunction;
    @NotNull
    private final Map<MemberDescriptor, List<DeclarationDescriptor>> classOrConstructorClosure;
    @NotNull
    private final Map<ClassDescriptor, List<DeferredCallSite>> deferredCallSites;
    @NotNull
    private final JsConfig config;
    @NotNull
    private final ModuleDescriptor currentModule;
    @NotNull
    private final NameSuggestion nameSuggestion;
    @NotNull
    private final Map<DeclarationDescriptor, JsName> nameCache;
    @NotNull
    private final Map<PropertyDescriptor, JsName> backingFieldNameCache;
    @NotNull
    private final Map<DeclarationDescriptor, JsExpression> fqnCache;
    @NotNull
    private final Map<String, JsName> importedModules;
    private Map<String, JsName> readOnlyImportedModules;
    @NotNull
    private final JsScope rootPackageScope;

    public static StaticContext generateStaticContext(@NotNull BindingTrace bindingTrace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "generateStaticContext"));
        }
        JsProgram program = new JsProgram("main");
        Namer namer = Namer.newInstance(program.getRootScope());
        Intrinsics intrinsics = new Intrinsics();
        StandardClasses standardClasses = StandardClasses.bindImplementations(namer.getKotlinScope());
        return new StaticContext(program, bindingTrace, namer, intrinsics, standardClasses, program.getRootScope(), config, moduleDescriptor);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull BindingTrace bindingTrace, @NotNull Namer namer, @NotNull Intrinsics intrinsics, @NotNull StandardClasses standardClasses, @NotNull JsScope rootScope2, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor) {
        if (program == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "program", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (intrinsics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intrinsics", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (standardClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardClasses", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "<init>"));
        }
        this.packageNames = Maps.newHashMap();
        this.scopes = new ScopeGenerator();
        this.scopeToFunction = Maps.newHashMap();
        this.classOrConstructorClosure = Maps.newHashMap();
        this.deferredCallSites = new HashMap<ClassDescriptor, List<DeferredCallSite>>();
        this.nameSuggestion = new NameSuggestion();
        this.nameCache = new HashMap<DeclarationDescriptor, JsName>();
        this.backingFieldNameCache = new HashMap<PropertyDescriptor, JsName>();
        this.fqnCache = new HashMap<DeclarationDescriptor, JsExpression>();
        this.importedModules = new LinkedHashMap<String, JsName>();
        this.program = program;
        this.bindingTrace = bindingTrace;
        this.namer = namer;
        this.intrinsics = intrinsics;
        this.rootScope = rootScope2;
        this.standardClasses = standardClasses;
        this.config = config;
        this.currentModule = moduleDescriptor;
        this.rootPackageScope = new JsObjectScope(rootScope2, "<root package>", "root-package");
    }

    @NotNull
    public JsProgram getProgram() {
        JsProgram jsProgram = this.program;
        if (jsProgram == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getProgram"));
        }
        return jsProgram;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        BindingTrace bindingTrace = this.bindingTrace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingTrace.getBindingContext();
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        Intrinsics intrinsics = this.intrinsics;
        if (intrinsics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getIntrinsics"));
        }
        return intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        Namer namer = this.namer;
        if (namer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNamer"));
        }
        return namer;
    }

    @NotNull
    private JsScope getRootScope() {
        JsScope jsScope = this.rootScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getRootScope"));
        }
        return jsScope;
    }

    @NotNull
    public Map<String, JsName> getImportedModules() {
        if (this.readOnlyImportedModules == null) {
            this.readOnlyImportedModules = Collections.unmodifiableMap(this.importedModules);
        }
        Map<String, JsName> map2 = this.readOnlyImportedModules;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getImportedModules"));
        }
        return map2;
    }

    @NotNull
    public JsScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            JsScope jsScope = this.rootScope;
            if (jsScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
            }
            return jsScope;
        }
        JsScope scope = this.scopes.get(descriptor2.getOriginal());
        assert (scope != null) : "Must have a scope for descriptor";
        JsScope jsScope = scope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getScopeForDescriptor"));
        }
        return jsScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        JsScope scope = this.getScopeForDescriptor(descriptor2);
        JsFunction function2 = this.scopeToFunction.get(scope);
        assert (scope.equals(function2.getScope())) : "Inconsistency.";
        JsFunction jsFunction = function2;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getFunctionWithScope"));
        }
        return jsFunction;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsNameRef jsNameRef = (JsNameRef)this.getQualifiedExpression(descriptor2);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression getQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedExpression"));
        }
        JsExpression fqn = this.fqnCache.get(descriptor2);
        if (fqn == null) {
            fqn = this.buildQualifiedExpression(descriptor2);
            this.fqnCache.put(descriptor2, fqn);
        }
        JsExpression jsExpression = fqn.deepCopy();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedExpression"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression buildQualifiedExpression(@NotNull DeclarationDescriptor descriptor2) {
        List<JsName> partNames;
        Object expression;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
        }
        SuggestedName suggested = this.nameSuggestion.suggest(descriptor2);
        if (suggested == null) {
            ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
            JsExpression result2 = this.getModuleExpressionFor(module);
            JsExpression jsExpression = result2 != null ? result2 : JsAstUtils.pureFqn(Namer.getRootPackageName(), null);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
            }
            return jsExpression;
        }
        if (this.standardClasses.isStandardObject(suggested.getDescriptor())) {
            expression = Namer.kotlinObject();
            partNames = Collections.singletonList(this.standardClasses.getStandardObjectName(suggested.getDescriptor()));
        } else {
            partNames = this.getActualNameFromSuggested(suggested);
            expression = AnnotationsUtils.isLibraryObject(suggested.getDescriptor()) ? Namer.kotlinObject() : (AnnotationsUtils.isNativeObject(suggested.getDescriptor()) && !AnnotationsUtils.isNativeObject(suggested.getScope()) || suggested.getDescriptor() instanceof CallableDescriptor && suggested.getScope() instanceof FunctionDescriptor ? null : this.getQualifiedExpression(suggested.getScope()));
        }
        for (JsName partName : partNames) {
            expression = new JsNameRef(partName, (JsExpression)expression);
            StaticContext.applySideEffects((JsExpression)expression, suggested.getDescriptor());
        }
        assert (expression != null) : "Since partNames is not empty, expression must be non-null";
        JsNameRef jsNameRef = expression;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "buildQualifiedExpression"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsNameRef getQualifiedReference(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        JsName packageName = this.getNameForPackage(packageFqName);
        JsNameRef jsNameRef = JsAstUtils.pureFqn(packageName, packageFqName.isRoot() ? null : this.getQualifierForParentPackage(packageFqName.parent()));
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifiedReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        SuggestedName suggested = this.nameSuggestion.suggest(descriptor2);
        if (suggested == null) {
            throw new IllegalArgumentException("Can't generate name for root declarations: " + descriptor2);
        }
        JsName jsName = this.getActualNameFromSuggested(suggested).get(0);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForDescriptor"));
        }
        return jsName;
    }

    @NotNull
    public JsName getNameForBackingField(@NotNull PropertyDescriptor property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForBackingField"));
        }
        JsName name2 = this.backingFieldNameCache.get(property);
        if (name2 == null) {
            SuggestedName fqn = this.nameSuggestion.suggest(property);
            assert (fqn != null) : "Properties are non-root declarations: " + property;
            assert (fqn.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsScope scope = this.getScopeForDescriptor(fqn.getScope());
            String baseName = NameSuggestion.getPrivateMangledName(fqn.getNames().get(0), property) + "_0";
            name2 = scope.declareFreshName(baseName);
            this.backingFieldNameCache.put(property, name2);
        }
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForBackingField"));
        }
        return jsName;
    }

    @NotNull
    private List<JsName> getActualNameFromSuggested(@NotNull SuggestedName suggested) {
        if (suggested == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggested", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getActualNameFromSuggested"));
        }
        JsScope scope = this.getScopeForDescriptor(suggested.getScope());
        if (DynamicCallsKt.isDynamic(suggested.getDescriptor())) {
            scope = JsDynamicScope.INSTANCE;
        }
        ArrayList<JsName> names2 = new ArrayList<JsName>();
        if (suggested.getStable()) {
            for (String namePart : suggested.getNames()) {
                names2.add(scope.declareName(namePart));
            }
        } else {
            assert (suggested.getNames().size() == 1) : "Private names must always consist of exactly one name";
            JsName name2 = this.nameCache.get(suggested.getDescriptor());
            if (name2 == null) {
                String baseName = suggested.getNames().get(0);
                if (!DescriptorUtils.isDescriptorWithLocalVisibility(suggested.getDescriptor())) {
                    baseName = baseName + "_0";
                }
                name2 = scope.declareFreshName(baseName);
            }
            this.nameCache.put(suggested.getDescriptor(), name2);
            names2.add(name2);
        }
        ArrayList<JsName> arrayList = names2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getActualNameFromSuggested"));
        }
        return arrayList;
    }

    @NotNull
    public JsName getNameForPackage(final @NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        JsName jsName = ContainerUtil.getOrCreate(this.packageNames, packageFqName, new Factory<JsName>(){

            @Override
            public JsName create() {
                String name2 = Namer.generatePackageName(packageFqName);
                return StaticContext.this.rootPackageScope.declareName(name2);
            }
        });
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getNameForPackage"));
        }
        return jsName;
    }

    @NotNull
    private JsNameRef getQualifierForParentPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        JsNameRef result2 = null;
        JsNameRef qualifier = null;
        FqName fqName2 = packageFqName;
        while (true) {
            JsNameRef ref = JsAstUtils.pureFqn(this.getNameForPackage(fqName2), null);
            if (qualifier == null) {
                result2 = ref;
            } else {
                qualifier.setQualifier(ref);
            }
            qualifier = ref;
            if (fqName2.isRoot()) break;
            fqName2 = fqName2.parent();
        }
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getQualifierForParentPackage"));
        }
        return jsNameRef;
    }

    @NotNull
    public JsConfig getConfig() {
        JsConfig jsConfig = this.config;
        if (jsConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getConfig"));
        }
        return jsConfig;
    }

    @NotNull
    public JsName declarePropertyOrPropertyAccessorName(@NotNull DeclarationDescriptor descriptor2, @NotNull String name2, boolean fresh) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        JsScope scope = this.getEnclosingScope(descriptor2);
        JsName jsName = fresh ? scope.declareFreshName(name2) : scope.declareName(name2);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "declarePropertyOrPropertyAccessorName"));
        }
        return jsName;
    }

    @NotNull
    private JsScope getEnclosingScope(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getEnclosingScope"));
        }
        DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        JsScope jsScope = this.getScopeForDescriptor(containingDeclaration.getOriginal());
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getEnclosingScope"));
        }
        return jsScope;
    }

    @Nullable
    public JsExpression getModuleExpressionFor(@NotNull DeclarationDescriptor descriptor2) {
        JsName moduleId;
        String moduleName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getModuleExpressionFor"));
        }
        ModuleDescriptor module = DescriptorUtils.getContainingModule(descriptor2);
        if (this.currentModule == module) {
            return JsAstUtils.pureFqn(Namer.getRootPackageName(), null);
        }
        if (module == module.getBuiltIns().getBuiltInsModule()) {
            moduleName = Namer.KOTLIN_LOWER_NAME;
        } else {
            moduleName = module.getName().asString();
            moduleName = moduleName.substring(1, moduleName.length() - 1);
        }
        if ("<unknown>".equals(moduleName)) {
            return null;
        }
        JsName jsName = moduleId = moduleName.equals(Namer.KOTLIN_LOWER_NAME) ? this.rootScope.declareName("Kotlin") : this.importedModules.get(moduleName);
        if (moduleId == null) {
            moduleId = this.rootScope.declareFreshName("$module$" + Namer.suggestedModuleName(moduleName));
            this.importedModules.put(moduleName, moduleId);
        }
        return JsAstUtils.pureFqn(moduleId, null);
    }

    private static JsExpression applySideEffects(JsExpression expression, DeclarationDescriptor descriptor2) {
        if (expression instanceof HasMetadata && (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof ClassDescriptor)) {
            MetadataProperties.setSideEffects((HasMetadata)((Object)expression), SideEffectKind.PURE);
        }
        return expression;
    }

    public void putClassOrConstructorClosure(@NotNull MemberDescriptor localClass, @NotNull List<DeclarationDescriptor> closure) {
        if (localClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localClass", "org/jetbrains/kotlin/js/translate/context/StaticContext", "putClassOrConstructorClosure"));
        }
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/js/translate/context/StaticContext", "putClassOrConstructorClosure"));
        }
        this.classOrConstructorClosure.put(localClass, Lists.newArrayList(closure));
    }

    @Nullable
    public List<DeclarationDescriptor> getClassOrConstructorClosure(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getClassOrConstructorClosure"));
        }
        List<DeclarationDescriptor> result2 = this.classOrConstructorClosure.get(descriptor2);
        return result2 != null ? Lists.newArrayList(result2) : null;
    }

    @NotNull
    public Map<ClassDescriptor, List<DeferredCallSite>> getDeferredCallSites() {
        Map<ClassDescriptor, List<DeferredCallSite>> map2 = this.deferredCallSites;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/StaticContext", "getDeferredCallSites"));
        }
        return map2;
    }

    private final class ScopeGenerator
    extends Generator<JsScope> {
        public ScopeGenerator() {
            Rule<JsScope> generateNewScopesForClassesWithNoAncestors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$1", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2) == null) {
                        return StaticContext.this.getRootScope().innerObjectScope("Scope for class " + descriptor2.getName());
                    }
                    return null;
                }
            };
            Rule<JsScope> generateInnerScopesForDerivedClasses = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$2", "apply"));
                    }
                    if (!(descriptor2 instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor2);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerObjectScope("Scope for class " + descriptor2.getName());
                }
            };
            Rule<JsScope> generateNewScopesForPackageDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$3", "apply"));
                    }
                    if (!(descriptor2 instanceof PackageFragmentDescriptor)) {
                        return null;
                    }
                    return StaticContext.this.getRootScope().innerObjectScope("Package " + descriptor2.getName());
                }
            };
            Rule<JsScope> generateInnerScopesForMembers = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$4", "apply"));
                    }
                    JsScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor2);
                    return enclosingScope.innerObjectScope("Scope for member " + descriptor2.getName());
                }
            };
            Rule<JsScope> createFunctionObjectsForCallableDescriptors = new Rule<JsScope>(){

                @Override
                public JsScope apply(@NotNull DeclarationDescriptor descriptor2) {
                    if (descriptor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/StaticContext$ScopeGenerator$5", "apply"));
                    }
                    if (!(descriptor2 instanceof CallableDescriptor)) {
                        return null;
                    }
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(StaticContext.this.getRootScope());
                    assert (!StaticContext.this.scopeToFunction.containsKey(correspondingFunction.getScope())) : "Scope to function value overridden for " + descriptor2;
                    StaticContext.this.scopeToFunction.put(correspondingFunction.getScope(), correspondingFunction);
                    return correspondingFunction.getScope();
                }
            };
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForPackageDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }
}

