/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultVariant
implements ConfigurationVariant {
    private final String name;
    private final AttributeContainerInternal attributes;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final PublishArtifactSet artifacts;

    public DefaultVariant(String name, AttributeContainerInternal parentAttributes, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory cache) {
        this.name = name;
        this.attributes = new DefaultMutableAttributeContainer(cache, parentAttributes);
        this.artifactNotationParser = artifactNotationParser;
        this.artifacts = new DefaultPublishArtifactSet(name + " artifacts", (DomainObjectSet)new DefaultDomainObjectSet(PublishArtifact.class), fileCollectionFactory);
    }

    public String getName() {
        return this.name;
    }

    public OutgoingVariant convertToOutgoingVariant() {
        return new OutgoingVariant(){

            @Override
            public AttributeContainerInternal getAttributes() {
                return DefaultVariant.this.attributes;
            }

            @Override
            public Set<? extends PublishArtifact> getArtifacts() {
                return DefaultVariant.this.artifacts;
            }

            @Override
            public Set<? extends OutgoingVariant> getChildren() {
                return ImmutableSet.of();
            }
        };
    }

    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add(this.artifactNotationParser.parseNotation(notation));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }
}

