/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.cache.Stash;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassFilesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;

public class ClassSetAnalysisUpdater {
    private static final Logger LOG = Logging.getLogger(ClassSetAnalysisUpdater.class);
    private static final Predicate<File> IS_CLASS_DIRECTORY = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private final Stash<ClassSetAnalysisData> stash;
    private final FileOperations fileOperations;
    private ClassDependenciesAnalyzer analyzer;
    private final FileHasher fileHasher;

    public ClassSetAnalysisUpdater(Stash<ClassSetAnalysisData> stash, FileOperations fileOperations, ClassDependenciesAnalyzer analyzer, FileHasher fileHasher) {
        this.stash = stash;
        this.fileOperations = fileOperations;
        this.analyzer = analyzer;
        this.fileHasher = fileHasher;
    }

    public void updateAnalysis(JavaCompileSpec spec) {
        Timer clock = Timers.startTimer();
        LinkedHashSet baseDirs = Sets.newLinkedHashSet();
        baseDirs.add(spec.getDestinationDir());
        Iterables.addAll((Collection)baseDirs, (Iterable)Iterables.filter((Iterable)spec.getCompileClasspath(), IS_CLASS_DIRECTORY));
        ClassFilesAnalyzer analyzer = new ClassFilesAnalyzer(this.analyzer, this.fileHasher);
        for (File baseDir : baseDirs) {
            this.fileOperations.fileTree((Object)baseDir).visit((FileVisitor)analyzer);
        }
        ClassSetAnalysisData data = analyzer.getAnalysis();
        this.stash.put((Object)data);
        LOG.info("Class dependency analysis for incremental compilation took {}.", (Object)clock.getElapsed());
    }
}

