/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;

public abstract class JsLiteral
extends JsExpressionImpl {
    public static final JsValueLiteral THIS = new JsThisRef();
    public static final JsNameRef UNDEFINED = new JsNameRef("undefined");
    public static final JsNullLiteral NULL = new JsNullLiteral();
    public static final JsBooleanLiteral TRUE = new JsBooleanLiteral(true);
    public static final JsBooleanLiteral FALSE = new JsBooleanLiteral(false);

    public static JsBooleanLiteral getBoolean(boolean truth) {
        return truth ? TRUE : FALSE;
    }

    public static abstract class JsValueLiteral
    extends JsLiteral {
        protected JsValueLiteral() {
        }

        @Override
        public final boolean isLeaf() {
            return true;
        }

        @Override
        @NotNull
        public JsExpression deepCopy() {
            JsValueLiteral jsValueLiteral = this;
            if (jsValueLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsLiteral$JsValueLiteral", "deepCopy"));
            }
            return jsValueLiteral;
        }
    }

    public static final class JsBooleanLiteral
    extends JsValueLiteral {
        private final boolean value;

        private JsBooleanLiteral(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public void accept(JsVisitor v) {
            v.visitBoolean(this);
        }

        @Override
        public void traverse(JsVisitorWithContext v, JsContext ctx) {
            v.visit(this, ctx);
            v.endVisit(this, ctx);
        }
    }

    public static final class JsThisRef
    extends JsValueLiteral {
        private JsThisRef() {
        }

        @Override
        public void accept(JsVisitor v) {
            v.visitThis(this);
        }

        @Override
        public void traverse(JsVisitorWithContext v, JsContext ctx) {
            v.visit(this, ctx);
            v.endVisit(this, ctx);
        }
    }
}

