/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import com.google.common.collect.Lists;
import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.api.internal.project.antbuilder.ClassPathToClassLoaderCache;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.jvm.Jvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIsolatedAntBuilder
implements IsolatedAntBuilder,
Stoppable {
    private static final Logger LOG = Logging.getLogger(DefaultIsolatedAntBuilder.class);
    private final ClassLoader antLoader;
    private final ClassLoader baseAntLoader;
    private final ClassPath libClasspath;
    private final ClassLoader antAdapterLoader;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderFactory classLoaderFactory;
    private final ModuleRegistry moduleRegistry;
    private final ClassPathToClassLoaderCache classLoaderCache;
    private final GroovySystemLoader gradleApiGroovyLoader;
    private final GroovySystemLoader antAdapterGroovyLoader;

    public DefaultIsolatedAntBuilder(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory, ModuleRegistry moduleRegistry) {
        this.classPathRegistry = classPathRegistry;
        this.classLoaderFactory = classLoaderFactory;
        this.moduleRegistry = moduleRegistry;
        this.libClasspath = new DefaultClassPath(new File[0]);
        GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
        this.classLoaderCache = new ClassPathToClassLoaderCache(groovySystemLoaderFactory);
        ArrayList antClasspath = Lists.newArrayList((Iterable)classPathRegistry.getClassPath("ANT").getAsFiles());
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            antClasspath.add(toolsJar);
        }
        if (this.needJaxpHackery()) {
            antClasspath.addAll(moduleRegistry.getExternalModule("xercesImpl").getImplementationClasspath().getAsFiles());
        }
        this.antLoader = classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath((Iterable)antClasspath));
        FilteringClassLoader loggingLoader = new FilteringClassLoader(this.getClass().getClassLoader());
        loggingLoader.allowPackage("org.slf4j");
        loggingLoader.allowPackage("org.apache.commons.logging");
        loggingLoader.allowPackage("org.apache.log4j");
        loggingLoader.allowClass(Logger.class);
        loggingLoader.allowClass(LogLevel.class);
        this.baseAntLoader = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{this.antLoader, loggingLoader}));
        ClassPath gradleCoreUrls = moduleRegistry.getModule("gradle-core").getImplementationClasspath();
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-logging").getImplementationClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getExternalModule("groovy-all").getClasspath());
        gradleCoreUrls = gradleCoreUrls.plus(moduleRegistry.getModule("gradle-base-services").getImplementationClasspath());
        this.antAdapterLoader = new MutableURLClassLoader(this.baseAntLoader, gradleCoreUrls);
        this.gradleApiGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.getClass().getClassLoader());
        this.antAdapterGroovyLoader = groovySystemLoaderFactory.forClassLoader(this.antAdapterLoader);
    }

    private boolean needJaxpHackery() {
        return !JavaVersion.current().isJava7Compatible() && ClassLoader.getSystemResource("META-INF/services/javax.xml.parsers.SAXParserFactory") != null;
    }

    protected DefaultIsolatedAntBuilder(DefaultIsolatedAntBuilder copy, Iterable<File> libClasspath) {
        this.classPathRegistry = copy.classPathRegistry;
        this.classLoaderFactory = copy.classLoaderFactory;
        this.moduleRegistry = copy.moduleRegistry;
        this.antLoader = copy.antLoader;
        this.baseAntLoader = copy.baseAntLoader;
        this.antAdapterLoader = copy.antAdapterLoader;
        this.libClasspath = new DefaultClassPath(libClasspath);
        this.gradleApiGroovyLoader = copy.gradleApiGroovyLoader;
        this.antAdapterGroovyLoader = copy.antAdapterGroovyLoader;
        this.classLoaderCache = copy.classLoaderCache;
    }

    public ClassPathToClassLoaderCache getClassLoaderCache() {
        return this.classLoaderCache;
    }

    @Override
    public IsolatedAntBuilder withClasspath(Iterable<File> classpath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forking a new isolated ant builder for classpath : {}", classpath);
        }
        return new DefaultIsolatedAntBuilder(this, classpath);
    }

    @Override
    public void execute(final Closure antClosure) {
        this.classLoaderCache.withCachedClassLoader(this.libClasspath, this.gradleApiGroovyLoader, this.antAdapterGroovyLoader, (Factory<? extends ClassLoader>)new Factory<ClassLoader>(){

            public ClassLoader create() {
                return new MutableURLClassLoader(DefaultIsolatedAntBuilder.this.baseAntLoader, DefaultIsolatedAntBuilder.this.libClasspath);
            }
        }, (Action<? super CachedClassLoader>)new Action<CachedClassLoader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(CachedClassLoader cachedClassLoader) {
                ClassLoader classLoader = cachedClassLoader.getClassLoader();
                Object antBuilder = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.BasicAntBuilder");
                Object antLogger = DefaultIsolatedAntBuilder.this.newInstanceOf("org.gradle.api.internal.project.ant.AntLoggingAdapter");
                ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    DefaultIsolatedAntBuilder.this.configureAntBuilder(antBuilder, antLogger);
                    AntBuilderDelegate delegate = new AntBuilderDelegate(antBuilder, classLoader);
                    new ClosureBackedAction(antClosure).execute((Object)delegate);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                    DefaultIsolatedAntBuilder.this.disposeBuilder(antBuilder, antLogger);
                }
            }
        });
    }

    private Object newInstanceOf(String className) {
        try {
            return this.antAdapterLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private Object getProject(Object antBuilder) throws Exception {
        return antBuilder.getClass().getMethod("getProject", new Class[0]).invoke(antBuilder, new Object[0]);
    }

    protected void configureAntBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method addBuildListener = projectClass.getDeclaredMethod("addBuildListener", buildListenerClass);
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            Method getBuildListeners = projectClass.getDeclaredMethod("getBuildListeners", new Class[0]);
            Vector listeners = (Vector)getBuildListeners.invoke(project, new Object[0]);
            removeBuildListener.invoke(project, listeners.get(0));
            addBuildListener.invoke(project, antLogger);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
    }

    protected void disposeBuilder(Object antBuilder, Object antLogger) {
        try {
            Object project = this.getProject(antBuilder);
            Class<?> projectClass = project.getClass();
            ClassLoader cl = projectClass.getClassLoader();
            Class<?> buildListenerClass = cl.loadClass("org.apache.tools.ant.BuildListener");
            Method removeBuildListener = projectClass.getDeclaredMethod("removeBuildListener", buildListenerClass);
            removeBuildListener.invoke(project, antLogger);
            antBuilder.getClass().getDeclaredMethod("close", new Class[0]).invoke(antBuilder, new Object[0]);
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
    }

    public void stop() {
        this.classLoaderCache.stop();
        this.gradleApiGroovyLoader.discardTypesFrom(this.antAdapterLoader);
        this.gradleApiGroovyLoader.discardTypesFrom(this.antLoader);
        this.antAdapterGroovyLoader.shutdown();
    }
}

