/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.Serializable;
import javax.tools.JavaCompiler;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.JdkTools;
import org.gradle.internal.jvm.Jvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHomeBasedJavaCompilerFactory
implements Factory<JavaCompiler>,
Serializable {
    private final Factory<? extends File> currentJvmJavaHomeFactory;
    private final Factory<? extends File> systemPropertiesJavaHomeFactory;
    private final Factory<? extends JavaCompiler> systemJavaCompilerFactory;

    public JavaHomeBasedJavaCompilerFactory() {
        this(new CurrentJvmJavaHomeFactory(), new SystemPropertiesJavaHomeFactory(), new SystemJavaCompilerFactory());
    }

    JavaHomeBasedJavaCompilerFactory(Factory<? extends File> currentJvmJavaHomeFactory, Factory<? extends File> systemPropertiesJavaHomeFactory, Factory<? extends JavaCompiler> systemJavaCompilerFactory) {
        this.currentJvmJavaHomeFactory = currentJvmJavaHomeFactory;
        this.systemPropertiesJavaHomeFactory = systemPropertiesJavaHomeFactory;
        this.systemJavaCompilerFactory = systemJavaCompilerFactory;
    }

    public JavaCompiler create() {
        JavaCompiler compiler = this.findCompiler();
        if (compiler == null) {
            throw new RuntimeException("Cannot find System Java Compiler. Ensure that you have installed a JDK (not just a JRE) and configured your JAVA_HOME system variable to point to the according directory.");
        }
        return compiler;
    }

    private JavaCompiler findCompiler() {
        File javaHomeFromToolProvidersPointOfView;
        File realJavaHome = (File)this.currentJvmJavaHomeFactory.create();
        if (realJavaHome.equals(javaHomeFromToolProvidersPointOfView = (File)this.systemPropertiesJavaHomeFactory.create())) {
            return (JavaCompiler)this.systemJavaCompilerFactory.create();
        }
        return (JavaCompiler)SystemProperties.getInstance().withJavaHome(realJavaHome, this.systemJavaCompilerFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SystemJavaCompilerFactory
    implements Factory<JavaCompiler>,
    Serializable {
        public JavaCompiler create() {
            return JdkTools.current().getSystemJavaCompiler();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SystemPropertiesJavaHomeFactory
    implements Factory<File>,
    Serializable {
        public File create() {
            return SystemProperties.getInstance().getJavaHomeDir();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrentJvmJavaHomeFactory
    implements Factory<File>,
    Serializable {
        public File create() {
            return Jvm.current().getJavaHome();
        }
    }
}

