/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.BiAction;
import org.gradle.internal.Transformers;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.language.base.internal.model.ComponentSpecInitializer;
import org.gradle.language.base.internal.model.FunctionalSourceSetNodeInitializer;
import org.gradle.language.base.internal.registry.DefaultLanguageRegistry;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.collection.internal.BridgedCollections;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessor;
import org.gradle.model.collection.internal.ChildNodeInitializerStrategyAccessors;
import org.gradle.model.collection.internal.PolymorphicModelMapProjection;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeBackedModelMap;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.Service;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ConstructableTypesRegistry;
import org.gradle.model.internal.manage.schema.extract.DefaultConstructableTypesRegistry;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryContainer;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class LanguageBasePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ModelRegistry modelRegistry;

    @Inject
    public LanguageBasePlugin(Instantiator instantiator, ModelRegistry modelRegistry) {
        this.instantiator = instantiator;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project target) {
        target.getPluginManager().apply(LifecycleBasePlugin.class);
        this.applyRules(this.modelRegistry);
    }

    private void applyRules(ModelRegistry modelRegistry) {
        DefaultBinaryContainer binaries = (DefaultBinaryContainer)this.instantiator.newInstance(DefaultBinaryContainer.class, new Object[]{this.instantiator});
        String descriptor = LanguageBasePlugin.class.getSimpleName() + ".apply()";
        SimpleModelRuleDescriptor ruleDescriptor = new SimpleModelRuleDescriptor(descriptor);
        ModelPath binariesPath = ModelPath.path((String)"binaries");
        ModelType binarySpecModelType = ModelType.of(BinarySpec.class);
        modelRegistry.createOrReplace(BridgedCollections.creator((ModelReference)ModelReference.of((ModelPath)binariesPath, DefaultBinaryContainer.class), (Transformer)Transformers.constant((Object)binaries), (Namer)Named.Namer.INSTANCE, (String)descriptor, (Transformer)BridgedCollections.itemDescriptor((String)descriptor)).descriptor(descriptor).service(true).ephemeral(true).withProjection(PolymorphicModelMapProjection.of((ModelType)binarySpecModelType, (ChildNodeInitializerStrategyAccessor)ChildNodeInitializerStrategyAccessors.of((ChildNodeInitializerStrategy)NodeBackedModelMap.createUsingParentNode((ModelType)binarySpecModelType)))).withProjection(UnmanagedModelProjection.of(DefaultBinaryContainer.class)).build());
        modelRegistry.configure(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of((ModelPath)binariesPath), (ModelRuleDescriptor)ruleDescriptor, (Action)new Action<MutableModelNode>((ModelRuleDescriptor)ruleDescriptor){
            final /* synthetic */ ModelRuleDescriptor val$ruleDescriptor;
            {
                this.val$ruleDescriptor = modelRuleDescriptor;
            }

            public void execute(MutableModelNode binariesNode) {
                binariesNode.applyToAllLinks(ModelActionRole.Finalize, (ModelAction)InputUsingModelAction.single((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)this.val$ruleDescriptor, (ModelReference)ModelReference.of(ITaskFactory.class), (BiAction)new BiAction<BinarySpec, ITaskFactory>(){

                    public void execute(BinarySpec binary, ITaskFactory taskFactory) {
                        if (!((BinarySpecInternal)binary).isLegacyBinary()) {
                            TaskInternal binaryLifecycleTask = (TaskInternal)taskFactory.create(binary.getName(), DefaultTask.class);
                            binaryLifecycleTask.setGroup("build");
                            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
                            binary.setBuildTask((Task)binaryLifecycleTask);
                        }
                    }
                }));
            }
        }));
        modelRegistry.getRoot().applyToAllLinksTransitive(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of(BinarySpec.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor(descriptor), ComponentSpecInitializer.binaryAction()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Service
        ModelSchemaStore schemaStore(ServiceRegistry serviceRegistry) {
            return (ModelSchemaStore)serviceRegistry.get(ModelSchemaStore.class);
        }

        @Service
        ManagedProxyFactory proxyFactory(ServiceRegistry serviceRegistry) {
            return (ManagedProxyFactory)serviceRegistry.get(ManagedProxyFactory.class);
        }

        @Service
        ConstructableTypesRegistry constructableTypesRegistry() {
            return new DefaultConstructableTypesRegistry();
        }

        @Mutate
        void registerFunctionalSourceSetNodeInitializer(ConstructableTypesRegistry constructableTypesRegistry, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            constructableTypesRegistry.registerConstructableType(ModelType.of(FunctionalSourceSet.class), (NodeInitializer)new FunctionalSourceSetNodeInitializer(instantiator));
        }

        @Mutate
        void registerNodeInitializerExtractionStrategies(NodeInitializerRegistry nodeInitializerRegistry, ConstructableTypesRegistry constructableTypesRegistry) {
            nodeInitializerRegistry.registerStrategy((NodeInitializerExtractionStrategy)constructableTypesRegistry);
        }

        @Model
        ProjectSourceSet sources(ServiceRegistry serviceRegistry) {
            return (ProjectSourceSet)((Instantiator)serviceRegistry.get(Instantiator.class)).newInstance(DefaultProjectSourceSet.class, new Object[0]);
        }

        @Service
        LanguageRegistry languages() {
            return new DefaultLanguageRegistry();
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, ModelMap<BinarySpec> binaries) {
            for (BinarySpec binary : binaries) {
                tasks.addAll((Collection)((Object)binary.getTasks()));
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add((Object)buildTask);
            }
        }

        @Mutate
        void attachBinariesToAssembleLifecycle(@Path(value="tasks.assemble") Task assemble, ModelMap<BinarySpec> binaries) {
            ArrayList notBuildable = Lists.newArrayList();
            boolean hasBuildableBinaries = false;
            for (BinarySpec binary : binaries) {
                BinarySpecInternal binarySpecInternal = (BinarySpecInternal)binary;
                if (binarySpecInternal.isLegacyBinary()) continue;
                if (binarySpecInternal.isBuildable()) {
                    assemble.dependsOn(new Object[]{binarySpecInternal});
                    hasBuildableBinaries = true;
                    continue;
                }
                notBuildable.add(binarySpecInternal);
            }
            if (!hasBuildableBinaries && !notBuildable.isEmpty()) {
                assemble.doFirst((Action)new CheckForNotBuildableBinariesAction(notBuildable));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckForNotBuildableBinariesAction
        implements Action<Task> {
            private final List<BinarySpecInternal> notBuildable;

            public CheckForNotBuildableBinariesAction(List<BinarySpecInternal> notBuildable) {
                this.notBuildable = notBuildable;
            }

            public void execute(Task task) {
                Set taskDependencies = task.getTaskDependencies().getDependencies(task);
                if (taskDependencies.isEmpty()) {
                    TreeFormatter formatter = new TreeFormatter();
                    formatter.node("No buildable binaries found");
                    formatter.startChildren();
                    for (BinarySpecInternal binary : this.notBuildable) {
                        formatter.node(binary.getName());
                        formatter.startChildren();
                        binary.getBuildAbility().explain((TreeVisitor<? super String>)formatter);
                        formatter.endChildren();
                    }
                    formatter.endChildren();
                    throw new GradleException(formatter.toString());
                }
            }
        }
    }
}

