/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ExpressionReplacingVisitorSupport;
import org.gradle.internal.SystemProperties;
import org.gradle.model.dsl.internal.inputs.PotentialInputs;
import org.gradle.model.dsl.internal.transform.InputReferences;
import org.gradle.model.dsl.internal.transform.RuleMetadata;
import org.gradle.model.dsl.internal.transform.SourceLocation;
import org.gradle.model.dsl.internal.transform.TransformedClosure;
import org.gradle.model.internal.core.ModelPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class RuleVisitor
extends ExpressionReplacingVisitorSupport {
    public static final String INVALID_ARGUMENT_LIST = "argument list must be exactly 1 literal non empty string";
    private static final String AST_NODE_METADATA_INPUTS_KEY = RuleVisitor.class.getName() + ".inputs";
    private static final String AST_NODE_METADATA_LOCATION_KEY = RuleVisitor.class.getName() + ".location";
    private static final String DOLLAR = "$";
    private static final String GET = "get";
    private static final ClassNode RULE_METADATA = new ClassNode(RuleMetadata.class);
    private static final ClassNode POTENTIAL_INPUTS = new ClassNode(PotentialInputs.class);
    private static final ClassNode TRANSFORMED_CLOSURE = new ClassNode(TransformedClosure.class);
    private static final String INPUTS_LVAR_NAME = "__rule_inputs_var__";
    private static final String INPUTS_FIELD_NAME = "__rule_inputs__";
    private static final Token ASSIGN = new Token(100, "=", -1, -1);
    private final SourceUnit sourceUnit;
    private InputReferences inputs;
    private VariableExpression inputsVariable;

    public RuleVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public static void visitGeneratedClosure(ClassNode node) {
        MethodNode method = AstUtils.getGeneratedClosureImplMethod((ClassNode)node);
        Statement closureCode = method.getCode();
        SourceLocation sourceLocation = (SourceLocation)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY);
        if (sourceLocation != null) {
            AnnotationNode metadataAnnotation = new AnnotationNode(RULE_METADATA);
            metadataAnnotation.addMember("absoluteScriptSourceLocation", (Expression)new ConstantExpression((Object)sourceLocation.getUri()));
            metadataAnnotation.addMember("lineNumber", (Expression)new ConstantExpression((Object)sourceLocation.getLineNumber()));
            metadataAnnotation.addMember("columnNumber", (Expression)new ConstantExpression((Object)sourceLocation.getColumnNumber()));
            InputReferences inputs = (InputReferences)closureCode.getNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY);
            if (!inputs.isEmpty()) {
                metadataAnnotation.addMember("absoluteInputPaths", (Expression)new ListExpression(RuleVisitor.constants(inputs.getAbsolutePaths())));
                metadataAnnotation.addMember("absoluteInputLineNumbers", (Expression)new ListExpression(RuleVisitor.constants(inputs.getAbsolutePathLineNumbers())));
            }
            node.addAnnotation(metadataAnnotation);
            node.addInterface(TRANSFORMED_CLOSURE);
            node.addField(new FieldNode(INPUTS_FIELD_NAME, 1, POTENTIAL_INPUTS, node, null));
            ArrayList<ExpressionStatement> statements = new ArrayList<ExpressionStatement>();
            statements.add(new ExpressionStatement((Expression)new BinaryExpression((Expression)new VariableExpression(INPUTS_FIELD_NAME), ASSIGN, (Expression)new VariableExpression("inputs"))));
            node.addMethod(new MethodNode("applyRuleInputs", 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(POTENTIAL_INPUTS, "inputs")}, new ClassNode[0], (Statement)new BlockStatement(statements, new VariableScope())));
        }
    }

    private static List<Expression> constants(Collection<?> values) {
        ArrayList expressions = Lists.newArrayListWithCapacity((int)values.size());
        for (Object value : values) {
            expressions.add(new ConstantExpression(value));
        }
        return expressions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitRuleClosure(ClosureExpression expression, SourceLocation sourceLocation) {
        if (this.inputs != null) {
            throw new IllegalStateException("Already visiting a rule closure");
        }
        this.inputs = new InputReferences();
        try {
            this.inputsVariable = new VariableExpression(INPUTS_LVAR_NAME, POTENTIAL_INPUTS);
            super.visitClosureExpression(expression);
            BlockStatement code = (BlockStatement)expression.getCode();
            code.setNodeMetaData((Object)AST_NODE_METADATA_LOCATION_KEY, (Object)sourceLocation);
            code.setNodeMetaData((Object)AST_NODE_METADATA_INPUTS_KEY, (Object)this.inputs);
            this.inputsVariable.setClosureSharedVariable(true);
            code.getVariableScope().putDeclaredVariable((Variable)this.inputsVariable);
            DeclarationExpression variableDeclaration = new DeclarationExpression(this.inputsVariable, ASSIGN, (Expression)new VariableExpression(INPUTS_FIELD_NAME));
            code.getStatements().add(0, new ExpressionStatement((Expression)variableDeclaration));
            for (Parameter parameter : expression.getParameters()) {
                if (!parameter.hasInitialExpression()) continue;
                code.getStatements().add(1, new ExpressionStatement((Expression)new BinaryExpression((Expression)new VariableExpression(parameter.getName()), ASSIGN, parameter.getInitialExpression())));
                parameter.setInitialExpression((Expression)ConstantExpression.NULL);
            }
        }
        finally {
            this.inputs = null;
        }
    }

    public void visitClosureExpression(ClosureExpression expression) {
        expression.getVariableScope().putReferencedLocalVariable((Variable)this.inputsVariable);
        super.visitClosureExpression(expression);
    }

    public void visitPropertyExpression(PropertyExpression expr) {
        String modelPath = this.isDollarPathExpression(expr);
        if (modelPath != null) {
            this.inputs.absolutePath(modelPath, expr.getLineNumber());
            this.replaceVisitedExpressionWith((Expression)this.inputReferenceExpression(modelPath));
        } else {
            super.visitPropertyExpression(expr);
        }
    }

    private String isDollarPathExpression(PropertyExpression expr) {
        if (expr.getObjectExpression() instanceof VariableExpression) {
            VariableExpression objectExpression = (VariableExpression)expr.getObjectExpression();
            if (objectExpression.getName().equals(DOLLAR)) {
                return expr.getPropertyAsString();
            }
            return null;
        }
        if (expr.getObjectExpression() instanceof PropertyExpression) {
            PropertyExpression objectExpression = (PropertyExpression)expr.getObjectExpression();
            String path = this.isDollarPathExpression(objectExpression);
            if (path != null) {
                return path + '.' + expr.getPropertyAsString();
            }
            return null;
        }
        return null;
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        String methodName = call.getMethodAsString();
        if (call.isImplicitThis() && methodName != null && methodName.equals(DOLLAR)) {
            this.visitInputMethod(call);
        } else {
            super.visitMethodCallExpression(call);
        }
    }

    private void visitInputMethod(MethodCallExpression call) {
        ConstantExpression argExpression = AstUtils.hasSingleConstantStringArg((MethodCallExpression)call);
        if (argExpression == null) {
            this.error((ASTNode)call, INVALID_ARGUMENT_LIST);
        } else {
            String modelPath = argExpression.getText();
            if (modelPath.isEmpty()) {
                this.error((ASTNode)argExpression, INVALID_ARGUMENT_LIST);
                return;
            }
            try {
                ModelPath.validatePath((String)modelPath);
            }
            catch (ModelPath.InvalidPathException e) {
                String message = "Invalid model path given as rule input." + SystemProperties.getInstance().getLineSeparator() + "  > " + e.getMessage();
                if (e.getCause() != null) {
                    message = message + SystemProperties.getInstance().getLineSeparator() + "    > " + e.getCause().getMessage();
                }
                this.error((ASTNode)argExpression, message);
                return;
            }
            this.inputs.absolutePath(modelPath, call.getLineNumber());
            this.replaceVisitedExpressionWith((Expression)this.inputReferenceExpression(modelPath));
        }
    }

    private MethodCallExpression inputReferenceExpression(String modelPath) {
        return new MethodCallExpression((Expression)new VariableExpression((Variable)this.inputsVariable), (Expression)new ConstantExpression((Object)GET), (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)modelPath)));
    }

    private void error(ASTNode call, String message) {
        SyntaxException syntaxException = new SyntaxException(message, call.getLineNumber(), call.getColumnNumber());
        this.sourceUnit.getErrorCollector().addError(syntaxException, this.sourceUnit);
    }
}

