/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClientProtocol;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonServerProtocol;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.WorkerProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilerDaemonClient
implements CompilerDaemon,
CompilerDaemonClientProtocol,
Stoppable {
    private final DaemonForkOptions forkOptions;
    private final WorkerProcess workerProcess;
    private final CompilerDaemonServerProtocol server;
    private final BlockingQueue<CompileResult> compileResults = new SynchronousQueue<CompileResult>();

    public CompilerDaemonClient(DaemonForkOptions forkOptions, WorkerProcess workerProcess, CompilerDaemonServerProtocol server) {
        this.forkOptions = forkOptions;
        this.workerProcess = workerProcess;
        this.server = server;
    }

    @Override
    public <T extends CompileSpec> CompileResult execute(Compiler<T> compiler, T spec) {
        try {
            this.server.execute(compiler, spec);
            return this.compileResults.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    public void stop() {
        this.server.stop();
        this.workerProcess.waitForStop();
    }

    @Override
    public void executed(CompileResult result) {
        try {
            this.compileResults.put(result);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

