/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMExternalizableStringList;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.util.xmlb.ArrayBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.CompactCollectionBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMElementBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MapBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializationException;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.CollectionBean;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Text;

class XmlSerializerImpl {
    private static Reference<Map<Pair<Type, MutableAccessor>, Binding>> ourBindings;

    XmlSerializerImpl() {
    }

    @Nullable
    static Binding getBinding(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type2), type2, null);
    }

    @Nullable
    static Binding getBinding(@NotNull MutableAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        Type type2 = accessor.getGenericType();
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type2), type2, accessor);
    }

    @NotNull
    static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type2 instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type2).getRawType();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        return clazz;
    }

    @Nullable
    static synchronized Binding getClassBinding(@NotNull Class<?> aClass2, @NotNull Type originalType, @Nullable MutableAccessor accessor) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (aClass2.isPrimitive() || aClass2 == String.class || aClass2 == Integer.class || aClass2 == Long.class || aClass2 == Boolean.class || aClass2 == Double.class || aClass2 == Float.class || aClass2.isEnum() || Date.class.isAssignableFrom(aClass2)) {
            return null;
        }
        Pair<Type, MutableAccessor> key = Pair.create(originalType, accessor);
        Map<Pair<Type, MutableAccessor>, Binding> map2 = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map2.get(key);
        if (binding == null) {
            binding = XmlSerializerImpl.getNonCachedClassBinding(aClass2, accessor, originalType);
            map2.put(key, binding);
            try {
                binding.init(originalType);
            }
            catch (XmlSerializationException e) {
                map2.remove(key);
                throw e;
            }
        }
        return binding;
    }

    @NotNull
    private static Map<Pair<Type, MutableAccessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, MutableAccessor>, Binding> map2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ourBindings);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<Pair<Type, MutableAccessor>, Binding>();
            ourBindings = new SoftReference<Map<Pair<Type, MutableAccessor>, Binding>>(map2);
        }
        Map<Pair<Type, MutableAccessor>, Binding> map3 = map2;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getBindingCacheMap"));
        }
        return map3;
    }

    @NotNull
    private static Binding getNonCachedClassBinding(@NotNull Class<?> aClass2, @Nullable MutableAccessor accessor, @NotNull Type originalType) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (aClass2.isArray()) {
            if (Element.class.isAssignableFrom(aClass2.getComponentType())) {
                assert (accessor != null);
                JDOMElementBinding jDOMElementBinding = new JDOMElementBinding(accessor);
                if (jDOMElementBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return jDOMElementBinding;
            }
            ArrayBinding arrayBinding = new ArrayBinding(aClass2, accessor);
            if (arrayBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
            }
            return arrayBinding;
        }
        if (Collection.class.isAssignableFrom(aClass2) && originalType instanceof ParameterizedType) {
            CollectionBean listBean;
            if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                CompactCollectionBinding compactCollectionBinding = new CompactCollectionBinding(accessor);
                if (compactCollectionBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return compactCollectionBinding;
            }
            CollectionBinding collectionBinding = new CollectionBinding((ParameterizedType)originalType, accessor);
            if (collectionBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
            }
            return collectionBinding;
        }
        if (accessor != null) {
            if (Map.class.isAssignableFrom(aClass2) && originalType instanceof ParameterizedType) {
                MapBinding mapBinding = new MapBinding(accessor);
                if (mapBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return mapBinding;
            }
            if (Element.class.isAssignableFrom(aClass2)) {
                JDOMElementBinding jDOMElementBinding = new JDOMElementBinding(accessor);
                if (jDOMElementBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return jDOMElementBinding;
            }
            if (JDOMExternalizableStringList.class == aClass2) {
                CompactCollectionBinding compactCollectionBinding = new CompactCollectionBinding(accessor);
                if (compactCollectionBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return compactCollectionBinding;
            }
        }
        BeanBinding beanBinding = new BeanBinding(aClass2, accessor);
        if (beanBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        return beanBinding;
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "convert"));
        }
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull MutableAccessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            Object deserializedValue = null;
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                deserializedValue = enumConstant;
            }
            accessor.set(host, deserializedValue);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            }
            accessor.set(host, deserializedValue);
        }
    }

    @NotNull
    static String getTextValue(@NotNull Element element, @NotNull String defaultText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        if (defaultText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultText", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        List<Content> content = element.getContent();
        int size = content.size();
        StringBuilder builder = null;
        for (int i = 0; i < size; ++i) {
            Content child = content.get(i);
            if (!(child instanceof Text)) continue;
            String value = child.getValue();
            if (builder == null && i == size - 1) {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
                }
                return string;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(value);
        }
        String string = builder == null ? defaultText : builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/xmlb/XmlSerializerImpl", "getTextValue"));
        }
        return string;
    }
}

