/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.process.internal.daemon.DaemonForkOptions;
import org.gradle.process.internal.daemon.WorkerDaemonClient;
import org.gradle.process.internal.daemon.WorkerDaemonManager;
import org.gradle.process.internal.daemon.WorkerDaemonProtocol;
import org.gradle.process.internal.daemon.WorkerDaemonStarter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonClientsManager {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonManager.class);
    private final Object lock = new Object();
    private final List<WorkerDaemonClient> allClients = new ArrayList<WorkerDaemonClient>();
    private final List<WorkerDaemonClient> idleClients = new ArrayList<WorkerDaemonClient>();
    private WorkerDaemonStarter workerDaemonStarter;

    public WorkerDaemonClientsManager(WorkerDaemonStarter workerDaemonStarter) {
        this.workerDaemonStarter = workerDaemonStarter;
    }

    public WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<WorkerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WorkerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                WorkerDaemonClient candidate = it.next();
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                return candidate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerDaemonClient reserveNewClient(Class<? extends WorkerDaemonProtocol> serverImplementationClass, File workingDir, DaemonForkOptions forkOptions) {
        WorkerDaemonClient client = this.workerDaemonStarter.startDaemon(serverImplementationClass, workingDir, forkOptions);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(WorkerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.idleClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.debug("Stopping {} worker daemon(s).", (Object)this.allClients.size());
            CompositeStoppable.stoppable(this.allClients).stop();
            LOGGER.info("Stopped {} worker daemon(s).", (Object)this.allClients.size());
            this.allClients.clear();
        }
    }
}

