/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.generator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.UncheckedException;
import org.gradle.plugins.ide.internal.generator.generator.PersistableConfigurationObject;

public abstract class AbstractPersistableConfigurationObject
implements PersistableConfigurationObject {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File inputFile) {
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            this.load(inputStream);
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDefaults() {
        try {
            String defaultResourceName = this.getDefaultResourceName();
            InputStream inputStream = this.getClass().getResourceAsStream(defaultResourceName);
            if (inputStream == null) {
                throw new IllegalStateException(String.format("Failed to load default resource '%s' of persistable configuration object of type '%s' (resource not found)", defaultResourceName, this.getClass().getName()));
            }
            try {
                this.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public abstract void load(InputStream var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(File outputFile) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
            this.store(outputStream);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public abstract void store(OutputStream var1);

    protected abstract String getDefaultResourceName();
}

