/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class DefaultResolvedArtifactsBuilder
implements DependencyArtifactsVisitor {
    private final boolean buildProjectDependencies;
    private final Map<Long, ArtifactSet> artifactSets = Maps.newLinkedHashMap();
    private final Set<Long> buildableArtifactSets = new HashSet<Long>();

    public DefaultResolvedArtifactsBuilder(boolean buildProjectDependencies) {
        this.buildProjectDependencies = buildProjectDependencies;
    }

    @Override
    public void visitArtifacts(DependencyGraphNode from, DependencyGraphNode to, ArtifactSet artifacts) {
        ProjectComponentIdentifier incomingId;
        this.artifactSets.put(artifacts.getId(), artifacts);
        if (!this.buildProjectDependencies) {
            return;
        }
        if (this.buildableArtifactSets.contains(artifacts.getId())) {
            return;
        }
        ConfigurationMetadata configurationMetadata = to.getMetadata();
        if (!(configurationMetadata instanceof LocalConfigurationMetadata)) {
            return;
        }
        if (from.getOwner().getComponentId() instanceof ProjectComponentIdentifier && !(incomingId = (ProjectComponentIdentifier)from.getOwner().getComponentId()).getBuild().isCurrentBuild()) {
            return;
        }
        this.buildableArtifactSets.add(artifacts.getId());
    }

    @Override
    public void finishArtifacts() {
    }

    public VisitedArtifactsResults complete() {
        LinkedHashMap artifactsById = Maps.newLinkedHashMap();
        for (Map.Entry<Long, ArtifactSet> entry : this.artifactSets.entrySet()) {
            ArtifactSet resolvedArtifacts = entry.getValue().snapshot();
            artifactsById.put(entry.getKey(), resolvedArtifacts);
        }
        return new DefaultResolvedArtifactResults(artifactsById, this.buildableArtifactSets);
    }
}

