/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DependencyResultSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.cache.BinaryStore;
import org.gradle.api.internal.cache.Store;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.time.Timer;
import org.gradle.internal.time.Timers;

public class StreamingResolutionResultBuilder
implements DependencyGraphVisitor {
    private static final byte ROOT = 1;
    private static final byte COMPONENT = 2;
    private static final byte DEPENDENCY = 3;
    private final Map<ComponentSelector, ModuleVersionResolveException> failures = new HashMap<ComponentSelector, ModuleVersionResolveException>();
    private final BinaryStore store;
    private final ComponentResultSerializer componentResultSerializer = new ComponentResultSerializer();
    private final Store<ResolvedComponentResult> cache;
    private final DependencyResultSerializer dependencyResultSerializer = new DependencyResultSerializer();
    private final Set<Long> visitedComponents = new HashSet<Long>();

    public StreamingResolutionResultBuilder(BinaryStore store, Store<ResolvedComponentResult> cache) {
        this.store = store;
        this.cache = cache;
    }

    public ResolutionResult complete() {
        BinaryStore.BinaryData data = this.store.done();
        RootFactory rootSource = new RootFactory(data, this.failures, this.cache);
        return new DefaultResolutionResult(rootSource);
    }

    @Override
    public void start(DependencyGraphNode root) {
    }

    @Override
    public void finish(final DependencyGraphNode root) {
        this.store.write(new BinaryStore.WriteAction(){

            public void write(Encoder encoder) throws IOException {
                encoder.writeByte((byte)1);
                encoder.writeSmallLong(root.getOwner().getResultId().longValue());
            }
        });
    }

    @Override
    public void visitNode(DependencyGraphNode resolvedConfiguration) {
        final DependencyGraphComponent component = resolvedConfiguration.getOwner();
        if (this.visitedComponents.add(component.getResultId())) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)2);
                    StreamingResolutionResultBuilder.this.componentResultSerializer.write(encoder, component);
                }
            });
        }
    }

    @Override
    public void visitEdge(DependencyGraphNode resolvedConfiguration) {
        final Long fromComponent = resolvedConfiguration.getOwner().getResultId();
        final Set<? extends DependencyGraphEdge> dependencies = resolvedConfiguration.getOutgoingEdges();
        if (!dependencies.isEmpty()) {
            this.store.write(new BinaryStore.WriteAction(){

                public void write(Encoder encoder) throws IOException {
                    encoder.writeByte((byte)3);
                    encoder.writeSmallLong(fromComponent.longValue());
                    encoder.writeSmallInt(dependencies.size());
                    for (DependencyResult dependency : dependencies) {
                        StreamingResolutionResultBuilder.this.dependencyResultSerializer.write(encoder, dependency);
                        if (dependency.getFailure() == null) continue;
                        StreamingResolutionResultBuilder.this.failures.put(dependency.getRequested(), dependency.getFailure());
                    }
                }
            });
        }
    }

    private static class RootFactory
    implements Factory<ResolvedComponentResult> {
        private static final Logger LOG = Logging.getLogger(RootFactory.class);
        private final ComponentResultSerializer componentResultSerializer = new ComponentResultSerializer();
        private final BinaryStore.BinaryData data;
        private final Map<ComponentSelector, ModuleVersionResolveException> failures;
        private final Store<ResolvedComponentResult> cache;
        private final Object lock = new Object();
        private final DependencyResultSerializer dependencyResultSerializer = new DependencyResultSerializer();

        public RootFactory(BinaryStore.BinaryData data, Map<ComponentSelector, ModuleVersionResolveException> failures, Store<ResolvedComponentResult> cache) {
            this.data = data;
            this.failures = failures;
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResolvedComponentResult create() {
            Object object = this.lock;
            synchronized (object) {
                return (ResolvedComponentResult)this.cache.load((Factory)new Factory<ResolvedComponentResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public ResolvedComponentResult create() {
                        try {
                            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)RootFactory.this.data.read((BinaryStore.ReadAction)new BinaryStore.ReadAction<ResolvedComponentResult>(){

                                public ResolvedComponentResult read(Decoder decoder) throws IOException {
                                    return RootFactory.this.deserialize(decoder);
                                }
                            });
                            return resolvedComponentResult;
                        }
                        finally {
                            try {
                                RootFactory.this.data.close();
                            }
                            catch (IOException e) {
                                throw UncheckedException.throwAsUncheckedException((Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        private ResolvedComponentResult deserialize(Decoder decoder) {
            int valuesRead = 0;
            int type = -1;
            Timer clock = Timers.startTimer();
            try {
                DefaultResolutionResultBuilder builder = new DefaultResolutionResultBuilder();
                block7: while (true) {
                    type = decoder.readByte();
                    ++valuesRead;
                    switch (type) {
                        case 1: {
                            Long rootId = decoder.readSmallLong();
                            ResolvedComponentResult root = builder.complete(rootId).getRoot();
                            LOG.debug("Loaded resolution results ({}) from {}", (Object)clock.getElapsed(), (Object)this.data);
                            return root;
                        }
                        case 2: {
                            ComponentResult component = this.componentResultSerializer.read(decoder);
                            builder.visitComponent(component);
                            continue block7;
                        }
                        case 3: {
                            Long fromId = decoder.readSmallLong();
                            int size = decoder.readSmallInt();
                            ArrayList<DependencyResult> deps = new ArrayList<DependencyResult>(size);
                            for (int i = 0; i < size; ++i) {
                                deps.add(this.dependencyResultSerializer.read(decoder, this.failures));
                            }
                            builder.visitOutgoingEdges(fromId, deps);
                            continue block7;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown value type read from stream: " + type);
            }
            catch (IOException e) {
                throw new RuntimeException("Problems loading the resolution results (" + clock.getElapsed() + "). " + "Read " + valuesRead + " values, last was: " + type, e);
            }
        }
    }
}

