/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.sftp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.net.URI;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resource.transport.sftp.LockableSftpClient;
import org.gradle.internal.resource.transport.sftp.SftpHost;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SftpClientFactory
implements Stoppable {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(SftpClientFactory.class);
    private SftpClientCreator sftpClientCreator = new SftpClientCreator();
    private final Object lock = new Object();
    private final ListMultimap<SftpHost, LockableSftpClient> clients = ArrayListMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockableSftpClient createSftpClient(URI uri, PasswordCredentials credentials) {
        Object object = this.lock;
        synchronized (object) {
            SftpHost sftpHost = new SftpHost(uri, credentials);
            return this.acquireClient(sftpHost);
        }
    }

    private LockableSftpClient acquireClient(SftpHost sftpHost) {
        return this.clients.containsKey((Object)sftpHost) ? this.reuseExistingOrCreateNewClient(sftpHost) : this.sftpClientCreator.createNewClient(sftpHost);
    }

    private LockableSftpClient reuseExistingOrCreateNewClient(SftpHost sftpHost) {
        List clientsByHost = this.clients.get((Object)sftpHost);
        if (clientsByHost.isEmpty()) {
            return this.sftpClientCreator.createNewClient(sftpHost);
        }
        return (LockableSftpClient)clientsByHost.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSftpClient(LockableSftpClient sftpClient) {
        Object object = this.lock;
        synchronized (object) {
            this.clients.put((Object)sftpClient.getHost(), (Object)sftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            try {
                CompositeStoppable stoppable = new CompositeStoppable();
                for (LockableSftpClient client : this.clients.values()) {
                    stoppable.add(new Object[]{client});
                }
                stoppable.stop();
            }
            finally {
                this.clients.clear();
            }
        }
    }

    private static class DefaultLockableSftpClient
    implements LockableSftpClient {
        final SftpHost host;
        final ChannelSftp channelSftp;
        final Session session;

        private DefaultLockableSftpClient(SftpHost host, ChannelSftp channelSftp, Session session) {
            this.host = host;
            this.channelSftp = channelSftp;
            this.session = session;
        }

        public void stop() {
            this.channelSftp.disconnect();
            this.session.disconnect();
        }

        @Override
        public SftpHost getHost() {
            return this.host;
        }

        @Override
        public ChannelSftp getSftpClient() {
            return this.channelSftp;
        }
    }

    private static class SftpClientCreator {
        private JSch jsch;

        private SftpClientCreator() {
        }

        public LockableSftpClient createNewClient(SftpHost sftpHost) {
            try {
                Session session = this.createJsch().getSession(sftpHost.getUsername(), sftpHost.getHostname(), sftpHost.getPort());
                session.setPassword(sftpHost.getPassword());
                session.connect();
                Channel channel = session.openChannel("sftp");
                channel.connect();
                return new DefaultLockableSftpClient(sftpHost, (ChannelSftp)channel, session);
            }
            catch (JSchException e) {
                URI serverUri = URI.create(String.format("sftp://%s:%d", sftpHost.getHostname(), sftpHost.getPort()));
                if (e.getMessage().equals("Auth fail")) {
                    throw new ResourceException(serverUri, String.format("Password authentication not supported or invalid credentials for SFTP server at %s", serverUri), (Throwable)e);
                }
                throw new ResourceException(serverUri, String.format("Could not connect to SFTP server at %s", serverUri), (Throwable)e);
            }
        }

        private JSch createJsch() {
            if (this.jsch == null) {
                JSch.setConfig((String)"PreferredAuthentications", (String)"password");
                JSch.setConfig((String)"MaxAuthTries", (String)"1");
                this.jsch = new JSch();
                if (LOGGER.isDebugEnabled()) {
                    JSch.setLogger((Logger)new Logger(){

                        public boolean isEnabled(int level) {
                            return true;
                        }

                        public void log(int level, String message) {
                            LOGGER.debug(message);
                        }
                    });
                }
                this.jsch.setHostKeyRepository(new HostKeyRepository(){

                    public int check(String host, byte[] key) {
                        return 0;
                    }

                    public void add(HostKey hostkey, UserInfo ui) {
                    }

                    public void remove(String host, String type) {
                    }

                    public void remove(String host, String type, byte[] key) {
                    }

                    public String getKnownHostsRepositoryID() {
                        return "allow-everything";
                    }

                    public HostKey[] getHostKey() {
                        throw new UnsupportedOperationException();
                    }

                    public HostKey[] getHostKey(String host, String type) {
                        return new HostKey[0];
                    }
                });
            }
            return this.jsch;
        }
    }
}

