/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashCode;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.CompilationFileState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;

public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private final BaseSerializerFactory serializerFactory = new BaseSerializerFactory();
    private final Serializer<File> fileSerializer = this.serializerFactory.getSerializerFor(File.class);
    private final SetSerializer<File> fileSetSerializer = new SetSerializer(this.fileSerializer);
    private final MapSerializer<File, CompilationFileState> stateMapSerializer = new MapSerializer(this.fileSerializer, (Serializer)new CompilationFileStateSerializer());

    public CompilationState read(Decoder decoder) throws Exception {
        ImmutableSet sourceInputs = ImmutableSet.copyOf((Collection)this.fileSetSerializer.read(decoder));
        ImmutableMap fileStates = ImmutableMap.copyOf((Map)this.stateMapSerializer.read(decoder));
        return new CompilationState((ImmutableSet<File>)sourceInputs, (ImmutableMap<File, CompilationFileState>)fileStates);
    }

    public void write(Encoder encoder, CompilationState value) throws Exception {
        this.fileSetSerializer.write(encoder, value.getSourceInputs());
        this.stateMapSerializer.write(encoder, value.getFileStates());
    }

    private class IncludeSerializer
    implements Serializer<Include> {
        private final Serializer<String> stringSerializer;
        private final Serializer<Boolean> booleanSerializer;
        private final Serializer<IncludeType> enumSerializer;

        private IncludeSerializer() {
            this.stringSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(String.class);
            this.booleanSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(Boolean.class);
            this.enumSerializer = CompilationStateSerializer.this.serializerFactory.getSerializerFor(IncludeType.class);
        }

        public Include read(Decoder decoder) throws Exception {
            String value = (String)this.stringSerializer.read(decoder);
            boolean isImport = (Boolean)this.booleanSerializer.read(decoder);
            IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
            return new DefaultInclude(value, isImport, type);
        }

        public void write(Encoder encoder, Include value) throws Exception {
            this.stringSerializer.write(encoder, (Object)value.getValue());
            this.booleanSerializer.write(encoder, (Object)value.isImport());
            this.enumSerializer.write(encoder, (Object)value.getType());
        }
    }

    private class SourceIncludesSerializer
    implements Serializer<IncludeDirectives> {
        private final Serializer<Include> includeSerializer;
        private final ListSerializer<Include> includeListSerializer;

        private SourceIncludesSerializer() {
            this.includeSerializer = new IncludeSerializer();
            this.includeListSerializer = new ListSerializer(this.includeSerializer);
        }

        public IncludeDirectives read(Decoder decoder) throws Exception {
            return new DefaultIncludeDirectives(this.includeListSerializer.read(decoder));
        }

        public void write(Encoder encoder, IncludeDirectives value) throws Exception {
            this.includeListSerializer.write(encoder, value.getIncludesAndImports());
        }
    }

    private class ResolvedIncludeSerializer
    implements Serializer<ResolvedInclude> {
        private ResolvedIncludeSerializer() {
        }

        public ResolvedInclude read(Decoder decoder) throws Exception {
            String include = decoder.readString();
            File included = null;
            if (decoder.readBoolean()) {
                included = (File)CompilationStateSerializer.this.fileSerializer.read(decoder);
            }
            return new ResolvedInclude(include, included);
        }

        public void write(Encoder encoder, ResolvedInclude value) throws Exception {
            encoder.writeString((CharSequence)value.getInclude());
            if (value.getFile() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                CompilationStateSerializer.this.fileSerializer.write(encoder, (Object)value.getFile());
            }
        }
    }

    private class CompilationFileStateSerializer
    implements Serializer<CompilationFileState> {
        private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();
        private final Serializer<Set<ResolvedInclude>> resolveIncludesSerializer = new SetSerializer((Serializer)new ResolvedIncludeSerializer());
        private final Serializer<IncludeDirectives> sourceIncludesSerializer = new SourceIncludesSerializer();

        private CompilationFileStateSerializer() {
        }

        public CompilationFileState read(Decoder decoder) throws Exception {
            HashCode hash = (HashCode)this.hashSerializer.read(decoder);
            ImmutableSet resolvedIncludes = ImmutableSet.copyOf((Collection)((Collection)this.resolveIncludesSerializer.read(decoder)));
            IncludeDirectives includeDirectives = (IncludeDirectives)this.sourceIncludesSerializer.read(decoder);
            return new CompilationFileState(hash, includeDirectives, (ImmutableSet<ResolvedInclude>)resolvedIncludes);
        }

        public void write(Encoder encoder, CompilationFileState value) throws Exception {
            this.hashSerializer.write(encoder, (Object)value.getHash());
            this.resolveIncludesSerializer.write(encoder, value.getResolvedIncludes());
            this.sourceIncludesSerializer.write(encoder, (Object)value.getIncludeDirectives());
        }
    }
}

