/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

public class FunctionResult {
    private String message;
    private int errno;
    private Failure failure = Failure.Generic;
    private String errorCodeDescription;

    void failed(String message, int failure, int errno, String errorCodeDescription) {
        this.message = message;
        this.failure = Failure.values()[failure];
        this.errno = errno;
        this.errorCodeDescription = errorCodeDescription;
    }

    void failed(String message) {
        this.message = message;
    }

    public boolean isFailed() {
        return this.message != null;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public String getMessage() {
        if (this.errorCodeDescription != null && this.errorCodeDescription.length() > 0) {
            return String.format("%s (errno %d: %s)", this.message, this.errno, this.errorCodeDescription);
        }
        if (this.errno != 0) {
            return String.format("%s (errno %d)", this.message, this.errno);
        }
        return this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Failure {
        Generic,
        NoSuchFile,
        NotADirectory;

    }
}

