#ifndef _Ogreebler_H_
#define _Ogreebler_H_

enum
{
	// Info button
	GREEBLER_INFO						=	1000,

	// General (2000) =======================
	// - Random Seed Value
	GREEBLER_SEED						=	2001,
	// - Subdivisions
	GREEBLER_SUBDIV						=	2003,
	// - Show Input Objects
	GREEBLER_SHOWINPUT					=	2004,
	// - Polygon Clusters
	GREEBLER_POLYGROUP_ENABLE			=	2005,
	GREEBLER_POLYGROUP_SPARSITY			=	2006,
	GREEBLER_POLYGROUP_SIZE				=	2007,
	// - Invert Polygon Normals
	GREEBLER_INVNORMALS					=	2008,
	// - Level of Detail
	GREEBLER_LOD						=	2009,
	GREEBLER_LOD_USE					=	2010,
	// - Polygon Exclusions
	GREEBLER_LOWAREA_USE				=	2011,
	GREEBLER_LOWAREA					=	2012,
	GREEBLER_THINPOLY_USE				=	2013,
	GREEBLER_THINPOLY					=	2014,
	// - Quick Generator Disable
	GREEBLER_GENERATOR_DISABLE			=	2015,

	// Base (3000) ==========================
	GREEBLER_BASE_GENERATE				=	3000,
	GREEBLER_BASE_SELECTIONS			=	3001,
	GREEBLER_BASE_SPARSITY				=	3002,
	GREEBLER_BASE_HEIGHT_MIN			=	3003,
	GREEBLER_BASE_HEIGHT_MAX			=	3004,
	GREEBLER_BASE_BEVEL_MIN				=	3005,
	GREEBLER_BASE_BEVEL_MAX				=	3006,
	GREEBLER_BASE_BCAP					=	3007,
	GREEBLER_BASE_INSELTEX				=	3008,
	GREEBLER_BASE_LOD					=	3009,
	GREEBLER_BASE_PHONG					=	3010,
	GREEBLER_BASE_PHONGANGLELIMIT		=	3011,
	GREEBLER_BASE_PHONGANGLE			=	3012,
	GREEBLER_BASE_END					=	3013,
										
	// Stock Greebles (4000-7000) ===========
	GREEBLER_GREE_GENERATE				=	4000,
	GREEBLER_GREE_SELECTIONS			=	4001,
	GREEBLER_GREE_SPARSITY				=	4002,
	GREEBLER_GREE_PERPOLYGON			=	4003,
	GREEBLER_GREE_HEIGHT_MIN			=	4004,
	GREEBLER_GREE_HEIGHT_MAX			=	4005,
	GREEBLER_GREE_BEVEL_MIN				=	4006,
	GREEBLER_GREE_BEVEL_MAX				=	4007,
	GREEBLER_GREE_LENGTH_MIN			=	4008,
	GREEBLER_GREE_LENGTH_MAX			=	4009,
	GREEBLER_GREE_WIDTH_MIN				=	4010,
	GREEBLER_GREE_WIDTH_MAX				=	4011,
	// - Bars
	GREEBLER_GREE_BARS_MIN				=	4012,
	GREEBLER_GREE_BARS_MAX				=	4013,
	GREEBLER_GREE_BARS_OBJ				=	4014,
		GREEBLER_GREE_SHAPE_CUBE		=	0,
		GREEBLER_GREE_SHAPE_T			=	1,
		GREEBLER_GREE_SHAPE_L			=	2,
		GREEBLER_GREE_SHAPE_C			=	3,
		GREEBLER_GREE_SHAPE_H			=	4,
		GREEBLER_GREE_SHAPE_D			=	5,
		GREEBLER_GREE_SHAPE_BOX			=	6,
		GREEBLER_GREE_SHAPE_CUBECC		=	7,
		GREEBLER_GREE_SHAPE_OBLOCT		=	8,
		GREEBLER_GREE_SHAPE_CYLINDER	=	9,
		GREEBLER_GREE_SHAPE_RING		=	10,
		GREEBLER_GREE_SHAPE_REGPOLY		=	11,
		GREEBLER_GREE_SHAPE_REGPOLYR	=	12,
	GREEBLER_GREE_BARS_ASPECT			=	4030,
	GREEBLER_GREE_BARS_SIZE_MIN			=	4037,
	GREEBLER_GREE_BARS_SIZE_MAX			=	4038,
	// - Arrays
	GREEBLER_GREE_ARRAY_MMIN			=	4031,
	GREEBLER_GREE_ARRAY_MMAX			=	4032,
	GREEBLER_GREE_ARRAY_NMIN			=	4033,
	GREEBLER_GREE_ARRAY_NMAX			=	4034,
	GREEBLER_GREE_ARRAY_ASPECT			=	4035,
	GREEBLER_GREE_ARRAY_SIZE_MIN		=	4039,
	GREEBLER_GREE_ARRAY_SIZE_MAX		=	4040,
	// -- Same choices are GREEBLER_GREE_BARS_OBJ
	GREEBLER_GREE_ARRAY_OBJ				=	4036,
	// - Ring Arrays
	GREEBLER_GREE_RARRAY_NMIN			=	4062,
	GREEBLER_GREE_RARRAY_NMAX			=	4063,
	GREEBLER_GREE_RARRAY_ASPECT			=	4064,
	GREEBLER_GREE_RARRAY_SIZE_MIN		=	4065,
	GREEBLER_GREE_RARRAY_SIZE_MAX		=	4066,
	GREEBLER_GREE_RARRAY_OBJ			=	4067,
	GREEBLER_GREE_RARRAY_SCALE			=	4068,
	// - Cylinder/Rings
	GREEBLER_GREE_ROTSEGS				=	4015,
	GREEBLER_GREE_CASPECT				=	4016,
	GREEBLER_GREE_CSIZE_MIN				=	4017,
	GREEBLER_GREE_CSIZE_MAX				=	4018,
	GREEBLER_GREE_RING_INNERSIZE		=	4019,
	GREEBLER_GREE_RING_INNERHLOC		=	4020,
	GREEBLER_GREE_RING_INNERVLOC		=	4021,
	// --
	GREEBLER_GREE_BCAP					=	4022,
	GREEBLER_GREE_USMAP					=	4023,
	// - Box
	GREEBLER_GREE_BOX_INNERLENGTH		=	4024,
	GREEBLER_GREE_BOX_INNERWIDTH		=	4025,
	GREEBLER_GREE_BOX_INNERHLOC			=	4026,
	GREEBLER_GREE_BOX_INNERVLOC			=	4027,
	// - Regular Polygons
	GREEBLER_GREE_RP_SIDES				=	4041,
	GREEBLER_GREE_RP_ASPECT				=	4042,
	GREEBLER_GREE_RP_SIZE_MIN			=	4043,
	GREEBLER_GREE_RP_SIZE_MAX			=	4044,
	GREEBLER_GREE_RP_INNERSIZE			=	4045,
	GREEBLER_GREE_RP_INNERHLOC			=	4046,
	GREEBLER_GREE_RP_INNERVLOC			=	4047,
	// - Shape Selection
	GREEBLER_GREE_SHAPES_ALL			=	4028,
	GREEBLER_GREE_SHAPES_NONE			=	4029,
	// - Surface Offest
	GREEBLER_GREE_SURFOFFSET_MIN		=	4048,
	GREEBLER_GREE_SURFOFFSET_MAX		=	4049,
	GREEBLER_GREE_LOD					=	4050,
	// - Other
	GREEBLER_GREE_RELAXBORDERS			=	4051,
	GREEBLER_GREE_GLOBALALIGN			=	4052,
	GREEBLER_GREE_GAROTATION			=	4053,
	GREEBLER_GREE_PHONG					=	4054,
	GREEBLER_GREE_PHONGANGLELIMIT		=	4055,
	GREEBLER_GREE_PHONGANGLE			=	4056,
	// - Images for Shape Options
	GREEBLER_GREE_BOXIMAGE				=	4057,
	GREEBLER_GREE_CYLIMAGE				=	4058,
	GREEBLER_GREE_RNGIMAGE				=	4059,
	GREEBLER_GREE_POLIMAGE				=	4060,
	GREEBLER_GREE_PLRIMAGE				=	4061,
	// - Group Selection
	GREEBLER_GREE_GROUP_ALL				=	4069,
	GREEBLER_GREE_GROUP_NONE			=	4070,
	// - Toggle State (5000)
	GREEBLER_SHAPE_CUBE					=	5000,
	GREEBLER_SHAPE_T					=	5001,
	GREEBLER_SHAPE_L					=	5002,
	GREEBLER_SHAPE_C					=	5003,
	GREEBLER_SHAPE_H					=	5004,
	GREEBLER_SHAPE_D					=	5005,
	GREEBLER_SHAPE_BOX					=	5006,
	GREEBLER_SHAPE_CUBECC				=	5007,
	GREEBLER_SHAPE_OBLOCT				=	5008,
	GREEBLER_SHAPE_CYLINDER				=	5009,
	GREEBLER_SHAPE_RING					=	5010,
	GREEBLER_SHAPE_BARS					=	5011,
	GREEBLER_SHAPE_REGPOLY				=	5012,
	GREEBLER_SHAPE_REGPOLYR				=	5013,
	GREEBLER_SHAPE_ARRAY				=	5014,
	GREEBLER_SHAPE_RARRAY				=	5015,
	// - BitmapButtons (6000)
	GREEBLER_BITMAP_CUBE				=	6000,
	GREEBLER_BITMAP_T					=	6001,
	GREEBLER_BITMAP_L					=	6002,
	GREEBLER_BITMAP_C					=	6003,
	GREEBLER_BITMAP_H					=	6004,
	GREEBLER_BITMAP_D					=	6005,
	GREEBLER_BITMAP_BOX					=	6006,
	GREEBLER_BITMAP_CUBECC				=	6007,
	GREEBLER_BITMAP_OBLOCT				=	6008,
	GREEBLER_BITMAP_CYLINDER			=	6009,
	GREEBLER_BITMAP_RING				=	6010,
	GREEBLER_BITMAP_BARS				=	6011,
	GREEBLER_BITMAP_REGPOLY				=	6012,
	GREEBLER_BITMAP_REGPOLYR			=	6013,
	GREEBLER_BITMAP_ARRAY				=	6014,
	GREEBLER_BITMAP_RARRAY				=	6015,
	// - Frequency Sliders (7000)
	GREEBLER_FREQ_CUBE					=	7000,
	GREEBLER_FREQ_T						=	7001,
	GREEBLER_FREQ_L						=	7002,
	GREEBLER_FREQ_C						=	7003,
	GREEBLER_FREQ_H						=	7004,
	GREEBLER_FREQ_D						=	7005,
	GREEBLER_FREQ_BOX					=	7006,
	GREEBLER_FREQ_CUBECC				=	7007,
	GREEBLER_FREQ_OBLOCT				=	7008,
	GREEBLER_FREQ_CYLINDER				=	7009,
	GREEBLER_FREQ_RING					=	7010,
	GREEBLER_FREQ_BARS					=	7011,
	GREEBLER_FREQ_REGPOLY				=	7012,
	GREEBLER_FREQ_REGPOLYR				=	7013,
	GREEBLER_FREQ_ARRAY					=	7014,
	GREEBLER_FREQ_RARRAY				=	7015,
	// - Random Rotation Checkboxes (7100)
	GREEBLER_ROT_RANDOM_CUBE			=	7100,
	GREEBLER_ROT_RANDOM_T				=	7101,
	GREEBLER_ROT_RANDOM_L				=	7102,
	GREEBLER_ROT_RANDOM_C				=	7103,
	GREEBLER_ROT_RANDOM_H				=	7104,
	GREEBLER_ROT_RANDOM_D				=	7105,
	GREEBLER_ROT_RANDOM_BOX				=	7106,
	GREEBLER_ROT_RANDOM_CUBECC			=	7107,
	GREEBLER_ROT_RANDOM_OBLOCT			=	7108,
	GREEBLER_ROT_RANDOM_CYLINDER		=	7109,
	GREEBLER_ROT_RANDOM_RING			=	7110,
	GREEBLER_ROT_RANDOM_BARS			=	7111,
	GREEBLER_ROT_RANDOM_REGPOLY			=	7112,
	GREEBLER_ROT_RANDOM_REGPOLYR		=	7113,
	GREEBLER_ROT_RANDOM_ARRAY			=	7114,
	GREEBLER_ROT_RANDOM_RARRAY			=	7115,
	// - Rotation Angle Sliders (7200)
	GREEBLER_ROT_ANGLE_CUBE				=	7200,
	GREEBLER_ROT_ANGLE_T				=	7201,
	GREEBLER_ROT_ANGLE_L				=	7202,
	GREEBLER_ROT_ANGLE_C				=	7203,
	GREEBLER_ROT_ANGLE_H				=	7204,
	GREEBLER_ROT_ANGLE_D				=	7205,
	GREEBLER_ROT_ANGLE_BOX				=	7206,
	GREEBLER_ROT_ANGLE_CUBECC			=	7207,
	GREEBLER_ROT_ANGLE_OBLOCT			=	7208,
	GREEBLER_ROT_ANGLE_CYLINDER			=	7209,
	GREEBLER_ROT_ANGLE_RING				=	7210,
	GREEBLER_ROT_ANGLE_BARS				=	7211,
	GREEBLER_ROT_ANGLE_REGPOLY			=	7212,
	GREEBLER_ROT_ANGLE_REGPOLYR			=	7213,
	GREEBLER_ROT_ANGLE_ARRAY			=	7214,
	GREEBLER_ROT_ANGLE_RARRAY			=	7215,
	GREEBLER_GREE_END					=	7216,

	// Custom Greebles (8000) ===============
	GREEBLER_GREEC_GENERATE				=	8000,
	GREEBLER_GREEC_SELECTIONS			=	8001,
	GREEBLER_GREEC_SPARSITY				=	8002,
	GREEBLER_GREEC_PERPOLYGON			=	8003,
	GREEBLER_GREEC_HEIGHT_MIN			=	8004,
	GREEBLER_GREEC_HEIGHT_MAX			=	8005,
	GREEBLER_GREEC_BEVEL_MIN			=	8006,
	GREEBLER_GREEC_BEVEL_MAX			=	8007,
	GREEBLER_GREEC_LENGTH_MIN			=	8008,
	GREEBLER_GREEC_LENGTH_MAX			=	8009,
	GREEBLER_GREEC_WIDTH_MIN			=	8010,
	GREEBLER_GREEC_WIDTH_MAX			=	8011,
	GREEBLER_GREEC_BCAP					=	8012,
	GREEBLER_GREEC_USMAP				=	8013,
	// - Shape Selection
	GREEBLER_GREEC_SHAPES_ALL			=	8014,
	GREEBLER_GREEC_SHAPES_NONE			=	8015,
	// - Bars
	GREEBLER_GREEC_BARS_MIN				=	8016,
	GREEBLER_GREEC_BARS_MAX				=	8017,
	GREEBLER_GREEC_BARS_ASPECT			=	8018,
	GREEBLER_GREEC_BARS_SIZE_MIN		=	8019,
	GREEBLER_GREEC_BARS_SIZE_MAX		=	8020,
	GREEBLER_GREEC_BARS_OBJ				=	8021,
	// - Arrays
	GREEBLER_GREEC_ARRAY_MMIN			=	8022,
	GREEBLER_GREEC_ARRAY_MMAX			=	8023,
	GREEBLER_GREEC_ARRAY_NMIN			=	8024,
	GREEBLER_GREEC_ARRAY_NMAX			=	8025,
	GREEBLER_GREEC_ARRAY_ASPECT			=	8026,
	GREEBLER_GREEC_ARRAY_SIZE_MIN		=	8027,
	GREEBLER_GREEC_ARRAY_SIZE_MAX		=	8028,
	GREEBLER_GREEC_ARRAY_OBJ			=	8029,
	// - Ring Arrays
	GREEBLER_GREEC_RARRAY_NMIN			=	8062,
	GREEBLER_GREEC_RARRAY_NMAX			=	8063,
	GREEBLER_GREEC_RARRAY_ASPECT		=	8064,
	GREEBLER_GREEC_RARRAY_SIZE_MIN		=	8065,
	GREEBLER_GREEC_RARRAY_SIZE_MAX		=	8066,
	GREEBLER_GREEC_RARRAY_OBJ			=	8067,
	GREEBLER_GREEC_RARRAY_SCALE			=	8068,
	// -
	GREEBLER_BITMAP_CBARS				=	8030,
	GREEBLER_FREQ_CBARS					=	8031,
	GREEBLER_SHAPE_CBARS				=	8032,
	GREEBLER_BITMAP_CARRAY				=	8033,
	GREEBLER_FREQ_CARRAY				=	8034,
	GREEBLER_SHAPE_CARRAY				=	8035,
	GREEBLER_BITMAP_CRARRAY				=	8069,
	GREEBLER_FREQ_CRARRAY				=	8070,
	GREEBLER_SHAPE_CRARRAY				=	8071,
	// - Null object containing shapes
	GREEBLER_GREEC_LIBRARY				=	8036,
	// - Number of Custom Greebles (en toto)
	GREEBLER_GREEC_COUNT				=	8037,
	// - Layout Group for Custom Greeble Buttons
	GREEBLER_GREEC_GREEBLES				=	8038,
	GREEBLER_GREEC_GREEBLES_COL1		=	8039,
	GREEBLER_GREEC_GREEBLES_COL2		=	8040,
	GREEBLER_GREEC_GREEBLES_COL3		=	8041,
	GREEBLER_GREEC_GREEBLES_COL4		=	8042,
	GREEBLER_GREEC_GREEBLES_COL5		=	8043,
	GREEBLER_GREEC_SPACER				=	8044,
	// - Combine Custom with Stock
	GREEBLER_GREEC_COMBINE				=	8045,
	// - Surface Offest
	GREEBLER_GREEC_SURFOFFSET_MIN		=	8046,
	GREEBLER_GREEC_SURFOFFSET_MAX		=	8047,
	GREEBLER_GREEC_LOD					=	8048,
	// - Other
	GREEBLER_GREEC_RELAXBORDERS			=	8049,
	GREEBLER_GREEC_LIBMANAGER			=	8050,
	GREEBLER_GREEC_GLOBALALIGN			=	8051,
	GREEBLER_GREEC_GAROTATION			=	8052,
	GREEBLER_GREEC_LIBINSERT			=	8053,
	GREEBLER_GREEC_PHONG				=	8054,
	GREEBLER_GREEC_PHONGANGLELIMIT		=	8055,
	GREEBLER_GREEC_PHONGANGLE			=	8056,
	GREEBLER_GREEC_BARS_ROTRANDOM		=	8057,
	GREEBLER_GREEC_BARS_ROTANGLE		=	8058,
	GREEBLER_GREEC_ARRAY_ROTRANDOM		=	8059,
	GREEBLER_GREEC_ARRAY_ROTANGLE		=	8060,
	GREEBLER_GREEC_RARRAY_ROTRANDOM		=	8072,
	GREEBLER_GREEC_RARRAY_ROTANGLE		=	8073,
	// - Group Selection
	GREEBLER_GREEC_GROUP_ALL			=	8074,
	GREEBLER_GREEC_GROUP_NONE			=	8075,
	// - BitmapButtons (9000-9999)
	GREEBLER_GREEC_BITMAP				=	9000,
	GREEBLER_GREEC_BITMAP_END			=	9999,
	// - Frequency Sliders (10000-10999)
	GREEBLER_GREEC_FREQ					=	10000,
	GREEBLER_GREEC_FREQ_END				=	10999,
	// - Custom Greeble Name (11000-11999)
	GREEBLER_GREEC_NAME					=	11000,
	// - Custom Greeble State (12000-12999)
	GREEBLER_GREEC_STATE				=	12000,
	// - Custom Greeble Random Rotation (13000-13999)
	GREEBLER_GREEC_ROT_RANDOM			=	13000,
	GREEBLER_GREEC_ROT_RANDOM_END		=	13999,
	// - Custom Greeble Rotation Angle (14000-14999)
	GREEBLER_GREEC_ROT_ANGLE			=	14000,
	GREEBLER_GREEC_ROT_ANGLE_END		=	14999,
	GREEBLER_GREEC_END 					=	15000,

	// Nurnies (20000) ===============
	GREEBLER_NURN_GENERATE				=	20000,
	GREEBLER_NURN_SPARSITY				=	20002,
	GREEBLER_NURN_PERPOLYGON			=	20003,
	GREEBLER_NURN_HEIGHT_MIN			=	20004,
	GREEBLER_NURN_HEIGHT_MAX			=	20005,
	GREEBLER_NURN_LENGTH_MIN			=	20006,
	GREEBLER_NURN_LENGTH_MAX			=	20009,
	GREEBLER_NURN_WIDTH_MIN				=	20010,
	GREEBLER_NURN_WIDTH_MAX				=	20011,
	GREEBLER_NURN_USMAP					=	20013,
	// - Nurnie Selection
	GREEBLER_NURN_OBJECTS_ALL			=	20014,
	GREEBLER_NURN_OBJECTS_NONE			=	20015,
	// - Bars
	GREEBLER_NURN_BARS_MIN				=	20016,
	GREEBLER_NURN_BARS_MAX				=	20017,
	GREEBLER_NURN_BARS_ASPECT			=	20018,
	GREEBLER_NURN_BARS_SIZE_MIN			=	20019,
	GREEBLER_NURN_BARS_SIZE_MAX			=	20020,
	GREEBLER_NURN_BARS_OBJ				=	20021,
	// - Arrays							
	GREEBLER_NURN_ARRAY_MMIN			=	20022,
	GREEBLER_NURN_ARRAY_MMAX			=	20023,
	GREEBLER_NURN_ARRAY_NMIN			=	20024,
	GREEBLER_NURN_ARRAY_NMAX			=	20025,
	GREEBLER_NURN_ARRAY_ASPECT			=	20026,
	GREEBLER_NURN_ARRAY_SIZE_MIN		=	20027,
	GREEBLER_NURN_ARRAY_SIZE_MAX		=	20028,
	GREEBLER_NURN_ARRAY_OBJ				=	20029,
	// - Ring Arrays
	GREEBLER_NURN_RARRAY_NMIN			=	20062,
	GREEBLER_NURN_RARRAY_NMAX			=	20063,
	GREEBLER_NURN_RARRAY_ASPECT			=	20064,
	GREEBLER_NURN_RARRAY_SIZE_MIN		=	20065,
	GREEBLER_NURN_RARRAY_SIZE_MAX		=	20066,
	GREEBLER_NURN_RARRAY_OBJ			=	20067,
	GREEBLER_NURN_RARRAY_SCALE			=	20068,
	// -
	GREEBLER_BITMAP_NBARS				=	20030,
	GREEBLER_FREQ_NBARS					=	20031,
	GREEBLER_BASE_NBARS					=	20045,
	GREEBLER_OBJECT_NBARS				=	20032,
	GREEBLER_BITMAP_NARRAY				=	20033,
	GREEBLER_FREQ_NARRAY				=	20034,
	GREEBLER_BASE_NARRAY				=	20046,
	GREEBLER_OBJECT_NARRAY				=	20035,
	GREEBLER_BITMAP_NRARRAY				=	20069,
	GREEBLER_FREQ_NRARRAY				=	20070,
	GREEBLER_BASE_NRARRAY				=	20071,
	GREEBLER_OBJECT_NRARRAY				=	20072,
	// - Null object containing nurnies
	GREEBLER_NURN_LIBRARY				=	20036,
	// - Number of Nurnies (en toto)
	GREEBLER_NURN_COUNT					=	20037,
	// - Layout Group for Nurnie Buttons
	GREEBLER_NURN_GREEBLES				=	20038,
	GREEBLER_NURN_GREEBLES_COL1			=	20039,
	GREEBLER_NURN_GREEBLES_COL2			=	20040,
	GREEBLER_NURN_GREEBLES_COL3			=	20041,
	GREEBLER_NURN_GREEBLES_COL4			=	20042,
	GREEBLER_NURN_GREEBLES_COL5			=	20043,
	GREEBLER_NURN_SPACER				=	20044,
	// - Surface Offest
	GREEBLER_NURN_SURFOFFSET_MIN		=	20047,
	GREEBLER_NURN_SURFOFFSET_MAX		=	20048,
	// - Other
	GREEBLER_NURN_LOD					=	20049,
	GREEBLER_NURN_INSTANCE				=	20050,
	GREEBLER_NURN_RELAXBORDERS			=	20051,
	GREEBLER_NURN_LIBMANAGER			=	20052,
	GREEBLER_NURN_GLOBALALIGN			=	20053,
	GREEBLER_NURN_GAROTATION			=	20054,
	GREEBLER_NURN_LIBINSERT				=	20055,
	GREEBLER_NURN_RENDERINSTANCE		=	20056,
	GREEBLER_NURN_BARS_ROTRANDOM		=	20057,
	GREEBLER_NURN_BARS_ROTANGLE			=	20058,
	GREEBLER_NURN_ARRAY_ROTRANDOM		=	20059,
	GREEBLER_NURN_ARRAY_ROTANGLE		=	20060,
	GREEBLER_NURN_RARRAY_ROTRANDOM		=	20073,
	GREEBLER_NURN_RARRAY_ROTANGLE		=	20074,
	GREEBLER_NURN_BARS_SCALING			=	20075,
	GREEBLER_NURN_ARRAY_SCALING			=	20076,
	GREEBLER_NURN_RARRAY_SCALING		=	20077,
	// - Group Selection
	GREEBLER_NURN_GROUP_ALL				=	20078,
	GREEBLER_NURN_GROUP_NONE			=	20079,
	// - Use Absolute Height/Length/Width
	GREEBLER_NURN_HLW_ABSOLUTE			=	20080,
	// - BitmapButtons (21000-21999)
	GREEBLER_NURN_BITMAP				=	21000,
	GREEBLER_NURN_BITMAP_END			=	21999,
	// - Frequency Sliders (22000-22999)
	GREEBLER_NURN_FREQ					=	22000,
	GREEBLER_NURN_FREQ_END				=	22999,
	// - Nurnie Name (23000-23999)
	GREEBLER_NURN_NAME					=	23000,
	// - Nurnie State (24000-24999)
	GREEBLER_NURN_STATE					=	24000,
	// - Nurnie 'base' (25000-25999)
	GREEBLER_NURN_BASE					=	25000,
		GREEBLER_NURN_BASE_ORIGIN		=	0,
		GREEBLER_NURN_BASE_BOTTOM		=	1,
		GREEBLER_NURN_BASE_TOP			=	2,
		GREEBLER_NURN_BASE_LEFT			=	3,
		GREEBLER_NURN_BASE_RIGHT		=	4,
		GREEBLER_NURN_BASE_FRONT		=	5,
		GREEBLER_NURN_BASE_BACK			=	6,
	GREEBLER_NURN_BASE_END				=	25999,
	// - Nurnie Random Rotation (26000-26999)
	GREEBLER_NURN_ROT_RANDOM			=	26000,
	GREEBLER_NURN_ROT_RANDOM_END		=	26999,
	// - Nurnie Rotation Angle (27000-27999)
	GREEBLER_NURN_ROT_ANGLE				=	27000,
	GREEBLER_NURN_ROT_ANGLE_END			=	27999,
	// - Nurnie Scaling (28000-28999)
	GREEBLER_NURN_SCALING				=	28000,
	GREEBLER_NURN_SCALING_END			=	28999,
	GREEBLER_NURN_END					=	29000,

	// Piping (40000) ========================
	GREEBLER_PIPE_GENERATE				=	40000,
	// - Number of Pipe Types
	GREEBLER_PIPE_TYPES_COUNT			=	40001,
	// - Individual Pipe configurations
	GREEBLER_PIPE_LIBRARY				=	40002,
	// ***************************************
	// - For each Pipe Type (up to 100 types)
	GREEBLER_PIPE_TYPE_GROUP			=	41000,
	GREEBLER_PIPE_TYPE_GROUP_END		=	41099,
	GREEBLER_PIPE_STATE					=	41100,
	GREEBLER_PIPE_STATE_END				=	41199,
	// -- Number of Pipe Bundles on object surface
	GREEBLER_PIPE_COUNT_TEXT			=	41200,
	GREEBLER_PIPE_COUNT_MIN				=	41300,
	GREEBLER_PIPE_COUNT_MIN_END			=	41399,
	GREEBLER_PIPE_COUNT_MAX				=	41400,
	GREEBLER_PIPE_COUNT_MAX_END			=	41499,
	// -- Phong shading
	GREEBLER_PIPE_PHONG					=	41500,
	GREEBLER_PIPE_PHONG_END				=	41599,
	GREEBLER_PIPE_PHONGANGLELIMIT		=	41600,
	GREEBLER_PIPE_PHONGANGLELIMIT_END	=	41699,
	GREEBLER_PIPE_PHONGANGLE			=	41700,
	GREEBLER_PIPE_PHONGANGLE_END		=	41799,
	// -- Terminus distance from random surface point
	GREEBLER_PIPE_FULLLEN_TEXT			=	41800,
	GREEBLER_PIPE_FULLLEN_MIN			=	41900,
	GREEBLER_PIPE_FULLLEN_MIN_END		=	41999,
	GREEBLER_PIPE_FULLLEN_MAX			=	42000,
	GREEBLER_PIPE_FULLLEN_MAX_END		=	42099,
	// -- Separators
	GREEBLER_PIPE_SEPARATOR_1			=	42100,
	// -- Formatting Groups
	GREEBLER_PIPE_GROUP_1				=	45000,
	GREEBLER_PIPE_GROUP_2				=	45100,
	GREEBLER_PIPE_SINGLE_GROUP			=	45200,
	GREEBLER_PIPE_LINEAR_GROUP			=	45300,
	GREEBLER_PIPE_ARRAY_GROUP			=	45400,
	// -- Single, Linear, Array (etc. in future)
	GREEBLER_PIPE_SINGLE_STATE			=	50000,
	GREEBLER_PIPE_SINGLE_STATE_END		=	50099,
	GREEBLER_PIPE_LINEAR_STATE			=	50100,
	GREEBLER_PIPE_LINEAR_STATE_END		=	50199,
	GREEBLER_PIPE_ARRAY_STATE			=	50200,
	GREEBLER_PIPE_ARRAY_STATE_END		=	50299,
	GREEBLER_PIPE_SINGLE_FREQUENCY		=	50300,
	GREEBLER_PIPE_SINGLE_FREQUENCY_END	=	50399,
	GREEBLER_PIPE_LINEAR_FREQUENCY		=	50400,
	GREEBLER_PIPE_LINEAR_FREQUENCY_END	=	50499,
	GREEBLER_PIPE_ARRAY_FREQUENCY		=	50500,
	GREEBLER_PIPE_ARRAY_FREQUENCY_END	=	50599,
	GREEBLER_PIPE_LINEAR_TEXT			=	50600,
	GREEBLER_PIPE_LINEAR_MIN			=	50700,
	GREEBLER_PIPE_LINEAR_MIN_END		=	50799,
	GREEBLER_PIPE_LINEAR_MAX			=	50800,
	GREEBLER_PIPE_LINEAR_MAX_END		=	50899,
	GREEBLER_PIPE_ARRAY_ROW_TEXT		=	50900,
	GREEBLER_PIPE_ARRAY_ROW_MIN			=	51000,
	GREEBLER_PIPE_ARRAY_ROW_MIN_END		=	51099,
	GREEBLER_PIPE_ARRAY_ROW_MAX			=	51100,
	GREEBLER_PIPE_ARRAY_ROW_MAX_END		=	51199,
	GREEBLER_PIPE_ARRAY_COL_TEXT		=	51200,
	GREEBLER_PIPE_ARRAY_COL_MIN			=	51300,
	GREEBLER_PIPE_ARRAY_COL_MIN_END		=	51399,
	GREEBLER_PIPE_ARRAY_COL_MAX			=	51400,
	GREEBLER_PIPE_ARRAY_COL_MAX_END		=	51499,
	GREEBLER_PIPE_LINEAR_GROUP_1		=	60000,
	GREEBLER_PIPE_ARRAY_GROUP_1			=	70000,
	GREEBLER_PIPE_ARRAY_GROUP_2			=	70100,
	// -- Based on GREEBLER_PIPE_TYPE_GROUP
	GREEBLER_PIPE_DD_END				=	99999,
	// ***************************************

	// Presets (100000) ======================
	GREEBLER_PRESET_LOAD				=	100000,
	GREEBLER_PRESET_SAVE				=	100001,
	GREEBLER_PRESET_SAVEDEFAULT			=	100002,
	GREEBLER_PRESET_REMOVE				=	100003,
	GREEBLER_PRESET_FACTORY				=	100004,

	// Utility (101000) ======================
	GREEBLER_UTIL_MAKETAGS_LBL			=	101000,
	GREEBLER_UTIL_MAKETAGS_ALL			=	101001,
	GREEBLER_UTIL_MAKETAGS_SEL			=	101002,
	GREEBLER_UTIL_MAKETAGS_CONFIG		=	101003,
	GREEBLER_UTIL_CPLABEL				=	101004,
	GREEBLER_UTIL_COPY					=	101005,
	GREEBLER_UTIL_PASTE					=	101006,

	// Labels (110000)
	GREEBLER_TEXT_SHAPES				=	110000,
	GREEBLER_BASE_HEIGHT				=	110001,
	GREEBLER_BASE_BEVEL					=	110002,
	GREEBLER_GREE_HEIGHT				=	110003,
	GREEBLER_GREE_BEVEL					=	110004,
	GREEBLER_GREE_LENGTH				=	110005,
	GREEBLER_GREE_WIDTH					=	110006,
	GREEBLER_GREE_BARS					=	110007,
	GREEBLER_GREE_CYLRINGG				=	110008,
	GREEBLER_GREE_BARG					=	110009,
	GREEBLER_GREE_BOXG					=	110010,
	GREEBLER_GREE_REGPOLYG				=	110011,
	GREEBLER_GREE_ARRAYG				=	110012,
	GREEBLER_GREEC_HEIGHT				=	110013,
	GREEBLER_GREEC_BEVEL				=	110014,
	GREEBLER_GREEC_LENGTH				=	110015,
	GREEBLER_GREEC_WIDTH				=	110016,
	GREEBLER_GREEC_BARS					=	110017,
	GREEBLER_GREEC_BARG					=	110018,
	GREEBLER_GREEC_ARRAYG				=	110019,
	GREEBLER_GREE_SHAPEOPTIONS			=	110020,
	GREEBLER_GREEC_GROUPOPTIONS			=	110021,
	GREEBLER_GREEC_GROUPING				=	110022,
	GREEBLER_GREEC_SHAPES				=	110023,
	GREEBLER_GREE_GROUPING				=	110024,
	GREEBLER_GREE_GROUPOPTIONS			=	110025,
	GREEBLER_NURN_HEIGHT				=	110026,
	GREEBLER_NURN_LENGTH				=	110027,
	GREEBLER_NURN_WIDTH					=	110028,
	GREEBLER_NURN_GROUPING				=	110029,
	GREEBLER_NURN_GROUPOPTIONS			=	110030,
	GREEBLER_NURN_BARS					=	110031,
	GREEBLER_NURN_BARG					=	110032,
	GREEBLER_NURN_ARRAYG				=	110033,
	GREEBLER_NURN_OBJECTS				=	110034,
	GREEBLER_GROUP_POLYGROUP			=	110035,
	GREEBLER_GROUP_GREE_SETTING			=	110036,
	GREEBLER_GROUP_GREEC_SETTING		=	110037,
	GREEBLER_GROUP_NURN_SETTING			=	110038,
	GREEBLER_GREE_SURFOFFSET			=	110039,
	GREEBLER_GREEC_SURFOFFSET			=	110040,
	GREEBLER_NURN_SURFOFFSET			=	110041,
	GREEBLER_GROUP_PIPE_SETTING			=	110042,
	GREEBLER_GROUP_PIPE_TYPES			=	110043,
	GREEBLER_PIPE_COUNT					=	110044,
	GREEBLER_GREE_RARRAYG				=	110045,
	GREEBLER_GREEC_RARRAYG				=	110046,
	GREEBLER_NURN_RARRAYG				=	110047,

	// Tab Groups (111000) ===================
	GREEBLER_GROUP_GENERAL				=	111000,
	GREEBLER_GROUP_BASE					=	111001,
	GREEBLER_GROUP_GREEBLES_STOCK		=	111002,
	GREEBLER_GROUP_GREEBLES_CUSTOM		=	111003,
	GREEBLER_GROUP_NURNIES				=	111004,
	GREEBLER_GROUP_UTILITY				=	111005,
	GREEBLER_GROUP_PRESETS				=	111006,
	GREEBLER_GROUP_PIPING				=	111007,

	// Terminator
	GREEBLER_DUMMY
};

#endif	//_Ogreebler_H_
