CONTAINER Ogreebler
{
	NAME	Ogreebler;
	INCLUDE Obase;

	GROUP ID_OBJECTPROPERTIES
	{
		DEFAULT			1;
		// Help and Information about Greebler
		BITMAPBUTTON	GREEBLER_INFO								{ ANIM OFF; BUTTON; }
		SEPARATOR													{ LINE; }
		GROUP
		{
			// General
			// - Quick Generator Disable
			BUTTON			GREEBLER_GENERATOR_DISABLE				{ ANIM OFF; }
			// - Random Seed Value
			LONG			GREEBLER_SEED							{ ANIM OFF; MIN 0; MAX 1073741824; STEP 1;  }
			// - Subdivision value
			LONG			GREEBLER_SUBDIV							{ MIN 0; MAX 8; STEP 1; }
			// - Invert Normals of Input Object
			BOOL			GREEBLER_INVNORMALS						{ ANIM OFF; }
			// - Show Input Object
			BOOL			GREEBLER_SHOWINPUT						{ ANIM OFF; }
			SEPARATOR												{ LINE; }
			// - LOD
			//BOOL			GREEBLER_LOD_USE						{ ANIM OFF; }
			//REAL			GREEBLER_LOD							{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			SEPARATOR												{ LINE; }
			// - Exclude Low Area Polygons
			GROUP
			{
				COLUMNS		2;
				BOOL		GREEBLER_LOWAREA_USE					{ ANIM OFF; }
				REAL		GREEBLER_LOWAREA						{ MIN 0.0; UNIT METER; }
			}
			// - Exclude Thin Polygons
			GROUP
			{
				COLUMNS		2;
				BOOL		GREEBLER_THINPOLY_USE					{ ANIM OFF; }
				REAL		GREEBLER_THINPOLY						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
		}
		// Polygon Grouping (Clusters)
		//GROUP	GREEBLER_GROUP_POLYGROUP
		//{
		//	DEFAULT			0;
			BOOL			GREEBLER_POLYGROUP_ENABLE				{ HIDDEN; ANIM OFF; }
			REAL			GREEBLER_POLYGROUP_SPARSITY				{ HIDDEN; MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			LONG			GREEBLER_POLYGROUP_SIZE					{ HIDDEN; MIN 1; MAX 1024; STEP 1; }
		//}
	}
	// Base
	GROUP	GREEBLER_GROUP_BASE
	{
		// Generate Bases
		BOOL			GREEBLER_BASE_GENERATE						{ ANIM OFF; }
		// Use Input Object Selections/Textures/Materials
		BOOL			GREEBLER_BASE_INSELTEX						{ ANIM OFF; }
		// Separate Base tops from sides
		BOOL			GREEBLER_BASE_SELECTIONS					{ ANIM OFF; }
		// - Add Bottom Caps to Bases
		BOOL			GREEBLER_BASE_BCAP							{ ANIM OFF; }
		// Random Base Sparsity (0% = All Polygons, 100% = No Polygons)
		REAL			GREEBLER_BASE_SPARSITY						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		// LOD
		//REAL			GREEBLER_BASE_LOD							{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		SEPARATOR													{ LINE; }
		GROUP
		{
			COLUMNS		3;
			// Base Height from Min to Max Units
			STATICTEXT		GREEBLER_BASE_HEIGHT					{ ANIM OFF; }
			REAL			GREEBLER_BASE_HEIGHT_MIN				{ MIN 0.0; UNIT METER; }
			REAL			GREEBLER_BASE_HEIGHT_MAX				{ MIN 0.0; UNIT METER; }
			// Bevel Amount from Min to Max Percent (0% = No Bevel, 100% = Bevel to a point)
			STATICTEXT		GREEBLER_BASE_BEVEL						{ ANIM OFF; }
			REAL			GREEBLER_BASE_BEVEL_MIN					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			REAL			GREEBLER_BASE_BEVEL_MAX					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		}
		SEPARATOR													{ LINE; }
		// - Add Phong tag
		BOOL			GREEBLER_BASE_PHONG							{ ANIM OFF; }
		BOOL			GREEBLER_BASE_PHONGANGLELIMIT				{ ANIM OFF; }
		REAL			GREEBLER_BASE_PHONGANGLE					{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
	}
	// Greebles
	// - Stock Greebling Shapes
	GROUP	GREEBLER_GROUP_GREEBLES_STOCK
	{
		// Generate Greebles
		BOOL			GREEBLER_GREE_GENERATE						{ ANIM OFF; }
		GROUP	GREEBLER_GROUP_GREE_SETTING
		{
			DEFAULT		0;
			// Separate Greeble tops from sides
			BOOL			GREEBLER_GREE_SELECTIONS				{ ANIM OFF; }
			// - Add Bottom Caps to Greeble objects
			BOOL			GREEBLER_GREE_BCAP						{ ANIM OFF; }
			// Do not map from Unit-Square
			BOOL			GREEBLER_GREE_USMAP						{ ANIM OFF; }
			// Allow Populating Across Polygon Borders
			BOOL			GREEBLER_GREE_RELAXBORDERS				{ ANIM OFF; }
			// Random Greeble Sparsity (0% = All Polygons, 100% = No Polygons)
			REAL			GREEBLER_GREE_SPARSITY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// LOD
			//REAL			GREEBLER_GREE_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// Max number of Greebles per polygon (1-max will be created)
			LONG			GREEBLER_GREE_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Stock Greebles
			BOOL			GREEBLER_GREE_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			GREEBLER_GREE_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				// Greeble height from Min to Max Units
				STATICTEXT		GREEBLER_GREE_SURFOFFSET			{ ANIM OFF; }
				REAL			GREEBLER_GREE_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			GREEBLER_GREE_SURFOFFSET_MAX		{ UNIT METER; }
				// Greeble height from Min to Max Units
				STATICTEXT		GREEBLER_GREE_HEIGHT				{ ANIM OFF; }
				REAL			GREEBLER_GREE_HEIGHT_MIN			{ MIN 0.0; UNIT METER; }
				REAL			GREEBLER_GREE_HEIGHT_MAX			{ MIN 0.0; UNIT METER; }
				// Bevel Amount from Min to Max Percent (0% = No Bevel, 100% = Bevel to a point)
				STATICTEXT		GREEBLER_GREE_BEVEL					{ ANIM OFF; }
				REAL			GREEBLER_GREE_BEVEL_MIN				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREE_BEVEL_MAX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Length Variation Percentage
				STATICTEXT		GREEBLER_GREE_LENGTH				{ ANIM OFF; }
				REAL			GREEBLER_GREE_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREE_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Width Variation Percentage
				STATICTEXT		GREEBLER_GREE_WIDTH					{ ANIM OFF; }
				REAL			GREEBLER_GREE_WIDTH_MIN				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREE_WIDTH_MAX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			SEPARATOR												{ LINE; }
			// - Add Phong tag
			BOOL			GREEBLER_GREE_PHONG						{ ANIM OFF; }
			BOOL			GREEBLER_GREE_PHONGANGLELIMIT			{ ANIM OFF; }
			REAL			GREEBLER_GREE_PHONGANGLE				{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
		}
		SEPARATOR													{ LINE; }
		GROUP	GREEBLER_GREE_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			GREEBLER_GREE_GROUP_ALL				{ ANIM OFF; }
				BUTTON			GREEBLER_GREE_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	GREEBLER_GREE_BARG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_BARS			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_BARS				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_BARS		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_BARS			{ STEP 1.0; }
				}
				// - Number of Bars when Bar Greebles are being generated
				GROUP
				{
					COLUMNS		3;
					STATICTEXT		GREEBLER_GREE_BARS				{ ANIM OFF; }
					LONG			GREEBLER_GREE_BARS_MIN			{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREE_BARS_MAX			{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREE_BARS_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_GREE_BARS_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREE_BARS_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Bar Shape
				LONG			GREEBLER_GREE_BARS_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_GREE_SHAPE_CUBE;
						GREEBLER_GREE_SHAPE_T;
						GREEBLER_GREE_SHAPE_L;
						GREEBLER_GREE_SHAPE_C;
						GREEBLER_GREE_SHAPE_H;
						GREEBLER_GREE_SHAPE_D;
						GREEBLER_GREE_SHAPE_BOX;
						GREEBLER_GREE_SHAPE_CUBECC;
						GREEBLER_GREE_SHAPE_OBLOCT;
						GREEBLER_GREE_SHAPE_CYLINDER;
						GREEBLER_GREE_SHAPE_RING;
						GREEBLER_GREE_SHAPE_REGPOLY;
						GREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
			// ARRAY Settings
			GROUP	GREEBLER_GREE_ARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_ARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_ARRAY				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_ARRAY		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_ARRAY		{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_GREE_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREE_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREE_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREE_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREE_ARRAY_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_GREE_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREE_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			GREEBLER_GREE_ARRAY_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_GREE_SHAPE_CUBE;
						GREEBLER_GREE_SHAPE_T;
						GREEBLER_GREE_SHAPE_L;
						GREEBLER_GREE_SHAPE_C;
						GREEBLER_GREE_SHAPE_H;
						GREEBLER_GREE_SHAPE_D;
						GREEBLER_GREE_SHAPE_BOX;
						GREEBLER_GREE_SHAPE_CUBECC;
						GREEBLER_GREE_SHAPE_OBLOCT;
						GREEBLER_GREE_SHAPE_CYLINDER;
						GREEBLER_GREE_SHAPE_RING;
						GREEBLER_GREE_SHAPE_REGPOLY;
						GREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
			// CIRCULAR ARRAY Settings
			GROUP	GREEBLER_GREE_RARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_RARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_RARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			GREEBLER_GREE_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			GREEBLER_ROT_RANDOM_RARRAY		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_RARRAY		{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_GREE_RARRAY_NMIN		{ MIN 1; MAX 255; STEP 1; }
					LONG			GREEBLER_GREE_RARRAY_NMAX		{ MIN 1; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREE_RARRAY_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_GREE_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREE_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			GREEBLER_GREE_RARRAY_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_GREE_SHAPE_CUBE;
						GREEBLER_GREE_SHAPE_T;
						GREEBLER_GREE_SHAPE_L;
						GREEBLER_GREE_SHAPE_C;
						GREEBLER_GREE_SHAPE_H;
						GREEBLER_GREE_SHAPE_D;
						GREEBLER_GREE_SHAPE_BOX;
						GREEBLER_GREE_SHAPE_CUBECC;
						GREEBLER_GREE_SHAPE_OBLOCT;
						GREEBLER_GREE_SHAPE_CYLINDER;
						GREEBLER_GREE_SHAPE_RING;
						GREEBLER_GREE_SHAPE_REGPOLY;
						GREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
		}
		SEPARATOR													{ LINE; }
		GROUP	GREEBLER_TEXT_SHAPES
		{
			DEFAULT		0;
			GROUP
			{
				COLUMNS		2;
				// - Shape Selection
				BUTTON			GREEBLER_GREE_SHAPES_ALL			{ ANIM OFF; }
				BUTTON			GREEBLER_GREE_SHAPES_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_CUBE			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CUBE				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_CUBE		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_CUBE			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_D				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_D					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_D			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_D			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_RING			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_RING				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_RING		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_RING			{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_T				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_T					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_T			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_T			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_BOX				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_BOX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_BOX			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_BOX			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_REGPOLY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_REGPOLY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_REGPOLY		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_REGPOLY		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_L				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_L					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_L			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_L			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_CUBECC			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CUBECC			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_CUBECC		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_CUBECC		{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_REGPOLYR		{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_REGPOLYR			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_REGPOLYR	{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_REGPOLYR		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_C				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_C					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_C			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_C			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_OBLOCT			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_OBLOCT			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_OBLOCT		{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_OBLOCT		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_H				{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_H					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_H			{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_H			{ STEP 1.0; }
					BITMAPBUTTON	GREEBLER_BITMAP_CYLINDER		{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CYLINDER			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_ROT_RANDOM_CYLINDER	{ ANIM OFF; }
					REAL			GREEBLER_ROT_ANGLE_CYLINDER		{ STEP 1.0; }
				}
			}
			SEPARATOR												{ LINE; }
			STATICTEXT		GREEBLER_GREE_SHAPEOPTIONS				{ ANIM OFF; }
			// BOX Settings
			GROUP	GREEBLER_GREE_BOXG
			{
				DEFAULT		0;
				BITMAPBUTTON	GREEBLER_GREE_BOXIMAGE				{ ANIM OFF; }
				GROUP
				{
					COLUMNS		2;
					REAL		GREEBLER_GREE_BOX_INNERLENGTH		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL		GREEBLER_GREE_BOX_INNERWIDTH		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL		GREEBLER_GREE_BOX_INNERHLOC			{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL		GREEBLER_GREE_BOX_INNERVLOC			{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
			// CYLINDER/RING Settings
			GROUP	GREEBLER_GREE_CYLRINGG
			{
				DEFAULT		0;
				GROUP
				{
					COLUMNS	2;
					BITMAPBUTTON	GREEBLER_GREE_CYLIMAGE			{ ANIM OFF; }
					BITMAPBUTTON	GREEBLER_GREE_RNGIMAGE			{ ANIM OFF; }
				}
				// - Size of Cylinder and Rings with respect to location in polygon
				GROUP
				{
					COLUMNS	3;
					// - Retain Aspect of Cylinder and Rings
					BOOL			GREEBLER_GREE_CASPECT			{ ANIM OFF; }
					REAL			GREEBLER_GREE_CSIZE_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREE_CSIZE_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Rotation Segments for Cylinders and Rings
				LONG			GREEBLER_GREE_ROTSEGS				{ MIN 3; MAX 720; STEP 1; }
				// Inner Ring Size and Location
				REAL			GREEBLER_GREE_RING_INNERSIZE		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				GROUP
				{
					COLUMNS	2;
					REAL			GREEBLER_GREE_RING_INNERHLOC	{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL			GREEBLER_GREE_RING_INNERVLOC	{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
			// REGULAR POLYGON Settings
			GROUP	GREEBLER_GREE_REGPOLYG
			{
				DEFAULT		0;
				GROUP
				{
					COLUMNS	2;
					BITMAPBUTTON	GREEBLER_GREE_POLIMAGE			{ ANIM OFF; }
					BITMAPBUTTON	GREEBLER_GREE_PLRIMAGE			{ ANIM OFF; }
				}
				// - Size of Regular Polygon with respect to location in polygon
				GROUP
				{
					COLUMNS	3;
					// - Retain Aspect of Regular Polygon
					BOOL			GREEBLER_GREE_RP_ASPECT			{ ANIM OFF; }
					REAL			GREEBLER_GREE_RP_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREE_RP_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Number of Sides for Regular Polygon
				LONG			GREEBLER_GREE_RP_SIDES				{ MIN 3; MAX 10; STEP 1; }
				// Inner Hole Size and Location
				REAL			GREEBLER_GREE_RP_INNERSIZE			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				GROUP
				{
					COLUMNS	2;
					REAL			GREEBLER_GREE_RP_INNERHLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL			GREEBLER_GREE_RP_INNERVLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
		}
	}
	// - Custom Greebling Shapes
	GROUP	GREEBLER_GROUP_GREEBLES_CUSTOM
	{
		DEFAULT		0;
		// Generate Greebles
		BOOL			GREEBLER_GREEC_GENERATE						{ ANIM OFF; }
		GROUP	GREEBLER_GROUP_GREEC_SETTING
		{
			DEFAULT		0;
			// - Combine Custom with Stock
			BOOL			GREEBLER_GREEC_COMBINE					{ ANIM OFF; }
			// Separate Greeble tops from sides
			BOOL			GREEBLER_GREEC_SELECTIONS				{ ANIM OFF; }
			// - Add Bottom Caps to Greeble objects
			BOOL			GREEBLER_GREEC_BCAP						{ ANIM OFF; }
			// Do not map from Unit-Square
			BOOL			GREEBLER_GREEC_USMAP					{ ANIM OFF; }
			// Allow Populating Across Polygon Borders
			BOOL			GREEBLER_GREEC_RELAXBORDERS				{ ANIM OFF; }
			// Random Greeble Sparsity (0% = All Polygons, 100% = No Polygons)
			REAL			GREEBLER_GREEC_SPARSITY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// LOD
			//REAL			GREEBLER_GREEC_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// Max number of Greebles per polygon (1-max will be created)
			LONG			GREEBLER_GREEC_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Custom Greebles
			BOOL			GREEBLER_GREEC_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			GREEBLER_GREEC_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				// Greeble height from Min to Max Units
				STATICTEXT		GREEBLER_GREEC_SURFOFFSET			{ ANIM OFF; }
				REAL			GREEBLER_GREEC_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			GREEBLER_GREEC_SURFOFFSET_MAX		{ UNIT METER; }
				// Greeble height from Min to Max Units
				STATICTEXT		GREEBLER_GREEC_HEIGHT				{ ANIM OFF; }
				REAL			GREEBLER_GREEC_HEIGHT_MIN			{ MIN 0.0; UNIT METER; }
				REAL			GREEBLER_GREEC_HEIGHT_MAX			{ MIN 0.0; UNIT METER; }
				// Bevel Amount from Min to Max Percent (0% = No Bevel, 100% = Bevel to a point)
				STATICTEXT		GREEBLER_GREEC_BEVEL				{ ANIM OFF; }
				REAL			GREEBLER_GREEC_BEVEL_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREEC_BEVEL_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Length Variation Percentage	
				STATICTEXT		GREEBLER_GREEC_LENGTH				{ ANIM OFF; }
				REAL			GREEBLER_GREEC_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREEC_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Width Variation Percentage
				STATICTEXT		GREEBLER_GREEC_WIDTH				{ ANIM OFF; }
				REAL			GREEBLER_GREEC_WIDTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_GREEC_WIDTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			SEPARATOR												{ LINE; }
			// - Add Phong tag
			BOOL			GREEBLER_GREEC_PHONG					{ ANIM OFF; }
			BOOL			GREEBLER_GREEC_PHONGANGLELIMIT			{ ANIM OFF; }
			REAL			GREEBLER_GREEC_PHONGANGLE				{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
		}
		SEPARATOR													{ LINE; }
		GROUP	GREEBLER_GREEC_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			GREEBLER_GREEC_GROUP_ALL			{ ANIM OFF; }
				BUTTON			GREEBLER_GREEC_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	GREEBLER_GREEC_BARG
			{
				DEFAULT		0;
				BOOL				GREEBLER_SHAPE_CBARS			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_CBARS			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CBARS				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_GREEC_BARS_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_GREEC_BARS_ROTANGLE	{ STEP 1.0; }
				}
				// - Number of Bars when Bar Greebles are being generated
				GROUP
				{
					COLUMNS		3;
					STATICTEXT		GREEBLER_GREEC_BARS				{ ANIM OFF; }
					LONG			GREEBLER_GREEC_BARS_MIN			{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREEC_BARS_MAX			{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREEC_BARS_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_GREEC_BARS_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREEC_BARS_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Bar Shape
				LONG			GREEBLER_GREEC_BARS_OBJ				{ ANIM OFF; CYCLE {} }
			}
			// ARRAY Settings
			GROUP	GREEBLER_GREEC_ARRAYG
			{
				DEFAULT		0;
				BOOL				GREEBLER_SHAPE_CARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_CARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			GREEBLER_GREEC_ARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_GREEC_ARRAY_ROTANGLE	{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_GREEC_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREEC_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREEC_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_GREEC_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREEC_ARRAY_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_GREEC_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREEC_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			GREEBLER_GREEC_ARRAY_OBJ			{ ANIM OFF; CYCLE {} }
			}
			// CIRCULAR ARRAY Settings
			GROUP	GREEBLER_GREEC_RARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_CRARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_CRARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			GREEBLER_GREEC_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			GREEBLER_GREEC_RARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_GREEC_RARRAY_ROTANGLE	{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_GREEC_RARRAY_NMIN		{ MIN 1; MAX 255; STEP 1; }
					LONG			GREEBLER_GREEC_RARRAY_NMAX		{ MIN 1; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_GREEC_RARRAY_ASPECT	{ ANIM OFF; }
					REAL			GREEBLER_GREEC_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_GREEC_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			GREEBLER_GREEC_RARRAY_OBJ			{ ANIM OFF; CYCLE {} }
			}
		}
		SEPARATOR													{ LINE; }
		GROUP	GREEBLER_GREEC_SHAPES
		{
			DEFAULT		0;
			// --- Dynamic Descriptions ---
			// - Number of Custom Greebles
			LONG		GREEBLER_GREEC_COUNT						{ HIDDEN; ANIM OFF; }
			GROUP
			{
				COLUMNS		2;
				// - Button to launch Library Manager
				BUTTON		GREEBLER_GREEC_LIBMANAGER				{ ANIM OFF; }
				//BUTTON		GREEBLER_GREEC_LIBINSERT				{ ANIM OFF; }
				// - Null object containing shapes
				LINK		GREEBLER_GREEC_LIBRARY					{ ANIM OFF; ACCEPT { Onull; } }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		2;
				// - Shape Selection
				BUTTON			GREEBLER_GREEC_SHAPES_ALL			{ ANIM OFF; }
				BUTTON			GREEBLER_GREEC_SHAPES_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP	GREEBLER_GREEC_GREEBLES
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP	GREEBLER_GREEC_GREEBLES_COL1
				{
				}
				GROUP	GREEBLER_GREEC_GREEBLES_COL2
				{
				}
				GROUP	GREEBLER_GREEC_GREEBLES_COL3
				{
				}
				GROUP	GREEBLER_GREEC_GREEBLES_COL4
				{
				}
				GROUP	GREEBLER_GREEC_GREEBLES_COL5
				{
				}
			}
		}
	}
	// - Nurnies
	GROUP	GREEBLER_GROUP_NURNIES
	{
		DEFAULT			0;
		// Generate Nurnies
		BOOL			GREEBLER_NURN_GENERATE						{ ANIM OFF; }
		GROUP	GREEBLER_GROUP_NURN_SETTING
		{
			DEFAULT		0;
			// Use instances instead of polygonal mesh
			GROUP
			{
				COLUMNS		2;
				BOOL		GREEBLER_NURN_INSTANCE					{ ANIM OFF; }
				BOOL		GREEBLER_NURN_RENDERINSTANCE			{ ANIM OFF; }
			}
			// Do not map from Unit-Square
			BOOL			GREEBLER_NURN_USMAP						{ ANIM OFF; }
			// Allow Populating Across Polygon Borders
			BOOL			GREEBLER_NURN_RELAXBORDERS				{ ANIM OFF; }
			// Random Nurnie Sparsity (0% = All Polygons, 100% = No Polygons)
			REAL			GREEBLER_NURN_SPARSITY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// LOD
			//REAL			GREEBLER_NURN_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// Max number of Nurnies per polygon (1-max will be created)
			LONG			GREEBLER_NURN_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Stock Greebles
			BOOL			GREEBLER_NURN_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			GREEBLER_NURN_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS			3;
				// Nurnie height from Min to Max Units
				STATICTEXT		GREEBLER_NURN_SURFOFFSET			{ ANIM OFF; }
				REAL			GREEBLER_NURN_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			GREEBLER_NURN_SURFOFFSET_MAX		{ UNIT METER; }
				// Height Variation Percentage
				STATICTEXT		GREEBLER_NURN_HEIGHT				{ ANIM OFF; }
				REAL			GREEBLER_NURN_HEIGHT_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_NURN_HEIGHT_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Length Variation Percentage
				STATICTEXT		GREEBLER_NURN_LENGTH				{ ANIM OFF; }
				REAL			GREEBLER_NURN_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_NURN_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Width Variation Percentage
				STATICTEXT		GREEBLER_NURN_WIDTH					{ ANIM OFF; }
				REAL			GREEBLER_NURN_WIDTH_MIN				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			GREEBLER_NURN_WIDTH_MAX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			// Absolute Dimension Variations
			BOOL			GREEBLER_NURN_HLW_ABSOLUTE				{ ANIM OFF; }
		}
		SEPARATOR													{ LINE; }
		GROUP	GREEBLER_NURN_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			GREEBLER_NURN_GROUP_ALL				{ ANIM OFF; }
				BUTTON			GREEBLER_NURN_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	GREEBLER_NURN_BARG
			{
				DEFAULT		0;
				BOOL				GREEBLER_OBJECT_NBARS			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_NBARS			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_NBARS				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			GREEBLER_NURN_BARS_SCALING		{ MIN 0.00001; STEP 0.01; }
					BOOL			GREEBLER_NURN_BARS_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_NURN_BARS_ROTANGLE		{ STEP 1.0; }
				}
				LONG			GREEBLER_BASE_NBARS
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_NURN_BASE_ORIGIN;
						GREEBLER_NURN_BASE_BOTTOM;
						GREEBLER_NURN_BASE_TOP;
						GREEBLER_NURN_BASE_LEFT;
						GREEBLER_NURN_BASE_RIGHT;
						GREEBLER_NURN_BASE_FRONT;
						GREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Bars when Bar Nurnies are being generated
				GROUP
				{
					COLUMNS		3;
					STATICTEXT		GREEBLER_NURN_BARS				{ ANIM OFF; }
					LONG			GREEBLER_NURN_BARS_MIN			{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_NURN_BARS_MAX			{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_NURN_BARS_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_NURN_BARS_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_NURN_BARS_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Bar Object
				LONG			GREEBLER_NURN_BARS_OBJ				{ ANIM OFF; CYCLE {} }
			}
			// ARRAY Settings
			GROUP	GREEBLER_NURN_ARRAYG
			{
				DEFAULT		0;
				BOOL				GREEBLER_OBJECT_NARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_NARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_NARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			GREEBLER_NURN_ARRAY_SCALING		{ MIN 0.00001; STEP 0.01; }
					BOOL			GREEBLER_NURN_ARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_NURN_ARRAY_ROTANGLE	{ STEP 1.0; }
				}
				LONG			GREEBLER_BASE_NARRAY
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_NURN_BASE_ORIGIN;
						GREEBLER_NURN_BASE_BOTTOM;
						GREEBLER_NURN_BASE_TOP;
						GREEBLER_NURN_BASE_LEFT;
						GREEBLER_NURN_BASE_RIGHT;
						GREEBLER_NURN_BASE_FRONT;
						GREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_NURN_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_NURN_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_NURN_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_NURN_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_NURN_ARRAY_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_NURN_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_NURN_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Object
				LONG			GREEBLER_NURN_ARRAY_OBJ				{ ANIM OFF; CYCLE {} }
			}
			// CIRCULAR ARRAY Settings
			GROUP	GREEBLER_NURN_RARRAYG
			{
				DEFAULT		0;
				BOOL				GREEBLER_OBJECT_NRARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	GREEBLER_BITMAP_NRARRAY			{ ANIM OFF; BUTTON; }
					REAL			GREEBLER_FREQ_NRARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			GREEBLER_NURN_RARRAY_SCALING	{ MIN 0.00001; STEP 0.01; }
					REAL			GREEBLER_NURN_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			GREEBLER_NURN_RARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			GREEBLER_NURN_RARRAY_ROTANGLE	{ STEP 1.0; }
				}
				LONG			GREEBLER_BASE_NRARRAY
				{
					ANIM OFF;
					CYCLE
					{
						GREEBLER_NURN_BASE_ORIGIN;
						GREEBLER_NURN_BASE_BOTTOM;
						GREEBLER_NURN_BASE_TOP;
						GREEBLER_NURN_BASE_LEFT;
						GREEBLER_NURN_BASE_RIGHT;
						GREEBLER_NURN_BASE_FRONT;
						GREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			GREEBLER_NURN_RARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			GREEBLER_NURN_RARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			GREEBLER_NURN_RARRAY_ASPECT		{ ANIM OFF; }
					REAL			GREEBLER_NURN_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			GREEBLER_NURN_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Object
				LONG			GREEBLER_NURN_RARRAY_OBJ				{ ANIM OFF; CYCLE {} }
			}
		}
		SEPARATOR													{ LINE; }
		// --- Dynamic Descriptions ---
		GROUP	GREEBLER_NURN_OBJECTS
		{
			DEFAULT		0;
			// - Number of Custom Greebles
			LONG		GREEBLER_NURN_COUNT							{ HIDDEN; ANIM OFF; }
			GROUP
			{
				COLUMNS		2;
				// - Button to launch Library Manager
				BUTTON		GREEBLER_NURN_LIBMANAGER				{ ANIM OFF; }
				//BUTTON		GREEBLER_NURN_LIBINSERT					{ ANIM OFF; }
				// - Null object containing nurnie objects
				LINK		GREEBLER_NURN_LIBRARY					{ ANIM OFF; ACCEPT { Onull; } }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				STATICTEXT		GREEBLER_NURN_OBJECTS				{ ANIM OFF; }
				// - Shape Selection
				BUTTON			GREEBLER_NURN_OBJECTS_ALL			{ ANIM OFF; }
				BUTTON			GREEBLER_NURN_OBJECTS_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP	GREEBLER_NURN_GREEBLES
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP	GREEBLER_NURN_GREEBLES_COL1
				{
				}
				GROUP	GREEBLER_NURN_GREEBLES_COL2
				{
				}
				GROUP	GREEBLER_NURN_GREEBLES_COL3
				{
				}
				GROUP	GREEBLER_NURN_GREEBLES_COL4
				{
				}
				GROUP	GREEBLER_NURN_GREEBLES_COL5
				{
				}
			}
		}
	}
	// Piping
	//GROUP	GREEBLER_GROUP_PIPING
	//{
	//	DEFAULT			0;
		// Generate Pipes
	//	BOOL			GREEBLER_PIPE_GENERATE						{ ANIM OFF; }
		// Number of Pipe Types
	//	LONG			GREEBLER_PIPE_TYPES_COUNT					{ ANIM OFF; HIDDEN; }
		// - Null object containing pipe Spline objects
	//	LINK			GREEBLER_PIPE_LIBRARY						{ ANIM OFF; ACCEPT { Onull; } }
	//	SEPARATOR													{ LINE; }
	//	GROUP	GREEBLER_GROUP_PIPE_TYPES
	//	{
	//	}
	//}
	// Utility
	GROUP	GREEBLER_GROUP_UTILITY
	{
		STATICTEXT	GREEBLER_UTIL_MAKETAGS_LBL						{ ANIM OFF; }
		GROUP
		{
			COLUMNS	3;
			// Make Greebler Tags for All PolygonSelection tags on input objects
			BUTTON		GREEBLER_UTIL_MAKETAGS_ALL					{ ANIM OFF; }
			// Make Greebler Tags for Selected PolygonSelection tags on input objects
			BUTTON		GREEBLER_UTIL_MAKETAGS_SEL					{ ANIM OFF; }
			BOOL		GREEBLER_UTIL_MAKETAGS_CONFIG				{ ANIM OFF; }
		}
		SEPARATOR													{ LINE; }
		STATICTEXT	GREEBLER_UTIL_CPLABEL							{ ANIM OFF; }
		GROUP
		{
			BUTTON		GREEBLER_UTIL_COPY							{ ANIM OFF; }
			BUTTON		GREEBLER_UTIL_PASTE							{ ANIM OFF; }
		}
	}
	// Presets
	GROUP	GREEBLER_GROUP_PRESETS
	{
		BUTTON		GREEBLER_PRESET_LOAD							{ ANIM OFF; }
		BUTTON		GREEBLER_PRESET_SAVE							{ ANIM OFF; }
		BUTTON		GREEBLER_PRESET_SAVEDEFAULT						{ ANIM OFF; }
		SEPARATOR													{ LINE; }
		BUTTON		GREEBLER_PRESET_REMOVE							{ ANIM OFF; }
		BUTTON		GREEBLER_PRESET_FACTORY							{ ANIM OFF; }
	}
	// Enable/Disable State
	BOOL			GREEBLER_SHAPE_CUBE								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_T								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_L								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_C								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_H								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_D								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_BOX								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_CYLINDER							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_RING								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_BARS								{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_CUBECC							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_OBLOCT							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_REGPOLY							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_REGPOLYR							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_ARRAY							{ ANIM OFF; HIDDEN; }
	BOOL			GREEBLER_SHAPE_RARRAY							{ ANIM OFF; HIDDEN; }
}
