#ifndef _Tgreebler_H_
#define _Tgreebler_H_

enum
{
	// These enumerations must match those in Ogreebler.h!!!
	TGREEBLER_INFO						=	1000,
	TGREEBLER_ID						=	1001,

	// General (2000) =======================
	// - Enable/Disable Tag
	TGREEBLER_ENABLE					=	2000,
	// - Random Seed Value
	TGREEBLER_SEED						=	2001,
	// - Polygon Selections
	TGREEBLER_SELECTIONTAG				=	2002,
	TGREEBLER_SUBDIV					=	2003,
	TGREEBLER_INVNORMALS				=	2008,
	// - Level of Detail
	TGREEBLER_LOD						=	2009,
	TGREEBLER_LOD_USE					=	2010,
	// - Polygon Exclusions
	TGREEBLER_LOWAREA_USE				=	2011,
	TGREEBLER_LOWAREA					=	2012,
	TGREEBLER_THINPOLY_USE				=	2013,
	TGREEBLER_THINPOLY					=	2014,
	// - Quick Generator Disable
	TGREEBLER_GENERATOR_DISABLE			=	2015,

	// Base (3000) ==========================
	TGREEBLER_BASE_GENERATE				=	3000,
	TGREEBLER_BASE_SELECTIONS			=	3001,
	TGREEBLER_BASE_SPARSITY				=	3002,
	TGREEBLER_BASE_HEIGHT_MIN			=	3003,
	TGREEBLER_BASE_HEIGHT_MAX			=	3004,
	TGREEBLER_BASE_BEVEL_MIN			=	3005,
	TGREEBLER_BASE_BEVEL_MAX			=	3006,
	TGREEBLER_BASE_BCAP					=	3007,
	TGREEBLER_BASE_INSELTEX				=	3008,
	TGREEBLER_BASE_LOD					=	3009,
	TGREEBLER_BASE_PHONG				=	3010,
	TGREEBLER_BASE_PHONGANGLELIMIT		=	3011,
	TGREEBLER_BASE_PHONGANGLE			=	3012,
	TGREEBLER_BASE_END					=	3013,

	// Stock Greebles (4000) ================
	TGREEBLER_GREE_GENERATE				=	4000,
	TGREEBLER_GREE_SELECTIONS			=	4001,
	TGREEBLER_GREE_SPARSITY				=	4002,
	TGREEBLER_GREE_PERPOLYGON			=	4003,
	TGREEBLER_GREE_HEIGHT_MIN			=	4004,
	TGREEBLER_GREE_HEIGHT_MAX			=	4005,
	TGREEBLER_GREE_BEVEL_MIN			=	4006,
	TGREEBLER_GREE_BEVEL_MAX			=	4007,
	TGREEBLER_GREE_LENGTH_MIN			=	4008,
	TGREEBLER_GREE_LENGTH_MAX			=	4009,
	TGREEBLER_GREE_WIDTH_MIN			=	4010,
	TGREEBLER_GREE_WIDTH_MAX			=	4011,
	// - Bars
	TGREEBLER_GREE_BARS_MIN				=	4012,
	TGREEBLER_GREE_BARS_MAX				=	4013,
	TGREEBLER_GREE_BARS_OBJ				=	4014,
		TGREEBLER_GREE_SHAPE_CUBE			=	0,
		TGREEBLER_GREE_SHAPE_T				=	1,
		TGREEBLER_GREE_SHAPE_L				=	2,
		TGREEBLER_GREE_SHAPE_C				=	3,
		TGREEBLER_GREE_SHAPE_H				=	4,
		TGREEBLER_GREE_SHAPE_D				=	5,
		TGREEBLER_GREE_SHAPE_BOX			=	6,
		TGREEBLER_GREE_SHAPE_CUBECC			=	7,
		TGREEBLER_GREE_SHAPE_OBLOCT			=	8,
		TGREEBLER_GREE_SHAPE_CYLINDER		=	9,
		TGREEBLER_GREE_SHAPE_RING			=	10,
		TGREEBLER_GREE_SHAPE_REGPOLY		=	11,
		TGREEBLER_GREE_SHAPE_REGPOLYR		=	12,
	TGREEBLER_GREE_BARS_ASPECT			=	4030,
	TGREEBLER_GREE_BARS_SIZE_MIN		=	4037,
	TGREEBLER_GREE_BARS_SIZE_MAX		=	4038,
	// - Arrays
	TGREEBLER_GREE_ARRAY_MMIN			=	4031,
	TGREEBLER_GREE_ARRAY_MMAX			=	4032,
	TGREEBLER_GREE_ARRAY_NMIN			=	4033,
	TGREEBLER_GREE_ARRAY_NMAX			=	4034,
	TGREEBLER_GREE_ARRAY_ASPECT			=	4035,
	TGREEBLER_GREE_ARRAY_SIZE_MIN		=	4039,
	TGREEBLER_GREE_ARRAY_SIZE_MAX		=	4040,
	// -- Same choices are GREEBLER_GREE_BARS_OBJ
	TGREEBLER_GREE_ARRAY_OBJ			=	4036,
	// - Ring Arrays
	TGREEBLER_GREE_RARRAY_NMIN			=	4062,
	TGREEBLER_GREE_RARRAY_NMAX			=	4063,
	TGREEBLER_GREE_RARRAY_ASPECT		=	4064,
	TGREEBLER_GREE_RARRAY_SIZE_MIN		=	4065,
	TGREEBLER_GREE_RARRAY_SIZE_MAX		=	4066,
	TGREEBLER_GREE_RARRAY_OBJ			=	4067,
	TGREEBLER_GREE_RARRAY_SCALE			=	4068,
	// - Cylinder/Ring
	TGREEBLER_GREE_ROTSEGS				=	4015,
	TGREEBLER_GREE_CASPECT				=	4016,
	TGREEBLER_GREE_CSIZE_MIN			=	4017,
	TGREEBLER_GREE_CSIZE_MAX			=	4018,
	TGREEBLER_GREE_RING_INNERSIZE		=	4019,
	TGREEBLER_GREE_RING_INNERHLOC		=	4020,
	TGREEBLER_GREE_RING_INNERVLOC		=	4021,
	// --
	TGREEBLER_GREE_BCAP					=	4022,
	TGREEBLER_GREE_USMAP				=	4023,
	// - Box
	TGREEBLER_GREE_BOX_INNERLENGTH		=	4024,
	TGREEBLER_GREE_BOX_INNERWIDTH		=	4025,
	TGREEBLER_GREE_BOX_INNERHLOC		=	4026,
	TGREEBLER_GREE_BOX_INNERVLOC		=	4027,
	// - Regular Polygons
	TGREEBLER_GREE_RP_SIDES				=	4041,
	TGREEBLER_GREE_RP_ASPECT			=	4042,
	TGREEBLER_GREE_RP_SIZE_MIN			=	4043,
	TGREEBLER_GREE_RP_SIZE_MAX			=	4044,
	TGREEBLER_GREE_RP_INNERSIZE			=	4045,
	TGREEBLER_GREE_RP_INNERHLOC			=	4046,
	TGREEBLER_GREE_RP_INNERVLOC			=	4047,
	// - Shape Selection
	TGREEBLER_GREE_SHAPES_ALL			=	4028,
	TGREEBLER_GREE_SHAPES_NONE			=	4029,
	// - Surface Offest
	TGREEBLER_GREE_SURFOFFSET_MIN		=	4048,
	TGREEBLER_GREE_SURFOFFSET_MAX		=	4049,
	TGREEBLER_GREE_LOD					=	4050,
	// - Other
	TGREEBLER_GREE_RELAXBORDERS			=	4051,
	TGREEBLER_GREE_GLOBALALIGN			=	4052,
	TGREEBLER_GREE_GAROTATION			=	4053,
	TGREEBLER_GREE_PHONG				=	4054,
	TGREEBLER_GREE_PHONGANGLELIMIT		=	4055,
	TGREEBLER_GREE_PHONGANGLE			=	4056,
	// - Images for Shape Options
	TGREEBLER_GREE_BOXIMAGE				=	4057,
	TGREEBLER_GREE_CYLIMAGE				=	4058,
	TGREEBLER_GREE_RNGIMAGE				=	4059,
	TGREEBLER_GREE_POLIMAGE				=	4060,
	TGREEBLER_GREE_PLRIMAGE				=	4061,
	// - Group Selection
	TGREEBLER_GREE_GROUP_ALL			=	4069,
	TGREEBLER_GREE_GROUP_NONE			=	4070,
	// - Toggle State (5000)
	TGREEBLER_SHAPE_CUBE				=	5000,
	TGREEBLER_SHAPE_T					=	5001,
	TGREEBLER_SHAPE_L					=	5002,
	TGREEBLER_SHAPE_C					=	5003,
	TGREEBLER_SHAPE_H					=	5004,
	TGREEBLER_SHAPE_D					=	5005,
	TGREEBLER_SHAPE_BOX					=	5006,
	TGREEBLER_SHAPE_CUBECC				=	5007,
	TGREEBLER_SHAPE_OBLOCT				=	5008,
	TGREEBLER_SHAPE_CYLINDER			=	5009,
	TGREEBLER_SHAPE_RING				=	5010,
	TGREEBLER_SHAPE_BARS				=	5011,
	TGREEBLER_SHAPE_REGPOLY				=	5012,
	TGREEBLER_SHAPE_REGPOLYR			=	5013,
	TGREEBLER_SHAPE_ARRAY				=	5014,
	TGREEBLER_SHAPE_RARRAY				=	5015,
	// - BitmapButtons (6000)
	TGREEBLER_BITMAP_CUBE				=	6000,
	TGREEBLER_BITMAP_T					=	6001,
	TGREEBLER_BITMAP_L					=	6002,
	TGREEBLER_BITMAP_C					=	6003,
	TGREEBLER_BITMAP_H					=	6004,
	TGREEBLER_BITMAP_D					=	6005,
	TGREEBLER_BITMAP_BOX				=	6006,
	TGREEBLER_BITMAP_CUBECC				=	6007,
	TGREEBLER_BITMAP_OBLOCT				=	6008,
	TGREEBLER_BITMAP_CYLINDER			=	6009,
	TGREEBLER_BITMAP_RING				=	6010,
	TGREEBLER_BITMAP_BARS				=	6011,
	TGREEBLER_BITMAP_REGPOLY			=	6012,
	TGREEBLER_BITMAP_REGPOLYR			=	6013,
	TGREEBLER_BITMAP_ARRAY				=	6014,
	TGREEBLER_BITMAP_RARRAY				=	6015,
	// - Frequency Sliders (7000)
	TGREEBLER_FREQ_CUBE					=	7000,
	TGREEBLER_FREQ_T					=	7001,
	TGREEBLER_FREQ_L					=	7002,
	TGREEBLER_FREQ_C					=	7003,
	TGREEBLER_FREQ_H					=	7004,
	TGREEBLER_FREQ_D					=	7005,
	TGREEBLER_FREQ_BOX					=	7006,
	TGREEBLER_FREQ_CUBECC				=	7007,
	TGREEBLER_FREQ_OBLOCT				=	7008,
	TGREEBLER_FREQ_CYLINDER				=	7009,
	TGREEBLER_FREQ_RING					=	7010,
	TGREEBLER_FREQ_BARS					=	7011,
	TGREEBLER_FREQ_REGPOLY				=	7012,
	TGREEBLER_FREQ_REGPOLYR				=	7013,
	TGREEBLER_FREQ_ARRAY				=	7014,
	TGREEBLER_FREQ_RARRAY				=	7015,
	// - Random Rotation Checkboxes (7100)
	TGREEBLER_ROT_RANDOM_CUBE			=	7100,
	TGREEBLER_ROT_RANDOM_T				=	7101,
	TGREEBLER_ROT_RANDOM_L				=	7102,
	TGREEBLER_ROT_RANDOM_C				=	7103,
	TGREEBLER_ROT_RANDOM_H				=	7104,
	TGREEBLER_ROT_RANDOM_D				=	7105,
	TGREEBLER_ROT_RANDOM_BOX			=	7106,
	TGREEBLER_ROT_RANDOM_CUBECC			=	7107,
	TGREEBLER_ROT_RANDOM_OBLOCT			=	7108,
	TGREEBLER_ROT_RANDOM_CYLINDER		=	7109,
	TGREEBLER_ROT_RANDOM_RING			=	7110,
	TGREEBLER_ROT_RANDOM_BARS			=	7111,
	TGREEBLER_ROT_RANDOM_REGPOLY		=	7112,
	TGREEBLER_ROT_RANDOM_REGPOLYR		=	7113,
	TGREEBLER_ROT_RANDOM_ARRAY			=	7114,
	TGREEBLER_ROT_RANDOM_RARRAY			=	7115,
	// - Rotation Angle Sliders (7200)
	TGREEBLER_ROT_ANGLE_CUBE			=	7200,
	TGREEBLER_ROT_ANGLE_T				=	7201,
	TGREEBLER_ROT_ANGLE_L				=	7202,
	TGREEBLER_ROT_ANGLE_C				=	7203,
	TGREEBLER_ROT_ANGLE_H				=	7204,
	TGREEBLER_ROT_ANGLE_D				=	7205,
	TGREEBLER_ROT_ANGLE_BOX				=	7206,
	TGREEBLER_ROT_ANGLE_CUBECC			=	7207,
	TGREEBLER_ROT_ANGLE_OBLOCT			=	7208,
	TGREEBLER_ROT_ANGLE_CYLINDER		=	7209,
	TGREEBLER_ROT_ANGLE_RING			=	7210,
	TGREEBLER_ROT_ANGLE_BARS			=	7211,
	TGREEBLER_ROT_ANGLE_REGPOLY			=	7212,
	TGREEBLER_ROT_ANGLE_REGPOLYR		=	7213,
	TGREEBLER_ROT_ANGLE_ARRAY			=	7214,
	TGREEBLER_ROT_ANGLE_RARRAY			=	7215,
	TGREEBLER_GREE_END					=	7216,

	// Custom Greebles (8000) ===============
	TGREEBLER_GREEC_GENERATE			=	8000,
	TGREEBLER_GREEC_SELECTIONS			=	8001,
	TGREEBLER_GREEC_SPARSITY			=	8002,
	TGREEBLER_GREEC_PERPOLYGON			=	8003,
	TGREEBLER_GREEC_HEIGHT_MIN			=	8004,
	TGREEBLER_GREEC_HEIGHT_MAX			=	8005,
	TGREEBLER_GREEC_BEVEL_MIN			=	8006,
	TGREEBLER_GREEC_BEVEL_MAX			=	8007,
	TGREEBLER_GREEC_LENGTH_MIN			=	8008,
	TGREEBLER_GREEC_LENGTH_MAX			=	8009,
	TGREEBLER_GREEC_WIDTH_MIN			=	8010,
	TGREEBLER_GREEC_WIDTH_MAX			=	8011,
	TGREEBLER_GREEC_BCAP				=	8012,
	TGREEBLER_GREEC_USMAP				=	8013,
	// - Shape Selection
	TGREEBLER_GREEC_SHAPES_ALL			=	8014,
	TGREEBLER_GREEC_SHAPES_NONE			=	8015,
	// - Bars
	TGREEBLER_GREEC_BARS_MIN			=	8016,
	TGREEBLER_GREEC_BARS_MAX			=	8017,
	TGREEBLER_GREEC_BARS_ASPECT			=	8018,
	TGREEBLER_GREEC_BARS_SIZE_MIN		=	8019,
	TGREEBLER_GREEC_BARS_SIZE_MAX		=	8020,
	TGREEBLER_GREEC_BARS_OBJ			=	8021,
	// - Arrays
	TGREEBLER_GREEC_ARRAY_MMIN			=	8022,
	TGREEBLER_GREEC_ARRAY_MMAX			=	8023,
	TGREEBLER_GREEC_ARRAY_NMIN			=	8024,
	TGREEBLER_GREEC_ARRAY_NMAX			=	8025,
	TGREEBLER_GREEC_ARRAY_ASPECT		=	8026,
	TGREEBLER_GREEC_ARRAY_SIZE_MIN		=	8027,
	TGREEBLER_GREEC_ARRAY_SIZE_MAX		=	8028,
	TGREEBLER_GREEC_ARRAY_OBJ			=	8029,
	// - Ring Arrays
	TGREEBLER_GREEC_RARRAY_NMIN			=	8062,
	TGREEBLER_GREEC_RARRAY_NMAX			=	8063,
	TGREEBLER_GREEC_RARRAY_ASPECT		=	8064,
	TGREEBLER_GREEC_RARRAY_SIZE_MIN		=	8065,
	TGREEBLER_GREEC_RARRAY_SIZE_MAX		=	8066,
	TGREEBLER_GREEC_RARRAY_OBJ			=	8067,
	TGREEBLER_GREEC_RARRAY_SCALE		=	8068,
	// -
	TGREEBLER_BITMAP_CBARS				=	8030,
	TGREEBLER_FREQ_CBARS				=	8031,
	TGREEBLER_SHAPE_CBARS				=	8032,
	TGREEBLER_BITMAP_CARRAY				=	8033,
	TGREEBLER_FREQ_CARRAY				=	8034,
	TGREEBLER_SHAPE_CARRAY				=	8035,
	TGREEBLER_BITMAP_CRARRAY			=	8069,
	TGREEBLER_FREQ_CRARRAY				=	8070,
	TGREEBLER_SHAPE_CRARRAY				=	8071,
	// - Null object containing shapes
	TGREEBLER_GREEC_LIBRARY				=	8036,
	// - Number of Custom Greebles (en toto)
	TGREEBLER_GREEC_COUNT				=	8037,
	// - Layout Group for Custom Greeble Buttons
	TGREEBLER_GREEC_GREEBLES			=	8038,
	TGREEBLER_GREEC_GREEBLES_COL1		=	8039,
	TGREEBLER_GREEC_GREEBLES_COL2		=	8040,
	TGREEBLER_GREEC_GREEBLES_COL3		=	8041,
	TGREEBLER_GREEC_GREEBLES_COL4		=	8042,
	TGREEBLER_GREEC_GREEBLES_COL5		=	8043,
	TGREEBLER_GREEC_SPACER				=	8044,
	// - Combine Custom with Stock
	TGREEBLER_GREEC_COMBINE				=	8045,
	// - Surface Offest
	TGREEBLER_GREEC_SURFOFFSET_MIN		=	8046,
	TGREEBLER_GREEC_SURFOFFSET_MAX		=	8047,
	TGREEBLER_GREEC_LOD					=	8048,
	// - Other
	TGREEBLER_GREEC_RELAXBORDERS		=	8049,
	TGREEBLER_GREEC_LIBMANAGER			=	8050,
	TGREEBLER_GREEC_GLOBALALIGN			=	8051,
	TGREEBLER_GREEC_GAROTATION			=	8052,
	TGREEBLER_GREEC_LIBINSERT			=	8053,
	TGREEBLER_GREEC_PHONG				=	8054,
	TGREEBLER_GREEC_PHONGANGLELIMIT		=	8055,
	TGREEBLER_GREEC_PHONGANGLE			=	8056,
	TGREEBLER_GREEC_BARS_ROTRANDOM		=	8057,
	TGREEBLER_GREEC_BARS_ROTANGLE		=	8058,
	TGREEBLER_GREEC_ARRAY_ROTRANDOM		=	8059,
	TGREEBLER_GREEC_ARRAY_ROTANGLE		=	8060,
	TGREEBLER_GREEC_RARRAY_ROTRANDOM	=	8072,
	TGREEBLER_GREEC_RARRAY_ROTANGLE		=	8073,
	// - Group Selection
	TGREEBLER_GREEC_GROUP_ALL			=	8074,
	TGREEBLER_GREEC_GROUP_NONE			=	8075,
	// - BitmapButtons (9000-9999)
	TGREEBLER_GREEC_BITMAP				=	9000,
	TGREEBLER_GREEC_BITMAP_END			=	9999,
	// - Frequency Sliders (10000-10999)
	TGREEBLER_GREEC_FREQ				=	10000,
	TGREEBLER_GREEC_FREQ_END			=	10999,
	// - Custom Greeble Name
	TGREEBLER_GREEC_NAME				=	11000,
	// - Custom Greeble State
	TGREEBLER_GREEC_STATE				=	12000,
	// - Custom Greeble Random Rotation (13000-13999)
	TGREEBLER_GREEC_ROT_RANDOM			=	13000,
	TGREEBLER_GREEC_ROT_RANDOM_END		=	13999,
	// - Custom Greeble Rotation Angle (14000-14999)
	TGREEBLER_GREEC_ROT_ANGLE			=	14000,
	TGREEBLER_GREEC_ROT_ANGLE_END		=	14999,
	TGREEBLER_GREEC_END 				=	15000,

	// Nurnies (20000) ===============
	TGREEBLER_NURN_GENERATE				=	20000,
	TGREEBLER_NURN_SPARSITY				=	20002,
	TGREEBLER_NURN_PERPOLYGON			=	20003,
	TGREEBLER_NURN_HEIGHT_MIN			=	20004,
	TGREEBLER_NURN_HEIGHT_MAX			=	20005,
	TGREEBLER_NURN_LENGTH_MIN			=	20006,
	TGREEBLER_NURN_LENGTH_MAX			=	20009,
	TGREEBLER_NURN_WIDTH_MIN			=	20010,
	TGREEBLER_NURN_WIDTH_MAX			=	20011,
	TGREEBLER_NURN_USMAP				=	20013,
	// - Nurnie Selection
	TGREEBLER_NURN_OBJECTS_ALL			=	20014,
	TGREEBLER_NURN_OBJECTS_NONE			=	20015,
	// - Bars
	TGREEBLER_NURN_BARS_MIN				=	20016,
	TGREEBLER_NURN_BARS_MAX				=	20017,
	TGREEBLER_NURN_BARS_ASPECT			=	20018,
	TGREEBLER_NURN_BARS_SIZE_MIN		=	20019,
	TGREEBLER_NURN_BARS_SIZE_MAX		=	20020,
	TGREEBLER_NURN_BARS_OBJ				=	20021,
	// - Arrays
	TGREEBLER_NURN_ARRAY_MMIN			=	20022,
	TGREEBLER_NURN_ARRAY_MMAX			=	20023,
	TGREEBLER_NURN_ARRAY_NMIN			=	20024,
	TGREEBLER_NURN_ARRAY_NMAX			=	20025,
	TGREEBLER_NURN_ARRAY_ASPECT			=	20026,
	TGREEBLER_NURN_ARRAY_SIZE_MIN		=	20027,
	TGREEBLER_NURN_ARRAY_SIZE_MAX		=	20028,
	TGREEBLER_NURN_ARRAY_OBJ			=	20029,
	// - Ring Arrays
	TGREEBLER_NURN_RARRAY_NMIN			=	20062,
	TGREEBLER_NURN_RARRAY_NMAX			=	20063,
	TGREEBLER_NURN_RARRAY_ASPECT		=	20064,
	TGREEBLER_NURN_RARRAY_SIZE_MIN		=	20065,
	TGREEBLER_NURN_RARRAY_SIZE_MAX		=	20066,
	TGREEBLER_NURN_RARRAY_OBJ			=	20067,
	TGREEBLER_NURN_RARRAY_SCALE			=	20068,
	// -
	TGREEBLER_BITMAP_NBARS				=	20030,
	TGREEBLER_FREQ_NBARS				=	20031,
	TGREEBLER_BASE_NBARS				=	20045,
	TGREEBLER_OBJECT_NBARS				=	20032,
	TGREEBLER_BITMAP_NARRAY				=	20033,
	TGREEBLER_FREQ_NARRAY				=	20034,
	TGREEBLER_BASE_NARRAY				=	20046,
	TGREEBLER_OBJECT_NARRAY				=	20035,
	TGREEBLER_BITMAP_NRARRAY			=	20069,
	TGREEBLER_FREQ_NRARRAY				=	20070,
	TGREEBLER_BASE_NRARRAY				=	20071,
	TGREEBLER_OBJECT_NRARRAY			=	20072,
	// - Null object containing nurnies
	TGREEBLER_NURN_LIBRARY				=	20036,
	// - Number of Nurnies (en toto)
	TGREEBLER_NURN_COUNT				=	20037,
	// - Layout Group for Nurnie Buttons
	TGREEBLER_NURN_GREEBLES				=	20038,
	TGREEBLER_NURN_GREEBLES_COL1		=	20039,
	TGREEBLER_NURN_GREEBLES_COL2		=	20040,
	TGREEBLER_NURN_GREEBLES_COL3		=	20041,
	TGREEBLER_NURN_GREEBLES_COL4		=	20042,
	TGREEBLER_NURN_GREEBLES_COL5		=	20043,
	TGREEBLER_NURN_SPACER				=	20044,
	// - Surface Offest
	TGREEBLER_NURN_SURFOFFSET_MIN		=	20047,
	TGREEBLER_NURN_SURFOFFSET_MAX		=	20048,
	// - Other
	TGREEBLER_NURN_LOD					=	20049,
	TGREEBLER_NURN_INSTANCE				=	20050,
	TGREEBLER_NURN_RELAXBORDERS			=	20051,
	TGREEBLER_NURN_LIBMANAGER			=	20052,
	TGREEBLER_NURN_GLOBALALIGN			=	20053,
	TGREEBLER_NURN_GAROTATION			=	20054,
	TGREEBLER_NURN_LIBINSERT			=	20055,
	TGREEBLER_NURN_RENDERINSTANCE		=	20056,
	TGREEBLER_NURN_BARS_ROTRANDOM		=	20057,
	TGREEBLER_NURN_BARS_ROTANGLE		=	20058,
	TGREEBLER_NURN_ARRAY_ROTRANDOM		=	20059,
	TGREEBLER_NURN_ARRAY_ROTANGLE		=	20060,
	TGREEBLER_NURN_RARRAY_ROTRANDOM		=	20073,
	TGREEBLER_NURN_RARRAY_ROTANGLE		=	20074,
	TGREEBLER_NURN_BARS_SCALING			=	20075,
	TGREEBLER_NURN_ARRAY_SCALING		=	20076,
	TGREEBLER_NURN_RARRAY_SCALING		=	20077,
	// - Group Selection
	TGREEBLER_NURN_GROUP_ALL			=	20078,
	TGREEBLER_NURN_GROUP_NONE			=	20079,
	// - Use Absolute Height/Length/Width
	TGREEBLER_NURN_HLW_ABSOLUTE			=	20080,
	// - BitmapButtons (21000-21999)
	TGREEBLER_NURN_BITMAP				=	21000,
	TGREEBLER_NURN_BITMAP_END			=	21999,
	// - Frequency Sliders (22000-22999)
	TGREEBLER_NURN_FREQ					=	22000,
	TGREEBLER_NURN_FREQ_END				=	22999,
	// - Nurnie Name (23000-23999)
	TGREEBLER_NURN_NAME					=	23000,
	// - Nurnie State (24000-24999)
	TGREEBLER_NURN_STATE				=	24000,
	// - Nurnie 'base' (25000-25999)
	TGREEBLER_NURN_BASE					=	25000,
		TGREEBLER_NURN_BASE_ORIGIN		=	0,
		TGREEBLER_NURN_BASE_BOTTOM		=	1,
		TGREEBLER_NURN_BASE_TOP			=	2,
		TGREEBLER_NURN_BASE_LEFT		=	3,
		TGREEBLER_NURN_BASE_RIGHT		=	4,
		TGREEBLER_NURN_BASE_FRONT		=	5,
		TGREEBLER_NURN_BASE_BACK		=	6,
	TGREEBLER_NURN_BASE_END				=	25999,
	// - Nurnie Random Rotation (26000-26999)
	TGREEBLER_NURN_ROT_RANDOM			=	26000,
	TGREEBLER_NURN_ROT_RANDOM_END		=	26999,
	// - Nurnie Rotation Angle (27000-27999)
	TGREEBLER_NURN_ROT_ANGLE			=	27000,
	TGREEBLER_NURN_ROT_ANGLE_END		=	27999,
	// - Nurnie Scaling (28000-28999)
	TGREEBLER_NURN_SCALING				=	28000,
	TGREEBLER_NURN_SCALING_END			=	28999,
	TGREEBLER_NURN_END					=	29000,

	// Presets (100000) ======================
	TGREEBLER_PRESET_LOAD				=	100000,
	TGREEBLER_PRESET_SAVE				=	100001,
	TGREEBLER_PRESET_SAVEDEFAULT		=	100002,
	TGREEBLER_PRESET_REMOVE				=	100003,
	TGREEBLER_PRESET_FACTORY			=	100004,

	// Utility (101000) =======================
	TGREEBLER_UTIL_CPLABEL				=	101004,
	TGREEBLER_UTIL_COPY					=	101005,
	TGREEBLER_UTIL_PASTE				=	101006,

	// Labels (110000)
	TGREEBLER_TEXT_SHAPES				=	110000,
	TGREEBLER_BASE_HEIGHT				=	110001,
	TGREEBLER_BASE_BEVEL				=	110002,
	TGREEBLER_GREE_HEIGHT				=	110003,
	TGREEBLER_GREE_BEVEL				=	110004,
	TGREEBLER_GREE_LENGTH				=	110005,
	TGREEBLER_GREE_WIDTH				=	110006,
	TGREEBLER_GREE_BARS					=	110007,
	TGREEBLER_GREE_CYLRINGG				=	110008,
	TGREEBLER_GREE_BARG					=	110009,
	TGREEBLER_GREE_BOXG					=	110010,
	TGREEBLER_GREE_REGPOLYG				=	110011,
	TGREEBLER_GREE_ARRAYG				=	110012,
	TGREEBLER_GREEC_HEIGHT				=	110013,
	TGREEBLER_GREEC_BEVEL				=	110014,
	TGREEBLER_GREEC_LENGTH				=	110015,
	TGREEBLER_GREEC_WIDTH				=	110016,
	TGREEBLER_GREEC_BARS				=	110017,
	TGREEBLER_GREEC_BARG				=	110018,
	TGREEBLER_GREEC_ARRAYG				=	110019,
	TGREEBLER_GREE_SHAPEOPTIONS			=	110020,
	TGREEBLER_GREEC_GROUPOPTIONS		=	110021,
	TGREEBLER_GREEC_GROUPING			=	110022,
	TGREEBLER_GREEC_SHAPES				=	110023,
	TGREEBLER_GREE_GROUPING				=	110024,
	TGREEBLER_GREE_GROUPOPTIONS			=	110025,
	TGREEBLER_NURN_HEIGHT				=	110026,
	TGREEBLER_NURN_LENGTH				=	110027,
	TGREEBLER_NURN_WIDTH				=	110028,
	TGREEBLER_NURN_GROUPING				=	110029,
	TGREEBLER_NURN_GROUPOPTIONS			=	110030,
	TGREEBLER_NURN_BARS					=	110031,
	TGREEBLER_NURN_BARG					=	110032,
	TGREEBLER_NURN_ARRAYG				=	110033,
	TGREEBLER_NURN_OBJECTS				=	110034,
	TGREEBLER_GROUP_POLYGROUP			=	110035,
	TGREEBLER_GROUP_GREE_SETTING		=	110036,
	TGREEBLER_GROUP_GREEC_SETTING		=	110037,
	TGREEBLER_GROUP_NURN_SETTING		=	110038,
	TGREEBLER_GREE_SURFOFFSET			=	110039,
	TGREEBLER_GREEC_SURFOFFSET			=	110040,
	TGREEBLER_NURN_SURFOFFSET			=	110041,
	TGREEBLER_GREE_RARRAYG				=	110045,
	TGREEBLER_GREEC_RARRAYG				=	110046,
	TGREEBLER_NURN_RARRAYG				=	110047,

	// Tab Groups (111000) ===================
	TGREEBLER_GROUP_GENERAL				=	111000,
	TGREEBLER_GROUP_BASE				=	111001,
	TGREEBLER_GROUP_GREEBLES_STOCK		=	111002,
	TGREEBLER_GROUP_GREEBLES_CUSTOM		=	111003,
	TGREEBLER_GROUP_NURNIES				=	111004,
	TGREEBLER_GROUP_UTILITY				=	111005,
	TGREEBLER_GROUP_PRESETS				=	111006,

	// Terminator
	TGREEBLER_DUMMY
};

#endif	//_Tgreebler_H_
