CONTAINER Tgreebler
{
	NAME	Tgreebler;
	INCLUDE Tbase;

	GROUP ID_TAGPROPERTIES
	{
		DEFAULT		1;
		LONG			TGREEBLER_ID								{ ANIM OFF; HIDDEN; }
		// Help and Information about Greebler
		BITMAPBUTTON	TGREEBLER_INFO								{ ANIM OFF; BUTTON; }
		SEPARATOR													{ LINE; }
		// General
		GROUP
		{
			BOOL			TGREEBLER_ENABLE						{ ANIM OFF; }
			// - Quick Generator Disable
			BUTTON			TGREEBLER_GENERATOR_DISABLE				{ ANIM OFF; }
			// Polygon Selection tag
			LINK			TGREEBLER_SELECTIONTAG					{ ANIM OFF; ACCEPT { Tpolygonselection; } }
			// Random Seed Value
			LONG			TGREEBLER_SEED							{ ANIM OFF; MIN 0; MAX 1073741824; STEP 1;  }
			// Subdivision value
			LONG			TGREEBLER_SUBDIV						{ MIN 0; MAX 8; STEP 1; }
			BOOL			TGREEBLER_INVNORMALS					{ ANIM OFF; }
			SEPARATOR												{ LINE; }
			// - LOD
			//BOOL			TGREEBLER_LOD_USE						{ ANIM OFF; }
			//REAL			TGREEBLER_LOD							{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			SEPARATOR												{ LINE; }
			// - Exclude Low Area Polygons
			GROUP
			{
				COLUMNS		2;
				BOOL			TGREEBLER_LOWAREA_USE				{ ANIM OFF; }
				REAL			TGREEBLER_LOWAREA					{ MIN 0.0; UNIT METER; }
			}
			// - Exclude Thin Polygons
			GROUP
			{
				COLUMNS		2;
				BOOL			TGREEBLER_THINPOLY_USE				{ ANIM OFF; }
				REAL			TGREEBLER_THINPOLY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
		}
	}
	// Base
	GROUP	TGREEBLER_GROUP_BASE
	{
		BOOL			TGREEBLER_BASE_GENERATE						{ ANIM OFF; }
		BOOL			TGREEBLER_BASE_INSELTEX						{ ANIM OFF; }
		BOOL			TGREEBLER_BASE_SELECTIONS					{ ANIM OFF; }
		BOOL			TGREEBLER_BASE_BCAP							{ ANIM OFF; }
		REAL			TGREEBLER_BASE_SPARSITY						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		//REAL			TGREEBLER_BASE_LOD							{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		SEPARATOR													{ LINE; }
		GROUP
		{
			COLUMNS		3;
			STATICTEXT		TGREEBLER_BASE_HEIGHT					{ ANIM OFF; }
			REAL			TGREEBLER_BASE_HEIGHT_MIN				{ MIN 0.0; UNIT METER; }
			REAL			TGREEBLER_BASE_HEIGHT_MAX				{ MIN 0.0; UNIT METER; }
			STATICTEXT		TGREEBLER_BASE_BEVEL					{ ANIM OFF; }
			REAL			TGREEBLER_BASE_BEVEL_MIN				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			REAL			TGREEBLER_BASE_BEVEL_MAX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
		}
		SEPARATOR													{ LINE; }
		// - Add Phong tag
		BOOL			TGREEBLER_BASE_PHONG						{ ANIM OFF; }
		BOOL			TGREEBLER_BASE_PHONGANGLELIMIT				{ ANIM OFF; }
		REAL			TGREEBLER_BASE_PHONGANGLE					{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
	}
	// - Stock Greebling Shapes
	GROUP	TGREEBLER_GROUP_GREEBLES_STOCK
	{
		BOOL			TGREEBLER_GREE_GENERATE						{ ANIM OFF; }
		GROUP	TGREEBLER_GROUP_GREE_SETTING
		{
			DEFAULT		0;
			BOOL			TGREEBLER_GREE_SELECTIONS				{ ANIM OFF; }
			BOOL			TGREEBLER_GREE_BCAP						{ ANIM OFF; }
			BOOL			TGREEBLER_GREE_USMAP					{ ANIM OFF; }
			BOOL			TGREEBLER_GREE_RELAXBORDERS				{ ANIM OFF; }
			REAL			TGREEBLER_GREE_SPARSITY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			//REAL			TGREEBLER_GREE_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			LONG			TGREEBLER_GREE_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Stock Greebles
			BOOL			TGREEBLER_GREE_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			TGREEBLER_GREE_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				STATICTEXT		TGREEBLER_GREE_SURFOFFSET			{ ANIM OFF; }
				REAL			TGREEBLER_GREE_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			TGREEBLER_GREE_SURFOFFSET_MAX		{ UNIT METER; }
				STATICTEXT		TGREEBLER_GREE_HEIGHT				{ ANIM OFF; }
				REAL			TGREEBLER_GREE_HEIGHT_MIN			{ MIN 0.0; UNIT METER; }
				REAL			TGREEBLER_GREE_HEIGHT_MAX			{ MIN 0.0; UNIT METER; }
				STATICTEXT		TGREEBLER_GREE_BEVEL				{ ANIM OFF; }
				REAL			TGREEBLER_GREE_BEVEL_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREE_BEVEL_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				STATICTEXT		TGREEBLER_GREE_LENGTH				{ ANIM OFF; }
				REAL			TGREEBLER_GREE_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREE_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				STATICTEXT		TGREEBLER_GREE_WIDTH				{ ANIM OFF; }
				REAL			TGREEBLER_GREE_WIDTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREE_WIDTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			SEPARATOR												{ LINE; }
			// - Add Phong tag
			BOOL			TGREEBLER_GREE_PHONG					{ ANIM OFF; }
			BOOL			TGREEBLER_GREE_PHONGANGLELIMIT			{ ANIM OFF; }
			REAL			TGREEBLER_GREE_PHONGANGLE				{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
		}
		SEPARATOR													{ LINE; }
		GROUP	TGREEBLER_GREE_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			TGREEBLER_GREE_GROUP_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_GREE_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	TGREEBLER_GREE_BARG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_BARS			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_BARS				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_BARS		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_BARS		{ STEP 1.0; }
				}
				GROUP
				{
					COLUMNS		3;
					// - Number of Bars when Bar Greebles are being generated
					STATICTEXT		TGREEBLER_GREE_BARS					{ ANIM OFF; }
					LONG			TGREEBLER_GREE_BARS_MIN				{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREE_BARS_MAX				{ MIN 2; MAX 255; STEP 1; }
				}
				GROUP
				{
					COLUMNS		3;
					// - Preserve Aspect and size range
					BOOL			TGREEBLER_GREE_BARS_ASPECT			{ ANIM OFF; }
					REAL			TGREEBLER_GREE_BARS_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREE_BARS_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Bar Shape
				LONG			TGREEBLER_GREE_BARS_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_GREE_SHAPE_CUBE;
						TGREEBLER_GREE_SHAPE_T;
						TGREEBLER_GREE_SHAPE_L;
						TGREEBLER_GREE_SHAPE_C;
						TGREEBLER_GREE_SHAPE_H;
						TGREEBLER_GREE_SHAPE_D;
						TGREEBLER_GREE_SHAPE_BOX;
						TGREEBLER_GREE_SHAPE_CUBECC;
						TGREEBLER_GREE_SHAPE_OBLOCT;
						TGREEBLER_GREE_SHAPE_CYLINDER;
						TGREEBLER_GREE_SHAPE_RING;
						TGREEBLER_GREE_SHAPE_REGPOLY;
						TGREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
			// ARRAY Settings
			GROUP	TGREEBLER_GREE_ARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_ARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_ARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_ARRAY		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_ARRAY		{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_GREE_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREE_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREE_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREE_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_GREE_ARRAY_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_GREE_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREE_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			TGREEBLER_GREE_ARRAY_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_GREE_SHAPE_CUBE;
						TGREEBLER_GREE_SHAPE_T;
						TGREEBLER_GREE_SHAPE_L;
						TGREEBLER_GREE_SHAPE_C;
						TGREEBLER_GREE_SHAPE_H;
						TGREEBLER_GREE_SHAPE_D;
						TGREEBLER_GREE_SHAPE_BOX;
						TGREEBLER_GREE_SHAPE_CUBECC;
						TGREEBLER_GREE_SHAPE_OBLOCT;
						TGREEBLER_GREE_SHAPE_CYLINDER;
						TGREEBLER_GREE_SHAPE_RING;
						TGREEBLER_GREE_SHAPE_REGPOLY;
						TGREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
			// CIRCULAR ARRAY Settings
			GROUP	TGREEBLER_GREE_RARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_RARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_RARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			TGREEBLER_GREE_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			TGREEBLER_ROT_RANDOM_RARRAY		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_RARRAY		{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_GREE_RARRAY_NMIN		{ MIN 1; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREE_RARRAY_NMAX		{ MIN 1; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_GREE_RARRAY_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_GREE_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREE_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			TGREEBLER_GREE_RARRAY_OBJ
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_GREE_SHAPE_CUBE;
						TGREEBLER_GREE_SHAPE_T;
						TGREEBLER_GREE_SHAPE_L;
						TGREEBLER_GREE_SHAPE_C;
						TGREEBLER_GREE_SHAPE_H;
						TGREEBLER_GREE_SHAPE_D;
						TGREEBLER_GREE_SHAPE_BOX;
						TGREEBLER_GREE_SHAPE_CUBECC;
						TGREEBLER_GREE_SHAPE_OBLOCT;
						TGREEBLER_GREE_SHAPE_CYLINDER;
						TGREEBLER_GREE_SHAPE_RING;
						TGREEBLER_GREE_SHAPE_REGPOLY;
						TGREEBLER_GREE_SHAPE_REGPOLYR;
					}
				}
			}
		}
		SEPARATOR													{ LINE; }
		// Stock Greebling Shapes
		GROUP	TGREEBLER_TEXT_SHAPES
		{
			DEFAULT		0;
			GROUP
			{
				COLUMNS		2;
				// - Shape Selection
				BUTTON			TGREEBLER_GREE_SHAPES_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_GREE_SHAPES_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_CUBE			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CUBE				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_CUBE		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_CUBE		{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_D				{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_D				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_D			{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_D			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_RING			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_RING				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_RING		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_RING		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_T				{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_T				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_T			{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_T			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_BOX			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_BOX				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_BOX		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_BOX			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_REGPOLY		{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_REGPOLY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_REGPOLY	{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_REGPOLY		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_L				{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_L				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_L			{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_L			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_CUBECC			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CUBECC			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_CUBECC		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_CUBECC		{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_REGPOLYR		{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_REGPOLYR			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_REGPOLYR	{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_REGPOLYR	{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_C				{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_C				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_C			{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_C			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_OBLOCT			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_OBLOCT			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_OBLOCT		{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_OBLOCT		{ STEP 1.0; }
				}
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_H				{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_H				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_H			{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_H			{ STEP 1.0; }
					BITMAPBUTTON	TGREEBLER_BITMAP_CYLINDER		{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CYLINDER			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_ROT_RANDOM_CYLINDER	{ ANIM OFF; }
					REAL			TGREEBLER_ROT_ANGLE_CYLINDER	{ STEP 1.0; }
				}
			}
			SEPARATOR												{ LINE; }
			STATICTEXT		TGREEBLER_GREE_SHAPEOPTIONS				{ ANIM OFF; }
			// BOX Settings
			GROUP	TGREEBLER_GREE_BOXG
			{
				DEFAULT		0;
				BITMAPBUTTON	TGREEBLER_GREE_BOXIMAGE				{ ANIM OFF; }
				GROUP
				{
					COLUMNS		2;
					REAL		TGREEBLER_GREE_BOX_INNERLENGTH		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL		TGREEBLER_GREE_BOX_INNERWIDTH		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL		TGREEBLER_GREE_BOX_INNERHLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL		TGREEBLER_GREE_BOX_INNERVLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
			// CYLINDER/RING Settings
			GROUP	TGREEBLER_GREE_CYLRINGG
			{
				DEFAULT		0;
				GROUP
				{
					COLUMNS	2;
					BITMAPBUTTON	TGREEBLER_GREE_CYLIMAGE			{ ANIM OFF; }
					BITMAPBUTTON	TGREEBLER_GREE_RNGIMAGE			{ ANIM OFF; }
				}
				// - Size of Cylinder and Rings with respect to location in polygon
				GROUP
				{
					COLUMNS	3;
					// - Retain Aspect of Cylinder and Rings
					BOOL			TGREEBLER_GREE_CASPECT			{ ANIM OFF; }
					REAL			TGREEBLER_GREE_CSIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREE_CSIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Rotation Segments for Cylinders and Rings
				LONG			TGREEBLER_GREE_ROTSEGS				{ MIN 3; MAX 720; STEP 1; }
				// Inner Ring Size and Location
				REAL			TGREEBLER_GREE_RING_INNERSIZE		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				GROUP
				{
					COLUMNS	2;
					REAL			TGREEBLER_GREE_RING_INNERHLOC	{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL			TGREEBLER_GREE_RING_INNERVLOC	{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
			// REGULAR POLYGON Settings
			GROUP	TGREEBLER_GREE_REGPOLYG
			{
				DEFAULT		0;
				GROUP
				{
					COLUMNS	2;
					BITMAPBUTTON	TGREEBLER_GREE_POLIMAGE			{ ANIM OFF; }
					BITMAPBUTTON	TGREEBLER_GREE_PLRIMAGE			{ ANIM OFF; }
				}
				// - Size of Regular Polygon with respect to location in polygon
				GROUP
				{
					COLUMNS	3;
					// - Retain Aspect of Regular Polygon
					BOOL			TGREEBLER_GREE_RP_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_GREE_RP_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREE_RP_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Number of Sides for Regular Polygon
				LONG			TGREEBLER_GREE_RP_SIDES				{ MIN 3; MAX 10; STEP 1; }
				// Inner Hole Size and Location
				REAL			TGREEBLER_GREE_RP_INNERSIZE			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				GROUP
				{
					COLUMNS	2;
					REAL			TGREEBLER_GREE_RP_INNERHLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
					REAL			TGREEBLER_GREE_RP_INNERVLOC		{ MIN -0.5; MAX 0.5; STEP 0.005; }
				}
			}
		}
	}
	// - Custom Greebling Shapes
	GROUP	TGREEBLER_GROUP_GREEBLES_CUSTOM
	{
		DEFAULT		0;
		// Generate Greebles
		BOOL			TGREEBLER_GREEC_GENERATE					{ ANIM OFF; }
		GROUP	TGREEBLER_GROUP_GREEC_SETTING
		{
			DEFAULT		0;
			// - Combine Custom with Stock
			BOOL			TGREEBLER_GREEC_COMBINE					{ ANIM OFF; }
			// Separate Greeble tops from sides
			BOOL			TGREEBLER_GREEC_SELECTIONS				{ ANIM OFF; }
			// - Add Bottom Caps to Greeble objects
			BOOL			TGREEBLER_GREEC_BCAP					{ ANIM OFF; }
			// Do not map from Unit-Square
			BOOL			TGREEBLER_GREEC_USMAP					{ ANIM OFF; }
			// Allow Populating Across Polygon Borders
			BOOL			TGREEBLER_GREEC_RELAXBORDERS			{ ANIM OFF; }
			// Random Greeble Sparsity (0% = All Polygons, 100% = No Polygons)
			REAL			TGREEBLER_GREEC_SPARSITY				{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			//REAL			TGREEBLER_GREEC_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// Max number of Greebles per polygon (1-max will be created)
			LONG			TGREEBLER_GREEC_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Custom Greebles
			BOOL			TGREEBLER_GREEC_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			TGREEBLER_GREEC_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				// Greeble height from Min to Max Units
				STATICTEXT		TGREEBLER_GREEC_SURFOFFSET			{ ANIM OFF; }
				REAL			TGREEBLER_GREEC_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			TGREEBLER_GREEC_SURFOFFSET_MAX		{ UNIT METER; }
				// Greeble height from Min to Max Units
				STATICTEXT		TGREEBLER_GREEC_HEIGHT				{ ANIM OFF; }
				REAL			TGREEBLER_GREEC_HEIGHT_MIN			{ MIN 0.0; UNIT METER; }
				REAL			TGREEBLER_GREEC_HEIGHT_MAX			{ MIN 0.0; UNIT METER; }
				// Bevel Amount from Min to Max Percent (0% = No Bevel, 100% = Bevel to a point)
				STATICTEXT		TGREEBLER_GREEC_BEVEL				{ ANIM OFF; }
				REAL			TGREEBLER_GREEC_BEVEL_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREEC_BEVEL_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Length Variation Percentage
				STATICTEXT		TGREEBLER_GREEC_LENGTH				{ ANIM OFF; }
				REAL			TGREEBLER_GREEC_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREEC_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Width Variation Percentage
				STATICTEXT		TGREEBLER_GREEC_WIDTH				{ ANIM OFF; }
				REAL			TGREEBLER_GREEC_WIDTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_GREEC_WIDTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			SEPARATOR												{ LINE; }
			// - Add Phong tag
			BOOL			TGREEBLER_GREEC_PHONG					{ ANIM OFF; }
			BOOL			TGREEBLER_GREEC_PHONGANGLELIMIT			{ ANIM OFF; }
			REAL			TGREEBLER_GREEC_PHONGANGLE				{ MIN 0.0; MAX 180.0; STEP 1.0; UNIT DEGREE; }
		}
		SEPARATOR													{ LINE; }
		GROUP	TGREEBLER_GREEC_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			TGREEBLER_GREEC_GROUP_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_GREEC_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	TGREEBLER_GREEC_BARG
			{
				DEFAULT		0;
				BOOL				TGREEBLER_SHAPE_CBARS			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_CBARS			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CBARS			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_GREEC_BARS_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_BARS_ROTANGLE	{ STEP 1.0; }
				}
				GROUP
				{
					COLUMNS		3;
					// - Number of Bars when Bar Greebles are being generated
					STATICTEXT		TGREEBLER_GREEC_BARS				{ ANIM OFF; }
					LONG			TGREEBLER_GREEC_BARS_MIN			{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREEC_BARS_MAX			{ MIN 2; MAX 255; STEP 1; }
					// - Preserve Aspect and size range
					BOOL			TGREEBLER_GREEC_BARS_ASPECT			{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_BARS_SIZE_MIN		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREEC_BARS_SIZE_MAX		{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					// - Bar Shape
					LONG			TGREEBLER_GREEC_BARS_OBJ			{ ANIM OFF; CYCLE {} }
				}
			}
			// ARRAY Settings
			GROUP	TGREEBLER_GREEC_ARRAYG
			{
				DEFAULT		0;
				BOOL				TGREEBLER_SHAPE_CARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_CARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					BOOL			TGREEBLER_GREEC_ARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_ARRAY_ROTANGLE	{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_GREEC_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREEC_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREEC_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREEC_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_GREEC_ARRAY_ASPECT	{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREEC_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			TGREEBLER_GREEC_ARRAY_OBJ			{ ANIM OFF; CYCLE {} }
			}
			// CIRCULAR ARRAY Settings
			GROUP	TGREEBLER_GREEC_RARRAYG
			{
				DEFAULT		0;
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_CRARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_CRARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			TGREEBLER_GREEC_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			TGREEBLER_GREEC_RARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_RARRAY_ROTANGLE	{ STEP 1.0; }
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_GREEC_RARRAY_NMIN		{ MIN 1; MAX 255; STEP 1; }
					LONG			TGREEBLER_GREEC_RARRAY_NMAX		{ MIN 1; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_GREEC_RARRAY_ASPECT	{ ANIM OFF; }
					REAL			TGREEBLER_GREEC_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_GREEC_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Shape
				LONG			TGREEBLER_GREEC_RARRAY_OBJ			{ ANIM OFF; CYCLE {} }
			}
		}
		SEPARATOR													{ LINE; }
		// --- Dynamic Descriptions ---
		GROUP	TGREEBLER_GREEC_SHAPES
		{
			DEFAULT		0;
			// - Number of Custom Greebles
			LONG		TGREEBLER_GREEC_COUNT						{ HIDDEN; ANIM OFF; }
			GROUP
			{
				COLUMNS		2;
				// - Button to launch Library Manager
				BUTTON		TGREEBLER_GREEC_LIBMANAGER				{ ANIM OFF; }
				//BUTTON		TGREEBLER_GREEC_LIBINSERT				{ ANIM OFF; }
				// - Null object containing shapes
				LINK		TGREEBLER_GREEC_LIBRARY					{ ANIM OFF; ACCEPT { Onull; } }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		2;
				// - Shape Selection
				BUTTON			TGREEBLER_GREEC_SHAPES_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_GREEC_SHAPES_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP	TGREEBLER_GREEC_GREEBLES
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP	TGREEBLER_GREEC_GREEBLES_COL1
				{
				}
				GROUP	TGREEBLER_GREEC_GREEBLES_COL2
				{
				}
				GROUP	TGREEBLER_GREEC_GREEBLES_COL3
				{
				}
				GROUP	TGREEBLER_GREEC_GREEBLES_COL4
				{
				}
				GROUP	TGREEBLER_GREEC_GREEBLES_COL5
				{
				}
			}
		}
	}
	// - Nurnies
	GROUP	TGREEBLER_GROUP_NURNIES
	{
		DEFAULT		0;
		// Generate Nurnies
		BOOL			TGREEBLER_NURN_GENERATE						{ ANIM OFF; }
		GROUP	TGREEBLER_GROUP_NURN_SETTING
		{
			DEFAULT		0;
			// Use instances instead of polygonal mesh
			GROUP
			{
				COLUMNS	2;
				BOOL		TGREEBLER_NURN_INSTANCE					{ ANIM OFF; }
				BOOL		TGREEBLER_NURN_RENDERINSTANCE			{ ANIM OFF; }
			}
			// Do not map from Unit-Square
			BOOL			TGREEBLER_NURN_USMAP					{ ANIM OFF; }
			// Allow Populating Across Polygon Borders
			BOOL			TGREEBLER_NURN_RELAXBORDERS				{ ANIM OFF; }
			// Random Nurnie Sparsity (0% = All Polygons, 100% = No Polygons)
			REAL			TGREEBLER_NURN_SPARSITY					{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			//REAL			TGREEBLER_NURN_LOD						{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			// Max number of Nurnies per polygon (1-max will be created)
			LONG			TGREEBLER_NURN_PERPOLYGON				{ MIN 1; MAX 256; STEP 1; }
			// Global Alignment of Stock Greebles
			BOOL			TGREEBLER_NURN_GLOBALALIGN				{ ANIM OFF; }
			VECTOR			TGREEBLER_NURN_GAROTATION				{ UNIT DEGREE; }
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		3;
				STATICTEXT		TGREEBLER_NURN_SURFOFFSET			{ ANIM OFF; }
				REAL			TGREEBLER_NURN_SURFOFFSET_MIN		{ UNIT METER; }
				REAL			TGREEBLER_NURN_SURFOFFSET_MAX		{ UNIT METER; }
				// Height Variation Percentage
				STATICTEXT		TGREEBLER_NURN_HEIGHT				{ ANIM OFF; }
				REAL			TGREEBLER_NURN_HEIGHT_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_NURN_HEIGHT_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Length Variation Percentage
				STATICTEXT		TGREEBLER_NURN_LENGTH				{ ANIM OFF; }
				REAL			TGREEBLER_NURN_LENGTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_NURN_LENGTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				// Width Variation Percentage
				STATICTEXT		TGREEBLER_NURN_WIDTH				{ ANIM OFF; }
				REAL			TGREEBLER_NURN_WIDTH_MIN			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				REAL			TGREEBLER_NURN_WIDTH_MAX			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
			}
			// Absolute Dimension Variations
			BOOL			TGREEBLER_NURN_HLW_ABSOLUTE				{ ANIM OFF; }
		}
		SEPARATOR													{ LINE; }
		GROUP	TGREEBLER_NURN_GROUPING
		{
			DEFAULT		0;
			// Enable/Disable Buttons
			GROUP
			{
				COLUMNS		2;
				BUTTON			TGREEBLER_NURN_GROUP_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_NURN_GROUP_NONE			{ ANIM OFF; }
			}
			// BARS Settings
			GROUP	TGREEBLER_NURN_BARG
			{
				DEFAULT		0;
				BOOL				TGREEBLER_OBJECT_NBARS			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_NBARS			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_NBARS			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			TGREEBLER_NURN_BARS_SCALING		{ MIN 0.00001; STEP 0.01; }
					BOOL			TGREEBLER_NURN_BARS_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_NURN_BARS_ROTANGLE	{ STEP 1.0; }
				}
				LONG			TGREEBLER_BASE_NBARS
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_NURN_BASE_ORIGIN;
						TGREEBLER_NURN_BASE_BOTTOM;
						TGREEBLER_NURN_BASE_TOP;
						TGREEBLER_NURN_BASE_LEFT;
						TGREEBLER_NURN_BASE_RIGHT;
						TGREEBLER_NURN_BASE_FRONT;
						TGREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Bars when Bar Nurnies are being generated
				GROUP
				{
					COLUMNS		3;
					STATICTEXT		TGREEBLER_NURN_BARS				{ ANIM OFF; }
					LONG			TGREEBLER_NURN_BARS_MIN			{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_NURN_BARS_MAX			{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_NURN_BARS_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_NURN_BARS_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_NURN_BARS_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Bar Object
				LONG			TGREEBLER_NURN_BARS_OBJ				{ ANIM OFF; CYCLE {} }
			}
			// ARRAY Settings
			GROUP	TGREEBLER_NURN_ARRAYG
			{
				DEFAULT		0;
				BOOL				TGREEBLER_OBJECT_NARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_NARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_NARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			TGREEBLER_NURN_ARRAY_SCALING	{ MIN 0.00001; STEP 0.01; }
					BOOL			TGREEBLER_NURN_ARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_NURN_ARRAY_ROTANGLE	{ STEP 1.0; }
				}
				LONG			TGREEBLER_BASE_NARRAY
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_NURN_BASE_ORIGIN;
						TGREEBLER_NURN_BASE_BOTTOM;
						TGREEBLER_NURN_BASE_TOP;
						TGREEBLER_NURN_BASE_LEFT;
						TGREEBLER_NURN_BASE_RIGHT;
						TGREEBLER_NURN_BASE_FRONT;
						TGREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_NURN_ARRAY_MMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_NURN_ARRAY_MMAX		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_NURN_ARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_NURN_ARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_NURN_ARRAY_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_NURN_ARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_NURN_ARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Object
				LONG			TGREEBLER_NURN_ARRAY_OBJ			{ ANIM OFF; CYCLE {} }
			}
			// CIRCULAR ARRAY Settings
			GROUP	TGREEBLER_NURN_RARRAYG
			{
				DEFAULT		0;
				BOOL				TGREEBLER_OBJECT_NRARRAY			{ ANIM OFF; HIDDEN; }
				GROUP
				{
					BITMAPBUTTON	TGREEBLER_BITMAP_NRARRAY			{ ANIM OFF; BUTTON; }
					REAL			TGREEBLER_FREQ_NRARRAY			{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; ANIM OFF; }
					REAL			TGREEBLER_NURN_RARRAY_SCALING	{ MIN 0.00001; STEP 0.01; }
					REAL			TGREEBLER_NURN_RARRAY_SCALE		{ MIN 0.00001; STEP 0.1; }
					BOOL			TGREEBLER_NURN_RARRAY_ROTRANDOM	{ ANIM OFF; }
					REAL			TGREEBLER_NURN_RARRAY_ROTANGLE	{ STEP 1.0; }
				}
				LONG			TGREEBLER_BASE_NRARRAY
				{
					ANIM OFF;
					CYCLE
					{
						TGREEBLER_NURN_BASE_ORIGIN;
						TGREEBLER_NURN_BASE_BOTTOM;
						TGREEBLER_NURN_BASE_TOP;
						TGREEBLER_NURN_BASE_LEFT;
						TGREEBLER_NURN_BASE_RIGHT;
						TGREEBLER_NURN_BASE_FRONT;
						TGREEBLER_NURN_BASE_BACK;
					}
				}
				// - Number of Rows and Columns
				GROUP
				{
					COLUMNS		2;
					LONG			TGREEBLER_NURN_RARRAY_NMIN		{ MIN 2; MAX 255; STEP 1; }
					LONG			TGREEBLER_NURN_RARRAY_NMAX		{ MIN 2; MAX 255; STEP 1; }
				}
				// - Preserve Aspect and size range
				GROUP
				{
					COLUMNS		3;
					BOOL			TGREEBLER_NURN_RARRAY_ASPECT		{ ANIM OFF; }
					REAL			TGREEBLER_NURN_RARRAY_SIZE_MIN	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
					REAL			TGREEBLER_NURN_RARRAY_SIZE_MAX	{ MIN 0.0; MAX 100.0; STEP 1.0; UNIT PERCENT; }
				}
				// - Array Object
				LONG			TGREEBLER_NURN_RARRAY_OBJ				{ ANIM OFF; CYCLE {} }
			}
		}
		SEPARATOR													{ LINE; }
		// --- Dynamic Descriptions ---
		GROUP	TGREEBLER_NURN_OBJECTS
		{
			DEFAULT		0;
			// - Number of Custom Greebles
			LONG		TGREEBLER_NURN_COUNT						{ HIDDEN; ANIM OFF; }
			GROUP
			{
				COLUMNS		2;
				// - Button to launch Library Manager
				BUTTON		TGREEBLER_NURN_LIBMANAGER				{ ANIM OFF; }
				//BUTTON		TGREEBLER_NURN_LIBINSERT				{ ANIM OFF; }
				// - Null object containing shapes
				LINK		TGREEBLER_NURN_LIBRARY					{ ANIM OFF; ACCEPT { Onull; } }
			}
			SEPARATOR												{ LINE; }
			GROUP
			{
				COLUMNS		2;
				// - Shape Selection
				BUTTON			TGREEBLER_NURN_OBJECTS_ALL			{ ANIM OFF; }
				BUTTON			TGREEBLER_NURN_OBJECTS_NONE			{ ANIM OFF; }
			}
			SEPARATOR												{ LINE; }
			GROUP	TGREEBLER_NURN_GREEBLES
			{
				LAYOUTGROUP;
				COLUMNS		5;
				GROUP	TGREEBLER_NURN_GREEBLES_COL1
				{
				}
				GROUP	TGREEBLER_NURN_GREEBLES_COL2
				{
				}
				GROUP	TGREEBLER_NURN_GREEBLES_COL3
				{
				}
				GROUP	TGREEBLER_NURN_GREEBLES_COL4
				{
				}
				GROUP	TGREEBLER_NURN_GREEBLES_COL5
				{
				}
			}
		}
	}
	// Utility
	GROUP	TGREEBLER_GROUP_UTILITY
	{
		STATICTEXT	TGREEBLER_UTIL_CPLABEL						{ ANIM OFF; }
		BUTTON		TGREEBLER_UTIL_COPY							{ ANIM OFF; }
		BUTTON		TGREEBLER_UTIL_PASTE						{ ANIM OFF; }
	}
	// Presets
	GROUP	TGREEBLER_GROUP_PRESETS
	{
		BUTTON		TGREEBLER_PRESET_LOAD						{ ANIM OFF; }
		BUTTON		TGREEBLER_PRESET_SAVE						{ ANIM OFF; }
		BUTTON		TGREEBLER_PRESET_SAVEDEFAULT				{ ANIM OFF; }
		SEPARATOR												{ LINE; }
		BUTTON		TGREEBLER_PRESET_REMOVE						{ ANIM OFF; }
		BUTTON		TGREEBLER_PRESET_FACTORY					{ ANIM OFF; }
	}
	// Enable/Disable State
	BOOL			TGREEBLER_SHAPE_CUBE						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_T							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_L							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_C							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_H							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_D							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_BOX							{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_CYLINDER					{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_RING						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_BARS						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_CUBECC						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_OBLOCT						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_REGPOLY						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_REGPOLYR					{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_ARRAY						{ ANIM OFF; HIDDEN; }
	BOOL			TGREEBLER_SHAPE_RARRAY						{ ANIM OFF; HIDDEN; }
}
