(DEFUN AI_ABORT (APP MSG) (DEFUN *ERROR* (S) (IF OLD_ERROR (SETQ *ERROR* OLD_ERROR)) (PRINC)) (IF MSG (ALERT (STRCAT " Ӧó: " APP " \n\n  " MSG "  \n"))) (EXIT))
(DEFUN AI_RETURN (VALUE) VALUE)
(DEFUN AI_BEEP (/ F) (WRITE-LINE "\007" (SETQ F (OPEN "CON" "w"))) (SETQ F (CLOSE F)))
(DEFUN AI_ALERT (MSG) (IF AI_BEEP? (AI_BEEP)) (ALERT (STRCAT " " MSG "  ")))
(DEFUN AI_ACADAPP (/ FNAME) (SETQ FNAME "acapp.arx") (COND ((= (TYPE ACAD_COLORDLG) (QUOTE EXRXSUBR))) ((NOT (FINDFILE FNAME)) (AI_ALERT (STRCAT "δҵ " FNAME ".")) (AI_RETURN nil)) ((EQ "failed" (ARXLOAD FNAME "failed")) (AI_ALERT (STRCAT "޷" FNAME ".")) (AI_RETURN nil)) (T)))
(DEFUN AI_TABLE (TABLE_NAME BIT / TBLDATA TABLE_LIST JUST_NAME) (SETQ TBLDATA nil) (SETQ TABLE_LIST (QUOTE nil)) (SETQ TABLE_NAME (XSTRCASE TABLE_NAME)) (WHILE (SETQ TBLDATA (TBLNEXT TABLE_NAME (NOT TBLDATA))) (SETQ JUST_NAME (CDR (ASSOC 2 TBLDATA))) (COND ((= "" JUST_NAME)) ((AND (= 1 (LOGAND BIT 1)) (OR (AND (= TABLE_NAME "LAYER") (= JUST_NAME "0")) (AND (= TABLE_NAME "LTYPE") (= JUST_NAME "CONTINUOUS"))))) ((AND (= 2 (LOGAND BIT 2)) (= TABLE_NAME "BLOCK") (= 1 (LOGAND 1 (CDR (ASSOC 70 TBLDATA)))))) ((AND (= 4 (LOGAND BIT 4)) (ZEROP (LOGAND 4 (CDR (ASSOC 70 TBLDATA)))) (NOT (ZEROP (LOGAND 48 (CDR (ASSOC 70 TBLDATA))))))) ((AND (= 8 (LOGAND BIT 8)) (NOT (ZEROP (LOGAND 4 (CDR (ASSOC 70 TBLDATA))))))) ((MEMBER JUST_NAME TABLE_LIST)) (T (SETQ TABLE_LIST (CONS JUST_NAME TABLE_LIST))))) (COND ((AND (= 16 (LOGAND BIT 16)) (= TABLE_NAME "LTYPE")) (SETQ TABLE_LIST (CONS "BYBLOCK" (CONS "BYLAYER" TABLE_LIST)))) (T)) (AI_RETURN TABLE_LIST))
(DEFUN AI_STRTRIM (S) (COND ((/= (TYPE S) (QUOTE STR)) nil) (T (AI_STRLTRIM (AI_STRRTRIM S)))))
(DEFUN AI_STRLTRIM (S) (COND ((EQ S "") S) ((/= " " (SUBSTR S 1 1)) S) (T (AI_STRLTRIM (SUBSTR S 2)))))
(DEFUN AI_STRRTRIM (S) (COND ((EQ S "") S) ((/= " " (SUBSTR S (STRLEN S) 1)) S) (T (AI_STRRTRIM (SUBSTR S 1 (1- (STRLEN S)))))))
(DEFUN AI_NUM (VALUE ERROR_MSG RANGE / GOOD_VALUE) (COND ((NOT (SETQ GOOD_VALUE (DISTOF VALUE))) (SET_TILE "error" ERROR_MSG) nil) ((AND (= 1 (LOGAND 1 RANGE)) (= (ABS GOOD_VALUE) GOOD_VALUE)) (SET_TILE "error" ERROR_MSG) nil) ((AND (= 2 (LOGAND 2 RANGE)) (= 0.0 GOOD_VALUE)) (SET_TILE "error" ERROR_MSG) nil) ((AND (= 4 (LOGAND 4 RANGE)) (/= (ABS GOOD_VALUE) GOOD_VALUE)) (SET_TILE "error" ERROR_MSG) nil) (T GOOD_VALUE)))
(DEFUN AI_ANGLE (VALUE ERROR_MSG / GOOD_VALUE) (COND ((AND (SETQ GOOD_VALUE (ANGTOF VALUE))) (SET_TILE "error" "") (ATOF (ANGTOS GOOD_VALUE))) (T (SET_TILE "error" ERROR_MSG) nil)))
(DEFUN AI_ERROR (S) (IF (NOT (MEMBER S (QUOTE ("ȡ" "̨ж")))) (PRINC (STRCAT "\n: " S))) (IF UNDO_INIT (AI_UNDO_POP)) (IF OLD_ERROR (SETQ *ERROR* OLD_ERROR)) (IF OLD_CMD (SETVAR "cmdecho" OLD_CMD)) (PRINC))
(DEFUN AI_TRANS nil (IF (ZEROP (LOGAND (GETVAR "cmdactive") (+ 2 8))) T (PROGN (ALERT "͸ø") nil)))
(DEFUN AI_TRANSD nil (IF (ZEROP (LOGAND (GETVAR "cmdactive") (+ 2))) T (PROGN (ALERT "͸ø") nil)))
(DEFUN AI_NOTRANS nil (IF (ZEROP (LOGAND (GETVAR "cmdactive") (+ 1 2 8))) T (PROGN (ALERT "͸ø") nil)))
(DEFUN AI_ASELECT (/ SS) (COND ((AND (EQ 1 (LOGAND 1 (GETVAR "pickfirst"))) (SETQ SS (SSGET "_i"))) (SETQ SS (AI_SSGET SS)) (SETQ AI_SELTYPE 1) (AI_RETURN SS)) ((SETQ SS (SSGET)) (IF SS (SETQ SS (AI_SSGET SS))) (SETQ AI_SELTYPE 2) (AI_RETURN SS))))
(DEFUN AI_ASELECT1 (MSG / ENT) (COND ((AND (EQ 1 (LOGAND 1 (GETVAR "pickfirst"))) (SETQ ENT (SSGET "_i")) (EQ 1 (SSLENGTH ENT))) (SETQ AI_SELTYPE 1) (IF (AI_ENTITY_LOCKED (SSNAME ENT 0) 1) (AI_RETURN nil) (AI_RETURN (SSNAME ENT 0)))) ((SETQ ENT (ENTSEL MSG)) (IF (AI_ENTITY_LOCKED (CAR ENT) 1) (SETQ ENT nil)) (SETQ AI_SELTYPE 2) (AI_RETURN (CAR ENT)))))
(DEFUN AI_AUTOSSGET1 (MSG / ENT SS) (COND ((AND (EQ 1 (LOGAND 1 (GETVAR "pickfirst"))) (SETQ ENT (SSGET "_i")) (EQ 1 (SSLENGTH ENT))) (SETQ AI_SELTYPE 1) (IF (AI_ENTITY_LOCKED (SSNAME ENT 0) 1) (AI_RETURN nil) (AI_RETURN (SSNAME ENT 0)))) (T (WHILE (NOT SS) (PRINC MSG) (COMMAND "_.SELECT" "_SI" "_AU" PAUSE) (IF (AND (SETQ SS (SSGET "_P")) (EQ 1 (SSLENGTH SS)) (SETQ SS (AI_SSGET SS))) (SETQ ENT (SSNAME SS 0)) (SETQ SS nil ENT nil)) (SETQ AI_SELTYPE 2) (AI_RETURN ENT)))))
(DEFUN AI_UNDO_ON nil (SETQ UNDO_SETTING (GETVAR "undoctl")) (COND ((= 2 (LOGAND UNDO_SETTING 2)) (COMMAND "_.undo" "_control" "_all" "_.undo" "_auto" "_off")) ((/= 1 (LOGAND UNDO_SETTING 1)) (COMMAND "_.undo" "_all" "_.undo" "_auto" "_off"))))
(DEFUN AI_UNDO_OFF nil (COND ((/= 1 (LOGAND UNDO_SETTING 1)) (COMMAND "_.undo" "_control" "_none")) ((= 2 (LOGAND UNDO_SETTING 2)) (COMMAND "_.undo" "_control" "_one"))))
(DEFUN AI_UNDO_PUSH nil (SETQ UNDO_INIT (GETVAR "undoctl")) (COND ((AND (= 1 (LOGAND UNDO_INIT 1)) (/= 2 (LOGAND UNDO_INIT 2)) (/= 8 (LOGAND UNDO_INIT 8))) (COMMAND "_.undo" "_group")) (T)) (IF (= 4 (LOGAND 4 UNDO_INIT)) (COMMAND "_.undo" "_auto" "_off")))
(DEFUN AI_UNDO_POP nil (COND ((AND (= 1 (LOGAND UNDO_INIT 1)) (/= 2 (LOGAND UNDO_INIT 2)) (/= 8 (LOGAND UNDO_INIT 8))) (COMMAND "_.undo" "_end")) (T)) (IF (= 4 (LOGAND UNDO_INIT 4)) (COMMAND "_.undo" "_auto" "_on")))
(DEFUN AI_DCL (DCL_FILE / DCL_HANDLE) (COND ((AI_RETURN (CDR (ASSOC DCL_FILE AI_SUPPORT)))) ((NOT (FINDFILE (STRCAT DCL_FILE ".dcl"))) (AI_ALERT (STRCAT "δҵԻļ " DCL_FILE ".dcl\n֧Ŀ¼")) (AI_RETURN nil)) ((OR (NOT (SETQ DCL_HANDLE (LOAD_DIALOG DCL_FILE))) (> 1 DCL_HANDLE)) (AI_ALERT (STRCAT "޷ضԻļ " DCL_FILE ".dcl" "\n֧Ŀ¼")) (AI_RETURN nil)) (T (SETQ AI_SUPPORT (CONS (CONS DCL_FILE DCL_HANDLE) AI_SUPPORT)) (AI_RETURN DCL_HANDLE))))
(DEFUN AI_COMMON_STATE (SS_ENAME / BIT_VALUE) (SETQ BIT_VALUE 0) (SETQ SS_ENAME (STRCASE SS_ENAME)) (COND ((MEMBER SS_ENAME (QUOTE ("ARC" "ATTDEF" "CIRCLE" "LINE" "POINT" "POLYLINE" "SHAPE" "SOLID" "TRACE" "TEXT" "XREF"))) (SETQ BIT_VALUE (LOGIOR 1 2 4 8 16))) ((MEMBER SS_ENAME (QUOTE ("3DFACE" "ELLIPSE" "BODY" "REGION" "3DSOLID" "SPLINE" "XLINE" "TOLERANCE" "LEADER" "RAY"))) (SETQ BIT_VALUE (LOGIOR 1 2 4 8))) ((MEMBER SS_ENAME (QUOTE ("DIMENSION" "INSERT"))) (SETQ BIT_VALUE (LOGIOR 1 2 4))) ((MEMBER SS_ENAME (QUOTE ("VIEWPORT" "MTEXT"))) (SETQ BIT_VALUE (LOGIOR 1 2))) ((MEMBER SS_ENAME (QUOTE ("MLINE"))) (SETQ BIT_VALUE (LOGIOR 1 8))) (T (SETQ BIT_VALUE (LOGIOR 1 2 4 8 16)))) BIT_VALUE)
(DEFUN AI_HELPFILE (/ PLATFORM) "")
(DEFUN AI_RTOS (VAL / A B UNITS OLD_DIMZIN) (SETQ UNITS (GETVAR "lunits")) (IF (OR (= UNITS 4) (= UNITS 5)) (RTOS VAL) (PROGN (SETQ OLD_DIMZIN (GETVAR "dimzin")) (SETVAR "dimzin" (LOGAND OLD_DIMZIN (~ 8))) (SETQ A (RTOS VAL)) (SETVAR "dimzin" (LOGIOR OLD_DIMZIN 8)) (SETQ B (RTOS VAL UNITS 15)) (SETVAR "dimzin" OLD_DIMZIN) (IF (EQUAL (DISTOF A) (DISTOF B) 1.0e-006) A B))))
(DEFUN AI_ANGTOS (VAL / A B OLD_DIMZIN) (SETQ OLD_DIMZIN (GETVAR "dimzin")) (SETVAR "dimzin" (LOGAND OLD_DIMZIN (~ 8))) (SETQ A (ANGTOS VAL)) (SETVAR "dimzin" (LOGIOR OLD_DIMZIN 8)) (SETQ B (ANGTOS VAL (GETVAR "aunits") 15)) (SETVAR "dimzin" OLD_DIMZIN) (IF (EQUAL (ANGTOF A) (ANGTOF B) 1.0e-008) A B))
(DEFUN AI_SSGET (SS / START_SIZE END_SIZE A DIFF) (SETQ START_SIZE (SSLENGTH SS)) (SETQ A 0) (WHILE (< A (SSLENGTH SS)) (IF (AI_ENTITY_LOCKED (SSNAME SS A) 0) (SSDEL (SSNAME SS A) SS) (SETQ A (1+ A)))) (SETQ END_SIZE (SSLENGTH SS)) (IF (/= 0 (SETQ DIFF (- START_SIZE END_SIZE))) (PRINC (STRCAT "\n" (ITOA DIFF) " λͼ㡣"))) (IF (> (SSLENGTH SS) 0) SS nil))
(DEFUN AI_ENTITY_LOCKED (ENAME MESSAGE) (IF (= 4 (LOGAND 4 (CDR (ASSOC 70 (TBLSEARCH "layer" (CDR (ASSOC 8 (ENTGET ENAME)))))))) (PROGN (IF (= 1 MESSAGE) (PRINC "\n1 λͼ㡣")) T) nil))
(DEFUN AI_SSLENGTH (SS) (IF SS (FIX (SSLENGTH SS)) 0))
(DEFUN AI_SETCMDECHO (NEWVAL / _OLDENVVAL) (IF (/= NEWVAL (GETVAR "CMDECHO")) (PROGN (SETQ _OLDENVVAL (GETENV "acedChangeCmdEchoWithoutUndo")) (IF (NOT _OLDENVVAL) (SETQ _OLDENVVAL "0")) (SETENV "acedChangeCmdEchoWithoutUndo" "1") (SETVAR "cmdecho" NEWVAL) (SETENV "acedChangeCmdEchoWithoutUndo" _OLDENVVAL))))
(PRINC)
