<?php 

  // Contact us Form
  // Provided by A4Desk Flash Web Site Builder
  // Website: http://www.a4desk.com/
  // 
  // Note: 
  //   Modifying this page without knowledge in PHP is not recommended.
  // 

  // ========================================
  // Settings
  // ========================================

  // basic settings
  define(MAIL_TO, '{a4contact_mail_to}'); // your email address
  define(MAIL_SUBJECT, '{a4contact_mail_subject}'); // mail subject showing in your mail box
  
  // data checking options
  define(IS_CHECK_EMPTY, true); // check if visitor fill in all required fields
  define(IS_CHECK_DEFAULT, true); // check if visitor change default values
  define(IS_CHECK_SPAM, true); // spam protection

  define(DEFAULT_NAME, 'Your Name'); // works with option 'IS_CHECK_DEFAULT'
  define(DEFAULT_MESSAGE, 'Type your message here'); // works with option 'IS_CHECK_DEFAULT'



  // ========================================
  // Check Required Fields
  // ========================================

  // default status
  $valid = true; 

  // check is empty
  if(IS_CHECK_EMPTY)
    $valid = $valid && (trim($_POST['name'])!='') && (trim($_POST['email'])!='') && (trim($_POST['subject'])!='') && (trim($_POST['message'])!='');

  // check is default value changed
  if(IS_CHECK_DEFAULT)
    $valid = $valid && (($_POST['name']!=DEFAULT_NAME) && ($_POST['message']!=DEFAULT_MESSAGE));

  // check if there are spam content
  if(IS_CHECK_SPAM)
    $valid = $valid && is_content_safe($_POST);



  // ========================================
  // Send Email
  // ========================================

  // send message to your mail box, if data is valid
  if($valid)
  {
    $message = sprintf("
========================================

Name: %s

Company: %s

Email: %s

Phone: %s

Country: %s

City: %s

Subject: %s

Message:

%s

========================================
", $_POST['name'], $_POST['company'], $_POST['email'], $_POST['phone'], $_POST['country'], $_POST['city'], $_POST['subject'], $_POST['message']);

    mail(MAIL_TO, MAIL_SUBJECT, $message, 'From: '.trim(trim($_POST['name'],'<>:')).'<'.trim(trim($_POST['email'],'<>:')).'>');
  }


// ========================================
function is_content_safe($data)
{
	// flatten data
	$data_flat = serialize($data);
  // spam keywords 
	$keyword = array();
	$keyword[0] = 'Content-Type:';
	$keyword[1] = 'MIME-Version:';
	$keyword[2] = 'Content-Transfer-Encoding:';
	$keyword[3] = 'Subject:';
	$keyword[4] = 'bcc:';
	$keyword[5] = '\[url=';
  // check if keywords exist in content
  for($a=0 ; $a<sizeof($keyword) ; $a++)
    if(eregi($keyword[$a], $data_flat))
			return false; 
  // content is safe 
	return true;
}


?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>{a4contact_page_companyname}</title>  
<style type="text/css">
<!--

body, div, p {  font-family: arial, helvetica, sans-serif; font-size: 12px; color: 444444}
a, a:visited, a:active, a:hover { color: #ff0000 }

.message_box {  background-color: #eeeeee; border: 1px #CCCCCC solid; margin-top: 10px; margin-right: 10px; margin-bottom: 10px; margin-left: 10px; width: 360px}
.message_title {  background-color: e0e0e0; font-weight: bold; padding-top: 5px; padding-right: 5px; padding-bottom: 5px; padding-left: 5px; color: #FFFFFF; border-color: black black #CCCCCC; border-style: solid; border-top-width: 0px; border-right-width: 0px; border-bottom-width: 1px; border-left-width: 0px}
.message_content {  background-color: #eeeeee; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px}

#msg_error {  background-color: #CC3333}
#msg_done {  background-color: #3333CC}

-->
</style>
</head>
<body>

<?php 
  // show success message screen
  if($valid) { 
?>
<div class="message_box"><div class="message_title" id="msg_done">Message Sent</div>
  <div class="message_content">
    <p>Thank you for your message. </p>
    <p>We will get back to you soon.</p>
    <p align="center"><a href="javascript:window.close();">Close Page</a></p>
  </div>
</div>
<?php 
  // show error message screen
  } else { 
?>
<div class="message_box">
	<div class="message_title" id="msg_error">Error</div>
  <div class="message_content">
    <p>Unable to submit your request.</p>
    <p>Please check  details  you entered and try again.</p>
    <p align="center"><a href="javascript:history.go(-1);">Go Back</a></p>
  </div>
</div>
<?php } ?>

</body>
</html>