/************************************************************************/
/*                                                                      */
/*      Zoom Page  -  Firefox Extension  -  Customize Toolbar Window    */
/*                                                                      */
/*      Javascript for Customize Toolbar overlay                        */
/*                                                                      */
/*      Copyright (C) 2009-2013  by  DW-dev                             */
/*                                                                      */
/*      Last Edit  -  31 Oct 2013                                       */
/*                                                                      */
/************************************************************************/

"use strict";

var zoomPageCustomizeToolbar =
{
    /********************************************************************/
    
    /* Shared variables */
    
    prefs: Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch),
	
    /********************************************************************/
    
    /* Load and Unload functions */
    
    onLoad: function()
    {
        var button;
        var colors = new Array();
        
        /* Add event listener */
        
        document.getElementById("palette-box").addEventListener("drop",zoomPageCustomizeToolbar.onButtonDrop,false);
        
        if (document.getElementById("wrapper-zoompage-item") != null)  /* button already in Customize window */
        {
            /* Use normal button style */
            
            document.getElementById("zoompage-style-c").setAttribute("hidden","true");
            document.getElementById("zoompage-style-n").setAttribute("hidden","false");
            document.getElementById("zoompage-style-s").setAttribute("hidden","true");
            document.getElementById("zoompage-style-t").setAttribute("hidden","true");
            document.getElementById("zoompage-style-m").setAttribute("hidden","true");
            
            colors =  window.getComputedStyle(document.getElementById("zoompage-percent-label-n"),null).
                      getPropertyValue("color").match(/rgb\((\d+),\s(\d+),\s(\d+)\)/);
            
            if (Number(colors[1])+Number(colors[2])+Number(colors[3]) >= 0x80+0x80+0x80)  /* light text means dark theme */
            {
                button = document.getElementById("zoompage-zoomout-n");
                button.setAttribute("image","chrome://zoompage/skin/zoompage-zoomout-icon-n-d.png");
                button = document.getElementById("zoompage-zoomin-n");
                button.setAttribute("image","chrome://zoompage/skin/zoompage-zoomin-icon-n-d.png");
            }
            
            /* Initialise percent display */
            
            document.getElementById("zoompage-percent-label-n").setAttribute("value","100%");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("font-style");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("color");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("outline");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("outline-offset");
        }
    },
    
    onUnload: function()
    {
    },
    
    /********************************************************************/
    
    /* Event handlers */
    
    onButtonDrop: function(event)
    {
        var button;
        var colors = new Array();
        
        if (event.dataTransfer.mozSourceNode.id == "wrapper-zoompage-item")  /* button dropped in Customize window */
        {
            /* Use normal button style */
            
            document.getElementById("zoompage-style-c").setAttribute("hidden","true");
            document.getElementById("zoompage-style-n").setAttribute("hidden","false");
            document.getElementById("zoompage-style-s").setAttribute("hidden","true");
            document.getElementById("zoompage-style-t").setAttribute("hidden","true");
            document.getElementById("zoompage-style-m").setAttribute("hidden","true");
            
            colors =  window.getComputedStyle(document.getElementById("zoompage-percent-label-n"),null).
                      getPropertyValue("color").match(/rgb\((\d+),\s(\d+),\s(\d+)\)/);
            
            if (Number(colors[1])+Number(colors[2])+Number(colors[3]) >= 0x80+0x80+0x80)  /* light text means dark theme */
            {
                button = document.getElementById("zoompage-zoomout-n");
                button.setAttribute("image","chrome://zoompage/skin/zoompage-zoomout-icon-n-d.png");
                button = document.getElementById("zoompage-zoomin-n");
                button.setAttribute("image","chrome://zoompage/skin/zoompage-zoomin-icon-n-d.png");
            }
            
            /* Initialise percent display */
            
            document.getElementById("zoompage-percent-label-n").setAttribute("value","100%");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("font-style");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("color");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("outline");
            document.getElementById("zoompage-percent-label-n").style.removeProperty("outline-offset");
        }
    }
};

/************************************************************************/

/* Start Zoom Page Customize Toolbar */

window.addEventListener("load",zoomPageCustomizeToolbar.onLoad,false);

/************************************************************************/
