/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

var Cu = Components.utils;
var Ci = Components.interfaces;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");


// install & uninstall are called even for disabled extensions
function install(data, reason) {
}


function uninstall(data, reason) {
  registerResourceProtocol(data.resourceURI);

  // uninstall: remove storage, prefs
  if (reason === ADDON_UNINSTALL) { // updating=ADDON_UPGRADE
    var ns = {};
    Cu.import("resource://multifox-4410e96638/new-window.js", ns);
    ns.Bootstrap.extensionUninstall();
  }

  // update/uninstall: unload all modules
  unloadModules();
  registerResourceProtocol(null);
}


function startup(data, reason) {
  registerResourceProtocol(data.resourceURI);
  registerAbout();

  var firstRun = false;
  var reinstall = false;
  if (reason !== APP_STARTUP) {
    switch (reason) {
      case ADDON_INSTALL:
        firstRun = true;
        break;
      case ADDON_UPGRADE:
      case ADDON_DOWNGRADE:
        reinstall = true;
        break;
    }
  }

  var ns = {};
  Cu.import("resource://multifox-4410e96638/new-window.js", ns);
  ns.Bootstrap.extensionStartup(firstRun, reinstall);
}


function shutdown(data, reason) {
  if (reason === APP_SHUTDOWN) {
    return;
  }

  var ns = {};
  Cu.import("resource://multifox-4410e96638/new-window.js", ns);
  ns.Bootstrap.extensionShutdown();

  unregisterAbout();
  unloadModules();
  registerResourceProtocol(null);
}


function unloadModules() {
  Cu.unload("resource://multifox-4410e96638/actions.js");
  Cu.unload("resource://multifox-4410e96638/menus.js");
  Cu.unload("resource://multifox-4410e96638/popup.js");
  Cu.unload("resource://multifox-4410e96638/error.js");
  Cu.unload("resource://multifox-4410e96638/main.js");
  Cu.unload("resource://multifox-4410e96638/new-window.js");
}


// chrome.manifest line:
// resource ext-modules modules/
function registerResourceProtocol(uri) { // null to unregister
  var io = Services.io;
  var module = uri ? io.newURI(uri.resolve("modules/"), null, null) : null;
  io.getProtocolHandler("resource")
    .QueryInterface(Ci.nsIResProtocolHandler)
    .setSubstitution("multifox-4410e96638", module);
}


function registerAbout() {
  var Cm = Components.manager;
  Cm.QueryInterface(Ci.nsIComponentRegistrar).registerFactory(
    Components.ID("{347c41b6-1417-411c-b87a-422bcfc1899a}"),
    "about multifox",
    "@mozilla.org/network/protocol/about;1?what=multifox",
    AboutMultifoxFactory);
}


function unregisterAbout() {
  var Cm = Components.manager;
  Cm.QueryInterface(Ci.nsIComponentRegistrar).unregisterFactory(
    Components.ID("{347c41b6-1417-411c-b87a-422bcfc1899a}"),
    AboutMultifoxFactory);
}


var AboutMultifoxFactory = {
  createInstance: function(outer, iid) {
    if (outer !== null) {
      throw Components.resources.NS_ERROR_NO_AGGREGATION;
    }
    return AboutMultifoxImpl.QueryInterface(iid);
  }
};


var AboutMultifoxImpl = {
  QueryInterface: XPCOMUtils.generateQI([Ci.nsIAboutModule]),
  getURIFlags: function(uri) {
    return Ci.nsIAboutModule.ALLOW_SCRIPT;
  },

  newChannel: function(uri) {
    var channel = Services.io.newChannel("chrome://multifox-4410e96638/content/about-multifox.html", null, null);
    channel.originalURI = uri;
    return channel;
  }
};
