var SpaceNext = {

	ID												: "{c71ff04d-f001-1fc1-1fc1-c71ff04df005}",
	//The word "Next" in the top X most-spoken languages from Wikipedia.org
	//Chinese (Simplified), Chinese (Traditional), Spanish, English, Hindi, Urdu, Arabic, Bengali, Portuguese (Brazil), Portuguese (Portugal), Russian, Japanese, German, Javanese, Punjabi, Telegu, Marathi, French, Vietnamese, Korean, Tamil, Italian, Turkish, Gujarati, Polish, Ukrainian, Malay, Kannada, Malayalam, Sunda, Oriya, Persian, Hausa, Romanian, Indonesian, Azerbaijani, Dutch, Thai, Yoruba
	NEXT_REGEXP_ARRAY1								: ["\u4E0B\u4E00\u9875", "\u4E0B\u4E00\u9801", "siguiente", "next|EN_VERB?next\\s*(chapter|page|image|photo(graph)?|pic(ture)?|slide|step|recipe)?|next\\s\\d+(\\b|\\s.+)", "\u0905\u0917\u0932\u093E", "\u0627\u06AF\u0644", "\u0627\u0644\u062A\u0627\u0644\u064A\u0629", "\u09AA\u09B0\u09C7\u09B0", "mais", "pr\u00F3ximo", "\u0421\u043B\u0435\u0434\u0443\u044E\u0449\u0430\u044F", "\u6B21\u3078", "vorw\u00E4rts", "terusane", "\u0A05\u0A71\u0A17\u0A47", "\u0C24\u0C26\u0C41\u0C2A\u0C30\u0C3F", "\u092A\u0941\u0922\u0940\u0932", "suivant(e)?(s)?|suite|(aller \u00E0 la )?(page|chapitre|[\u00E9|e]tape|diapo(rama)?|image|photo|photographie|recette|fiche).*suivante|suiv\\.?|\\d+\\s(.*\\s)?suivant(e)?s", "ti\u1EBFp", "\uB2E4\uC74C", "\u0B85\u0B9F\u0BC1\u0BA4\u0BCD\u0BA4\u0BC1", "avanti", "sonraki", "\u0A86\u0A97\u0AB3", "nast\u0119pna", "\u0423\u043F\u0435\u0440\u0435\u0434", "berikut", "\u0CAE\u0CC1\u0C82\u0CA6\u0CBF\u0CA8", "\u0D05\u0D1F\u0D41\u0D24\u0D4D\u0D24\u0D24\u0D4D", "salajengna", "\u0B2A\u0B30\u0B2C\u0B30\u0B4D\u0B24\u0B4D\u0B24\u0B3F", "\u0B2A\u0B30\u0B2C\u0B30\u0B4D\u0B24\u0B4D\u0B24\u0B3F", "gaba", "\u00CEnainte", "berikutnya", "sonrak\u0131", "volgende", "\u0E16\u0E31\u0E14\u0E44\u0E1B", "ti.*\u00F3.*K\u00E0n"],
	//Sindhi, Pashto, Uzbek, Igbo, Amharic, Nepali, Serbo-Croatian, Kurdish, Malagasy, Hungarian, Sinhalese, Greek, Czech, Shona, Oromo, Somali, Zulu, Quechua, Kazakh, Chichewa, Haitian Creole, Belarusian, Swedish, Akan, Uyghur, Bulgarian, Albanian, Kinyarwanda, Xhosa, Afrikaans, Hebrew, Tigrinya, Catalan, Turkmen, Tajik, Armenian, Mongolian, Danish, Finnish, Tatase, Slovak, Guarani, Kirundi, Sesotho, Norwegian
	NEXT_REGEXP_ARRAY2								: ["\u0627\u06B3\u064A\u0648\u0646", "\u0628\u0644", "navbatdagi", "nke na abia.", "\u1240\u1323\u12ED", "\u0905\u0930\u094D\u0915\u094B", "slede\u0107a", "\u062F\u0648\u0627\u062A\u0631", "manaraka", "k\u00F6vetkez\u0151", "\u0DB4\u0DC3\u0DD4", "\u0395\u03C0\u03CC\u03BC\u03B5\u03BD\u03B7", "dal\u0161\u00ED", "zvirikutevera", "ka'ittaanu", "kan ku xiga", "okulandelayo", "qhepan", "\u041A\u0435\u043B\u0435\u0441\u0456", "patsogolo", "paj apre a", "\u041D\u0430\u0441\u0442\u0443\u043F\u043D\u044B\u044F", "n\u00E4sta", "dea \u025Bdi so", "\u0643\u06D0\u064A\u0649\u0646\u0643\u0649", "\u0421\u043B\u0435\u0434\u0432\u0430\u0449\u0430", "faqja tjeter", "igikurikira", "elandelayo", "volgende", "\u05D4\u05D1\u05D0", "\u12DD\u1255\u133D\u120D", "seg\u00FCent", "o\u00F1e", "\u041E\u044F\u043D\u0434\u0430", "\u0540\u0561\u057B\u0578\u0580\u0564", "\u0425\u043E\u0439\u0448\u0438\u0445", "n\u00E6ste", "seuraava", "kil\u00E4se", "\u010Eal\u0161ia", "upeigu\u00E1va", "igikurikira", "latelang", "neste"],
	NEXT_REGEXP_SPECIAL_STRING_0					: "( )?(>|>>|\u00BB|\u203A|\u2026|\u2192|\u226B|\u25BA|\u25B8|\\.\\.\\.|\=\=\>)",
	NEXT_REGEXP_SPECIAL_STRING_1					: "((\u003C|\u00AB|\u2190|\u2193|\u219C|\u219E) )?((earlier|EN_VERB?(more|old(er)?|other|past|previous|)) (EN_EXP)+|Prev 7 Days|(show( me)?|load) more|more \u2192|older|past|many more( \u2193)?(.*)|(FR_VERB(les )?)?(FR_EXP) (pr[\u00E9|e]c[\u00E9|e]dente?s?|plus ancien(ne)?s?)|ancien(ne)?s?|avant|FR_VERB?(plus d('|e )|davantage d('|e ))(FR_EXP)))((\u00A0| ?)",
	EN_VERB											: "(display |go to |load |read |see |show (me)?|view )",
	FR_VERB											: "(afficher |charger |consulter |visualiser |voir )",
	EN_EXP											: "images?.*|models?.*|photos?.*|photographs?.*|pictures?.*|slides?.*|steps?.*|stuff|articles?.*|comments?.*|content|entr(y|ies).*|features?.*|headlines?.*|messages?.*|(gaming )?news.*|notes?.*|(news )?posts?.*|releases?.*|results?.*|stor(y|ies).*|strips?.*|threads?.*|titles?.*|topics?.*|updates?.*|weeks?.*",
	FR_EXP											: "actu(alit[\u00E9|e])?s?|articles?|billets?|contenus?|entr[\u00E9|e]es?|info(rmation)?s?|messages?|news|notes?|posts?|r[\u00E9|e]sultats?|semaines?|sujets?|titres?",
	NEXT_REGEXP_GOOGLE_STRING_1						: "repeat the search with the omitted results included|relancer la recherche en incluant les pages ignor\u00E9es",
	NEXT_REGEXP_GOOGLE_STRING_2						: "show more results|plus de r\u00E9sultats",
	NEXT_REGEXP_TWITTER_STRING						: "view all tweets",
	NEXT_REGEXP_NUMERICAL_ELEMENT					: /^([\/\|\.\,\:\u00B7\u2022\u2026\u203A\uFF5C\[\]\(\)\{\}]|[\d\s\-])*\d([\/\|\.\,\:\u00B7\u2022\u2026\u203A\uFF5C\[\]\(\)\{\}]|[\d\s\-])*$/,
	NEXT_REGEXP										: null,
	NEXT_REGEXP_PAGE								: /pages?|parts?|p[a|\u00E1]ginas?|bladsye?|faqe|stranic[a|e]|sivut?|lehek[u|\u00FC]l(g|jed)|p[a|\u00E1]xinas?|seiten?|oldal|halaman|leathana(ch|igh)|strona?|sayf(a|alari)/i,
	NEXT_REGEXP_DATE_YYYYMM							: /(\d{4}\/([0]?[1-9]|[1][0-2])(\/|$)|\W(m|d|date)?(\=|\-)\d{4}([0]?[1-9]|[1][0-2])([0]?[1-9]|[1-2][0-9]|[3][0-1])(\W|\b)|\=([0]?[1-9]|[1-2][0-9]|[3][0-1])\/([0]?[1-9]|[1][0-2])\/\d{4}(\W|\b)|\d{4}\-([0]?[1-9]|[1][0-2])\-([0]?[1-9]|[1-2][0-9]|[3][0-1])(\W|\b)|([0][1-9]|[1][0-2])\.([0][1-9]|[1-2][0-9]|[3][0-1])\.\d{2}(\W|\b))/i, /** YYYY/mM(/|$) (m|d|date)(=|-)YYYYmMdDx =dD/mM/YYYYx YYYY-mM-dDx MM.DD.YY**/
	TRIM_REGEXP_1									: /[\/\|\.\,\:\u00B7\u2022\u2026\u203A\uFF5C\[\]\(\)\{\}]|[\f\n\r\t\v\u00A0\u2028\u2029]/g,
	TRIM_REGEXP_2									: /\s+/g,
	TRIM_REGEXP_3									: /\-(?!\d)/g,
	CLOUD_REGEXP									: /cloud|nuage/i,
	SIDEBAR_REGEXP									: /leftbar|rightbar|sidebar/i,
	STYLE_NO_DISPLAY_REGEXP							: /^(none)$/i,
	STYLE_NO_VISIBILITY_REGEXP						: /^(collapse|hidden)$/i,
	STYLE_CURSOR_REGEXP								: /^(pointer|move)$/i,
	STYLE_TEXT_DECORATION_REGEXP					: /^(underline)$/i,
	JAVASCRIPT_HREF_REGEXP							: /^javascript\:/,
	WWW_REGEXP										: /^www\./,
	VALID_SEARCH_REGEXP								: /(re)?cherche|find|query|question|rech|result(at)?s|search|send|submit|valider|nb_sb_noss/i,	//nb_sb_noss=>amazon.com
	VALID_PROTOCOL_REGEXP							: /^(https?|file)$/,
	VALID_HTTP_PROTOCOL_REGEXP						: /^https?$/,
	REL_NOFOLLOW_SELECTOR							: /\bnofollow\b/gi,
	TAG_REGEXP										: /\/(categor(y|ies)|labels?|tags?)(\/|\-)[^\/]*\/?$/i,
	COMMENT_REGEXP									: /\bcomment(aire)?s?|\brates?|\bratings?|\br[\u00E9|e]actions?|\bstars?/i,
	SPECIAL_METAS_SELECTOR							: "[name=generator][content^=vBulletin]",
	SPECIAL_WRAPPERS_SELECTOR						: "body > div[id=ipbwrapper]",
	BLACKLISTED_HOSTS								: /^(((.+)\.)?(calendar\.live|calendar\.yahoo|mail\.yahoo|i-tchat|shoutmix)\.com)|(((.+)\.)?(cbox)\.ws)$/,
	BLACKLISTED_ELEMENTS							: [[/^(https:\/\/(encrypted|www)\.google\.com\/)|(https?:\/\/www\.google\.(com|ad|ae|com\.af|com\.ag|com\.ai|am|co\.ao|com\.ar|as|at|com\.au|az|ba|com\.bd|be|bf|bg|com\.bh|bi|bj|com\.bn|com\.bo|com\.br|bs|co\.bw|by|com\.bz|ca|cd|cf|cg|ch|ci|co\.ck|cl|cm|cn|com\.co|co\.cr|com\.cu|cz|de|dj|dk|dm|com\.do|dz|com\.ec|ee|com\.eg|es|com\.et|fi|com\.fj|fm|fr|ga|ge|gg|com\.gh|com\.gi|gl|gm|gp|gr|com\.gt|gy|com\.hk|hn|hr|ht|hu|co\.id|ie|co\.il|im|co\.in|iq|is|it|je|com\.jm|jo|co\.jp|co\.ke|com\.kh|ki|kg|co\.kr|com\.kw|kz|la|com\.lb|li|lk|co\.ls|lt|lu|lv|com\.ly|co\.ma|md|me|mg|mk|ml|mn|ms|com\.mt|mu|mv|mw|com\.mx|com\.my|co\.mz|com\.na|com\.nf|com\.ng|com\.ni|ne|nl|no|com\.np|nr|nu|co\.nz|com\.om|com\.pa|com\.pe|com\.ph|com\.pk|pl|pn|com\.pr|ps|pt|com\.py|com\.qa|ro|ru|rw|com\.sa|com\.sb|sc|se|com\.sg|sh|si|sk|com\.sl|sn|so|sm|st|com\.sv|td|tg|co\.th|com\.tj|tk|tl|tm|tn|to|com\.tr|tt|com\.tw|co\.tz|com\.ua|co\.ug|co\.uk|com\.uy|co\.uz|com\.vc|co\.ve|vg|co\.vi|com\.vn|vu|ws|rs|co\.za|co\.zm|co\.zw)\/)/i, /^(past week|show more results from .*|plus de r\u00E9sultats de .*)$/i], [/^http:\/\/www\.flickr\.com\/.*\/lightbox\/$/i, /^next$/i], [/^http:\/\/((.+)\.)?yahoo\.(com|co\.jp)\//i, /^(past week|more results from .*|plus de r\u00E9sultats .*)$/i], [/^https?:\/\/groups\.google\.com\//i, /^(more message actions)$/i]],
	WHITELISTED_ELEMENTS							: [[/^(https:\/\/(encrypted|www)\.google\.com\/)|(https?:\/\/www\.google\.(com|ad|ae|com\.af|com\.ag|com\.ai|am|co\.ao|com\.ar|as|at|com\.au|az|ba|com\.bd|be|bf|bg|com\.bh|bi|bj|com\.bn|com\.bo|com\.br|bs|co\.bw|by|com\.bz|ca|cd|cf|cg|ch|ci|co\.ck|cl|cm|cn|com\.co|co\.cr|com\.cu|cz|de|dj|dk|dm|com\.do|dz|com\.ec|ee|com\.eg|es|com\.et|fi|com\.fj|fm|fr|ga|ge|gg|com\.gh|com\.gi|gl|gm|gp|gr|com\.gt|gy|com\.hk|hn|hr|ht|hu|co\.id|ie|co\.il|im|co\.in|iq|is|it|je|com\.jm|jo|co\.jp|co\.ke|com\.kh|ki|kg|co\.kr|com\.kw|kz|la|com\.lb|li|lk|co\.ls|lt|lu|lv|com\.ly|co\.ma|md|me|mg|mk|ml|mn|ms|com\.mt|mu|mv|mw|com\.mx|com\.my|co\.mz|com\.na|com\.nf|com\.ng|com\.ni|ne|nl|no|com\.np|nr|nu|co\.nz|com\.om|com\.pa|com\.pe|com\.ph|com\.pk|pl|pn|com\.pr|ps|pt|com\.py|com\.qa|ro|ru|rw|com\.sa|com\.sb|sc|se|com\.sg|sh|si|sk|com\.sl|sn|so|sm|st|com\.sv|td|tg|co\.th|com\.tj|tk|tl|tm|tn|to|com\.tr|tt|com\.tw|co\.tz|com\.ua|co\.ug|co\.uk|com\.uy|co\.uz|com\.vc|co\.ve|vg|co\.vi|com\.vn|vu|ws|rs|co\.za|co\.zm|co\.zw)\/)/i, /^\d+$/i], [/^http:\/\/www\.bing\.com\//i, /^\d+$/i], [/^http:\/\/((.+)\.)?yahoo\.(com|co\.jp)\//i, /^\d+$/i]],
	BLACKLISTED_CONTENT_ELEMENTS					: [[/^(https?:\/\/translate.googleusercontent.com\/)/i, /^.*$/i]],
	NEXT_LINK_SELECTOR								: "link[rel~='next'][href]:not([href=''])",
	NEXT_ANCHOR_SELECTOR							: "a[rel~='next']",
	NEXT_AREA_SELECTOR								: "area[rel~='next']",
	NEXT_CONTAINERS_SELECTOR						: "*:not(a) > div, *:not(a) > span, *:not(a) > li, input[type='button'], input[type='submit'], button[type='button']",
	ANCHOR_SELECTOR									: "a",
	AREA_SELECTOR									: "area",
	BASE_SELECTOR									: "base",
	BR_SELECTOR										: "br",
	BUTTON_SELECTOR									: "button",
	DIV_SELECTOR									: "div",
	FORM_SELECTOR									: "form",
	FRAMESET_SELECTOR								: "frameset",
	HEAD_SELECTOR									: "head",
	IMAGE_SELECTOR									: "img",
	INPUT_SELECTOR									: "input",
	LINK_SELECTOR									: "link",
	SCRIPT_SELECTOR									: "script",
	META_SELECTOR									: "meta",
	EXCEPTIONAL_PROPERTIES							: {"bottom": null, "left": null, "right": null, "top": null, "height": null, "width": null, "margin-bottom": null, "margin-left": null, "margin-right": null, "margin-top": null, "min-height": null, "min-width": null, "padding-bottom": null, "padding-left": null, "padding-right": null, "padding-top": null, "text-indent": null},
	DEPRECATED_ATTRIBUTES							: {"basefont": ["color", "size"], "body": ["alink", "background", "bgcolor", "link", "text", "vlink"], "br": ["clear"], "caption": ["align"], "div": ["align"], "font": ["color", "face", "size"], "h1": ["align"], "h2": ["align"], "h3": ["align"], "h4": ["align"], "h5": ["align"], "h6": ["align"], "hr": ["align", "noshade", "size", "width"], "img": ["align", "border", "hspace", "vspace"], "li": ["type", "value"], "object": ["border", "hspace", "vspace"], "ol": ["compact", "start"], "pre": ["width"], "table": ["align", "bgcolor"], "td": ["bgcolor", "nowrap", "width"], "th": ["bgcolor", "nowrap", "width"], "tr": ["bgcolor"], "ul": ["compact"]},
	READYSTATES										: {"interactive": null, "complete": null},
	STRING_PREFERENCE_ADDON							: "extensions.spacenext.",
	STRING_PREFERENCE_ADDON_APPEND					: "append",
	STRING_PREFERENCE_ADDON_APPEND_CONTENT_ONLY		: "appendContentOnly",
	STRING_PREFERENCE_ADDON_CONSERVE_ON_UNLOAD		: "conserveOnUnload",
	STRING_PREFERENCE_ADDON_DEBUG					: "debug",
	STRING_PREFERENCE_ADDON_DELAY					: "delay",
	STRING_PREFERENCE_ADDON_ENABLE					: "enable",
	STRING_PREFERENCE_ADDON_KEY						: "key",
	STRING_PREFERENCE_ADDON_MAXIMUM_APPENDED_PAGES	: "maximumAppendedPages",
	STRING_PREFERENCE_ADDON_MAXIMUM_RETRIES			: "maximumRetries",
	STRING_PREFERENCE_ADDON_MODIFIERS				: "modifiers",
	STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR		: "showInStatusBar",
	STRING_PREFERENCE_ADDON_TIMEOUT					: "timeOut",
	STRING_PREFERENCE_ADDON_WARP					: "warp",
	STRING_PREFERENCES								: {STRING_PREFERENCE_ADDON: null},
	KEYCODE_REGEXP									: /^(DOM_VK_|VK_)/i,
	MAXIMUM_LEVELS									: 3,
	ELEMENT_RATIO									: 0.2,
	AREA											: 1024 * 768,
	TARGETS											: {null: null, "": null, "_parent": null, "_self": null},
	AUTHORIZED_CONTAINERS							: {"body": null, "tbody": null, "td": null, "div": null, "span": null, "article": null, "section": null},
	POSITIONS										: {"absolute": null, "fixed": null},
	FLAG_DEBUG_FORCE_APPEND							: 0x1, // 0001
	FLAG_DEBUG_FORCE_APPEND_FRAME					: 0x2, // 0010
	loadXULIFrameTimers								: [],
	scrollXULIFrameTimers							: [],
	checkFrameTimers								: [],
	progressBarTimers								: [],
	requestTimeoutTimers							: [],
	currentDocs										: [],
	domUtils										: null,
	eTLDService										: null,
	eventListenerService							: null,
	iOService										: null,
	isGecko2Plus									: null,

	_keypressWithCapture: function(e) {
		SpaceNext.keypressWithCapture(e);
	},

	_keypress: function(e) {
		SpaceNext.keyPress(e);
	},

	_closeTab: function(e) {
		SpaceNext.closeTab(e.view);
	},

	setPointers: function() {
		this.NEXT_REGEXP = new RegExp ("^(((" + this.NEXT_REGEXP_ARRAY1.join("|").replace(/EN_VERB/g, this.EN_VERB) + "|" + this.NEXT_REGEXP_ARRAY2.join("|") + ")" + this.NEXT_REGEXP_SPECIAL_STRING_0 + "?|" + this.NEXT_REGEXP_SPECIAL_STRING_1.replace(/EN_EXP/g, this.EN_EXP).replace(/FR_EXP/g, this.FR_EXP).replace(/EN_VERB/g, this.EN_VERB).replace(/FR_VERB/g, this.FR_VERB) + this.NEXT_REGEXP_SPECIAL_STRING_0 + ")?|" + this.NEXT_REGEXP_GOOGLE_STRING_1 + "|" + this.NEXT_REGEXP_GOOGLE_STRING_2 + "|" + this.NEXT_REGEXP_TWITTER_STRING + "|" + this.NEXT_REGEXP_SPECIAL_STRING_0 + ")$", "gi");
		this.domUtils = Components.classes["@mozilla.org/inspector/dom-utils;1"].getService(Components.interfaces.inIDOMUtils);
		this.eTLDService = Components.classes["@mozilla.org/network/effective-tld-service;1"].getService(Components.interfaces.nsIEffectiveTLDService);
		this.eventListenerService = Components.classes["@mozilla.org/eventlistenerservice;1"].getService(Components.interfaces.nsIEventListenerService);
		this.iOService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
	},

	unsetPointers: function() {
		this.NEXT_REGEXP = null;
		this.domUtils = null;
		this.eTLDService = null;
		this.eventListenerService = null;
		this.iOService = null;
	},

	addListeners: function() {
		window.addEventListener("unload", this._closeTab, false);
		this.getGBrowser().tabContainer.addEventListener("TabClose", this._closeTab, false);
	},

	removeListeners: function() {
		window.removeEventListener("unload", this._closeTab, false);
		this.getGBrowser().tabContainer.removeEventListener("TabClose", this._closeTab, false);
	},

	init: function() {
		if (this.getBooleanEnable()) {
			this.setPointers();
			this.setShortcut();
			this.addListeners();
		}
		this.showInStatusBar();
	},

	uninit: function() {
		this.unsetPointers();
		this.unsetShortcut();
		this.removeListeners();
	},

	getGBrowser: function() {
		return (!window.getBrowser) ? window.opener.getBrowser() : window.getBrowser();
	},

	filterKeypress: function(e) {
		if (e.which == e.DOM_VK_SPACE && !e.shiftKey && !e.ctrlKey) {
			var target = e.target;
			if (target.ownerDocument.designMode == "off" && !target.isContentEditable && (!this.testBodyInnerElement(target) || target instanceof HTMLAnchorElement)) {
				return true;
			}
		}
		return false;
	},

	keypressWithCapture: function(e) {
		if (this.filterKeypress(e)) {
			var topDoc = e.target.ownerDocument.defaultView.top.document;
			topDoc["_SpaceNextEndOfPage"] = this.checkEndOfPage(topDoc);
		}
	},

	keyPress: function(e) {
		if (this.filterKeypress(e)) {
			var doc = e.target.ownerDocument;
			if (this.getBooleanWarp()) {
				if (this.goToNextPage(doc.defaultView.top.document, true)) {
					e.preventDefault();
				}
			} else {
				if (this.checkScrollingDocument(doc) && this.checkPagePosition(this.getScrollingDocument(doc))) {
					if (this.goToNextPage(doc.defaultView.top.document, false)) {
						e.preventDefault();
					}
				}
			}
		}
	},

	closeTab: function(tab) {
		var content = tab.content;
		if (content.document instanceof HTMLDocument) {
			this.removeFromCurrentDocs(content.document);
		}
	},

	checkScrollingDocument: function(doc) {
		var selection = doc.defaultView.content.getSelection();
		if (selection.rangeCount > 0) {
			var computedStyle = doc.defaultView.getComputedStyle(doc.documentElement.lastElementChild, null);
			var intLineHeight = parseInt(computedStyle.getPropertyValue("line-height"), 10);
			var element = selection.getRangeAt(0).commonAncestorContainer;
			while (element.parentNode) {
				if (element.clientHeight != element.scrollHeight && element.offsetHeight != element.scrollHeight && element.scrollTop + element.offsetHeight < element.scrollHeight && element.scrollHeight > intLineHeight) {
					var elementComputedStyle = doc.defaultView.getComputedStyle(element, null);
					if (elementComputedStyle.getPropertyValue("overflow-y") != "hidden") {
						break;
					}
				}
				element = element.parentNode;
			}
			return !this.testBodyInnerElement(element);
		}
		return true;
	},

	testBodyInnerElement: function(elt) {
		return !(elt instanceof HTMLBodyElement) && this.testBodyOrDescendantElement(elt);
	},

	testBodyOrDescendantElement: function(elt) {
		return !(elt instanceof HTMLHtmlElement || elt instanceof HTMLDocument);
	},

	getScrollingDocument: function(doc) {
		var win = doc.defaultView;
		while (win != win.top && (win.scrollMaxY == 0 || (win.frameElement && win.frameElement.scrolling == "no"))) {
			win = win.parent;
		}
		return win.document;
	},

	checkPagePosition: function(doc) {
		var win = doc.defaultView;
		return this.getIntegerAppend() != 0 ? win.pageYOffset + (this.getIntegerAppend() * win.innerHeight) >= win.scrollMaxY : this.checkEndOfPage(doc);
	},

	checkEndOfPage: function(doc) {
		var win = doc.defaultView;
		return win.pageYOffset >= win.scrollMaxY;
	},

	___goToNextPage: function(tDoc, bool) {
		if (this.getBooleanEnable()) {
			this.goToNextPage(tDoc, bool);
		}
	},

	goToNextPage: function(tDoc, bool) {
		var result = 0;
		if (this.addToCurrentDocs(tDoc)) {
			try {
				if (bool) {
					tDoc["_SpaceNextEndOfPage"] = true;
				}
				var link = this.getNextLink(tDoc);
				if (link && link.href) {
					if (bool || this.checkPagePosition(link.ownerDocument)) {
						if (this.getIntegerAppend() != 0) {
							var element = this.getNextAnchor(tDoc) || this.getNextArea(tDoc) || this.getElement(tDoc, false);
							if (element && link.href == element.href) {
								result = this.activateElement(element, bool);
							} else {
								result = this.activateElement(link, bool);
							}
						} else {
							result = this.openLocation(link);
						}
					}
				} else {
					var element = this.getNextAnchor(tDoc) || this.getNextArea(tDoc) || this.getElement(tDoc, true);
					if (element) {
						if (bool || this.checkPagePosition(element.ownerDocument)) {
							result = this.activateElement(element, bool);
						}
					}
				}
			} catch (e) {
			} finally {
				if (result >= 0) {
					this.removeFromCurrentDocs(tDoc);
				}
				return (result == 1);
			}
		}
		return false;
	},

	addToCurrentDocs: function(tDoc) {
		this.currentDocs = this.currentDocs.filter(this._testElementDefaultView);
		if (this.currentDocs.every(this._testElementDifferentToDoc, tDoc)) {
			this.currentDocs.push(tDoc);
			return true;
		}
		return false;
	},

	removeFromCurrentDocs: function(doc) {
		this.currentDocs = this.currentDocs.filter(this._testElementDefaultView);
		if (doc.defaultView) {
			this.currentDocs = this.currentDocs.filter(this._testElementDifferentToDoc, doc.defaultView.top.document);
		}
	},

	_testElementDifferentToDoc: function(tDoc) {
		return (tDoc != this);
	},

	_testElementDefaultView: function(tDoc) {
		try {
			return (tDoc.defaultView != null && tDoc.defaultView.document == tDoc);
		} catch (e) {
			return false;
		}
	},

	getNextLink: function(tDoc) {
		return this.getNextItem(tDoc, this.NEXT_LINK_SELECTOR);
	},

	getNextItemInFrames: function(doc, sel, meth) {
		var frames = doc.defaultView.frames;
		for (var i = frames.length - 1, frame, frameDoc, nextItemInFrames; frame = frames[i]; i--) {
			frameDoc = frame.document;
			if (frameDoc) {
				nextItemInFrames = meth.call(this, frameDoc, sel);
				if (nextItemInFrames) {
					return nextItemInFrames;
				}
			}
		}
		return null;
	},

	openLocation: function(elt) {
		var href = elt.href;
		var document = elt.ownerDocument
		if (document.location.href != href) {
			document.location = href;
			return 1;
		}
		return 0;
	},

	getNextAnchor: function(tDoc) {
		return this.getNextItem(tDoc, this.NEXT_ANCHOR_SELECTOR);
	},

	getNextArea: function(tDoc) {
		return this.getNextItem(tDoc, this.NEXT_AREA_SELECTOR);
	},

	getNextItem: function(doc, sel) {
		var nextItems = this.filterOldElements(doc, doc.querySelectorAll(sel));
		return (nextItems.length == 0) ? this.getNextItemInFrames(doc, sel, this.getNextItem) : (nextItems.length == 1 ? nextItems[0] : null);
	},

	___filterAnchorsRelNoFollow: function(elt) {
		return !(elt[0] instanceof HTMLAnchorElement) || !this.REL_NOFOLLOW_SELECTOR.test(elt[0].rel);
	},

	filterAnchorsRelNoFollow: function(arr) {
		if (arr.length > 1) {
			var arrayWithoutAnchorsRelNoFollow = arr.filter(this.___filterAnchorsRelNoFollow, this);
			return (arr.length == arrayWithoutAnchorsRelNoFollow.length) ? arr : arrayWithoutAnchorsRelNoFollow;
		}
		return arr;
	},
	
	getElementFromElements: function(nElts, tElts, cElts) {
		function filterElementsStyleNonNegativeTextIndent(elt, idx, arr) {
			var computedStyle = elt[0].ownerDocument.defaultView.getComputedStyle(elt[0], null);
			return parseInt(computedStyle.getPropertyValue("text-indent"), 10) >= 0;
		}

		function sortByWidth(a, b) {
			var computedStyleA = a[0].ownerDocument.defaultView.getComputedStyle(a[0], null);
			var computedStyleB = b[0].ownerDocument.defaultView.getComputedStyle(b[0], null);
			return parseInt(computedStyleA.getPropertyValue("width"), 10) - parseInt(computedStyleB.getPropertyValue("width"), 10);
		}

		var numericalElements = nElts, textualElements = tElts, calendarElements = cElts;
		if (numericalElements.concat(textualElements).filter(filterElementsStyleNonNegativeTextIndent).length > 0) {
			numericalElements = numericalElements.filter(filterElementsStyleNonNegativeTextIndent);
			textualElements = textualElements.filter(filterElementsStyleNonNegativeTextIndent);
		} else {
			var elementsStyleNegativeTextIndent = textualElements.concat(numericalElements).sort(sortByWidth);
			if (elementsStyleNegativeTextIndent.length > 0) {
				return elementsStyleNegativeTextIndent.pop()[0];
			}
		}

		if (numericalElements[0]) {
			numericalElements = this.filterAnchorsRelNoFollow(numericalElements);
			numericalElements.sort(this.sortNumericalElementsByDimensions);
			return numericalElements[0][0];
		} else if (textualElements[0]) {
			textualElements = this.filterAnchorsRelNoFollow(textualElements);
			var textualElementsKeywords = textualElements.filter(function (elt) {return !this.getTrimmedValueForElement(elt[0]).match(new RegExp("^" + this.NEXT_REGEXP_SPECIAL_STRING_0 + "$"))}, this);
			if (textualElementsKeywords[0]) {
				textualElements = textualElementsKeywords;
			}
			var textualNonCalendarElements = textualElements.filter(function (elt) {return !elt[0].href || !this.call(SpaceNext, elt[0].href)}, this.testDateYYYYMMFormat);
			if (textualNonCalendarElements[0]) {
				if (textualNonCalendarElements.length == 2) {
					if (textualNonCalendarElements[1][0].textContent.match(this.NEXT_REGEXP_SPECIAL_STRING_0)) {
						if (textualNonCalendarElements[0][0].textContent == textualNonCalendarElements[1][0].textContent + "|") {
							return textualNonCalendarElements[1][0];
						} else if (textualNonCalendarElements[0][0].textContent == textualNonCalendarElements[1][0].textContent + textualNonCalendarElements[1][0].textContent) {
							return textualNonCalendarElements[1][0];
						}
					}
				}
				var newTextualNonCalendarElements = textualNonCalendarElements.filter(function(elt){return !this.getTrimmedValueForElement(elt[0]).match(new RegExp("^" + this.NEXT_REGEXP_SPECIAL_STRING_0 + "$"))}, this);
				if (newTextualNonCalendarElements.length > 0) {
					var newTextualNonCalendarElementsOutsideSideBar = newTextualNonCalendarElements.filter(function(elt){return !this.testSidebar(elt[0], 3)}, this);
					if (newTextualNonCalendarElementsOutsideSideBar.length > 0) {
						newTextualNonCalendarElementsOutsideSideBar.sort(this.sortTextualElementsByDimensions);
						return newTextualNonCalendarElementsOutsideSideBar[0][0];
					} else {
						newTextualNonCalendarElements.sort(this.sortTextualElementsByDimensions);
						return newTextualNonCalendarElements[0][0];
					}
				} else {
					textualNonCalendarElements.sort(this.sortTextualElementsByDimensions);
					return textualNonCalendarElements[0][0];
				}
			}
			var textualCalendarElements = textualElements.filter(function (elt) {return elt[0].href && this.call(SpaceNext, elt[0].href)}, this.testDateYYYYMMFormat);
			textualCalendarElements.sort(this.sortTextualElementsByDimensions);
			return textualCalendarElements[0][0];
		} else if (calendarElements[0]) {
			calendarElements = this.filterAnchorsRelNoFollow(calendarElements);
			calendarElements.sort(this.sortNumericalElementsByDimensions);
			return calendarElements[0][0];
		}
		return null;
	},

	getElement: function(tDoc, bool) {
		var [numericalElements, textualElements, calendarElements] = this.getElements(tDoc, bool);
		for (var i = 0, calendarElement; calendarElement = calendarElements[i];) {
			if (this.checkWhitelistedElement(calendarElement[0])) {
				numericalElements.push(calendarElements.splice(i, 1)[0]);
			} else {
				i++;
			}
		}
		var numericalElements1 = numericalElements.filter(function(arr){return !this.testTagAnchor(arr[0]);}, this);
		var textualElements1 = textualElements.filter(function(arr){return !this.testTagAnchor(arr[0]);}, this);
		var calendarElements1 = calendarElements.filter(function(arr){return !this.testTagAnchor(arr[0]);}, this);
		var element = this.getElementFromElements(numericalElements1, textualElements1, calendarElements1);
		if (!element) {
			var numericalElements2 = numericalElements.filter(function(arr){return this.testTagAnchor(arr[0]);}, this);
			var textualElements2 = textualElements.filter(function(arr){return this.testTagAnchor(arr[0]);}, this);
			var calendarElements2 = calendarElements.filter(function(arr){return this.testTagAnchor(arr[0]);}, this);
			element = this.getElementFromElements(numericalElements2, textualElements2, calendarElements2);
		}
		return element;
	},

	checkListedElement: function(elt, elts) {
		for (var i = 0, listedElement; listedElement = elts[i]; i++) {
			if (elt.ownerDocument.location.href.search(listedElement[0]) != -1 && this.getTrimmedValueForElement(elt).search(listedElement[1]) != -1) {
				return true;
			}
		}
		return false;
	},

	checkBlacklistedElement: function(elt) {
		return this.checkListedElement(elt, this.BLACKLISTED_ELEMENTS);
	},

	checkWhitelistedElement: function(elt) {
		return this.checkListedElement(elt, this.WHITELISTED_ELEMENTS);
	},

	checkBlacklistedContentElement: function(elt) {
		return this.checkListedElement(elt, this.BLACKLISTED_CONTENT_ELEMENTS);
	},

	___filterBlacklistedElements: function(arr) {
		return !this.checkBlacklistedElement(arr[0]);
	},

	getElements: function(doc, bool) {
		var [numericalAnchors, textualAnchors, calendarAnchors] = this.getAnchors(doc);
		var [numericalContainers, textualContainers] = (bool) ? this.getContainers(doc) : [[], [], []];
		var [numericalElementsInFrames, textualElementsInFrames, calendarElementsInFrames] = this.getElementsInFrames(doc, bool);
		var numericalElements = (numericalElementsInFrames.concat(numericalContainers, numericalAnchors)).filter(this.___filterBlacklistedElements, this);
		var textualElements = (textualElementsInFrames.concat(textualContainers, textualAnchors)).filter(this.___filterBlacklistedElements, this);
		var calendarElements = (calendarElementsInFrames.concat(calendarAnchors)).filter(this.___filterBlacklistedElements, this);
		return [numericalElements, textualElements, calendarElements];
	},

	getElementsInFrames: function(doc, bool) {
		var numericalAnchorsInFrames = [], textualAnchorsInFrames = [], calendarAnchorsInFrames = [];
		var frames = doc.defaultView.frames.frames;
		for (var i = frames.length - 1, frame, frameDoc, numericalAnchors, textualAnchors, calendarAnchors; frame = frames[i]; i--) {
			frameDoc = frame.document;
			if (frameDoc) {
				[numericalAnchors, textualAnchors, calendarAnchors] = this.getElements(frameDoc, bool);
				numericalAnchorsInFrames = numericalAnchorsInFrames.concat(numericalAnchors);
				textualAnchorsInFrames = textualAnchorsInFrames.concat(textualAnchors);
				calendarAnchorsInFrames = calendarAnchorsInFrames.concat(calendarAnchors);
			}
		}
		return [numericalAnchorsInFrames, textualAnchorsInFrames, calendarAnchorsInFrames];
	},

	sortNumericalElementsByDimensions: function(a, b) {
		var elementA = a[0];
		var previousElementA = a[1];
		var elementB = b[0];
		var previousElementB = b[1];

		var rangeA = elementA.ownerDocument.createRange();
		rangeA.setStartBefore(previousElementA);
		rangeA.setEndAfter(elementA);

		var rangeB = elementB.ownerDocument.createRange();
		rangeB.setStartBefore(previousElementB);
		rangeB.setEndAfter(elementB);

		try {
			if (rangeA.commonAncestorContainer.firstChild instanceof HTMLElement && rangeA.commonAncestorContainer.lastChild instanceof HTMLElement && rangeB.commonAncestorContainer.firstChild instanceof HTMLElement && rangeB.commonAncestorContainer.lastChild instanceof HTMLElement) {
				var widthA = rangeA.commonAncestorContainer.lastChild.offsetLeft + rangeA.commonAncestorContainer.firstChild.offsetWidth - rangeA.commonAncestorContainer.firstChild.offsetLeft;
				var widthB = rangeB.commonAncestorContainer.lastChild.offsetLeft + rangeB.commonAncestorContainer.firstChild.offsetWidth - rangeB.commonAncestorContainer.firstChild.offsetLeft;
				return (widthA == widthB) ? (elementB.offsetHeight - elementA.offsetHeight) : (widthB - widthA);
			}
		} catch (e) {}

		var offsetWidthRangeAncestorA = rangeA.commonAncestorContainer.offsetWidth;
		var offsetWidthRangeAncestorB = rangeB.commonAncestorContainer.offsetWidth;
		return (offsetWidthRangeAncestorA == offsetWidthRangeAncestorB) ? (elementB.offsetHeight - elementA.offsetHeight) : (offsetWidthRangeAncestorB - offsetWidthRangeAncestorA);
	},

	sortTextualElementsByDimensions: function(a, b) {
		return b[0].offsetHeight - a[0].offsetHeight;
	},

	getAnchors: function(doc) {
		var numericalAnchors = [], textualAnchors = [], calendarAnchors = [];
		if (!this.checkInvalidDocument(doc)) {
			var anchors = this.filterOldElements(doc, doc.querySelectorAll(this.ANCHOR_SELECTOR));
			for (var i = anchors.length - 1, anchor; anchor = anchors[i]; i--) {
				if (!this.testUnclickableElement(anchor) && !this.checkInvalidAnchor(anchor)) {
					if (!this.checkNumericalAnchor(anchor, numericalAnchors, calendarAnchors)) {
						this.checkTextualAnchor(anchor, textualAnchors);
					}
				}
			}
		}
		return [numericalAnchors, textualAnchors, calendarAnchors];
	},

	filterOldElements: function(doc, elts) {
		if (this.getIntegerAppend() != 0) {
			var separator = this.getLastSeparator(doc);
			if (separator) {
				var nbrElements = elts.length;
				if (nbrElements != 0) {
					var newElements = [];
					for (var i = nbrElements - 1, element; element = elts.item(i); i--) {
						if (element.compareDocumentPosition(separator) & Node.DOCUMENT_POSITION_PRECEDING) {
							newElements.push(element);
						} else {
							break;
						}
					}
					return newElements.reverse();
				}
			} else if (doc.defaultView.frameElement && doc.defaultView.frameElement.getAttribute("space-next-frame") == "true") {
				if (doc.defaultView.frameElement != doc.defaultView.parent.document.querySelector("iframe[space-next-frame=true]:last-of-type")) {
					return [];
				}
			} else if (doc.defaultView.parent.document.querySelector("iframe[space-next-frame=true]")) {
				return [];
			}
		}
		return Array.prototype.slice.call(elts, 0);
	},

	checkNumericalAnchor: function(anc, ancs1, ancs2) {
		if (this.testNumericalElement(anc) && !this.testCommentNumericalElement(anc) && this.checkAnchor(anc)) {
			var intAnchorValue = this.getTrimmedNumericalValueForElement(anc);
			var previousSiblingOrUncle = anc.previousSibling;
			var level = 0;
			while (level < this.MAXIMUM_LEVELS) {
				while (previousSiblingOrUncle) {
					if (!this.testUnclickableElement(previousSiblingOrUncle)) {
						if (this.testNumericalElement(previousSiblingOrUncle) && !this.testCommentNumericalElement(previousSiblingOrUncle)) {
							var intPreviousSiblingOrUncleValue = this.getTrimmedNumericalValueForElement(previousSiblingOrUncle);
							if (Math.abs(intAnchorValue - intPreviousSiblingOrUncleValue) == 1) {
								if (previousSiblingOrUncle instanceof Text) {
									if (this.testDateYYYYMMFormat(anc.href)) {
										ancs2.push([anc, previousSiblingOrUncle]);
									} else {
										ancs1.push([anc, previousSiblingOrUncle]);
									}
									return true;
								}
								switch (previousSiblingOrUncle instanceof HTMLAnchorElement) {
									case false:
										var previousAnchor = previousSiblingOrUncle.querySelector(this.ANCHOR_SELECTOR);
										if (!previousAnchor) {
											if (this.testDateYYYYMMFormat(anc.href)) {
												ancs2.push([anc, previousSiblingOrUncle]);
											} else {
												ancs1.push([anc, previousSiblingOrUncle]);
											}
											return true;
										} else {
											previousSiblingOrUncle = previousAnchor;
										}
									case true:
									default:
										var doc = anc.ownerDocument;
										var contentNode = this.getContentNode(doc);
										var docHref = contentNode ? contentNode.getAttribute("space-next-referer") : doc.location.href;
										if ((!this.testUnclickableElement(previousSiblingOrUncle) && !this.compareNumericalElements(anc, previousSiblingOrUncle) && !this.checkInvalidAnchor(previousSiblingOrUncle)) || (!this.checkJavaScriptForElement(anc) && docHref == previousSiblingOrUncle.href)) {
											if (this.testDateYYYYMMFormat(anc.href)) {
												if (!this.compareElementWithLastElementInArray(anc, ancs2)) {
													ancs2.push([anc, previousSiblingOrUncle]);
													return true;
												}
											} else {
												if (!this.compareElementWithLastElementInArray(anc, ancs1)) {
													ancs1.push([anc, previousSiblingOrUncle]);
													return true;
												}
											}
										}
										break;
								}
								return false;
							} else {
								return false;
							}
						} else if (this.getTrimmedValueForElement(previousSiblingOrUncle) != "") {
							return false;
						}
					}
					previousSiblingOrUncle = previousSiblingOrUncle.previousSibling;
				}
				var parentNode = this.getParentNode(anc, level++);
				previousSiblingOrUncle = parentNode ? parentNode.previousSibling : null;
			}
		}
		return false;
	},

	getParentNode: function(node, lev) {
		return lev == 0 ? node.parentNode : this.getParentNode(node.parentNode, --lev);
	},

	testDateYYYYMMFormat: function(val) {
		return val.match(this.NEXT_REGEXP_DATE_YYYYMM);
	},

	compareElementWithLastElementInArray: function(elt, arr) {
		if (arr[0]) {
			var lastElement = arr[arr.length - 1][0];
			var lastElementGrandParent = lastElement.parentNode.parentNode;
			return (lastElementGrandParent.compareDocumentPosition(elt) & Node.DOCUMENT_POSITION_CONTAINED_BY);
		}
		return false;
	},

	compareUri: function(uri1, uri2) {
		return uri1.scheme == uri2.scheme && uri1.host.match(new RegExp("(^|\\.)" + uri2.host + "$", "i")) && uri1.port == uri2.port;
	},

	checkInvalidDocument: function(doc) {
		var docUri = this.iOService.newURI(doc.location.href, doc.characterSet, null);
		return !this.checkValidProtocol(docUri.scheme) || docUri.host.match(this.BLACKLISTED_HOSTS);
	},

	checkInvalidAnchor: function(anc) {
		var href = anc.href;
		if (href != "" && !href.match(this.JAVASCRIPT_HREF_REGEXP)) {
			try {
				var doc = anc.ownerDocument;
				var docUri = this.iOService.newURI(doc.location.href, doc.characterSet, null);
				var ancUri = this.iOService.newURI(href, null, null);
				return !this.compareUri(docUri, ancUri);
			} catch (e) {
				return true;
			}
		}
		return false;
	},

	testSidebar: function(elt, lev) {
		return (lev >= 0) ? ((elt.id.match(this.SIDEBAR_REGEXP) || elt.className.match(this.SIDEBAR_REGEXP)) ? true : this.testSidebar(elt.parentNode, --lev)) : false;
	},

	testCloud: function(elt, lev) {
		return (lev >= 0) ? ((elt.id.match(this.CLOUD_REGEXP) || elt.className.match(this.CLOUD_REGEXP)) ? true : this.testCloud(elt.parentNode, --lev)) : false;
	},

	testTagAnchor: function(elt) {
		return elt instanceof HTMLAnchorElement && elt.href.match(this.TAG_REGEXP) && !this.testPageFormat(elt.href) && (!elt.href.match(this.VALID_SEARCH_REGEXP) || this.testCloud(elt, 2));
	},

	testCommentNumericalElement: function(elt) {
		if (elt instanceof HTMLElement) {
			for (var i = 0, children = elt.children, child; child = children[i]; i++) {
				if (this.testNumericalElement(child) && this.testCommentNumericalElement(child)) {
					return true;
				}
			}
			return (elt.className.match(this.COMMENT_REGEXP) || elt.title.match(this.COMMENT_REGEXP)) && (elt instanceof HTMLAnchorElement ? (elt.href && !this.testPageFormat(elt.href)) : true);
		}
		return false;
	},

	checkValidProtocol: function(prot) {
		return (prot.match(this.VALID_PROTOCOL_REGEXP) != null);
	},

	checkValidHTTPProtocol: function(prot) {
		return (prot.match(this.VALID_HTTP_PROTOCOL_REGEXP) != null);
	},

	getSecondLevelDomain: function(host) {
		try {
			return this.eTLDService.getBaseDomainFromHost(host);
		} catch (e) {
			return host;
		}
	},

	testPageFormat: function(val) {
		return val.match(this.NEXT_REGEXP_PAGE);
	},

	testElementCursorOrTextDecoration: function(elt) {
		if (elt instanceof HTMLInputElement || elt instanceof HTMLButtonElement || elt instanceof HTMLLIElement) {
			return true;
		}
		var computedStyle = elt.ownerDocument.defaultView.getComputedStyle(elt, null);
		return this.STYLE_CURSOR_REGEXP.test(computedStyle.getPropertyValue("cursor")) || this.STYLE_TEXT_DECORATION_REGEXP.test(computedStyle.getPropertyValue("text-decoration"));
	},

	testUnclickableElement: function(elt) {
		if (elt instanceof HTMLElement) {
			if (elt.disabled) {
				return true;
			} else if (elt.offsetHeight == 0) {
				for (var i = 0, children = elt.children, child; child = children[i]; i++) {
					if (!this.testUnclickableElement(child)) {
						return false;
					}
				}
				return true;
			}
			var computedStyle = elt.ownerDocument.defaultView.getComputedStyle(elt, null);
			return (this.STYLE_NO_DISPLAY_REGEXP.test(computedStyle.getPropertyValue("display")) || this.STYLE_NO_VISIBILITY_REGEXP.test(computedStyle.getPropertyValue("visibility")));
		} else if (elt instanceof Text) {
			return false;
		}
		return true;
	},

	compareNumericalElements: function(elt1, elt2) {
		if (this.compareElements(elt1, elt2) && this.compareElementsChildren(elt1, elt2)) {
			var parent1 = elt1.parentNode;
			var parent2 = elt2.parentNode;
			return (parent1 == parent2 || this.compareElements(parent1, parent2));
		}
		return false;
	},

	compareElementsChildren: function(elt1, elt2) {
		if (!elt1 && !elt2) {
			return true;
		} else if (!elt1 || !elt2) {
			return false;
		}
		for (var i = 0, j = 0, children1 = elt1.children, children2 = elt2.children, nbrChildren1 = children1.length, nbrChildren2 = children2.length, nbrChildren = Math.max(nbrChildren1, nbrChildren2); i < nbrChildren && j < nbrChildren; i++, j++) {
			var child1 = children1[i];
			var child2 = children2[j];
			while (child1 && this.testUnclickableElement(child1)) {
				child1 = children1[++i];
			}
			while (child2 && this.testUnclickableElement(child2)) {
				child2 = children1[++j];
			}
			if (!this.compareElements(child1, child2) || !this.compareElementsChildren(child1, child2)) {
				return false;
			}
		}
		return true;
	},

	compareElements: function(elt1, elt2) {
		return (!elt1 && !elt2) ? true : (!elt1 || !elt2) ? false : (!this.compareElementsNodeName(elt1, elt2) ? false : (!this.compareElementsDeprecatedAttributes(elt1, elt2) ? false : this.compareElementsStyle(elt1, elt2)));
	},

	compareElementsNodeName: function(elt1, elt2) {
		return (elt1.nodeName.toLowerCase() == elt2.nodeName.toLowerCase());
	},

	compareElementsClassName: function(elt1, elt2) {
		return (elt1.className == elt2.className);
	},

	compareElementsDeprecatedAttributes: function(elt1, elt2) {
		var attributes = this.DEPRECATED_ATTRIBUTES[elt1.nodeName.toLowerCase()];
		return attributes ? attributes.every(function (att) {return this[0][att] == this[1][att]}, [elt1, elt2]) : true;
	},

	compareElementsStyle: function(elt1, elt2) {
		var properties = [];
		this.getElementStyle(elt1, properties);
		this.getElementStyle(elt2, properties);
		return this.compareElementsProperties(elt1, elt2, properties) ? this.compareElementsCSSStyle(elt1, elt2) : false;
	},

	getElementStyle: function(elt, props) {
		for (var i = 0, style = elt.style, property; property = style[i]; i++) {
			if (!(property in this.EXCEPTIONAL_PROPERTIES) && !props.some(this._testArrayContainsElement, property)) {
				props.push(property);
			}
		}
	},

	compareElementsCSSStyle: function(elt1, elt2) {
		if (this.compareElementsClassName(elt1, elt2) && this.compareElementsClassName(elt1.parentNode, elt2.parentNode)) {
			return true;
		}
		var properties = [];
		this.getElementCSSStyle(elt1, properties);
		this.getElementCSSStyle(elt2, properties);
		return this.compareElementsProperties(elt1, elt2, properties);
	},

	getElementCSSStyle: function(elt, props) {
		for (var i = 0, cssStyleRules = this.domUtils.getCSSStyleRules(elt), cssStyleRule; cssStyleRule = cssStyleRules.GetElementAt(i); i++) {
			for (var j = 0, cssStyleDeclaration = cssStyleRule.style, property; property = cssStyleDeclaration[j]; j++) {
				if (!(property in this.EXCEPTIONAL_PROPERTIES) && !props.some(this._testArrayContainsElement, property)) {
					props.push(property);
				}
			}
		}
	},

	compareElementsProperties: function(elt1, elt2, props) {
		for (var i = 0, defaultView = elt1.ownerDocument.defaultView, computedStyle1 = defaultView.getComputedStyle(elt1, null), computedStyle2 = defaultView.getComputedStyle(elt2, null), property; property = props[i]; i++) {
			if (computedStyle1.getPropertyValue(property) != computedStyle2.getPropertyValue(property)) {
				return false;
			}
		}
		return true;
	},

	testNumericalElement: function(elt) {
		return ((elt.value != null && typeof elt.value == "string" && elt.value.replace(this.NEXT_REGEXP_PAGE, "").match(this.NEXT_REGEXP_NUMERICAL_ELEMENT)) || elt.textContent.replace(this.NEXT_REGEXP_PAGE, "").match(this.NEXT_REGEXP_NUMERICAL_ELEMENT));
	},

	checkAnchor: function(anc) {
		return (this.checkJavaScriptForElement(anc) || anc.href != anc.ownerDocument.location.href);
	},

	checkTextualAnchor: function(anc, ancs) {
		if (this.testTextualAnchor(anc) && this.checkAnchor(anc)) {
			ancs.push([anc]);
		}
	},

	testTextualAnchor: function(anc) {
		return this.testTextualObject(anc);
	},

	getTrimmedValue: function(val) {
		return val.replace(this.TRIM_REGEXP_1, "").replace(this.TRIM_REGEXP_2, " ").replace(this.TRIM_REGEXP_3, "").trim();
	},

	getTrimmedNumericalValue: function(val) {
		return (val == "") ? -Infinity : parseInt(this.getTrimmedValue(val), 10);
	},

	getTrimmedValueForElement: function(elt) {
		return (elt.value != null && typeof elt.value == "string" && elt.value != "") ? this.getTrimmedValue(elt.value) : this.getTrimmedValue(elt.textContent);
	},

	getTrimmedNumericalValueForElement: function(elt) {
		return (elt.value != null && typeof elt.value == "string" && elt.value != "") ? this.getTrimmedNumericalValue(elt.value.replace(this.NEXT_REGEXP_PAGE, "")) : this.getTrimmedNumericalValue(elt.textContent.replace(this.NEXT_REGEXP_PAGE, ""));
	},

	checkFrameset: function(elt) {
		var win = elt.ownerDocument.defaultView;
		if (win.frameElement) {
			while (win.parent != win) {
				if (win.document.body.localName == this.FRAMESET_SELECTOR) {
					return true;
				}
				win = win.parent;
			}
		}
		return false;
	},

	activateElement: function(elt, bool) {
		var result = 1;
		var doc = elt.ownerDocument;
		if (this.getIntegerAppend() != 0 && !this.checkFrameset(elt)) {
			if (this.getIntegerMaximumAppendedPages() <= 0 || !(doc.querySelectorAll("div[space-next-separator=true]").length >= this.getIntegerMaximumAppendedPages() || (doc.defaultView.frameElement && doc.defaultView.frameElement.getAttribute("space-next-frame") == "true" && doc.defaultView.parent.document.querySelectorAll("iframe[space-next-frame=true]").length >= this.getIntegerMaximumAppendedPages()))) {
				if (this.checkBlacklistedContentElement(elt)) {
					result = this.activateAnchorAndAppend(this.appendFrame, doc, elt, elt.href);
				} else if (elt instanceof HTMLAnchorElement || elt instanceof HTMLAreaElement) {
					if (!this.checkJavaScriptForElement(elt) || (this.getIntegerDebug() & this.FLAG_DEBUG_FORCE_APPEND)) {
						if (this.getIntegerDebug() & this.FLAG_DEBUG_FORCE_APPEND_FRAME) {
							result = this.activateAnchorAndAppend(this.appendFrame, doc, elt, elt.href);
						} else {
							if (elt.href && elt.href != "" && !(elt.href.match("#.*$")) && !elt.href.match(this.JAVASCRIPT_HREF_REGEXP) && elt.getAttribute("space-next-element") != "true" && !(doc.defaultView.frameElement && doc.defaultView.frameElement.getAttribute("space-next-frame") == "true")) {
								result = this.activateAnchorAndAppend(this.appendContent, doc, elt, elt.href);
							} else {
								this.activateMouseEventOnElement(elt, "mouseover");
								if (elt.href && elt.href != "" && !(elt.href.match("#.*$")) && !elt.href.match(this.JAVASCRIPT_HREF_REGEXP)) {
									result = this.activateAnchorAndAppend(this.appendFrame, doc, elt, elt.href);
								}
							}
						}
					}
				} else if (elt instanceof HTMLLinkElement) {
					result = this.activateAnchorAndAppend(this.appendFrame, doc, elt, elt.href);
				}
			} else {
				bool = true;
			}
		}
		if (result == 1) {
			if (bool || this.checkEndOfPage(doc)) {
				this.clickElement(elt);
			}
			result = 0;
		}
		return result;
	},

	activateAnchorAndAppend: function(meth, doc, elt, url) {
		if (!url.match(this.JAVASCRIPT_HREF_REGEXP)) {
			var contentNode = this.getContentNode(doc);
			if ((!contentNode || contentNode.getAttribute("space-next-referer") != url && contentNode.getAttribute("space-next-previous") != url) && doc.location.href != url) {
				meth.call(this, doc, elt, url);
				return -1;
			}
			return 0;
		}
		return 1;
	},

	clickElement: function(elt) {
		var element = elt.querySelector(this.IMAGE_SELECTOR) || elt;
		this.activateMouseEventOnElement(element, "mouseover");
		this.activateMouseEventsOnElement(element);
	},

	activateMouseEventsOnElement: function(elt) {
		this.activateMouseEventOnElement(elt, "mousedown");
		this.activateMouseEventOnElement(elt, "mouseup");
		this.activateMouseEventOnElement(elt, "click");
	},

	activateMouseEventOnElement: function(elt, evt) {
		var doc = elt.ownerDocument;
		var mouseEvent = doc.createEvent("MouseEvents");
		mouseEvent.initMouseEvent(evt, true, true, doc.defaultView, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
		elt.dispatchEvent(mouseEvent);
	},

	getContainers: function(doc) {
		var numericalContainers = [], textualContainers = [];
		var containers = this.filterOldElements(doc, doc.querySelectorAll(this.NEXT_CONTAINERS_SELECTOR));
		for (var i = containers.length - 1, container; container = containers[i]; i--) {
			if (!container.querySelector(this.ANCHOR_SELECTOR)) {
				if (!this.testUnclickableElement(container) && this.testElementCursorOrTextDecoration(container)) {
					if (container instanceof HTMLInputElement || container instanceof HTMLButtonElement || this.checkJavaScriptForElement(container)) {
						if (!this.checkNumericalContainer(container, numericalContainers)) {
							this.checkTextualContainer(container, textualContainers);
						}
					}
				}
			}
		}
		return [numericalContainers, textualContainers];
	},

	checkNumericalContainer: function(cont, conts) {
		if (this.testNumericalElement(cont) && !this.testCommentNumericalElement(cont)) {
			var intContainerValue = this.getTrimmedNumericalValueForElement(cont);
			var previousSiblingOrUncle = cont.previousSibling;
			var level = 0;
			while (level < this.MAXIMUM_LEVELS) {
				while (previousSiblingOrUncle) {
					if (!this.testUnclickableElement(previousSiblingOrUncle)) {
						if (this.testNumericalElement(previousSiblingOrUncle) && !this.testCommentNumericalElement(previousSiblingOrUncle)) {
							var intPreviousSiblingOrUncleValue = this.getTrimmedNumericalValueForElement(previousSiblingOrUncle);
							if (Math.abs(intContainerValue - intPreviousSiblingOrUncleValue) == 1) {
								if (level != 0) {
									for (var i = 0, previousSiblingOrUncleChildren = previousSiblingOrUncle.children, previousSiblingOrUncleChild; previousSiblingOrUncleChild = previousSiblingOrUncleChildren[i]; i++) {
										if (this.getTrimmedNumericalValueForElement(previousSiblingOrUncleChild) == intPreviousSiblingOrUncleValue) {
											previousSiblingOrUncle = previousSiblingOrUncleChild;
											break;
										}
									}
								}
								if (!this.testUnclickableElement(previousSiblingOrUncle) && !this.compareNumericalElements(cont, previousSiblingOrUncle)) {
									if (!this.compareElementWithLastElementInArray(cont, conts)) {
										conts.push([cont, previousSiblingOrUncle]);
										return true;
									}
								}
								return false;
							} else {
								return false;
							}
						} else if (this.getTrimmedValueForElement(previousSiblingOrUncle) != "") {
							return false;
						}
					}
					previousSiblingOrUncle = previousSiblingOrUncle.previousSibling;
				}
				var parentNode = this.getParentNode(cont, level++);
				previousSiblingOrUncle = parentNode ? parentNode.previousSibling : null;
			}
		}
		return false;
	},

	checkTextualContainer: function(cont, conts) {
		if (this.testTextualContainer(cont)) {
			conts.push([cont]);
		}
	},

	testTextualContainer: function(cont) {
		return this.testTextualObject(cont);
	},

	testTextualObject: function(obj) {
		var boolValidObject = this.getTrimmedValueForElement(obj).match(this.NEXT_REGEXP) || (obj.title != null && obj.title.match(this.NEXT_REGEXP) != null);
		if (!boolValidObject) {
			var image = obj.querySelector(this.IMAGE_SELECTOR);
			if (!image || (!(image.alt != null && image.alt != ">" && image.alt != "..." && image.alt.match(this.NEXT_REGEXP)) && !(image.title != null && image.title.match(this.NEXT_REGEXP)))) {
				return false;
			}
		}
		return true;
	},

	checkSameOriginPolicy: function(doc, url) {
		var docUri = this.iOService.newURI(doc.location.href, doc.characterSet, null);
		var linkUri = this.iOService.newURI(url, null, null);
		if (this.checkValidHTTPProtocol(docUri.scheme)) {
			return this.compareUri(docUri, linkUri);
		} else {
			if (this.getPreferencesBranch().getBoolPref("security.fileuri.strict_origin_policy")) {
				var docArray = docUri.spec.split("/"); docArray.pop();
				var docFolder = docArray.join("/") + "/";
				return linkUri.spec.match(new RegExp(docFolder));
			} else {
				return (docUri.scheme == linkUri.scheme);
			}
		}
	},

	removeNode: function(elt) {
		try { elt.parentNode.removeChild(elt); } catch (e) {}
	},

	___hashChangedWindowWithFrame: function(e) {
		if (!e.newURL || e.oldURL || e.newURL.search(new RegExp ("^" + e.oldURL + "#")) == -1) {
			SpaceNext.hashChangedWindowWithFrame(this);
		}
	},

	hashChangedWindowWithFrame: function(win) {
		var doc = win.document;

		var iframe;
		while (iframe = doc.querySelector("iframe[space-next-frame=true]:last-of-type")) {
			iframe.removeEventListener("load", this._loadFrame, false);
			this.removeNode(iframe);
		}

		var element = doc.querySelector("*:not(iframe)[space-next-element=true]");
		if (element) {
			element.removeAttribute("space-next-element");
		}
	},

	___pageHiddenWindowWithFrame: function(e) {
		SpaceNext.pageHiddenWindowWithFrame(this);
	},

	pageHiddenWindowWithFrame: function(win) {
		if (!this.getBooleanConserveOnUnload()) {
			win.removeEventListener("pagehide", this.___pageHiddenWindowWithFrame, false);
			win.removeEventListener("hashchange", this.___hashChangedWindowWithFrame, false);
			this.hashChangedWindowWithFrame(win);
		}
	},

	___hashChangedFrame: function(e) {
		if (!e.newURL || e.oldURL || e.newURL.search(new RegExp ("^" + e.oldURL + "#")) == -1) {
			SpaceNext.hashChangedFrame(this);
		}
	},

	hashChangedFrame: function(frm) {
		var frames = frm.parent.document.querySelectorAll("iframe[space-next-frame=true]");
		for (var i = frames.length - 1, frameElement = frm.frameElement, frame; frame = frames[i]; i--) {
			if (frame != frameElement) {
				this.removeNode(frame);
			} else {
				break;
			}
		}

		var element = frm.document.querySelector("*:not(iframe)[space-next-element=true]");
		if (element) {
			element.removeAttribute("space-next-element");
		}

		this.adjustElementsTargets(frameElement);
		this.adjustHeight(frameElement);
	},

	___pageHiddenFrame: function(e) {
		SpaceNext.pageHiddenFrame(this);
	},

	pageHiddenFrame: function(win) {
		win.removeEventListener("pagehide", this.___pageHiddenFrame, false);
		win.removeEventListener("hashchange", this.___hashChangedFrame, false);
	},

	_loadFrame: function(e) {
		SpaceNext.loadFrame(e.originalTarget.contentWindow.frameElement);
	},

	scrollIntoView: function(doc, elt) {
		var topDoc = doc.defaultView.top.document;
		if (topDoc["_SpaceNextEndOfPage"]) {
			elt.scrollIntoView(true);
			try { delete topDoc["_SpaceNextEndOfPage"]; } catch (e) {}
		}
	},

	loadFrame: function(ifr) {
		var win = ifr.contentWindow.parent;
		var doc = win.document;
		try {
			win.removeEventListener("hashchange", this.___hashChangedWindowWithFrame, false);
			win.addEventListener("hashchange", this.___hashChangedWindowWithFrame, false);
			win.removeEventListener("pagehide", this.___pageHiddenWindowWithFrame, false);
			win.addEventListener("pagehide", this.___pageHiddenWindowWithFrame, false);

			ifr.contentWindow.removeEventListener("hashchange", this.___hashChangedFrame, false);
			ifr.contentWindow.addEventListener("hashchange", this.___hashChangedFrame, false);
			ifr.contentWindow.removeEventListener("pagehide", this.___pageHiddenFrame, false);
			ifr.contentWindow.addEventListener("pagehide", this.___pageHiddenFrame, false);

			ifr.setAttribute("space-next-frame", true);
			this.adjustElementsTargets(ifr);
			this.adjustHeight(ifr);
			this.scrollIntoView(doc, ifr);
		} catch (e) {
		} finally {
			this.hideProgressBar(doc);
		}
	},

	getError: function(s) {
		var element = document.getElementById("strings_spacenext_neterrors");
		if (element) {
			try { return element.getString(s); } catch (e) {}
		}
		return "";
	},

	getGenericNetError: function() {
		return this.getError("generic");
	},

	getTimeoutNetError: function() {
		return this.getError("netTimeout");
	},

	getNetError: function(code) {
		var description = this.getError(code);
		return description ? description : this.getGenericNetError();
	},

	getErrorDescription: function(doc) {
		var url = doc.location.href;
		switch (url) {
			case "about:blank":
				break;
			default:
				var error = url.search(/e\=/);
				var duffUrl = url.search(/\&u\=/);
				if (error != -1 && duffUrl != -1 && duffUrl > error) {
					return this.getNetError(decodeURIComponent(url.slice(error + 2, duffUrl)));
				}
		}
		return this.getGenericNetError();
	},

	___checkFrame: function(ifr) {
		SpaceNext.checkFrame(ifr);
	},

	checkFrame: function(ifr) {
		this.checkFrameTimers = this.checkFrameTimers.filter(function(elt){return elt[0] != this;}, ifr);
		if (ifr.contentDocument) {
			if (ifr.contentDocument.readyState == "uninitialized") {
				var timer = setTimeout(this.___checkFrame, this.getIntegerDelay(), ifr);
				this.checkFrameTimers.push([ifr, timer]);
			} else {
				var tabBrowser = this.getTabBrowser(ifr.contentWindow.parent.document);
				if (tabBrowser && tabBrowser.webProgress.isLoadingDocument) {
					var timer = setTimeout(this.___checkFrame, this.getIntegerDelay(), ifr);
					this.checkFrameTimers.push([ifr, timer]);
				} else if (ifr.contentDocument.location.href.match(/(^about:blank$)|(^about:neterror\?)/)) {
					ifr.removeEventListener("load", this._loadFrame, false);
					this.displayProgressBarError(ifr.contentWindow.parent.document, this.getErrorDescription(ifr.contentDocument));
					this.removeNode(ifr);
				}
			}
		}
	},

	appendFrame: function(doc, elt, url) {
		elt.setAttribute("space-next-element", "true");

		if (doc.defaultView.frameElement && doc.defaultView.frameElement.getAttribute("space-next-frame") == "true") {
			doc = doc.defaultView.parent.document;
		}

		this.displayProgressBarFrame(doc);

		var iframe = doc.body.insertBefore(doc.createElement("iframe"), null);
		with (iframe) {
			addEventListener("load", this._loadFrame, false);
			frameBorder = "no";
			height = "0px";
			scrolling = "no";
			src = url;
			width = "100%";
		}

		var timer = setTimeout(this.___checkFrame, this.getIntegerDelay(), iframe);
		this.checkFrameTimers.push([iframe, timer]);
	},

	adjustElementsTargets: function(ifr) {
		var doc = ifr.contentDocument;
		this.adjustElementsTarget(doc, this.ANCHOR_SELECTOR + ":not([href*='#'])," + this.AREA_SELECTOR + ":not([href*='#'])," + this.FORM_SELECTOR + "," + this.NEXT_LINK_SELECTOR, "target");
		this.adjustElementsTarget(doc, this.BUTTON_SELECTOR + "," + this.INPUT_SELECTOR, "formtarget");
	},

	adjustHeight: function(ifr) {
		if (ifr) {
			ifr.height = ifr.contentDocument.documentElement.scrollHeight.toString(10) + "px";
			this.adjustHeight(ifr.contentDocument.defaultView.parent.frameElement);
		}
	},

	adjustElementsTarget: function(doc, sel, targ) {
		for (var i = 0, elements = doc.querySelectorAll(sel), element; element = elements[i]; i++) {
			if (element.getAttribute(targ) in this.TARGETS) {
				element.setAttribute(targ, "_top");
			}
		}
	},

	___preloadXULIFrame: function(e) {
		if (e.target.defaultView && !e.target.defaultView.frameElement) {
			this.removeEventListener("DOMContentLoaded", SpaceNext.___preloadXULIFrame, true);
			SpaceNext.preloadXULIFrame(e.currentTarget);
		}
	},

	preloadXULIFrame: function(xfr) {
		var win = xfr.contentWindow;
		if (this.checkEventsForElement(win, ["load"])) {
			var event = xfr.contentDocument.defaultView.document.createEvent("HTMLEvents");
			event.initEvent("load", true, false);
			xfr.contentDocument.defaultView.dispatchEvent(event);
		}

		var timer = setTimeout(this.___loadXULIFrame, this.getIntegerDelay(), xfr, 0, this.getIntegerMaximumRetries());
		this.loadXULIFrameTimers.push([xfr, timer]);
	},

	___loadXULIFrame: function(xfr, act, ret) {
		SpaceNext.loadXULIFrame(xfr, act, ret);
	},

	loadXULIFrame: function(xfr, act, ret) {
		this.loadXULIFrameTimers = this.loadXULIFrameTimers.filter(function(elt){return elt[0].contentWindow != null && elt[0] != this;}, xfr);
		var wait = false;
		var force = false;
		if (ret > 0) {
			try {
				if (xfr.ownerDocument.readyState != "complete") {
					wait = true;
				} else {
					var [jQuery, wrappedJSObjectWin, wrappedJSObjectDoc] = this.getJQuery(xfr.contentDocument);
					if (jQuery !== null) {
						if (jQuery.resize !== null && typeof jQuery.resize == "object") {
							force = true;
						} else if (jQuery.active !== null && typeof jQuery.active == "number" && jQuery.active != 0) {
							wait = true;
							if (jQuery.active != act) {
								act = jQuery.active;
								ret = this.getIntegerMaximumRetries();
							} else {
								if (jQuery.active < 0) {
									ret--;
								}
								ret--;
							}
						} else {
							if ((jQuery.readyWait !== null && typeof jQuery.readyWait == "number" && jQuery.readyWait > 0) || (jQuery.isReady !== null && typeof jQuery.isReady == "boolean" && !jQuery.isReady)) {
								wait = true;
								if (jQuery.ready !== null && typeof jQuery.ready == "function") {
									var sandbox = new Components.utils.Sandbox(wrappedJSObjectWin);
									sandbox.window = wrappedJSObjectWin;
									sandbox.document = wrappedJSObjectDoc;
									Components.utils.evalInSandbox("window.jQuery.ready.call(window.jQuery);", sandbox);
								}
							}
						}
					}
				}
			} catch (e) {}
		}

		if (!force) {
			if (wait) {
				var timer = setTimeout(this.___loadXULIFrame, this.getIntegerDelay(), xfr, act, ret);
				this.loadXULIFrameTimers.push([xfr, timer]);
			} else {
				if (this.checkEventListenersForElement(xfr.contentWindow, ["scroll"])) {
					var timer = setTimeout(this.___scrollXULIFrame, this.getIntegerDelay(), xfr, false, 0);
					this.scrollXULIFrameTimers.push([xfr, timer]);
				} else {
					this.postloadXULIFrame(xfr);
				}
			}
		} else {
			this.postloadXULIFrame(xfr);
		}
	},

	___scrollXULIFrame: function(xfr, bool, pos) {
		SpaceNext.scrollXULIFrame(xfr, bool, pos);
	},

	scrollXULIFrame: function(xfr, bool, pos) {
		this.scrollXULIFrameTimers = this.scrollXULIFrameTimers.filter(function(elt){return elt[0].contentWindow != null && elt[0] != this;}, xfr);
		var win = xfr.contentWindow;
		if (pos < win.scrollMaxY) {
			win.scrollTo(0, win.scrollY + win.outerHeight);
			var timer = setTimeout(this.___scrollXULIFrame, this.getIntegerDelay(), xfr, bool, win.scrollY);
			this.scrollXULIFrameTimers.push([xfr, timer]);
		} else {
			if (bool) {
				this.postloadXULIFrame(xfr);
			} else {
				var timer = setTimeout(this.___scrollXULIFrame, this.getIntegerDelay(), xfr, !bool, pos);
				this.scrollXULIFrameTimers.push([xfr, timer]);
			}
		}
	},

	postloadXULIFrame: function(xfr) {
		try {
			xfr["_SpaceNext"].appendBody(xfr["_SpaceNextDocument"], xfr.contentDocument, xfr["_SpaceNextElement"]);
		} catch (e) {
		} finally {
			this.removeNode(xfr);
			try { delete xfr["_SpaceNextDocument"]; } catch (e) {}
			try { delete xfr["_SpaceNextElement"]; } catch (e) {}
			try { delete xfr["_SpaceNext"]; } catch (e) {}
			try { delete xfr; } catch (e) {}
		}
	},

	loadInHiddenXULIFrame: function(doc, html, elt) {
		var chromeWindow = this.getChromeWindow(doc);
		if (chromeWindow) {
			var chromeWindowDocument = chromeWindow.document;
			var xframe = chromeWindowDocument.createElement("iframe");
			xframe.setAttribute("collapsed", true);
			xframe.setAttribute("type", "content");
			chromeWindowDocument.documentElement.appendChild(xframe);

			var webNavigation = xframe.docShell.QueryInterface(Ci.nsIWebNavigation);
			webNavigation.stop(Ci.nsIWebNavigation.STOP_NETWORK);

			xframe.docShell.allowAuth = false;
			xframe.docShell.allowDNSPrefetch = false;
			xframe.docShell.allowImages = false;
			xframe.docShell.allowJavascript = this.getPreferencesBranch().getBoolPref("javascript.enabled");
			xframe.docShell.allowMetaRedirects = this.getPreferencesBranch().getIntPref("network.http.redirection-limit") > 0;
			xframe.docShell.allowPlugins = false;
			xframe.docShell.allowSubframes = this.getPreferencesBranch().getBoolPref("browser.frames.enabled");

			xframe["_SpaceNextDocument"] = doc;
			xframe["_SpaceNextElement"] = elt;
			xframe["_SpaceNext"] = this;

			var scriptableUnicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
			scriptableUnicodeConverter.charset = "UTF-8";
			var newHtml = html.replace(/<img\s([^>]*)onerror(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|([^>\s]+)))?/gi, "<img $1");
			var stream = scriptableUnicodeConverter.convertToInputStream(newHtml);

			var linkUri = this.iOService.newURI(elt.href, null, null);
			var inputStreamChannel = Components.classes["@mozilla.org/network/input-stream-channel;1"].createInstance(Components.interfaces.nsIInputStreamChannel);
			inputStreamChannel.setURI(linkUri);
			inputStreamChannel.contentStream = stream;

			var request = inputStreamChannel.QueryInterface(Components.interfaces.nsIRequest);
			request.loadFlags |= Components.interfaces.nsIRequest.LOAD_BACKGROUND;

			var channel = inputStreamChannel.QueryInterface(Components.interfaces.nsIChannel);
			channel.contentCharset = "UTF-8";
			channel.contentType = "text/html";

			xframe.addEventListener("DOMContentLoaded", this.___preloadXULIFrame, true);
			var uriLoader = Components.classes["@mozilla.org/uriloader;1"].getService(Components.interfaces.nsIURILoader);
			uriLoader.openURI(inputStreamChannel, true, xframe.docShell);
		} else {
			this.displayProgressBarError(doc, this.getGenericNetError());
		}
	},

	getChromeWindow: function(doc) {
		var tabBrowser = this.getTabBrowser(doc);
		return tabBrowser ? tabBrowser.ownerDocument.defaultView : null;
	},

	getTabBrowser: function(doc) {
		var enumerator = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");
		while (enumerator.hasMoreElements()) {
			for (var i = 0, tabs = enumerator.getNext().gBrowser.browsers, tab; tab = tabs[i]; i++) {
				if (tab.contentDocument == doc || tab.contentDocument == doc.defaultView.top.document) {
					return tab;
				}
			}
		}
		return null;
	},

	appendContent: function(doc, elt, url) {
		var request = new XMLHttpRequest();
		request["_SpaceNextDocument"] = doc;
		request["_SpaceNextElement"] = elt;
		request["_SpaceNext"] = this;

		request.onreadystatechange = function(evt) {
			if (this.readyState == 1) {
				this["_SpaceNext"].displayProgressBarContent(this["_SpaceNextDocument"]);
			} else if (this.readyState == 4) {
				try {
					var timers = this["_SpaceNext"].requestTimeoutTimers.filter(function(elt){return elt[0] == this;}, this["_SpaceNextDocument"]);
					var nbrTimers = timers.length;
					for (var i = 0; i < nbrTimers; i++) {
						try { clearTimeout(timers[i][1]); } catch (e) {}
					}
					this["_SpaceNext"].requestTimeoutTimers = this["_SpaceNext"].requestTimeoutTimers.filter(function(elt){return elt[0] != this;}, this["_SpaceNextDocument"]);

					if (this.status == 0 || this.status == 200) {
						var refreshHeader = this.getResponseHeader("refresh");
						if (refreshHeader) {
							try {
								var refreshHeaderUrl = refreshHeader.replace(/^\s*\d+\s*;\s*url\=/i, "");
								if (refreshHeaderUrl) {
									var baseUri = this["_SpaceNext"].iOService.newURI(this["_SpaceNextDocument"].location.href, this["_SpaceNextDocument"].characterSet, null);
									var refreshUri = this["_SpaceNext"].iOService.newURI(refreshHeaderUrl, null, baseUri);
									if (baseUri.spec != refreshUri.spec) {
										return this["_SpaceNext"].appendContent(this["_SpaceNextDocument"], this["_SpaceNextElement"], refreshUri.spec);
									}
								}
							} catch (e) {}
						}
						if (this.responseText != "") {
							if (this.channel instanceof Components.interfaces.nsIChannel) {
								var securityInfo = this.channel.securityInfo;
								if (!(securityInfo instanceof Components.interfaces.nsITransportSecurityInfo) || ((securityInfo.securityState & Components.interfaces.nsIWebProgressListener.STATE_IS_SECURE) == Components.interfaces.nsIWebProgressListener.STATE_IS_SECURE)) {
									if (this["_SpaceNext"].checkSameOriginPolicy(this["_SpaceNextDocument"], this.channel.URI.spec)) {
										return this["_SpaceNext"].loadInHiddenXULIFrame(this["_SpaceNextDocument"], this.responseText, this["_SpaceNextElement"]);
									} else {
										return this["_SpaceNext"].appendFrame(this["_SpaceNextDocument"], this["_SpaceNextElement"], this["_SpaceNextElement"].href);
									}
								}
							}
						}
					}
					this["_SpaceNext"].displayProgressBarError(this["_SpaceNextDocument"], this.statusText);
				} catch (e) {
				} finally {
					try { delete this["_SpaceNextDocument"]; } catch (e) {}
					try { delete this["_SpaceNextElement"]; } catch (e) {}
					try { delete this["_SpaceNext"]; } catch (e) {}
				}
			}
		}

		request.mozBackgroundRequest = true;
		request.open('GET', url, true);
		request.setRequestHeader("Cache-Control", "no-cache");

		var cookieHeader = this.getCookieHeader(doc);
		if (cookieHeader != "") {
			request.setRequestHeader("Cookie", cookieHeader);
		}

		var refererString = this.getRefererString(doc);
		if (refererString != "") {
			request.setRequestHeader("Referer", refererString);
		}

		var contentType = this.getContentType(doc);
		if (contentType != "") {
			request.overrideMimeType(contentType);
		}

		try {
			if (this.getIntegerTimeOut() != 0) {
				var timer = setTimeout(this.___requestTimeout, this.getIntegerTimeOut() * 1000, doc, request);
				this.requestTimeoutTimers.push([doc, timer]);
			}
			request.send(null);
		} catch (e) {
			this.displayProgressBarError(doc, this.getTimeoutNetError());
		}
	},

	___requestTimeout: function(doc, req) {
		if (req) {
			req.abort();
			try { delete req["_SpaceNextDocument"]; } catch (e) {}
			try { delete req["_SpaceNextElement"]; } catch (e) {}
			try { delete req["_SpaceNext"]; } catch (e) {}
		}
		SpaceNext.requestTimeout(doc);
	},

	requestTimeout: function(doc) {
		this.requestTimeoutTimers = this.requestTimeoutTimers.filter(function(elt){return elt[0] != this;}, doc);
		this.displayProgressBarError(doc, this.getTimeoutNetError());
	},

	getContentNode: function(doc) {
		return doc.querySelector("*:not(iframe)[space-next-content=true]");
	},

	getFirstSeparator: function(doc) {
		var separators = doc.querySelectorAll("div[space-next-separator=true]");
		return separators.length == 0 ? null : separators[0];
	},

	getLastSeparator: function(doc) {
		var separators = doc.querySelectorAll("div[space-next-separator=true]");
		var nbrSeparators = separators.length;
		return nbrSeparators == 0 ? null : separators[nbrSeparators - 1];
	},

	createSeparator: function(doc) {
		var separator = doc.createElement(this.DIV_SELECTOR);
		separator.setAttribute("space-next-separator", "true");
		return separator;
	},

	testSpecialMetas: function(doc) {
		return doc.querySelector(this.HEAD_SELECTOR + " " + this.META_SELECTOR + this.SPECIAL_METAS_SELECTOR);
	},

	testSpecialWrappers: function(doc) {
		return doc.querySelector(this.SPECIAL_WRAPPERS_SELECTOR);
	},

	createContentNode: function(doc, elt) {
		var contentNode = null;

		if (!this.getBooleanAppendContentOnly() || this.testSpecialMetas(doc) || this.testSpecialWrappers(doc)) {
			contentNode = doc.body;
		} else {
			var tabNodes = [elt], parent;
			while (parent = this.getLargerParentNode(tabNodes[tabNodes.length - 1])) {
				while (!(parent.nodeName.toLowerCase() in this.AUTHORIZED_CONTAINERS)) {
					parent = parent.parentNode;
				}
				tabNodes.push(parent);
			}

			var height = tabNodes[0].offsetHeight;
			for (var i = 1, node; node = tabNodes[i]; i++) {
				if (node.offsetHeight != 0) {
					height = node.offsetHeight;
				}
				if (height * node.offsetWidth > this.AREA) {
					contentNode = node;
					break;
				}
			}
			if (!contentNode) {
				var node = tabNodes[tabNodes.length - 1];
				while (this.testBodyInnerElement(node)) {
					node = node.parentNode;
					if (node.nodeName.toLowerCase() in this.AUTHORIZED_CONTAINERS) {
						if (node.offsetHeight != 0) {
							height = node.offsetHeight;
						}
						if (height * node.offsetWidth > this.AREA) {
							contentNode = node;
							break;
						}
					}
				}
				if (!contentNode) {
					contentNode = doc.body;
				}
			}
		}

		var result = this.testBodyInnerElement(contentNode) ? this.getAdjustedNode(contentNode, elt) : contentNode;
		while (this.testBodyInnerElement(result) && result != contentNode) {
			contentNode = result;
			result = this.getAdjustedNode(contentNode, elt);
		}

		var computedStyle = doc.defaultView.getComputedStyle(result, null);
		if (parseInt(computedStyle.getPropertyValue("padding-bottom"), 10) != 0) {
			result = doc.body;
		}
		return result;
	},

	getAdjustedNode: function(cont, elt) {
		var contentNode = cont;
		var win = contentNode.ownerDocument.defaultView;
		var domWindowUtils = win.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMWindowUtils);
		var rectContentNode = contentNode.getBoundingClientRect();
		var rectElement = elt.getBoundingClientRect();
		var area = rectContentNode.width * rectContentNode.height;
		if (area != 0) {
			var distance = (area - (this.AREA)) / rectContentNode.width;
			var elementFromPoint = domWindowUtils.elementFromPoint(Math.ceil(rectContentNode.left), Math.ceil(rectContentNode.top) + distance, true, false);
			if (elementFromPoint && !(contentNode == elementFromPoint || contentNode.compareDocumentPosition(elementFromPoint) & Node.DOCUMENT_POSITION_CONTAINED_BY)) {
				contentNode = contentNode.parentNode;
				rectContentNode = contentNode.getBoundingClientRect();
			}

			if (rectElement.bottom > rectContentNode.bottom) {
				contentNode = contentNode.parentNode;
			}
		}

		var parent = contentNode.parentNode;
		if (this.testBodyInnerElement(parent)) {
			for (var i = 0, children = parent.children, child; child = children[i]; i++) {
				if (child != contentNode) {
					var computedStyle = win.getComputedStyle(child, null);
					if (computedStyle.getPropertyValue("float") != "none") {
						contentNode = parent;
						break;
					}
				} else {
					break;
				}
			}
		}

		return contentNode;
	},

	getLargerParentNode: function(elt) {
		var node = elt;
		while (this.testBodyOrDescendantElement(node.parentNode) && (this.getDisplayedArea(node.parentNode) / this.getDisplayedArea(node)) <= 2) {
			node = node.parentNode;
		}
		return this.testBodyOrDescendantElement(node.parentNode) ? node.parentNode : null;
	},

	getDisplayedArea: function(elt) {
		return elt.offsetWidth * elt.offsetHeight;
	},

	___hashChangedWindowWithContent: function(e) {
		if (!e.newURL || e.oldURL || e.newURL.search(new RegExp ("^" + e.oldURL + "#")) == -1) {
			SpaceNext.hashChangedWindowWithContent(this);
		}
	},

	hashChangedWindowWithContent: function(win) {
		var doc = win.document;

		var separator = this.getFirstSeparator(doc);
		if (separator) {
			var range = doc.createRange();
			range.setStartBefore(separator);
			range.setEndAfter(separator.parentNode.lastChild);
			range.deleteContents();
			range.detach();
		}

		var contentNode = this.getContentNode(doc);
		if (contentNode) {
			contentNode.removeAttribute("space-next-content");
			contentNode.removeAttribute("space-next-previous");
			contentNode.removeAttribute("space-next-referer");
		}
	},

	___pageHiddenWindowWithContent: function(e) {
		SpaceNext.pageHiddenWindowWithContent(this);
	},

	pageHiddenWindowWithContent: function(win) {
		if (!this.getBooleanConserveOnUnload() || win.frameElement) {
			win.removeEventListener("pagehide", this.___pageHiddenWindowWithContent, false);
			win.removeEventListener("hashchange", this.___hashChangedWindowWithContent, false);
			this.hashChangedWindowWithContent(win);
			this.resizeFrameElement(win.document, false);
		}
	},

	getLevelFromBody: function(elt) {
		return this.testBodyInnerElement(elt) ? 1 + this.getLevelFromBody(elt.parentNode) : 0;
	},

	getAdjustedContentNode: function(cont1, cont2) {
		for (var i = 0, levelDifference = this.getLevelFromBody(cont1) - this.getLevelFromBody(cont2); i < levelDifference; i++) {
			cont1 = cont1.parentNode;
		}
		return cont1;
	},

	appendBody: function(doc1, doc2, elt) {
		try {
			var win1 = doc1.defaultView;
			var win2 = doc2.defaultView;
			if (win1 && win1.document == doc1 && win2.document == doc2 && doc2.readyState in this.READYSTATES) {
				var head = doc2.querySelector(this.HEAD_SELECTOR);
				var body = doc2.body;
				var contentNode = this.getContentNode(doc1);
				var previousReferer = "";
				if (!contentNode) {
					contentNode = this.createContentNode(doc1, elt);
					win1.addEventListener("pagehide", this.___pageHiddenWindowWithContent, false);
					win1.addEventListener("hashchange", this.___hashChangedWindowWithContent, false);
				} else {
					previousReferer = contentNode.getAttribute("space-next-referer");
					contentNode.removeAttribute("space-next-content");
					contentNode.removeAttribute("space-next-previous");
					contentNode.removeAttribute("space-next-referer");
				}

				var newContentNode = this.getNewContentNode(contentNode, body);
				contentNode = this.getAdjustedContentNode(contentNode, newContentNode);

				contentNode.setAttribute("space-next-content", "true");
				contentNode.setAttribute("space-next-previous", previousReferer);
				contentNode.setAttribute("space-next-referer", elt.href);

				var br = contentNode.insertBefore(doc1.createElement(this.BR_SELECTOR), null);
				br.style.clear = "both";
				br.style.width = "100%";

				var separator = this.createSeparator(doc1);
				contentNode.insertBefore(separator, null);

				contentNode.insertBefore(doc1.createComment(" Space Next BEGIN: " + elt.href.replace("-", "%2D", "g") + " "), null);
				var fragment = doc1.createDocumentFragment();
				var childNodes = newContentNode.childNodes;
				for (var i = 0, childNode; childNode = childNodes[i]; i++) {
					fragment.insertBefore(doc1.importNode(childNode, true), null);
				}
				contentNode.insertBefore(fragment, null);
				contentNode.insertBefore(doc1.createComment(" Space Next END: " + elt.href.replace("-", "%2D", "g") + " "), null);

				this.loadBackgroundImages(doc1, contentNode, separator);
				this.appendScripts(doc1, head);
				this.appendStyles(doc1, head);
				this.adjustCSSPosition(doc1, contentNode, elt);
				this.resizeFrameElement(doc1, true);
				this.scrollIntoView(doc1, separator);
			}
		} catch (e) {
		} finally {
			this.hideProgressBar(doc1);
		}
	},

	loadBackgroundImages: function(doc, cont, sep) {
		if (this.getPreferencesBranch().getIntPref("permissions.default.image") != 2) {
			var xpathResultNodesWithBackground = doc.evaluate(".//*[contains(@style,'background')]", cont, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
			for (var i = xpathResultNodesWithBackground.snapshotLength - 1, nodeWithBackground; nodeWithBackground = xpathResultNodesWithBackground.snapshotItem(i); i--) {
				if (nodeWithBackground.compareDocumentPosition(sep) & Node.DOCUMENT_POSITION_PRECEDING) {
					if (nodeWithBackground.style.backgroundImage) {
						nodeWithBackground.style.backgroundImage = nodeWithBackground.style.backgroundImage;
					}
				} else {
					break;
				}
			}
			var xpathResultImagesWithDataOriginal = doc.evaluate(".//img[@data-original or @original]", cont, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
			var docUri = this.iOService.newURI(doc.location.href, doc.characterSet, null);
			for (var i = 0, imageWithDataOriginal; imageWithDataOriginal = xpathResultImagesWithDataOriginal.snapshotItem(i); i++) {
				var dataOriginal = imageWithDataOriginal.getAttribute("data-original") || imageWithDataOriginal.getAttribute("original");
				try {
					if (imageWithDataOriginal.src != dataOriginal) {
						var dataOriginalUri = this.iOService.newURI(dataOriginal, null, docUri);
						if (this.checkValidProtocol(docUri.scheme)) {
							imageWithDataOriginal.src = dataOriginal;
						}
					}
				} catch (e) {}
			}
		}
	},

	appendScripts: function(doc, head) {
		if (this.getPreferencesBranch().getBoolPref("javascript.enabled")) {
			var fragment = doc.createDocumentFragment();
			for (var i = 0, scripts = head.querySelectorAll(this.SCRIPT_SELECTOR), script; script = scripts[i]; i++) {
				if (this.testGecko2Plus() || !script.src) {
					fragment.insertBefore(doc.importNode(script, true), null);
				}
			}
			doc.querySelector(this.HEAD_SELECTOR).insertBefore(fragment, null);
		}
	},

	appendStyles: function(doc, head) {
		return "for the time being";
		var currentStylesHref = [];
		for (var i = 0, currentStyles = doc.querySelector(this.HEAD_SELECTOR).querySelectorAll(this.LINK_SELECTOR + "[href$=css]"), currentStyle; currentStyle = currentStyles[i]; i++) {
			currentStylesHref[currentStyle.href] = true;
		}

		var fragment = doc.createDocumentFragment();
		for (var i = 0, styles = head.querySelectorAll(this.LINK_SELECTOR + "[href$=css]"), style; style = styles[i]; i++) {
			if (!currentStylesHref[style.href]) {
				fragment.insertBefore(doc.importNode(style, true), null);
			}
		}
		doc.querySelector(this.HEAD_SELECTOR).insertBefore(fragment, null);
	},

	adjustCSSPosition: function(doc, cont, elt) {
		var positionalNodes = [];
		for (var i = 0, xpathResult = doc.evaluate(".//*[contains(@style,'position')]", cont, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), node; node = xpathResult.snapshotItem(i); i++) {
			if ((node.compareDocumentPosition(elt) & Node.DOCUMENT_POSITION_CONTAINED_BY) && node.style.position in this.POSITIONS) {
				positionalNodes.push(node);
			}
		}

		var selectors = [];
		for (var i = 0, styleSheets = doc.styleSheets, styleSheet; styleSheet = styleSheets[i]; i++) {
			for (var j = 0, cssRules = styleSheet.cssRules, cssRule; cssRule = cssRules[j]; j++) {
				if (cssRule instanceof CSSStyleRule && cssRule.style.position in this.POSITIONS) {
					selectors.push(cssRule.selectorText);
				}
			}
		}

		if (selectors.length > 0) {
			for (var i = 0, nodes = doc.querySelectorAll(selectors.join(", ")), node; node = nodes[i]; i++) {
				if ((cont.compareDocumentPosition(node) & Node.DOCUMENT_POSITION_CONTAINED_BY) && (node.compareDocumentPosition(elt) & Node.DOCUMENT_POSITION_CONTAINED_BY)) {
					positionalNodes.push(node);
				}
			}
		}

		positionalNodes = positionalNodes.filter(function(elt, idx, arr){return arr.indexOf(elt) >= idx;});
		for (var i = 0, node; node = positionalNodes[i]; i++) {
			node.style.position = "relative";
		}
	},

	getChildNodePosition: function(elt, xp) {
		try {
			for (var i = 0, xpathResult = elt.ownerDocument.evaluate(xp, elt.parentNode, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null), child; child = xpathResult.snapshotItem(i); i++) {
				if (child == elt) {
					return i + 1;
				}
			}
		} catch (e) {
			return 1;
		}
	},

	getNumberOfChildren: function(elt, name) {
		try {
			var xpathResult = elt.ownerDocument.evaluate(name, elt, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
			return xpathResult.snapshotLength;
		} catch (e) {
			return 0;
		}
	},

	getNewContentNode: function(cont, body) {
		var selectors = this.getSelectors(cont);
		var node = null;
		if (selectors) {
			var childNode = body.parentNode, parentNode, selector;
			while (parentNode != childNode && selectors.length != 0) {
				selector = selectors.shift();
				parentNode = childNode;
				childNode = this.getCorrespondingNode(parentNode, selector[0], selector[1], selector[2], selector[3], selector[4], selector[5]);
			}
			node = childNode;
		}

		var result = node ? (this.testBodyInnerElement(node) ? node : body) : body;
		while (!(result.nodeName.toLowerCase() in this.AUTHORIZED_CONTAINERS)) {
			result = result.parentNode;
		}
		return result;
	},

	getSelectors: function(elt) {
		var selector = null;
		if (this.testBodyOrDescendantElement(elt)) {
			var currentSelector = [[elt.nodeName.toLowerCase(), elt.getAttribute("id") ? elt.getAttribute("id") : "", elt.className, this.getNumberOfChildren(elt.parentNode, elt.nodeName.toLowerCase()), this.getChildNodePosition(elt, elt.nodeName.toLowerCase()), elt.className == "" ? 0 : this.getChildNodePosition(elt, elt.nodeName.toLowerCase() + "[@class='" + elt.className + "']"), this.getDisplayedArea(elt)]];
			var parentSelector = this.getSelectors(elt.parentNode);
			if (parentSelector == null) {
				selector = currentSelector;
			} else {
				parentSelector.push(currentSelector[0]);
				selector = parentSelector;
			}
		}
		return selector;
	},

	getCorrespondingNode: function(elt, name, id, cls, num, pos1, pos2) {
		var node = null, xpath = null;
		if (name == "BODY") {
			xpath = name;
		} else if (id != "") {
			xpath = name + "[@id='" + id + "']";
		} else {
			if (this.getNumberOfChildren(elt, name) == num) {
				xpath = name + "[" + pos1 + "]";
			} else if (cls != "") {
				xpath = name + "[@class='" + cls + "'][" + pos2 + "]";
			}
		}
		try {
			var node = xpath ? elt.ownerDocument.evaluate(xpath, elt, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue : null;
			if (node && (node.id == "" || id != "") && (node.className == "" || cls != "")) {
				return node;
			}
		} catch (e) {}
		return elt;
	},

	resizeFrameElement: function(doc, bool) {
		var win = doc.defaultView;
		if (win.frameElement) {
			if (bool) {
				var height = doc.body.scrollHeight;
				for (var i = 0, children = doc.body.children, child; child = children[i]; i++) {
					var computedStyle = win.getComputedStyle(child, null);
					if (computedStyle.getPropertyValue("float") != "none") {
						height = Math.max(height, child.scrollHeight);
					}
				}
				win.frameElement.style.height = height + "px";
			} else {
				win.frameElement.style.height = doc.body.offsetHeight + "px";
			}
		}
	},

	displayProgressBarContent: function(doc) {
		var progressBar = this.getProgressBarFrame(doc);
		progressBar.style.backgroundImage = "url('chrome://spacenextimages/content/progressBarContent.png')";
	},

	displayProgressBarFrame: function(doc) {
		var progressBar = this.getProgressBarFrame(doc);
		progressBar.style.backgroundImage = "url('chrome://spacenextimages/content/progressBarFrame.png')";
	},

	getProgressBarFrame: function(doc) {
		var progressBar = doc.documentElement.querySelector("div[id='space-next-progress-bar']") || this.createProgressBar(doc);
		return progressBar;
	},

	createProgressBar: function(doc) {
		var progressBar = doc.documentElement.lastElementChild.insertBefore(doc.createElement(this.DIV_SELECTOR), null);
		with (progressBar.style) {
			background = "no-repeat scroll center center transparent";
			bottom = "50px";
			clear = "both";
			color = "#FFFFFF";
			font = "bold 12px Arial";
			height = "50px";
			left = "0px";
			lineHeight = "50px";
			position = "fixed";
			textAlign = "center";
			textShadow = "-1px 0 2px #000000, 0 1px 2px #000000, 1px 0 2px #000000, 0 -1px 2px #000000, -2px 0 10px #FF0000, 0 2px 10px #FF0000, 2px 0 10px #FF0000, 0 -2px 10px #FF0000";
			width = "100%";
			zIndex = Math.pow(2, 31) - 1;
		}
		progressBar.setAttribute("id", "space-next-progress-bar");
		return progressBar;
	},

	displayProgressBarError: function(doc, txt) {
		var progressBar = this.getProgressBarFrame(doc);
		progressBar.style.backgroundImage = "url('chrome://spacenextimages/content/progressBarError.png')";

		while (progressBar.firstChild) {
			this.removeNode(progressBar.firstChild);
		}
		progressBar.insertBefore(doc.createTextNode(txt ? txt : this.getGenericNetError()), null);

		var timer = setTimeout(this.___hideProgressBar, 3000, doc);
		this.progressBarTimers.push([doc, timer]);
	},

	___hideProgressBar: function(doc) {
		SpaceNext.hideProgressBar(doc);
	},

	hideProgressBar: function(doc) {
		this.progressBarTimers = this.progressBarTimers.filter(function(elt){return elt[0] != this;}, doc);
		var progressBar = doc.documentElement.querySelector("div[id='space-next-progress-bar']");
		if (progressBar) {
			this.removeNode(progressBar);
		}
		this.removeFromCurrentDocs(doc);
	},

	getCookieHeader: function(doc) {
		var cookies = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager2).getCookiesFromHost(doc.location.hostname);
		var tabCookies = [];
		while (cookies.hasMoreElements()) {
			var cookie = cookies.getNext();
			tabCookies.push(cookie.QueryInterface(Ci.nsICookie2).name + "=" + cookie.QueryInterface(Ci.nsICookie2).value);
		}
		return tabCookies.join("; ");
	},

	getRefererString: function(doc) {
		var referer = "";
		if (this.getReferer() > 0) {
			var div = this.getContentNode(doc);
			referer = div ? div.getAttribute("space-next-referer") : doc.location.href;
		}
		return referer;
	},

	getContentType: function(doc) {
		return doc.contentType + "; charset=" + doc.characterSet;
	},

	getPreferencesBranch: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	},

	getReferer: function() {
		return this.getPreferencesBranch().getIntPref("network.http.sendRefererHeader");
	},

	getIntegerAppend: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND));
	},

	getBooleanAppendContentOnly: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND_CONTENT_ONLY) == pb.PREF_BOOL && pb.getBoolPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND_CONTENT_ONLY));
	},

	getBooleanConserveOnUnload: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_CONSERVE_ON_UNLOAD) == pb.PREF_BOOL && pb.getBoolPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_CONSERVE_ON_UNLOAD));
	},

	getIntegerDelay: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DELAY) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DELAY));
	},

	getIntegerDebug: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DEBUG) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DEBUG));
	},

	getBooleanEnable: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_ENABLE) == pb.PREF_BOOL && pb.getBoolPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_ENABLE));
	},

	getStringKey: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_KEY) == pb.PREF_STRING && pb.getCharPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_KEY));
	},

	getIntegerMaximumAppendedPages: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_APPENDED_PAGES) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_APPENDED_PAGES));
	},

	getIntegerMaximumRetries: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_RETRIES) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_RETRIES));
	},

	getStringModifiers: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MODIFIERS) == pb.PREF_STRING && pb.getCharPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MODIFIERS));
	},

	getBooleanShowInStatusBar: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR) == pb.PREF_BOOL && pb.getBoolPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR));
	},

	getIntegerTimeOut: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_TIMEOUT) == pb.PREF_INT && pb.getIntPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_TIMEOUT));
	},

	getBooleanWarp: function() {
		var pb = this.getPreferencesBranch();
		return (pb.getPrefType(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_WARP) == pb.PREF_BOOL && pb.getBoolPref(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_WARP));
	},

	getDefaultStringModifiers: function() {
		return this.getPreferencesBranch().getDefaultBranch(this.STRING_PREFERENCE_ADDON).getCharPref(this.STRING_PREFERENCE_ADDON_MODIFIERS);
	},

	getDefaultStringKey: function() {
		return this.getPreferencesBranch().getDefaultBranch(this.STRING_PREFERENCE_ADDON).getCharPref(this.STRING_PREFERENCE_ADDON_KEY);
	},

	unsetShortcut: function() {
		var content = window.document.getElementById("content");
		if (content) {
			content.removeEventListener("keypress", this._keypress, false);
			content.removeEventListener("keypress", this._keypressWithCapture, true);
		}

		var mainwindow = document.getElementById("main-window");
		if (mainwindow) {
			var keyset = document.getElementById("space-next-keyset");
			if (keyset != null) {
				mainwindow.removeChild(keyset);
			}
		}
	},

	setShortcut: function() {
		this.unsetShortcut();

		var mainwindow = document.getElementById("main-window");
		if (mainwindow) {
			var key = this.getStringKey();
			var modifiers = this.getStringModifiers();

			if (modifiers.match(/^(shift|alt|meta|control|accel|access|any)(( |,)(shift|alt|meta|control|accel|access|any))*$/) && (key.length == 1 || this.KEYCODE_REGEXP.test(key))) {
				var newKey = document.createElement("key");
					newKey.setAttribute("id", "space-next-key");
				var newKeyset = document.createElement("keyset");
					newKeyset.setAttribute("id", "space-next-keyset");

				if (key.length == 1) {
					newKey.setAttribute("key", key);
				} else if (this.KEYCODE_REGEXP.test(key)) {
					newKey.setAttribute("keycode", key);
				}

				newKey.setAttribute("modifiers", modifiers);
				newKey.setAttribute("oncommand", "SpaceNext.___goToNextPage(event.view.content.document, true);");

				newKeyset.appendChild(newKey);
				mainwindow.appendChild(newKeyset);
			} else if (modifiers == "" && key == "VK_SPACE") {
				var content = window.document.getElementById("content");
				if (content) {
					content.addEventListener("keypress", this._keypressWithCapture, true);
					content.addEventListener("keypress", this._keypress, false);
				}
			}
		}
	},

	enable: function() {
		if (this.getBooleanEnable()) {
			this.setPointers();
			this.setShortcut();
			this.addListeners();
		} else {
			this.unsetPointers();
			this.unsetShortcut();
			this.removeListeners();
		}
	},

	showInStatusBar: function() {
		var panel = document.getElementById("sn-statusbarpanel");
		if (panel) {
			panel.hidden = !this.getBooleanShowInStatusBar();
		}
	},

	hideInStatusBar: function() {
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR);
	},

	clearUserPreference: function(pref) {
		var pb = this.getPreferencesBranch();
		if (pb.prefHasUserValue(pref)) {
			pb.clearUserPref(pref);
		}
	},

	clearUserPreferences: function() {
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND_CONTENT_ONLY);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_CONSERVE_ON_UNLOAD);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DEBUG);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DELAY);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_ENABLE);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_KEY);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_APPENDED_PAGES);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_RETRIES);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MODIFIERS);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_TIMEOUT);
		this.clearUserPreference(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_WARP);
	},

	getExtensionManagerWindow: function() {
		return (this.testGecko2Plus()) ? window : Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getMostRecentWindow("Extension:Manager");
	},

	testPreferencesHaveUserValue: function() {
		return (this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_APPEND_CONTENT_ONLY) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_CONSERVE_ON_UNLOAD) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DEBUG) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_DELAY) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_ENABLE) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_KEY) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_APPENDED_PAGES) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MAXIMUM_RETRIES) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_MODIFIERS) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_TIMEOUT) || this.getPreferencesBranch().prefHasUserValue(this.STRING_PREFERENCE_ADDON + this.STRING_PREFERENCE_ADDON_WARP));
	},

	uninstall: function() {
		if (this.testPreferencesHaveUserValue()){
			var params = {in: null, out: null};
			var win = this.getExtensionManagerWindow();

			if (win!=null && (win == window || win.opener == window)) {
				win.openDialog("chrome://spacenext/content/uninstall.xul", "", "chrome=yes,centerscreen,modal=yes", params);

				if (params.out) {
					this.clearUserPreferences();
				}
			}
		}
	},

	checkJavaScriptForElement: function(elt) {
		return this.checkMouseEventsForElement(elt) || this.checkJQueryMouseEventsForElement(elt) || this.checkMouseEventsForElement(elt.parentNode) || this.checkJQueryMouseEventsForElement(elt.parentNode);
	},

	checkMouseEventsForElement: function(elt) {
		return this.checkEventsForElement(elt, ["click", "mousedown", "mouseup"]);
	},

	checkEventListenersForElement: function(elt, evts) {
		var eventListenerInfos = this.eventListenerService.getListenerInfoFor(elt, {});
		for (var j = 0, eventListenerInfo; eventListenerInfo = eventListenerInfos[j]; j++) {
			if (evts.some(this._testArrayContainsElement, eventListenerInfo.type)) {
				return true;
			}
		}
		return false;
	},

	checkEventsForElement: function(elt, evts) {
		if (evts.some(function (evt) {return ((evt != "click" && this[evt] != null) || (this.getAttribute && this.getAttribute("on" + evt) != null));}, elt)) {
			return true;
		}
		return this.checkEventListenersForElement(elt, evts);
	},

	getJQuery: function(doc) {
		var nativeWrapperWin = new XPCNativeWrapper(doc.defaultView);
		var nativeWrapperDoc = new XPCNativeWrapper(doc);
		var wrappedJSObjectWin = (typeof XPCSafeJSObjectWrapper == "function") ? new XPCSafeJSObjectWrapper(nativeWrapperWin.wrappedJSObject) : nativeWrapperWin.wrappedJSObject;
		var wrappedJSObjectDoc = (typeof XPCSafeJSObjectWrapper == "function") ? new XPCSafeJSObjectWrapper(nativeWrapperDoc.wrappedJSObject) : nativeWrapperDoc.wrappedJSObject;
		var jQuery = wrappedJSObjectWin.jQuery;
		return (jQuery !== null && typeof jQuery == "function") ? [jQuery, wrappedJSObjectWin, wrappedJSObjectDoc] : [null, null, null];
	},

	checkJQueryMouseEventsForElement: function(elt) {
		return this.checkJQueryEventsForElement(elt, ["click", "mousedown", "mouseup"]);
	},

	checkJQueryEventsForElement: function(elt, evts) {
		try {
			var [jQuery, wrappedJSObjectWin, wrappedJSObjectDoc] = this.getJQuery(elt.ownerDocument);
			if (jQuery !== null && jQuery.data !== null && typeof jQuery.data == "function") {
				var sandbox = new Components.utils.Sandbox(wrappedJSObjectWin);
				sandbox.window = wrappedJSObjectWin;
				sandbox.document = wrappedJSObjectDoc;
				var jQueryEvents = Components.utils.evalInSandbox("window.jQuery.data(document, 'events')", sandbox);
				if (jQueryEvents !== null && typeof jQueryEvents == "object") {
					for (var i = 0, event; event = evts[i]; i++) {
						var mouseEvents = jQueryEvents[event];
						if (mouseEvents !== null && typeof mouseEvents == "object") {
							for (var j = 0, mouseEvent; mouseEvent = mouseEvents[j]; j++) {
								if (mouseEvent.selector !== null && typeof mouseEvent.selector == "string" && elt.mozMatchesSelector(mouseEvent.selector)) {
									return true;
								}
							}
						}
					}
				}
			}
		} catch (e) {}
		return false;
	},

	_testArrayContainsElement: function(elt) {
		return (elt == this);
	},

	testGecko2Plus: function() {
		function geckoGetRv() {
			if (navigator.product != 'Gecko') {
				return -1;
			}
			var rvValue = 0;
			var ua      = navigator.userAgent.toLowerCase();
			var rvStart = ua.indexOf('rv:');
			var rvEnd   = ua.indexOf(')', rvStart);
			var rv      = ua.substring(rvStart+3, rvEnd);
			var rvParts = rv.split('.');
			var exp     = 1;

			for (var i = 0; i < rvParts.length; i++) {
				var val = parseInt(rvParts[i]);
				rvValue += val / exp;
				exp *= 100;
			}
			return rvValue;
		}

		if (this.isGecko2Plus == null) {
			this.isGecko2Plus = geckoGetRv() >= 2;
		}
		return this.isGecko2Plus;
	},

	preferenceChanged: function(brch, nme) {
		switch (brch) {
			case this.STRING_PREFERENCE_ADDON:
				switch (nme) {
					case this.STRING_PREFERENCE_ADDON_ENABLE: 
						this.enable();
						break;
					case this.STRING_PREFERENCE_ADDON_KEY:
					case this.STRING_PREFERENCE_ADDON_MODIFIERS:
						this.setShortcut();
						break;
					case this.STRING_PREFERENCE_ADDON_SHOW_IN_STATUS_BAR:
						this.showInStatusBar();
						break;
				}
				break;
		}
	},

	getId: function() {
		return this.ID;
	},

	getPreferences: function() {
		return this.STRING_PREFERENCES;
	},
}

var SpaceNextListeners = {
	mainAddon: null,
	preferencesListeners: [],
	uninstallListener: null,
	uninstallObserver: null,

	initPreferencesListeners: function() {
		function PreferencesListener(addon, branchName, func) {
			var branch = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch(branchName);
			branch.QueryInterface(Components.interfaces.nsIPrefBranch2);

			this.register = function() {
				branch.addObserver("", this, false);
			};

			this.unregister = function unregister() {
				if (branch) {
					branch.removeObserver("", this);
				}
			};

			this.observe = function(subject, topic, data) {
				if (topic == "nsPref:changed") {
					func.call(addon, branchName, data);
				}
			};
		}

		for (var i in this.mainAddon.getPreferences()) {
			var preferencesListener = new PreferencesListener(this.mainAddon, this.mainAddon[i], this.mainAddon.preferenceChanged);
			preferencesListener.register();
			this.preferencesListeners.push(preferencesListener);
		}
	},

	initUninstallListenerOrObserver: function() {
		if (this.mainAddon.testGecko2Plus()) {
			this.uninstallListener = {
				mainAddon: this.mainAddon,

				onUninstalling: function(addon) {
					if (addon.id == this.mainAddon.getId()) {
						this.mainAddon.uninstall();
					}
				},
			}

			try {
				Components.utils.import("resource://gre/modules/AddonManager.jsm");
				AddonManager.addAddonListener(this.uninstallListener);
			} catch (ex) {}
		} else {
			function UninstallObserver(addon) {
				this.mainAddon = addon;

				this.register = function() {
					Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService).addObserver(this, "em-action-requested", false);
				};

				this.unregister = function() {
					Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService).removeObserver(this, "em-action-requested");
				};

				this.observe = function(subject, topic, data) {
					if (subject.QueryInterface(Components.interfaces.nsIUpdateItem).id == this.mainAddon.getId()) {
						if (data == "item-uninstalled") {
							this.mainAddon.uninstall();
						}
					}
				};
			}

			this.uninstallObserver = new UninstallObserver(this.mainAddon);
			this.uninstallObserver.register();
		}
	},

	init: function(addon) {
		this.mainAddon = addon;
		this.initPreferencesListeners();
		this.initUninstallListenerOrObserver();
	},
}

SpaceNextListeners.init(SpaceNext);