/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2009-2012 Michael Koch
*/

var ViewMarksAdvice = {

	POPUP_WIDTH: 288,

	getScreenPosition: function(node) 
	{
		if (node.boxObject) {
			if (node.boxObject.screenX && node.boxObject.screenY) {
				return {x:node.boxObject.screenX,y:node.boxObject.screenY,w:node.boxObject.width,h:node.boxObject.height};
			}
		}

		var pos = {x:0,y:0};
		while (node.offsetParent) {
			pos.x += node.offsetLeft;
			pos.y += node.offsetTop;
			node = node.offsetParent;
		}
		return pos;
	},

	open: function(title, msg, id)
	{
		var node = document.getElementById("vmks_button");
		var pos = this.getScreenPosition(node);

		var popup = document.getElementById("vmks_advice_popup");
		popup.style.width = this.POPUP_WIDTH + "px";
		
		var ntitle = document.getElementById("vmks_advice_title");
		var nmsg = document.getElementById("vmks_advice_text");

		ntitle.setAttribute("value", title);
		nmsg.setAttribute("value", msg);

		popup.openPopupAtScreen(pos.x - this.POPUP_WIDTH + 5, pos.y+pos.h - 5, false);
	},


};

