/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/

Components.utils.import("resource://viewmarks/global.jsm"); 
Components.utils.import("resource://gre/modules/ctypes.jsm");
Components.utils.import("resource://gre/modules/AddonManager.jsm");


var ViewMarksBitmap = {

	appInfo: Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo),
	platform: Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULRuntime).OS,

  scaleDown: function (image, dw, dh) 
  {
    var { width: sw, height: sh, data } = image;
    var stepx = dw / sw;
    var stepy = dh / sh;
    var start, sindex, dindex, count, delta;

    var dw4 = 4*dw;
    var sw4 = 4*sw;

    var sum = Uint32Array(dw4);

    for (var y=0, start=0; y<sh; y++, start+=sw4) {
      sum[0] = sum[1] = sum[2] = 0;
      count = 0;
      delta = 0.0;
      for (var x=0, dindex=start, sindex=start; x<sw; x++, sindex+=4) {
        sum[0] += data[sindex];
        sum[1] += data[sindex+1];
        sum[2] += data[sindex+2];
        count++;
        delta += stepx;
        if (delta >= 1.0 || x == sw-1) {
          var fac = 1/count;
          data[dindex] = sum[0] * fac;
          data[dindex+1] = sum[1] * fac;
          data[dindex+2] = sum[2] * fac;
          sum[0] = sum[1] = sum[2] = 0;
          count = 0;
          delta -= 1.0;
          dindex += 4;
        }
      }
    }

    for (var x=0; x<dw4; x++) sum[x] = 0;
    dindex = 0;
    sindex = 0;
    count = 0;
    delta = 0.0;
    for (var y=0; y<sh; y++, sindex+=sw4) {
      for (var x=0; x<dw4; x+=4) {
        sum[x] += data[sindex+x];
        sum[x+1] += data[sindex+x+1];
        sum[x+2] += data[sindex+x+2];
      }
      count++;
      delta += stepy;
      if (delta >= 1.0 || y == sh-1) {
        var fac = 1/count;
        for (var x=0; x<dw4; x+=4) {
          data[dindex+x] = sum[x] * fac;
          data[dindex+x+1] = sum[x+1] * fac;
          data[dindex+x+2] = sum[x+2] * fac;
          sum[x] = sum[x+1] = sum[x+2] = 0;
        }
        count = 0;
        delta -= 1.0;
        dindex += sw4;               
      }
    }
  }, 



	createThumbnail: function(dstCanvas, dx, dy, dw, dh, srcCanvas, sx, sy, sw, sh)
	{
		if (sw == 0 || sh == 0 || dw == 0 || dh == 0) return;
		if (sw < dw || sh < dh) return;
		if (srcCanvas.width < sx + sw || srcCanvas.height < sy + sh) return;

		var elapsed = window.performance.now();

		let tmpCanvas = null;
		let tmpContext = null;
		let image = null;
		
		if (sx != 0 || sy != 0 || dx != 0 || dy != 0) {
			tmpCanvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");
			tmpCanvas.width = sw;
			tmpCanvas.height = sh;
		  tmpContext = tmpCanvas.getContext("2d");
		}

		try {
			if (sx == 0 && sy == 0) {
				image = srcCanvas.getContext("2d").getImageData(0, 0, sw, sh);
			} else {
				tmpContext.drawImage(srcCanvas, sx, sy, sw, sh, 0, 0, sw, sh);
				image = tmpContext.getImageData(0, 0, sw, sh);
			}
		} catch(e) {
			ViewMarksUtil.alert(e+"\n sx="+sx+" sy="+sy+" sw="+sw+" sh="+sh);
			return;
		}

		if (ViewMarksGlobal.resizeBitmapData) {
			try {
				ViewMarksGlobal.resizeBitmapData(
					image.data,
					ctypes.int32_t(dw),
					ctypes.int32_t(dh),
					ctypes.int32_t(sw),
					ctypes.int32_t(sh)
				);
			} catch (e) {
				delete ViewMarksGlobal.resizeBitmapData;
				ViewMarksUtil.logerror(e);
				this.scaleDown(image, dw, dh);
			}
		} else {
			this.scaleDown(image, dw, dh);
		}
				
		var dstContext = dstCanvas.getContext("2d");
		if (dx == 0 && dy == 0) {
			try {
				dstContext.putImageData(image, 0, 0);
			} catch (e) {
				this.putImageData(dstContext, image);
			}
		} else {
			try {
				tmpContext.putImageData(image, 0, 0);
			} catch (e) {
				this.putImageData(tmpContext, image);
			}
			dstContext.drawImage(tmpCanvas, 0, 0, dw, dh, dx, dy, dw, dh);
		}

		tmpCanvas = null;
		dstCanvas.written = true;

		elapsed = window.performance.now() - elapsed;
		ViewMarksUtil.logmsg("createThumbnail: "+Math.floor(elapsed+0.5)+"ms");
	},


	resetZoom: function(canvas)
	{
		canvas.sx = canvas.sy = 0;
		canvas.sw = canvas.width;
		canvas.sh = canvas.height;
		if (canvas.sh > canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH) {
			canvas.sh = Math.round(canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH);
		}
	},


	cropImage: function(canvas, image)
	{
			var data = image.data;
			var linewidth = 4 * canvas.width;
			var width = canvas.width;
			var height = canvas.height;
	
			for (x=0; x<canvas.width; x++) {
				var start = 4*x;
				var count = 0;
				for (y=0; y<height; y++, start+=linewidth) {
					if (data[start] == data[start+4]) count++; else break;
					if (data[start+1] == data[start+5]) count++; else break;
					if (data[start+2] == data[start+6]) count++; else break;
					//if (data[start+3] == data[start+7]) count++; else break;
				}
				if (count == 3*height) {
					canvas.sx = x + 1; 
					canvas.sw = canvas.sw - 1;
				} else break;
			}
	
			for (x=width-2; x>=0; x--) {
				var start = 4*x;
				var count = 0;
				for (y=0; y<height; y++, start+=linewidth) {
					if (data[start] == data[start+4]) count++; else break;
					if (data[start+1] == data[start+5]) count++; else break;
					if (data[start+2] == data[start+6]) count++; else break;
					//if (data[start+3] == data[start+7]) count++; else break;
				}
				if (count == 3*height) {
					canvas.sw = canvas.sw - 1;
				} else break;
			}
	
			var minheight = Math.round(canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH);
	
			var start1 = 0;
			var start2 = linewidth;
			for (var y=0; y<canvas.sh && canvas.sh > minheight; y++) {
				var count = 0;
				for (var x=0; x<linewidth; x++) {
					if (data[start1+x] == data[start2+x]) count++; else break;
				} 
				if (count == linewidth) {
					canvas.sy = y + 1; 
					canvas.sh = canvas.sh - 1;
				} else break;
				start1 += linewidth;
				start2 += linewidth;
			}
	
			start1 = 0;
			start2 = linewidth;
			for (var y=canvas.sh-2; y>=0 && canvas.sh > minheight; y--) {
				var count = 0;
				for (var x=0; x<linewidth; x++) {
					if (data[start1+x] == data[start2+x]) count++; else break;
				} 
				if (count == linewidth) {
					canvas.sh = canvas.sh - 1;
				} else break;
				start1 += linewidth;
				start2 += linewidth;
			}
	},		


	detectBorders: function(canvas)
	{
		var elapsed = (new Date()).getTime();	

	  var context = canvas.getContext("2d");
		var image = context.getImageData(0, 0, canvas.width, canvas.height);

		if (ViewMarksGlobal.cropBitmapData != undefined) {
			try {			
				let cx = ctypes.int32_t();
				let cy = ctypes.int32_t();
				let cw = ctypes.int32_t();
				let ch = ctypes.int32_t();
				ViewMarksGlobal.cropBitmapData(
					image.data,
					ctypes.int32_t(canvas.width),
					ctypes.int32_t(canvas.height),
					cx.address(),
					cy.address(), 
					cw.address(),
					ch.address()
				);
				canvas.sx = cx.value;
				canvas.sy = cy.value;
				canvas.sw = cw.value;
				canvas.sh = ch.value;
				ViewMarksUtil.logmsg("cropBitmapData: "+canvas.sx+"/"+canvas.sy+" "+canvas.sw+"x"+canvas.sh);
			} catch (e) {
				delete ViewMarksGlobal.cropBitmapData;
				ViewMarksUtil.logerror(e);
				this.cropImage(canvas, image);
			}
		} else {
			this.cropImage(canvas, image);
		}

		elapsed = (new Date()).getTime() - elapsed;	
		ViewMarksUtil.logmsg("detectBorders: sx="+canvas.sx+" sy="+canvas.sy+" sw="+canvas.sw+" sh="+canvas.sh+" "+elapsed+"ms");

		if (canvas.sh <= 1 || canvas.sw <= 1) {
			this.resetZoom(canvas);
			return false;
		}

		if (canvas.sw < ViewMarksData.TN_DEFAULT_WIDTH && canvas.width >= ViewMarksData.TN_DEFAULT_WIDTH) {
			let dw = ViewMarksData.TN_DEFAULT_WIDTH - canvas.sw;
			canvas.sx = canvas.sx - dw / 2;
			if (canvas.sx < 0) canvas.sx = 0;
			canvas.sw = ViewMarksData.TN_DEFAULT_WIDTH;
		}

		if (canvas.sh < ViewMarksData.TN_DEFAULT_HEIGHT && canvas.height >= ViewMarksData.TN_DEFAULT_HEIGHT) {
			let dh = ViewMarksData.TN_DEFAULT_HEIGHT - canvas.sh;
			canvas.sy = canvas.sy - dh / 2;
			if (canvas.sy < 0) canvas.sy = 0;
			canvas.sh = ViewMarksData.TN_DEFAULT_HEIGHT;
		}

		if (canvas.sh > canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH) {
			canvas.sh = Math.round(canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH);	
		}
		if (canvas.sh < canvas.sw/4) canvas.sh = Math.round(canvas.sw/4);	

		return true;
	},


	isEmpty: function(canvas)
	{
	  var context = canvas.getContext("2d");
		var image = context.getImageData(0, 0, canvas.width, canvas.height);
		var data = image.data;
		for (var i=4; i<image.data.length; i+=4) {
			if (data[0] != data[i]) return false;
			if (data[1] != data[i+1]) return false;
			if (data[2] != data[i+2]) return false;
			if (data[3] != data[i+3]) return false;
		}
		return true;
	},


	// workaround for Bug 564332
	putImageData: function(context, image)
	{
		let tmpCanvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");
		tmpCanvas.width = image.width;
		tmpCanvas.height = image.height;
	  let tmpContext = tmpCanvas.getContext("2d");
		tmpContext.putImageData(image, 0, 0);
		context.drawImage(tmpCanvas, 0, 0);
	},


	benchmark: function()
	{
		let srcCanvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");		
		srcCanvas.width = 1280;		
		srcCanvas.height = 960;		
		let dstCanvas = document.createElementNS("http://www.w3.org/1999/xhtml","html:canvas");				
		dstCanvas.width = 384;		
		dstCanvas.height = 256;		

		let start = start = window.performance.now();
		let elapsed = 0;
		let duration = 3000;
		let count = 0;

		while (elapsed < duration) {
			this.createThumbnail(dstCanvas, 0, 0, dstCanvas.width, dstCanvas.height, srcCanvas, 0, 0, srcCanvas.width, srcCanvas.height); 
			count++;
			elapsed = window.performance.now() - start;
		}

		return 1000.0 * count / duration;
	},


	init: function() 
	{
		if (ViewMarksGlobal.nativeInterfaceInit) return;
		ViewMarksGlobal.nativeInterfaceInit = true;

		let version = this.appInfo.version.split(".")[0];
		if (version < 18) return; // needed parameter conversion not supported before this version

		if (this.platform != "WINNT") return; // only Windows for now

		AddonManager.getAddonByID(
			ViewMarksUtil.addonID, 
			function(addon) {
		    var uri = addon.getResourceURI("/chrome/content/vmks32.dll");
		    var path = uri.QueryInterface(Components.interfaces.nsIFileURL).file.path;
				try {
		    	ViewMarksGlobal.lib = ctypes.open(path);
					try {
						ViewMarksGlobal.resizeBitmapData = ViewMarksGlobal.lib.declare(
							"resizeBitmapData", ctypes.default_abi, ctypes.int32_t,
							ctypes.uint8_t.ptr, ctypes.int32_t, ctypes.int32_t, ctypes.int32_t, ctypes.int32_t
						);
						ViewMarksGlobal.cropBitmapData = ViewMarksGlobal.lib.declare(
							"cropBitmapData", ctypes.default_abi, ctypes.int32_t,
							ctypes.uint8_t.ptr, ctypes.int32_t, ctypes.int32_t, 
							ctypes.int32_t.ptr, ctypes.int32_t.ptr, ctypes.int32_t.ptr, ctypes.int32_t.ptr
						);
				  } catch(e) {
				  	ViewMarksUtil.logerror(e);
						ctypes.close(ViewMarksGlobal.lib);
				  }
		    } catch (e) {}
			}
		);

	},


	
};


ViewMarksBitmap.init();

