/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2012 Michael Koch
*/



var ViewMarksCapture = {

/*
	rule: [],

	rulePreset: [
		["YouTube", "www.youtube.com", 0, "watch-player", 1],
		["Flickr", "www.flickr.com", 0, "photo-drag-proxy", 1],
	],
	
	ruleCompare: function(a, b)
	{
		if (a.pattern.indexOf(b.pattern) == 0) return -1;
		if (a.pattern < b.pattern) return -1;
		if (a.pattern == b.pattern) return 0;
		return 1;
	},
*/

	getPosition: function(node) 
	{
		var pos = {x:0,y:0};
		while (node.offsetParent) {
			pos.x += node.offsetLeft;
			pos.y += node.offsetTop;
			node = node.offsetParent;
		}
		return pos;
	},


	resetZoom: function(canvas)
	{
		canvas.sx = canvas.sy = 0;
		canvas.sw = canvas.width;
		canvas.sh = canvas.height;
		if (canvas.sh > canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH) {
			canvas.sh = Math.round(canvas.sw*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH);
		}
	},



	snapshot: function(canvas, win, doCrop)
	{
		//this.rule = ViewMarksCapture.getRules();

		if (win.document.body == null) return false;
		if (win.document.body.childNodes.length == 0) return false;

		if (win.document.body.childNodes.length == 1 ||
				(win.document.body.childNodes.length == 2 && win.document.body.childNodes[1].id == "sbi_camera_button")) {
			var node = win.document.body.childNodes[0];
			if (node.tagName && node.tagName.toLowerCase() == "img") {
				var imgratio = node.offsetWidth / node.offsetHeight;
				var tnratio = ViewMarksData.TN_DEFAULT_WIDTH / ViewMarksData.TN_DEFAULT_HEIGHT;
				var dx, dy;
				if (imgratio > tnratio) {
					canvas.width = node.offsetWidth;
					canvas.height = node.offsetWidth * ViewMarksData.TN_DEFAULT_HEIGHT / ViewMarksData.TN_DEFAULT_WIDTH;
					dx = 0;
					dy = 0.5*(canvas.height - node.offsetHeight);
				} else {
					canvas.width = node.offsetHeight * ViewMarksData.TN_DEFAULT_WIDTH / ViewMarksData.TN_DEFAULT_HEIGHT;
					canvas.height = node.offsetHeight;
					dx = 0.5*(canvas.width - node.offsetWidth);
					dy = 0;
				}
				canvas.sx = 0;
				canvas.sy = 0;
				canvas.sw = canvas.width;
				canvas.sh = canvas.height;
			  var context = canvas.getContext("2d");
			  context.fillStyle = "#484040";
			  context.fillRect(0, 0, canvas.width, canvas.height);
			  context.drawImage(node, dx, dy, node.offsetWidth, node.offsetHeight);
				return true;
			}
		}

		//var width = win.innerWidth;
		//if (win.document.body.clientWidth > width) width = win.document.body.clientWidth;
		//ViewMarksUtil.logmsg("win.innerWidth="+win.innerWidth);
		var width = win.document.body.clientWidth;
		try {
			var height = win.innerHeight;
		} catch (e) {
			var height = 0;
		}
		try {
			if (win.document.documentElement.scrollHeight > height) height = win.document.documentElement.scrollHeight;
		} catch(e) {/*ViewMarksUtil.alert(e);*/}
		try {
			if (win.document.defaultView.innerHeight > height) height = win.document.defaultView.innerHeight;
		} catch(e) {/*ViewMarksUtil.alert(e);*/}
		if (win.document.body.clientHeight > height) height = win.document.body.clientHeight;


		if (width == 0 || height == 0) {
			ViewMarksUtil.logmsg("ViewMarks: snapshot width or height is zero ("+width+"x"+height+")");
			return false;
		}

		// sanity check
		if (height > 4*width) {
			ViewMarksUtil.logmsg("ViewMarks: snapshot height clipped from "+height+" to "+4*width);
			height = 4*width;
		}
		
	  canvas.width = width;
	  canvas.height = height;
/*
		if (canvas.height > canvas.width*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH) {
			canvas.height = Math.round(canvas.width*ViewMarksData.TN_DEFAULT_HEIGHT/ViewMarksData.TN_DEFAULT_WIDTH);
		}
*/
		ViewMarksUtil.logmsg("ViewMarks: snapshot "+canvas.width+"x"+canvas.height);

	  var context = canvas.getContext("2d");
	  context.drawWindow(win, 0, 0, canvas.width, canvas.height, "rgb(255,255,255)");

/*
		var url = win.location.href;
		var index = url.indexOf("://");
		if (index > 0) url = url.substr(index+3);

		for (var i=0; i<this.rule.length; i++) {
			if (this.rule[i].active == false) continue;
			if (url.indexOf(this.rule[i].pattern) == 0) {
				var node = win.document.getElementById(this.rule[i].id);
				if (node == null) continue;
				if (this.rule[i].rel < 0) {
					for (var rel = this.rule[i].rel; rel < 0; rel++) {
						node = node.parentNode;
					}
				}
				if (this.rule[i].rel > 0) node = node.childNodes[this.rule[i].rel - 1];
				if (node) {
					var pos = this.getPosition(node);
					canvas.sx = pos.x;
					canvas.sy = pos.y;
					canvas.sw = node.offsetWidth;
					canvas.sh = node.offsetHeight;
					return true;
				}
			}
		}
*/

		this.resetZoom(canvas);
		if (ViewMarksPref.zoom_smart && doCrop) {
			if (!ViewMarksBitmap.detectBorders(canvas)) return false;
		} else {
			if (ViewMarksBitmap.isEmpty(canvas)) return false;
		}

	  return true;
	},

/*
	getRules: function()
	{
		var file = ViewMarksData.getLocalFile("rules.json");
		var rule = ViewMarksData.readObjectFromFile(file);
		var changed = false;
		if (rule == null) rule = [];

		for (var i=0; i<this.rulePreset.length; i++) {
			var present = false;
			for (var j=0; j<rule.length; j++) {
				if (this.rulePreset[i][1] == rule[j].pattern) {
					if (this.rulePreset[i][4] > rule[j].ts) {
						rule[j].name = this.rulePreset[i][0];
						rule[j].rel = this.rulePreset[i][2];
						rule[j].id = this.rulePreset[i][3];
						rule[j].ts = this.rulePreset[i][4];
						changed = true;
					}
					present = true; 
					break;
				}
			}
			if (!present) {
				var newrule = {
					active: true,
					name: this.rulePreset[i][0],
					pattern: this.rulePreset[i][1],
					rel: this.rulePreset[i][2],
					id: this.rulePreset[i][3],
					ts: this.rulePreset[i][4]
				};
				rule.push(newrule);
				changed = true;
			}
		}
		if (changed) this.setRules(rule);
		return rule;
	},


	setRules: function(rule)
	{
		if (rule == null) return;
		rule.sort(this.ruleCompare);
		var file = ViewMarksData.getLocalFile("rules.json");
		ViewMarksData.writeObjectToFile(file, rule);
	}
*/
	
};



