/*
Creative Commons License: Attribution-No Derivative Works 3.0 Unported
http://creativecommons.org/licenses/by-nd/3.0/
(c) 2010-2013 Michael Koch
*/

Components.utils.import("resource://viewmarks/global.jsm"); 

var ViewMarksConfig = {

	rule: null,
	ruleChanged: false,


	shareOnFacebook: function()
	{
		var url = "http://www.facebook.com/sharer.php?u=http%3A%2F%2Fwww.codepad.de%2Fsoftware%2Ffirefox-add-ons%2Fviewmarks.html";
		ViewMarksUtil.openInNewTab(url);
	},

	shareOnTwitter: function()
	{
		var url = "http://twitter.com/home?status=ViewMarks%20http://bit.ly/MaxAun";
		ViewMarksUtil.openInNewTab(url);
	},

	shareOnGoogle: function()
	{
		var url = "https://plusone.google.com/_/+1/confirm?url=http%3A%2F%2Fwww.codepad.de%2Fsoftware%2Ffirefox-add-ons%2Fviewmarks.html";
		ViewMarksUtil.openInNewTab(url);
	},


	onExportDatabase: function()
	{
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
	  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	  fp.init(window, ViewMarksUtil.getString("export_database"), nsIFilePicker.modeSave);
	  fp.defaultString = "viewmarks.json";
	  fp.appendFilter("*.json", "*.json");
	  fp.appendFilters(nsIFilePicker.filterAll);
		var last_save_dir = ViewMarksPref.getCharPref("last_save_dir");
		if (last_save_dir != "") {
		  var localFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			localFile.initWithPath(last_save_dir);
	  	fp.displayDirectory = localFile;
	  }
	  var res = fp.show();
	  if (res == nsIFilePicker.returnOK || res == nsIFilePicker.returnReplace) {
			try {ViewMarksPref.prefs.setCharPref("last_save_dir", fp.file.parent.target);} catch(e){}
			ViewMarksData.exportDatabase(fp.file);
		}
	},

	onImportDatabase: function()
	{
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
	  var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	  fp.init(window, ViewMarksUtil.getString("import_database"), nsIFilePicker.modeOpen);
	  fp.defaultString = "viewmarks.json";
	  fp.appendFilter("*.json", "*.json");
	  fp.appendFilters(nsIFilePicker.filterAll);
		var last_load_dir = ViewMarksPref.getCharPref("last_load_dir");
		if (last_load_dir != "") {
		  var localFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			localFile.initWithPath(last_load_dir);
	  	fp.displayDirectory = localFile;
	  }
	  var res = fp.show();
	  if (res == nsIFilePicker.returnOK) {
			try {ViewMarksPref.prefs.setCharPref("last_load_dir", fp.file.parent.target);} catch(e){}
			//ViewMarksData.importDatabase(fp.file);
			if (ViewMarksImport.doStat(fp.file)) {
				ViewMarksImport.doImport(fp.file);
			}
		}
	},


	onClearHistory: function()
	{
		ViewMarksHistory.clearHistory();		
	},

	
	onClearTrash: function()
	{
		ViewMarksTrash.deleteAllTrashItems();
	},

	
	onAccept: function()
	{
/*
		if (this.ruleChanged) {
			ViewMarksCapture.setRules(this.rule);
		}
*/
		var url = document.getElementById("vmks_pref_empty_tab").value;
		ViewMarksPref.browserPrefs.setBoolPref("newtabpage.enabled", url != "");
		var value = document.getElementById("vmks_pref_update_period").value;
		if (value < 10) document.getElementById("vmks_pref_update_period").value = 10;
	},

	toggleState: function(index)
	{
		for (var i=0; i<this.rule.length; i++) {
			if (this.rule[i].name == this.rule[index].name) {
				this.rule[i].active = !this.rule[i].active;
			}
		}
		this.ruleChanged = true;
	},

	update: function() {
		var value = document.getElementById("vmks_pref_replace_edit").value;
		ViewMarksUtil.enableNode("vmks_checkbox_menu_for_unfiled", value);

		var update = document.getElementById("vmks_pref_update_switch").value;
		document.getElementById("vmks_pref_update_warning_box").style.opacity = (update ? "0.9" : "0.5");
		var progress = document.getElementById("vmks_pref_thumbnail_progress");
		var label = document.getElementById("vmks_pref_thumbnail_present");
		var box = document.getElementById("vmks_pref_thumbnail_box");
		if (update) {
			box.removeAttribute("collapsed");
			if (ViewMarksGlobal.updateList) {
				progress.style.opacity = "1.0";
				progress.mode = "determined";
				var max = ViewMarksGlobal.updateBookmarkCount;
				var value = max - ViewMarksGlobal.updateList.length;
				value += ViewMarksGlobal.updateIndex + 1;
				value = 100 * value / max;
				value = value.toFixed(0);
				if (value == 100 && value < max) value = 99;
				progress.value = value;
				label.value = value + "%";
			} else {
				progress.style.opacity = "0.3";
				progress.mode = "undetermined";
				progress.value = 0;
				label.value = "";
			}
		} else {
			box.setAttribute("collapsed", true);
		}

	},

	onEmptyTabUrl: function() {
		var item = document.getElementById("vmks_pref_empty_tab");
		var selected = item.selectedItem.value;
		if (selected == "about:blank") {
			item.value = "about:blank";
		} else if (selected == "about:newtab") {
			item.value = "about:newtab";
		} else if (selected == "about:home") {
			item.value = "about:home";
		} else if (selected == ViewMarksData.mostVisitedFolder) {
			item.value = "about:viewmarks?folder=mostvisited";
		} else if (selected == ViewMarksData.lastVisitedFolder) {
			item.value = "about:viewmarks?folder=lastvisited";
		} else {
			item.value = "about:viewmarks?folder="+selected;
		}
	},


	createNewtabMenuitem: function(title, imageurl) {
		var item = document.createElement("menuitem");	
		item.setAttribute("label", title);
		//item.setAttribute("value", 0);
		item.setAttribute("value", title);
		item.setAttribute("class", "menuitem-iconic bookmark-item");
		item.setAttribute("style", "padding-left:0px");
		var image = document.createElement("image");
		image.setAttribute("src", imageurl);
		item.appendChild(image);		
		var label = document.createElement("label");
		label.setAttribute("value", title);
		item.appendChild(label);
		return item;
	},


	init: function() {
		ViewMarksUtil.addSystemInfoAttributes('dlgViewMarksConfig');
		ViewMarksUtil.getAddonVersion(
			function(version) {
				document.getElementById('vmks_version').value='Version '+version;
			});
		this.update();

		ViewMarksPref.init();

		ViewMarksUtil.showElement("vmks_label_native_support", ViewMarksGlobal.resizeBitmapData != undefined);

		var cell_size = ViewMarksPref.getIntPref("qrcode_cell_size");
		document.getElementById("vmks_scale_cell_size").setAttribute("value", ViewMarksPref.qrcode_cell_size);

		var newtab = document.getElementById("vmks_pref_empty_tab_popup");
		newtab.appendChild(this.createNewtabMenuitem("about:blank", "chrome://viewmarks/skin/stop.png"));
		if (ViewMarksPref.xulAppInfo.version >= "12.0") {
			newtab.appendChild(this.createNewtabMenuitem("about:newtab", "chrome://viewmarks/skin/newtab.png"));
			newtab.appendChild(this.createNewtabMenuitem("about:home", "chrome://viewmarks/skin/home.png"));
		}
		ViewMarksData.createFolderTree(newtab, true);

		window.sizeToContent();

		document.getElementById("vmks_pref_update_warning").textContent = ViewMarksLocale.msgUpdateWarning();

		if (window.arguments) {
			let paneId = window.arguments[0].pane;
			if (paneId) {
				let pane = document.getElementById(paneId);
				if (pane) {
					document.getElementById("dlgViewMarksConfig").showPane(pane);
				}
			}
		}

	}
	
};



